/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyItemMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItem;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemcode;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceItemCollectInfo;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewComplianceCompanyItemServiceImpl
extends BaseServiceImpl<NewComplianceCompanyItemMapper, NewComplianceCompanyItem>
implements INewComplianceCompanyItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceCompanyItemServiceImpl.class);
    @Autowired
    INewComplianceCompanyItemcodeService itemcodeService;

    public List<NewComplianceCompanyItem> getItemByComplianceId(Long id) {
        Example e = new Example(NewComplianceCompanyItem.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("complianceId", (Object)id).andEqualTo("isValid", (Object)true);
        List<NewComplianceCompanyItem> list = this.getListByExample(e);
        return list;
    }

    public List<NewComplianceCompanyItem> getItemByInfoIdCode(Long complianceId, String code) {
        Example e = new Example(NewComplianceCompanyItem.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            criteria.andEqualTo("itemcodeCode", (Object)code);
        }
        List<NewComplianceCompanyItem> list = this.getListByExample(e);
        return list;
    }

    public void addNewComplianceItem(Long infoId, Long loginStaffId) {
        ArrayList<NewComplianceCompanyItem> itemList = new ArrayList<NewComplianceCompanyItem>();
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        List<NewComplianceCompanyItem> itemByInfoIdCode = this.getItemByInfoIdCode(infoId, null);
        Map<Object, Object> codeItemMap = new HashMap();
        if (CollectionUtils.isNotEmpty(itemByInfoIdCode)) {
            codeItemMap = itemByInfoIdCode.stream().collect(Collectors.toMap(NewComplianceCompanyItem::getItemcodeCode, Function.identity(), (v1, v2) -> v1));
        }
        Set codeSet = allItemcode.stream().map(NewComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        for (String code : codeSet) {
            NewComplianceCompanyItem item2 = new NewComplianceCompanyItem();
            NewComplianceCompanyItem dbitem = (NewComplianceCompanyItem)codeItemMap.get(code);
            if (dbitem != null) {
                item2.setId(dbitem.getId());
            }
            item2.setComplianceId(infoId);
            item2.setItemcodeCode(code);
            item2.setCreateBy(loginStaffId);
            item2.setCreateDate(new Date());
            item2.setIsValid(Boolean.valueOf(true));
            itemList.add(item2);
        }
        this.batchUpdateOrInsert(itemList, NewComplianceCompanyItemMapper.class, (item, mapper) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setIsValid(Boolean.valueOf(true));
                return mapper.insert(item);
            }
            item.setUpdateDate(new Date());
            return mapper.updateByPrimaryKeySelective(item);
        });
    }

    public List<NewComplianceItemCollectInfo> judgeComplianceItemHasObjectionOrAppeal(Long complianceId) {
        return complianceId == null ? Collections.emptyList() : ((NewComplianceCompanyItemMapper)this.dao).judgeComplianceItemHasObjectionOrAppeal(complianceId);
    }

    public void delInvalid(List<NewComplianceCompanyItem> delitemList) {
        if (CollectionUtils.isEmpty(delitemList)) {
            return;
        }
        ((NewComplianceCompanyItemMapper)this.dao).delInvalid(delitemList);
    }
}

