/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.compliance.service.home.IHomeComplianceService;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceBasicVo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemBasicView;
import cn.smarthse.modules.health.newcompliance.constants.NewComplianceCompanyConstants;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceAreaScore;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItem;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemcode;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceAccordingTypeEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceOutReasonEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyDataScoreModel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyInfoLabelModel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyPromiseModel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyQueryParam;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceNeedRefreshModel;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceAreaScoreService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemdataService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceGhcollectMonthReportService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCollectInfo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyCardInfo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyCountVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyListVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyObjectionApplyVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceItemCollectInfo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceItemDataVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceItemInfoVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceSubItemVo;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryType;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualModel;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualParam;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.health.vo.base.company.HealthManagementInfoVo;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewComplianceCompanyInfoServiceImpl
extends BaseServiceImpl<NewComplianceCompanyInfoMapper, NewComplianceCompanyInfo>
implements INewComplianceCompanyInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceCompanyInfoServiceImpl.class);
    @Autowired
    private INewComplianceCompanyItemService itemService;
    @Autowired
    private INewComplianceCompanyItemdataService itemdataService;
    @Autowired
    private INewComplianceScoreRefreshService refreshService;
    @Autowired
    INewComplianceCompanyItemcodeService itemcodeService;
    @DubboReference
    CompanyReportInfoService companyReportInfoService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    ICompanyFunctionalOrganizationMemberService functionalOrganizationMemberService;
    @DubboReference
    IMsInfoService msInfoService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ILiteArchiveFilePersonalService personalService;
    @Autowired
    NewComplianceCompanyObjectionApplyMapper applyMapper;
    @Autowired
    NewComplianceCompanyExitItemMapper exitItemMapper;
    @Autowired
    INewComplianceGhcollectMonthReportService hgcollectMonthReportService;
    @Autowired
    INewComplianceCompanyObjectionApplyService objectionApplyService;
    @Autowired
    IImportantIndustryCategoryService importantIndustryCategoryService;
    @Value(value="${sms.switch}")
    private Boolean smsSwitch;
    @DubboReference
    private ISMSProvideMasService smsProvideMasService;
    @Autowired
    private IHomeComplianceService homeComplianceService;
    @DubboReference
    private ILiteArchiveUpdateService archiveUpdateService;
    @Autowired
    private INewComplianceAreaScoreService newComplianceAreaScoreService;
    @Autowired
    RedissonClient redissonClient;
    @Autowired
    RedisClient redisClient;
    @Autowired
    private ThreadPoolExecutor commonExecutor;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    private static final String CACHE_NAME = "NewComplianceCompanyInfoServiceImpl";

    public List<NewComplianceCompanyInfo> getComplianceCids(List<Long> cids) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return null;
        }
        return this.getComplianceCids(cids, null);
    }

    public List<NewComplianceCompanyInfo> listReformRemainDateInfo(List<Long> cids) {
        return ((NewComplianceCompanyInfoMapper)this.dao).listReformRemainDateInfo(cids);
    }

    public List<NewComplianceCompanyInfo> getAllComplianceCids(List<Integer> status) {
        Example e = new Example(NewComplianceCompanyInfo.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)0);
        e.selectProperties(new String[]{"id", "cid"});
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(status)) {
            criteria.andIn("status", status);
        }
        List<NewComplianceCompanyInfo> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public List<NewComplianceCompanyInfo> getComplianceCids(List<Long> cids, List<Integer> status) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Example e = new Example(NewComplianceCompanyInfo.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)0);
        if (cids.size() == 1) {
            criteria.andEqualTo("cid", (Object)cids.get(0));
        } else {
            criteria.andIn("cid", cids);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(status)) {
            criteria.andIn("status", status);
        }
        e.selectProperties(new String[]{"id", "cid"});
        List<NewComplianceCompanyInfo> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public NewComplianceCompanyInfo getCacheComplianceByCid(Long cid, List<Integer> status) {
        List newComplianceCompanyInfos;
        String key = "getCacheComplianceByCid:" + cid;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(status)) {
            key = key + status.hashCode();
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(newComplianceCompanyInfos = (List)this.redisClient.get(CACHE_NAME, key, 120L, () -> this.getComplianceCids(Arrays.asList(cid), status))))) {
            return (NewComplianceCompanyInfo)newComplianceCompanyInfos.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public NewComplianceCompanyInfo addCompliance(Long cid, Long loginStaffId) {
        Example e = new Example(NewComplianceCompanyInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("isOut", (Object)0);
        RLock lock = this.redissonClient.getLock("NewComplianceCompanyInfoServiceImpl:addCompliance:" + cid);
        NewComplianceCompanyInfo info = new NewComplianceCompanyInfo();
        try {
            if (lock.tryLock(5L, TimeUnit.MINUTES)) {
                List listByExample = this.getListByExample(e);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(listByExample)) {
                    NewComplianceCompanyInfo newComplianceCompanyInfo = (NewComplianceCompanyInfo)listByExample.get(0);
                    return newComplianceCompanyInfo;
                }
                info.setCid(cid);
                info.setFirstTimeInPromisepage(Boolean.valueOf(true));
                info.setStatus(NewComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey());
                this.add(info, loginStaffId, null);
            }
        }
        catch (Exception exce) {
            log.error("\u65b0\u589e\u5408\u89c4\u6570\u636e\u51fa\u9519\uff1a", (Object)e);
        }
        finally {
            lock.unlock();
        }
        this.commonExecutor.execute(() -> {
            String title = cn.smarthse.common.util.date.DateUtil.getYear() - 2 + "," + (cn.smarthse.common.util.date.DateUtil.getYear() - 1) + "," + cn.smarthse.common.util.date.DateUtil.getYear();
            this.archiveUpdateService.asyncRefreshArchiveV2(Arrays.asList(cid), "201,301,404");
            this.personalService.addPersonalArchiveByCid(Collections.emptyList(), cid, loginStaffId, null);
        });
        return info;
    }

    public NewComplianceCompanyInfo submitCompliance(Long cid, Long complianceId, Long loginStaffId) {
        NewComplianceCompanyInfo info = new NewComplianceCompanyInfo();
        info.setId(complianceId);
        info.setFirstPromiseDate(new Date());
        info.setStep(Byte.valueOf((byte)3));
        info.setStatus(NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
        this.update(info, loginStaffId);
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        Set<String> codeSet = allItemcode.stream().filter(f -> Objects.equals(f.getType(), 1)).map(NewComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        this.refreshService.reloadRefData(Arrays.asList(cid), null, codeSet.toArray(new String[0]));
        return (NewComplianceCompanyInfo)this.getById(complianceId);
    }

    public Boolean savePromiseData(List<NewComplianceCompanyItemdata> promiseDataList) {
        return this.refreshService.savePromiseData(promiseDataList);
    }

    public NewComplianceItemInfoVo getItemVo(Long infoId, String code, List<Long> codeIds, boolean isTrytool) {
        List scoreModelList = this.itemdataService.listItemDataScoreModel(infoId, code, codeIds);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)scoreModelList)) {
            return null;
        }
        NewComplianceItemInfoVo vo = new NewComplianceItemInfoVo();
        vo.setItemScore(((NewComplianceCompanyDataScoreModel)scoreModelList.get(0)).getScore());
        Map<Long, List<NewComplianceCompanyDataScoreModel>> codeIdModelMap = scoreModelList.stream().collect(Collectors.groupingBy(NewComplianceCompanyDataScoreModel::getItemcodeId));
        ArrayList<NewComplianceSubItemVo> subItemVoList = new ArrayList<NewComplianceSubItemVo>();
        if (MapUtils.isNotEmpty(codeIdModelMap)) {
            codeIdModelMap.forEach((codeId, modelList) -> {
                NewComplianceCompanyDataScoreModel dataScoreModel = (NewComplianceCompanyDataScoreModel)modelList.get(0);
                BigDecimal loseScore = dataScoreModel.getLoseScore();
                NewComplianceSubItemVo subItemVo = new NewComplianceSubItemVo();
                subItemVo.setLoseScore(loseScore);
                subItemVo.setPromiseDataClashFieldname(dataScoreModel.getPromiseDataClashFieldname());
                Optional<Date> date = modelList.stream().filter(m -> m.getSubUpdate() != null).map(NewComplianceCompanyDataScoreModel::getSubUpdate).max(Comparator.naturalOrder());
                if (date.isPresent()) {
                    subItemVo.setSubUpdate(date.get());
                }
                subItemVo.setItemCodeId(dataScoreModel.getItemcodeId());
                subItemVoList.add(subItemVo);
                List itemDataVoList = modelList.stream().map(m -> {
                    NewComplianceItemDataVo itemDataVo = new NewComplianceItemDataVo();
                    itemDataVo.setFieldName(m.getFieldName());
                    itemDataVo.setFormat(m.getFormat());
                    itemDataVo.setResultData(m.getResultData());
                    return itemDataVo;
                }).collect(Collectors.toList());
                subItemVo.setFieldDataList(itemDataVoList);
            });
        }
        vo.setSubItemList(subItemVoList);
        if (Objects.equals(isTrytool, false)) {
            this.setSubItemObjectionInfo(infoId, code, subItemVoList);
        }
        return vo;
    }

    public NewComplianceCollectInfo getItemCollectInfo(Long infoId) {
        NewComplianceCompanyInfo info = (NewComplianceCompanyInfo)this.getById(infoId);
        if (info == null) {
            return null;
        }
        NewComplianceCollectInfo collectInfo = new NewComplianceCollectInfo();
        collectInfo.setScore(info.getComplianceScore());
        collectInfo.setStatus(info.getStatus());
        List itemList = this.itemService.getItemByComplianceId(infoId);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)itemList)) {
            List<NewComplianceItemCollectInfo> itemCollectInfoList = itemList.stream().map(m -> {
                NewComplianceItemCollectInfo itemCollectInfo = new NewComplianceItemCollectInfo();
                itemCollectInfo.setStatus(Integer.valueOf(m.getStatus() == null ? 1 : m.getStatus()));
                itemCollectInfo.setScore(m.getScore());
                itemCollectInfo.setPromiseDataClash(m.getPromiseDataClash());
                itemCollectInfo.setCode(m.getItemcodeCode());
                return itemCollectInfo;
            }).collect(Collectors.toList());
            this.judgeComplianceItemHasObjectionOrAppeal(infoId, itemCollectInfoList);
            List addScoreItemList = itemList.stream().filter(f -> Objects.equals(f.getItemcodeCode(), "15")).collect(Collectors.toList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(addScoreItemList)) {
                BigDecimal score = ((NewComplianceCompanyItem)addScoreItemList.get(0)).getScore();
                collectInfo.setAddItemScore(score);
            } else {
                collectInfo.setAddItemScore(BigDecimal.ZERO);
            }
            collectInfo.setItemList(itemCollectInfoList);
        }
        return collectInfo;
    }

    public PageInfo<NewComplianceCompanyListVo> listData(JqGridParam param, NewComplianceCompanyQueryParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<NewComplianceCompanyListVo> list = ((NewComplianceCompanyInfoMapper)this.dao).listData(queryParam);
        ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
        typeParam.setMenuSet(Integer.valueOf(1));
        List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
        List<Object> typeNameList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)typeList)) {
            typeNameList = typeList.stream().map(ImportantIndustryCategoryType::getImportantTypeName).collect(Collectors.toList());
        }
        ArrayList finalTypeNameList = typeNameList;
        ArrayList cidList = new ArrayList();
        list.forEach(vo -> {
            vo.init();
            String importantTypeName = vo.getImportantTypeName();
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)importantTypeName)) {
                List strings = CommonUtil.str2list((String)importantTypeName);
                Set validInduSet = strings.stream().filter(f -> finalTypeNameList.contains(f)).collect(Collectors.toSet());
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(validInduSet)) {
                    vo.setImportantTypeName(cn.smarthse.common.util.StringUtils.join(validInduSet, (String)","));
                } else {
                    vo.setImportantTypeName("");
                }
            } else {
                vo.setImportantTypeName("");
            }
            if (Objects.equals(NewComplianceAccordingTypeEnum.REFORM.getKey(), vo.getComplianceAccordingType())) {
                cidList.add(vo.getCid());
            }
        });
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cidList)) {
            Map noDefusedRiskMap = this.reformItemBasicNewService.getReformItemBasicCountView(new ReformSearchVo().setCidList(cidList)).stream().filter(Objects::nonNull).collect(Collectors.toMap(ReformItemBasic::getCid, Function.identity(), (k1, k2) -> k1));
            Map riskMap = this.reformItemBasicNewService.getOverFourMonthRisk(StringUtils.join(cidList, (String)","));
            list.forEach(vo -> {
                ReformItemBasicView noDefusedRisk;
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Map)riskMap)) {
                    vo.setRiskSources((List)riskMap.get(vo.getCid()));
                }
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Map)noDefusedRiskMap) && (noDefusedRisk = (ReformItemBasicView)noDefusedRiskMap.get(vo.getCid())) != null) {
                    vo.setNoDefusedRiskNum(Integer.valueOf(noDefusedRisk.getKeyListCount() + noDefusedRisk.getAbnormalListCount()));
                    long l = DateUtil.betweenDay((Date)noDefusedRisk.getMinFindTime(), (Date)new Date(), (boolean)true);
                    vo.setNoDefusedRiskDayNum(Integer.valueOf(Math.toIntExact(l)));
                }
            });
        }
        PageInfo page = new PageInfo(list);
        return page;
    }

    public NewComplianceCompanyCountVo countByArea(NewComplianceCompanyQueryParam queryParam) {
        NewComplianceCompanyCountVo companyCountVo = ((NewComplianceCompanyInfoMapper)this.dao).countByArea(queryParam);
        companyCountVo.setAreaId(queryParam.getAreaId());
        companyCountVo.setAreaName(queryParam.getAreaName());
        HomeComplianceBasicVo provinceAvgVo = this.homeComplianceService.getProvinceAvgVo();
        companyCountVo.setProvinceAvg(provinceAvgVo.getProvinceAvg());
        companyCountVo.setProvinceAvgCount(provinceAvgVo.getProvinceAvgCount());
        NewComplianceAreaScore areaScore = this.newComplianceAreaScoreService.getOneAreaScore(queryParam.getAreaId(), queryParam.getAreaLevel(), Boolean.valueOf(false));
        if (areaScore != null) {
            companyCountVo.setComplianceCount2024(areaScore.getComplianceCount2024());
            companyCountVo.setComplianceProportion2024(areaScore.getComplianceProportion2024());
            companyCountVo.setScore(areaScore.getScore());
        }
        return companyCountVo;
    }

    public NewComplianceCompanyListVo getDetailById(Long complianceId) {
        NewComplianceCompanyListVo detail = ((NewComplianceCompanyInfoMapper)this.dao).getDetailById(complianceId);
        if (detail == null) {
            throw new ServiceException("\u4f20\u5165ID\u6709\u8bef\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u5408\u89c4\u4f01\u4e1a");
        }
        detail.init();
        if (detail.getImportantTypeName() != null) {
            String importantTypeName = detail.getImportantTypeName();
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)importantTypeName)) {
                ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
                typeParam.setMenuSet(Integer.valueOf(1));
                List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
                List<Object> typeNameList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)typeList)) {
                    typeNameList = typeList.stream().map(ImportantIndustryCategoryType::getImportantTypeName).collect(Collectors.toList());
                }
                ArrayList finalTypeNameList = typeNameList;
                List strings = CommonUtil.str2list((String)importantTypeName);
                Set validInduSet = strings.stream().filter(f -> finalTypeNameList.contains(f)).collect(Collectors.toSet());
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(validInduSet)) {
                    detail.setImportantTypeName(cn.smarthse.common.util.StringUtils.join(validInduSet, (String)","));
                } else {
                    detail.setImportantTypeName("");
                }
            } else {
                detail.setImportantTypeName("");
            }
        }
        return detail;
    }

    public NewComplianceCompanyListVo getTrytoolDetailById(Long complianceId) {
        return ((NewComplianceCompanyInfoMapper)this.dao).getTrytoolDetailById(complianceId);
    }

    public List<NewComplianceCompanyInfo> getCompanyFirstComplianceTime(List<Long> cidList) {
        return ((NewComplianceCompanyInfoMapper)this.dao).getCompanyFirstComplianceTime(cidList);
    }

    public NewComplianceCompanyInfo getLastByCid(Long loginStaffCompanyId) {
        return ((NewComplianceCompanyInfoMapper)this.dao).getLastByCid(loginStaffCompanyId);
    }

    public NewComplianceCompanyCardInfo getComplianceCompanyCardInfo(Long complianceId) {
        if (complianceId == null) {
            return null;
        }
        NewComplianceCompanyCardInfo card = ((NewComplianceCompanyInfoMapper)this.dao).getComplianceCompanyCardInfo(complianceId);
        this.setComplianceStatus(card);
        this.calcReformRemainDays(card);
        return card;
    }

    public NewComplianceCompanyInfo getInfoById(Long complianceId) {
        return ((NewComplianceCompanyInfoMapper)this.dao).getInfoById(complianceId);
    }

    private void setComplianceStatus(NewComplianceCompanyCardInfo newcompliance) {
        if (newcompliance != null) {
            String value = NewComplianceInfoStatusEnum.getValue((Integer)newcompliance.getStatus());
            if (StrUtil.isNotBlank((CharSequence)value)) {
                value = value.split("-")[0];
            }
            newcompliance.setStatusName(value);
        }
    }

    private void calcReformRemainDays(NewComplianceCompanyCardInfo newcompliance) {
        if (newcompliance == null) {
            return;
        }
        String reformRemainDate = newcompliance.getReformRemainDate();
        if (reformRemainDate != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime targetDate = LocalDateTime.parse(reformRemainDate, formatter);
            LocalDateTime now = LocalDateTime.now();
            Duration duration = Duration.between(now, targetDate);
            long days = duration.toDays();
            newcompliance.setReformRemainDays(Long.valueOf(days));
        }
    }

    private void judgeComplianceItemHasObjectionOrAppeal(Long complianceId, List<NewComplianceItemCollectInfo> itemCollectList) {
        List infoList = this.itemService.judgeComplianceItemHasObjectionOrAppeal(complianceId);
        Map itemMap = infoList.stream().collect(Collectors.toMap(NewComplianceItemCollectInfo::getCode, Function.identity(), (v1, v2) -> v1));
        for (NewComplianceItemCollectInfo item : itemCollectList) {
            NewComplianceItemCollectInfo info = (NewComplianceItemCollectInfo)itemMap.get(item.getCode());
            if (info == null) continue;
            item.setHasObjection(info.getHasObjection());
            item.setHasAppeal(info.getHasAppeal());
        }
    }

    private void setSubItemObjectionInfo(Long complianceId, String itemCode, List<NewComplianceSubItemVo> subItemList) {
        List objectionList = this.itemdataService.querySubItemObjectionInfo(complianceId, itemCode);
        Map objectionMap = objectionList.stream().collect(Collectors.toMap(NewComplianceCompanyObjectionApplyVo::getItemcodeId, Function.identity(), (v1, v2) -> v2));
        subItemList.forEach(sub -> sub.setObjectionVo((NewComplianceCompanyObjectionApplyVo)objectionMap.get(sub.getItemCodeId())));
        List itemcodeList = this.itemcodeService.getCacheAllItemcode();
        List codeIdList = itemcodeList.stream().filter(f -> Objects.equals(f.getCode(), itemCode)).map(NewComplianceCompanyItemcode::getId).collect(Collectors.toList());
        List complianceCompanyObjectionApplies = this.objectionApplyService.listObjectionApply(complianceId, codeIdList, Integer.valueOf(2), Arrays.asList(1));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)complianceCompanyObjectionApplies)) {
            Map itemCodeObjectionApplyMap = complianceCompanyObjectionApplies.stream().collect(Collectors.toMap(NewComplianceCompanyObjectionApply::getItemcodeId, Function.identity(), (v1, v2) -> v2));
            subItemList.forEach(sub -> sub.setAppealObj((NewComplianceCompanyObjectionApply)itemCodeObjectionApplyMap.get(sub.getItemCodeId())));
        }
    }

    public List<NewComplianceCompanyItemdata> getCommitmentContent(Long cid, String type, Map<String, Object> map) {
        ArrayList<NewComplianceCompanyItemdata> list = new ArrayList<NewComplianceCompanyItemdata>();
        if (cid == null || com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)type) || MapUtils.isEmpty(map) || map.get("complianceId") == null) {
            return list;
        }
        switch (type) {
            case "staffBasicInfo": {
                return this.getStaffBasicInfo(cid, list, map);
            }
            case "healthManagementInfo": {
                return this.getHealthManagementInfo(cid, list);
            }
            case "institutionInfo": {
                List institutionInfo = this.msInfoService.getInstitutionInfo(cid, Collections.emptyMap());
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)institutionInfo)) {
                    List collect = institutionInfo.stream().map(m -> {
                        NewComplianceCompanyItemdata itemdata = new NewComplianceCompanyItemdata();
                        BeanUtils.copyProperties((Object)m, (Object)itemdata);
                        return itemdata;
                    }).collect(Collectors.toList());
                    list.addAll(collect);
                }
                return list;
            }
        }
        return list;
    }

    public List<Long> getCidList() {
        Example example = new Example(NewComplianceCompanyInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)false).andNotIn("status", Arrays.asList(NewComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANCE.getKey()));
        example.selectProperties(new String[]{"cid"});
        example.setDistinct(true);
        List listByExample = this.getListByExample(example);
        return listByExample.stream().map(NewComplianceCompanyInfo::getCid).collect(Collectors.toList());
    }

    public Set<Long> getSubmitComplianceCidSet(Collection<Long> cids) {
        Example example = new Example(NewComplianceCompanyInfo.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)false).andEqualTo("complianceIndusInvalid", (Object)0).andNotIn("status", Arrays.asList(NewComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANCE.getKey()));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(cids)) {
            criteria.andIn("cid", cids);
        }
        example.selectProperties(new String[]{"cid"});
        example.setDistinct(true);
        List listByExample = this.getListByExample(example);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(listByExample)) {
            return listByExample.stream().map(NewComplianceCompanyInfo::getCid).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Integer recalculateComplianceStatus(Long complianceId) {
        NewComplianceCompanyInfo info = (NewComplianceCompanyInfo)((NewComplianceCompanyInfoMapper)this.dao).selectByPrimaryKey(complianceId);
        if (info == null || info.getComplianceScore() == null) {
            return NewComplianceInfoStatusEnum.NON_COMPLIANCE.getKey();
        }
        BigDecimal score = info.getComplianceScore();
        if (this.exitItemMapper.whetherExitItemsExist(complianceId).booleanValue()) {
            return NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey();
        }
        boolean hasExitItems = this.exitItemMapper.hasExitItems(complianceId);
        boolean hasApplyOrObjection = this.applyMapper.hasApplyOrObjection(complianceId);
        boolean hasProgress = ((NewComplianceCompanyInfoMapper)this.dao).hasProgressOrPromise(complianceId);
        if (hasExitItems || hasApplyOrObjection || hasProgress) {
            return NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey();
        }
        if (score.compareTo(NewComplianceCompanyConstants.COMPLIANT_SCORE) >= 0) {
            return NewComplianceInfoStatusEnum.COMPLIANT.getKey();
        }
        if (score.compareTo(NewComplianceCompanyConstants.BASIC_COMPLIANT_SCORE) >= 0) {
            return NewComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey();
        }
        return NewComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey();
    }

    public List<NewComplianceCompanyInfo> queryScoreByCidList(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((NewComplianceCompanyInfoMapper)this.dao).queryScoreByCidList(cidList);
    }

    public List<ImportantIndustryCategory> getImportantTypeByCids(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((NewComplianceCompanyInfoMapper)this.dao).getImportantTypeByCids(cidList);
    }

    public NewComplianceCompanyPromiseModel queryPromiseInfoById(Long complianceId) {
        if (complianceId == null) {
            return null;
        }
        return ((NewComplianceCompanyInfoMapper)this.dao).queryPromiseInfoById(complianceId);
    }

    public ComplianceVisualModel collectVisualCompliance(ComplianceVisualParam searchVo) {
        if (searchVo == null || searchVo.getAreaId() == null || searchVo.getAreaLevel() == null) {
            return null;
        }
        ImmutablePair weekNumber = cn.smarthse.common.util.date.DateUtil.getWeekNumber((LocalDate)LocalDate.now());
        searchVo.setWeekNum((Integer)weekNumber.getLeft());
        ComplianceVisualModel model = ((NewComplianceCompanyInfoMapper)this.dao).collectVisualCompliance(searchVo);
        if (model == null) {
            model = new ComplianceVisualModel();
            model.setHgTotal(Long.valueOf(0L));
            model.setZzHgTotal(Long.valueOf(0L));
            model.setMzjjHgTotal(Long.valueOf(0L));
            model.setQtHgTotal(Long.valueOf(0L));
            model.setSubmitHgTotal(Long.valueOf(0L));
            model.setJbHgTotal(Long.valueOf(0L));
            model.setIngHgTotal(Long.valueOf(0L));
            model.setLe80OrHasOutHgTotal(Long.valueOf(0L));
            model.setDescend(Long.valueOf(0L));
            this.setAreaSocre(searchVo, model);
            return model;
        }
        List hgCollectData = this.hgcollectMonthReportService.getHgCollectData(searchVo);
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)hgCollectData)) {
            Long preMonthHgNum = hgCollectData.stream().filter(f -> f != null && f.getHgNum() != null).map(f -> f.getHgNum()).reduce(0L, Long::sum);
            Long hgTotal = model.getHgTotal();
            model.setPreWeekHgTotal(preMonthHgNum);
            if (preMonthHgNum != null && hgTotal != null && !preMonthHgNum.equals(BigDecimal.ZERO)) {
                model.setPreWeekHgDiffTotal(Long.valueOf(hgTotal - preMonthHgNum));
                String preMonthHgDiffPercen = new BigDecimal(model.getPreWeekHgDiffTotal()).divide(new BigDecimal(preMonthHgNum), 2, 4).multiply(new BigDecimal(100)).setScale(2, 4).stripTrailingZeros().toPlainString();
                model.setPreWeekHgDiffPercen(preMonthHgDiffPercen);
            }
        }
        Long hgTotal = model.getHgTotal();
        BigDecimal num = hgTotal != null ? BigDecimal.valueOf((double)hgTotal.longValue() * 2.25).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        model.setFreePunishAmountNowYear(this.convertUnit(num));
        this.setAreaSocre(searchVo, model);
        return model;
    }

    private String convertUnit(BigDecimal punishAmount) {
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal tenThousand = new BigDecimal("10000.0");
        if (punishAmount.compareTo(BigDecimal.ZERO) >= 0 && punishAmount.compareTo(one) < 0) {
            return String.format("%s \u5143", punishAmount.multiply(tenThousand));
        }
        if (punishAmount.compareTo(one) >= 0 && punishAmount.compareTo(tenThousand) < 0) {
            return String.format("%s \u4e07\u5143", punishAmount);
        }
        if (punishAmount.compareTo(tenThousand) >= 0) {
            return String.format("%s \u4ebf\u5143", punishAmount.divide(tenThousand, 2, RoundingMode.HALF_UP));
        }
        return "";
    }

    public List<NewComplianceNeedRefreshModel> judgeExistObjectionByCidList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((NewComplianceCompanyInfoMapper)this.dao).judgeExistObjectionByCidList(cidList);
    }

    private List<NewComplianceCompanyItemdata> getStaffBasicInfo(Long cid, List<NewComplianceCompanyItemdata> list, Map<String, Object> map) {
        Integer staffTotalNum = this.companyReportInfoService.getCompanyReportInfoStaffCount(cid);
        Integer localWorkNum = 0;
        Integer outWorkNum = 0;
        List staffInfoList = this.staffInfoService.getStaffInfoWorkNum(Collections.singletonList(cid), null);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)staffInfoList) && staffInfoList.get(0) != null) {
            localWorkNum = ((StaffInfo)staffInfoList.get(0)).getLocalWorkNum();
            outWorkNum = ((StaffInfo)staffInfoList.get(0)).getOutWorkNum();
        }
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("staffTotalNum").setResultData(String.valueOf(staffTotalNum)));
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("localNum").setResultData(String.valueOf(localWorkNum)));
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("outNum").setResultData(String.valueOf(outWorkNum)));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(map) && map.get("complianceId") == null) {
            return list;
        }
        Example example = new Example(NewComplianceCompanyItemdata.class);
        example.createCriteria().andEqualTo("complianceId", map.get("complianceId")).andIn("itemcodeId", Arrays.asList(11201L, 11202L, 11303L)).andEqualTo("isValid", (Object)true);
        list.addAll(this.itemdataService.getListByExample(example));
        return list;
    }

    private List<NewComplianceCompanyItemdata> getHealthManagementInfo(Long cid, List<NewComplianceCompanyItemdata> list) {
        Integer majorNum = 0;
        Integer healthManageNum = 0;
        Integer healthManageZZNum = 0;
        Integer healthManageJZNum = 0;
        Integer complianceManageNum = 0;
        List data = this.functionalOrganizationMemberService.getListHealthManagementInfoVo(Collections.singletonList(cid), Collections.emptyMap());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)data) && data.get(0) != null) {
            majorNum = ((HealthManagementInfoVo)data.get(0)).getMajorNum();
            healthManageNum = ((HealthManagementInfoVo)data.get(0)).getHealthManageNum();
            complianceManageNum = ((HealthManagementInfoVo)data.get(0)).getComplianceManageNum();
            if (((HealthManagementInfoVo)data.get(0)).getHealthManageZZNum() != null) {
                healthManageZZNum = ((HealthManagementInfoVo)data.get(0)).getHealthManageZZNum();
            }
            if (((HealthManagementInfoVo)data.get(0)).getHealthManageJZNum() != null) {
                healthManageJZNum = ((HealthManagementInfoVo)data.get(0)).getHealthManageJZNum();
            }
        }
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("majorNum").setResultData(String.valueOf(majorNum)));
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("healthManageNum").setResultData(String.valueOf(healthManageNum)));
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("healthManageZZNum").setResultData(String.valueOf(healthManageZZNum)));
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("healthManageJZNum").setResultData(String.valueOf(healthManageJZNum)));
        list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("complianceManageNum").setResultData(String.valueOf(complianceManageNum)));
        return list;
    }

    public List<NewComplianceCompanyInfoLabelModel> selectComplianceInfoLabels(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return null;
        }
        return ((NewComplianceCompanyInfoMapper)this.dao).selectComplianceInfoLabels(cidList);
    }

    public List<NewComplianceCompanyInfo> getComplianceStatus(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return null;
        }
        return ((NewComplianceCompanyInfoMapper)this.dao).getComplianceStatus(cidList);
    }

    public Map<Long, Long> getComplianceIdByCidList(List<Long> cidList) {
        List<NewComplianceCompanyInfo> complianceCids = this.getComplianceCids(cidList);
        return complianceCids.stream().collect(Collectors.toMap(NewComplianceCompanyInfo::getCid, NewComplianceCompanyInfo::getId));
    }

    public Boolean getCompanyIsComplianceItem(Long cid) {
        return ((NewComplianceCompanyInfoMapper)this.dao).getCompanyIsComplianceItem(cid);
    }

    public void sendNonComplianceSms(Long complianceId, String text) {
        NewComplianceCompanyListVo infoVo = ((NewComplianceCompanyInfoMapper)this.dao).getDetailById(complianceId);
        if (infoVo == null) {
            return;
        }
        try {
            if (this.smsSwitch.booleanValue()) {
                if (infoVo.getOccManagerTel() != null && !infoVo.getOccManagerTel().isEmpty()) {
                    this.smsProvideMasService.sendSms(infoVo.getOccManagerTel(), text);
                } else {
                    log.warn("\u4f01\u4e1a: {} \u7f3a\u5c11\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)infoVo.getName());
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    public Set<Long> getCidsByVictimnullorgt3() {
        return ((NewComplianceCompanyInfoMapper)this.dao).getCidsByVictimnullorgt3();
    }

    @Transactional(readOnly=false)
    public void syncReformOutComplianceData(Long complianceId, Long cid) {
        if (complianceId == null || cid == null) {
            return;
        }
        Example e = new Example(NewComplianceCompanyInfo.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isOut", (Object)true).andEqualTo("isOutReason", (Object)NewComplianceOutReasonEnum.REFORM_OUT.getKey());
        e.setOrderByClause("create_date desc");
        List hasList = this.getListByExample(e);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(hasList)) {
            Long oldComplianceId = ((NewComplianceCompanyInfo)hasList.get(0)).getId();
            ((NewComplianceCompanyInfoMapper)this.dao).syncEverDayScoreChange(complianceId, oldComplianceId);
            ((NewComplianceCompanyInfoMapper)this.dao).syncComplianceItemData(complianceId, oldComplianceId);
        }
    }

    private void setAreaSocre(ComplianceVisualParam searchVo, ComplianceVisualModel model) {
        HomeComplianceBasicVo provinceAvgVo;
        Boolean isCurrent = searchVo.getAreaLevel() >= 3 ? Boolean.FALSE : (searchVo.getIsCurrent() == null ? null : searchVo.getIsCurrent());
        NewComplianceAreaScore areaScore = this.newComplianceAreaScoreService.getOneAreaScore(searchVo.getAreaId(), searchVo.getAreaLevel(), isCurrent);
        if (areaScore != null) {
            model.setScore(areaScore.getScore());
            model.setComplianceCount2024(areaScore.getComplianceCount2024());
            model.setComplianceProportion2024(areaScore.getComplianceProportion2024());
            model.setCompanyTotal(Long.valueOf(areaScore.getCompanyNum().intValue()));
        }
        if ((provinceAvgVo = this.homeComplianceService.getProvinceAvgVo()) != null) {
            model.setProvinceAvg(provinceAvgVo.getProvinceAvg());
            model.setProvinceAvgCount(provinceAvgVo.getProvinceAvgCount());
        }
    }

    public List<NewComplianceCompanyInfo> listComplianceIndusStatus(List<Long> cids, List<Integer> status) {
        return ((NewComplianceCompanyInfoMapper)this.dao).listComplianceIndusStatus(cids, status);
    }

    @Transactional(readOnly=false)
    public void updateComplianceIndusInvalid(List<NewComplianceCompanyInfo> complianceStatuCids) {
        Set invalidCompliceIdSet;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(complianceStatuCids)) {
            return;
        }
        Set validCompliceIdSet = complianceStatuCids.stream().filter(f -> Objects.equals(f.getComplianceIndusInvalid(), 1) && f.getComplianceIndusId() != null).map(NewComplianceCompanyInfo::getId).collect(Collectors.toSet());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(validCompliceIdSet)) {
            Example example = new Example(NewComplianceCompanyInfo.class);
            example.createCriteria().andIn("id", validCompliceIdSet);
            NewComplianceCompanyInfo result = new NewComplianceCompanyInfo();
            result.setComplianceIndusInvalid(Integer.valueOf(0));
            result.setUpdateDate(new Date());
            ((NewComplianceCompanyInfoMapper)this.dao).updateByExampleSelective(result, example);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(invalidCompliceIdSet = complianceStatuCids.stream().filter(f -> Objects.equals(f.getComplianceIndusInvalid(), 0) && f.getComplianceIndusId() == null).map(NewComplianceCompanyInfo::getId).collect(Collectors.toSet()))) {
            Example example = new Example(NewComplianceCompanyInfo.class);
            example.createCriteria().andIn("id", invalidCompliceIdSet);
            NewComplianceCompanyInfo result = new NewComplianceCompanyInfo();
            result.setComplianceIndusInvalid(Integer.valueOf(1));
            result.setUpdateDate(new Date());
            ((NewComplianceCompanyInfoMapper)this.dao).updateByExampleSelective(result, example);
        }
    }
}

