/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.hutool.core.convert.Convert;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.compliance.service.home.IHomeComplianceService;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceBasicVo;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyChangeRecordMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemRecordMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyInfoBakMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyItemdataMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyLabelMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyProcessRecordMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanySubitemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceScoreChangeRecordMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceAreaScore;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItem;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItemRecord;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItem;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyLabel;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyProcessRecord;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanySubitem;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyQueryParam;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceAreaScoreService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoManagerService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyCountVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceLogVo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class NewComplianceCompanyInfoManagerServiceImpl
implements INewComplianceCompanyInfoManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceCompanyInfoManagerServiceImpl.class);
    private final NewComplianceCompanyInfoMapper infoMapper;
    private final NewComplianceCompanyInfoBakMapper infoBakMapper;
    private final INewComplianceCompanyInfoService infoService;
    private final NewComplianceCompanyItemMapper itemMapper;
    private final NewComplianceCompanyItemdataMapper itemdataMapper;
    private final NewComplianceCompanyExitItemMapper exitItemMapper;
    private final NewComplianceCompanyExitItemRecordMapper exitItemRecordMapper;
    private final NewComplianceCompanySubitemMapper subitemMapper;
    private final NewComplianceCompanyChangeRecordMapper changeRecordMapper;
    private final INewComplianceCompanyObjectionApplyService objectionApplyService;
    private final NewComplianceCompanyProcessRecordMapper processRecordMapper;
    private final NewComplianceScoreChangeRecordMapper scoreChangeRecordMapper;
    private final NewComplianceCompanyLabelMapper labelMapper;
    private final INewComplianceAreaScoreService complianceAreaScoreService;
    private final IHomeComplianceService homeComplianceService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryService;

    @Transactional
    public ResponseData<String> resetComplianceData(Long id, Long loginUserId) {
        NewComplianceCompanyInfo info = this.infoService.getInfoById(id);
        if (info == null) {
            return ResponseData.fail((String)"\u4f20\u5165id\u6709\u8bef\uff0c\u67e5\u4e0d\u5230\u5408\u89c4\u6570\u636e");
        }
        Date now = new Date();
        this.updateComplianceCompanyInfo(info, loginUserId);
        this.updateComplianceCompanyItem(id, loginUserId, now);
        this.updateComplianceCompanyItemData(id, loginUserId, now);
        this.updateComplianceCompanySubitem(id, loginUserId, now);
        this.updateComplianceCompanyExitItem(id, loginUserId, now);
        this.updateComplianceCompanyExitItemRecord(info.getCid(), loginUserId, now);
        this.updateComplianceCompanyLabel(id, loginUserId, now);
        Example objectionApplyExample = this.createComplianceIdExample(NewComplianceCompanyObjectionApply.class, id);
        List objectionApplyList = this.objectionApplyService.getListByExample(objectionApplyExample);
        if (objectionApplyList != null && !objectionApplyList.isEmpty()) {
            this.objectionApplyService.batchUpdateOrInsert(objectionApplyList, NewComplianceCompanyObjectionApplyMapper.class, (item, mapper) -> {
                item.setUpdatedBy(loginUserId);
                item.setUpdateDate(now);
                item.setIsValid(Boolean.valueOf(false));
                return mapper.updateByPrimaryKeySelective(item);
            });
            List objectionApplyIds = objectionApplyList.stream().map(NewComplianceCompanyObjectionApply::getId).collect(Collectors.toList());
            Example processRecordExample = new Example(NewComplianceCompanyProcessRecord.class);
            processRecordExample.createCriteria().andIn("objectionApplyId", objectionApplyIds);
            this.processRecordMapper.deleteByExample(processRecordExample);
        }
        this.scoreChangeRecordMapper.cleanTableByComplianceId(id);
        this.changeRecordMapper.cleanTableByComplianceId(id);
        this.staffInfoService.cleanNewTable(Collections.singletonList(info.getCid()));
        return ResponseData.success();
    }

    public PageInfo<NewComplianceCompanyCountVo> listCountByArea(JqGridParam param, NewComplianceCompanyQueryParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<Object> list = new ArrayList();
        list = Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak()) ? (queryParam.getThisLevel() != null && queryParam.getThisLevel().booleanValue() ? this.infoBakMapper.listThisLevelCountByArea2024(queryParam) : this.infoBakMapper.listCountByArea2024(queryParam)) : (queryParam.getThisLevel() != null && queryParam.getThisLevel() != false ? this.infoMapper.listThisLevelCountByArea(queryParam) : this.infoMapper.listCountByArea(queryParam));
        HomeComplianceBasicVo provinceAvgVo = this.homeComplianceService.getProvinceAvgVo();
        this.setListScore(list, queryParam, provinceAvgVo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    private void setListScore(List<NewComplianceCompanyCountVo> list, NewComplianceCompanyQueryParam queryParam, HomeComplianceBasicVo provinceAvgVo) {
        List scoreList;
        if (Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak())) {
            scoreList = this.complianceAreaScoreService.getList20241231();
        } else {
            Example example = new Example(NewComplianceAreaScore.class);
            example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
            scoreList = this.complianceAreaScoreService.getListByExample(example);
        }
        Map<String, NewComplianceAreaScore> scoreMap = scoreList.stream().collect(Collectors.toMap(score -> score.getAreaId() + "_" + score.getAreaLevel(), score -> score, (existing, replacement) -> existing));
        for (NewComplianceCompanyCountVo vo : list) {
            String key = vo.getAreaId() + "_" + vo.getAreaLevel();
            if (!scoreMap.containsKey(key)) continue;
            NewComplianceAreaScore score2 = scoreMap.get(key);
            vo.setScore(score2.getScore());
            vo.setComplianceCount2024(score2.getComplianceCount2024());
            vo.setComplianceProportion2024(score2.getComplianceProportion2024());
            vo.setZeroComplianceCount(score2.getZeroComplianceCount());
            vo.setBelowOrNotImprovedCount(score2.getBelowOrNotImprovedCount());
            vo.setProvinceAvg(provinceAvgVo.getProvinceAvg());
            vo.setProvinceAvgCount(provinceAvgVo.getProvinceAvgCount());
        }
    }

    public Long listCountByAreaCount(NewComplianceCompanyQueryParam queryParam) {
        Long count = Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak()) ? (queryParam.getThisLevel() != null && queryParam.getThisLevel().booleanValue() ? this.infoBakMapper.listThisLevelCountByAreaCount2024(queryParam) : this.infoBakMapper.listCountByAreaCount2024(queryParam)) : (queryParam.getThisLevel() != null && queryParam.getThisLevel() != false ? this.infoMapper.listThisLevelCountByAreaCount(queryParam) : this.infoMapper.listCountByAreaCount(queryParam));
        return count;
    }

    public NewComplianceCompanyCountVo countByArea(NewComplianceCompanyQueryParam queryParam) {
        HomeComplianceBasicVo provinceAvgVo;
        List list;
        NewComplianceCompanyCountVo companyCountVo = Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak()) ? this.infoBakMapper.countAndCompanyNumByArea2024(queryParam) : this.infoMapper.countAndCompanyNumByArea(queryParam);
        companyCountVo.setAreaId(queryParam.getAreaId());
        companyCountVo.setAreaName(queryParam.getAreaName());
        if (queryParam.getThisLevel() != null && queryParam.getThisLevel().booleanValue()) {
            companyCountVo.setAreaName(companyCountVo.getAreaName() + "\u5e02\u672c\u7ea7");
        }
        Example example = new Example(NewComplianceAreaScore.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("areaId", (Object)companyCountVo.getAreaId()).andEqualTo("areaLevel", (Object)companyCountVo.getAreaLevel());
        if (Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak())) {
            String startDate = "2024-12-31 00:00:00";
            String endDate = "2025-01-01 00:00:00";
            criteria.andGreaterThanOrEqualTo("updateDate", (Object)startDate).andLessThan("updateDate", (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.complianceAreaScoreService.getListByExample(example)))) {
            NewComplianceAreaScore score = (NewComplianceAreaScore)list.get(0);
            companyCountVo.setScore(score.getScore());
            companyCountVo.setComplianceCount2024(score.getComplianceCount2024());
            companyCountVo.setComplianceProportion2024(score.getComplianceProportion2024());
            companyCountVo.setZeroComplianceCount(score.getZeroComplianceCount());
            companyCountVo.setBelowOrNotImprovedCount(score.getBelowOrNotImprovedCount());
        }
        if ((provinceAvgVo = this.homeComplianceService.getProvinceAvgVo()) != null) {
            companyCountVo.setProvinceAvg(provinceAvgVo.getProvinceAvg());
            companyCountVo.setProvinceAvgCount(provinceAvgVo.getProvinceAvgCount());
        }
        return companyCountVo;
    }

    public PageInfo<NewComplianceLogVo> getComplianceLog(JqGridParam param, NewComplianceCompanyQueryParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<NewComplianceLogVo> list = this.infoMapper.getComplianceLog(queryParam);
        ArrayList<Long> industryRegisterIdList = new ArrayList<Long>();
        for (NewComplianceLogVo vo : list) {
            if (!"null".equalsIgnoreCase(vo.getBeforeInfo())) {
                industryRegisterIdList.add(Long.valueOf(vo.getBeforeInfo()));
            }
            if (!"null".equalsIgnoreCase(vo.getAfterInfo())) {
                industryRegisterIdList.add(Long.valueOf(vo.getAfterInfo()));
            }
            vo.setChangeType(RecordOperationTypeEnum.getValue((Byte)vo.getBusiType()));
        }
        Map<Long, SysParamModel> irMap = this.batchGetIndustryRegister(industryRegisterIdList);
        for (NewComplianceLogVo vo : list) {
            String befIndustry;
            SysParamModel befParam = irMap.get(Convert.toLong((Object)vo.getBeforeInfo()));
            SysParamModel aftParam = irMap.get(Convert.toLong((Object)vo.getAfterInfo()));
            String string = "null".equalsIgnoreCase(vo.getBeforeInfo()) ? "-" : (befIndustry = Objects.isNull(befParam) ? "-" : befParam.getParamCode() + "-" + befParam.getParamValue());
            String aftIndustry = "null".equalsIgnoreCase(vo.getAfterInfo()) ? "-" : (Objects.isNull(aftParam) ? "-" : aftParam.getParamCode() + "-" + aftParam.getParamValue());
            vo.setBeforeInfoStr(befIndustry);
            vo.setAfterInfoStr(aftIndustry);
        }
        return new PageInfo(list);
    }

    private void updateComplianceCompanyInfo(NewComplianceCompanyInfo info, Long loginUserId) {
        info.setIsValid(Boolean.valueOf(false));
        this.infoService.update((Object)info, loginUserId);
    }

    private void updateComplianceCompanyItem(Long id, Long loginUserId, Date now) {
        Example itemExample = this.createComplianceIdExample(NewComplianceCompanyItem.class, id);
        NewComplianceCompanyItem item = new NewComplianceCompanyItem();
        item.setIsValid(Boolean.valueOf(false));
        item.setUpdateDate(now);
        item.setUpdateBy(loginUserId);
        int num = this.itemMapper.updateByExampleSelective(item, itemExample);
        log.info("\u5408\u89c4\u5355\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyItemData(Long id, Long loginUserId, Date now) {
        Example itemDataExample = this.createComplianceIdExample(NewComplianceCompanyItemdata.class, id);
        NewComplianceCompanyItemdata itemdata = new NewComplianceCompanyItemdata();
        itemdata.setIsValid(Boolean.valueOf(false));
        itemdata.setUpdateDate(now);
        itemdata.setUpdateBy(loginUserId);
        int num = this.itemdataMapper.updateByExampleSelective(itemdata, itemDataExample);
        log.info("\u5408\u89c4\u5c0f\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanySubitem(Long id, Long loginUserId, Date now) {
        Example subitemExample = this.createComplianceIdExample(NewComplianceCompanySubitem.class, id);
        NewComplianceCompanySubitem subitem = new NewComplianceCompanySubitem();
        subitem.setIsValid(Boolean.valueOf(false));
        subitem.setUpdateDate(now);
        subitem.setUpdateBy(loginUserId);
        int num = this.subitemMapper.updateByExampleSelective(subitem, subitemExample);
        log.info("\u5b50\u5408\u89c4\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyExitItem(Long id, Long loginUserId, Date now) {
        Example exitItemExample = this.createComplianceIdExample(NewComplianceCompanyExitItem.class, id);
        NewComplianceCompanyExitItem exitItem = new NewComplianceCompanyExitItem();
        exitItem.setIsValid(Boolean.valueOf(false));
        exitItem.setUpdateDate(now);
        exitItem.setUpdateBy(loginUserId);
        int num = this.exitItemMapper.updateByExampleSelective(exitItem, exitItemExample);
        log.info("\u9000\u51fa\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyExitItemRecord(Long id, Long loginUserId, Date now) {
        Example exitItemRecordExample = this.createCidExample(NewComplianceCompanyExitItemRecord.class, id);
        NewComplianceCompanyExitItemRecord exitItemRecord = new NewComplianceCompanyExitItemRecord();
        exitItemRecord.setIsValid(Boolean.valueOf(false));
        exitItemRecord.setUpdateDate(now);
        exitItemRecord.setUpdatedBy(loginUserId);
        int num = this.exitItemRecordMapper.updateByExampleSelective(exitItemRecord, exitItemRecordExample);
        log.info("\u9000\u51fa\u9879\u8bb0\u5f55\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyLabel(Long id, Long loginUserId, Date now) {
        Example labelExample = this.createComplianceIdExample(NewComplianceCompanyLabel.class, id);
        NewComplianceCompanyLabel label = new NewComplianceCompanyLabel();
        label.setIsValid(Boolean.valueOf(false));
        label.setUpdateDate(now);
        label.setUpdateBy(loginUserId);
        int num = this.labelMapper.updateByExampleSelective(label, labelExample);
        log.info("\u6807\u7b7e\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private <T> Example createComplianceIdExample(Class<T> clazz, Long id) {
        Example example = new Example(clazz);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("complianceId", (Object)id);
        return example;
    }

    private <T> Example createCidExample(Class<T> clazz, Long id) {
        Example example = new Example(clazz);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)id);
        return example;
    }

    private Map<Long, SysParamModel> batchGetIndustryRegister(List<Long> industryRegisterIdList) {
        Map<Long, SysParamModel> irMap = new HashMap<Long, SysParamModel>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(industryRegisterIdList)) {
            String industryRegisterIds = industryRegisterIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List industryRegisterList = this.industryService.getListByIds(industryRegisterIds);
            irMap = industryRegisterList.stream().collect(Collectors.toMap(SysParamModel::getId, r -> r, (a, b) -> a));
        }
        return irMap;
    }

    @Generated
    public NewComplianceCompanyInfoManagerServiceImpl(NewComplianceCompanyInfoMapper infoMapper, NewComplianceCompanyInfoBakMapper infoBakMapper, INewComplianceCompanyInfoService infoService, NewComplianceCompanyItemMapper itemMapper, NewComplianceCompanyItemdataMapper itemdataMapper, NewComplianceCompanyExitItemMapper exitItemMapper, NewComplianceCompanyExitItemRecordMapper exitItemRecordMapper, NewComplianceCompanySubitemMapper subitemMapper, NewComplianceCompanyChangeRecordMapper changeRecordMapper, INewComplianceCompanyObjectionApplyService objectionApplyService, NewComplianceCompanyProcessRecordMapper processRecordMapper, NewComplianceScoreChangeRecordMapper scoreChangeRecordMapper, NewComplianceCompanyLabelMapper labelMapper, INewComplianceAreaScoreService complianceAreaScoreService, IHomeComplianceService homeComplianceService) {
        this.infoMapper = infoMapper;
        this.infoBakMapper = infoBakMapper;
        this.infoService = infoService;
        this.itemMapper = itemMapper;
        this.itemdataMapper = itemdataMapper;
        this.exitItemMapper = exitItemMapper;
        this.exitItemRecordMapper = exitItemRecordMapper;
        this.subitemMapper = subitemMapper;
        this.changeRecordMapper = changeRecordMapper;
        this.objectionApplyService = objectionApplyService;
        this.processRecordMapper = processRecordMapper;
        this.scoreChangeRecordMapper = scoreChangeRecordMapper;
        this.labelMapper = labelMapper;
        this.complianceAreaScoreService = complianceAreaScoreService;
        this.homeComplianceService = homeComplianceService;
    }
}

