/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.newcompliance.calcscore.NewCalcScoreBusService;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyExitItemRecordMapper;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItem;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyExitItemRecord;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyLabel;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceExitTypeEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoLabelEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceNeedRefreshModel;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyExitItemRecordService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyExitItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyLabelService;
import cn.smarthse.modules.health.newcompliance.service.INewCompliancePrepareSmsService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyExitItemRecordVo;
import cn.smarthse.modules.health.newcompliance.vo.NewComplianceCompanyExitItemVo;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class NewComplianceCompanyExitItemServiceImpl
extends BaseServiceImpl<NewComplianceCompanyExitItemMapper, NewComplianceCompanyExitItem>
implements INewComplianceCompanyExitItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceCompanyExitItemServiceImpl.class);
    @Autowired
    private NewComplianceCompanyInfoMapper complianceCompanyInfoMapper;
    @Autowired
    private NewComplianceCompanyExitItemRecordMapper exitItemRecordMapper;
    @Autowired
    private INewComplianceCompanyExitItemRecordService exitItemRecordService;
    @Autowired
    private INewComplianceCompanyInfoService complianceCompanyInfoService;
    @Autowired
    private INewComplianceCompanyLabelService complianceCompanyLabelService;
    @Autowired
    private ISupervisionLawService supervisionLawService;
    @DubboReference
    private IBxZybService bxZybService;
    @Autowired
    INewComplianceScoreRefreshService scoreRefreshService;
    @Autowired
    INewCompliancePrepareSmsService prepareSmsService;
    @Autowired
    NewCalcScoreBusService calcScoreBusService;

    public List<NewComplianceCompanyExitItemVo> getItemByComplianceIdAndType(Long complianceId, Byte type) {
        return ((NewComplianceCompanyExitItemMapper)this.dao).getItemByCidAndType(complianceId, type);
    }

    @Transactional
    public void saveItem(NewComplianceCompanyExitItem item, Long userId) {
        java.util.Date now = new java.util.Date();
        NewComplianceCompanyInfo info = this.complianceCompanyInfoMapper.getInfoById(item.getComplianceId());
        if (info == null) {
            throw new ServiceException("\u4f20\u5165complianceId\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u5408\u89c4\u4f01\u4e1a");
        }
        item.setCid(info.getCid());
        if (item.getId() == null) {
            item.setCreateDate(now);
            item.setCreateBy(userId);
            item.setIsValid(Boolean.TRUE);
            item.setId(Long.valueOf(IdWorker.getId()));
            ((NewComplianceCompanyExitItemMapper)this.dao).insertSelective(item);
            this.exitItemRecordService.addExitItemRecord(null, item, userId, now, (byte)2);
        } else {
            NewComplianceCompanyExitItem oldItem = (NewComplianceCompanyExitItem)((NewComplianceCompanyExitItemMapper)this.dao).selectByPrimaryKey(item.getId());
            if (oldItem.getBusinessId() != null) {
                if (item.getStatus() == 1) {
                    String content = oldItem.getContent();
                    String[] split = content.split("; ");
                    for (int i = 0; i < split.length; ++i) {
                        if (i == 0) {
                            item.setDate(DateUtils.parseDate((Object)split[i]));
                        }
                        if (i != 1) continue;
                        if (split[i].contains("\u7f5a\u6b3e")) {
                            item.setLevel(Byte.valueOf((byte)2));
                        }
                        if (!split[i].contains("\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a")) continue;
                        item.setLevel(Byte.valueOf((byte)3));
                    }
                }
                item.setContent(oldItem.getContent());
            }
            item.setUpdateBy(userId);
            item.setUpdateDate(now);
            item.setIsValid(Boolean.TRUE);
            ((NewComplianceCompanyExitItemMapper)this.dao).updateByPrimaryKey(item);
            this.exitItemRecordService.addExitItemRecord(oldItem, item, userId, now, (byte)3);
        }
    }

    private void setInitialDateIfNeeded(NewComplianceCompanyExitItem item) {
        if (item.getDate() == null) {
            LocalDate initialDate = null;
            switch (item.getType()) {
                case 2: {
                    initialDate = LocalDate.now().minusYears(2L).withMonth(1).withDayOfMonth(1);
                    break;
                }
                case 3: {
                    initialDate = LocalDate.now().minusYears(5L).withMonth(1).withDayOfMonth(1);
                    break;
                }
            }
            item.setDate((java.util.Date)Date.valueOf(initialDate));
        }
    }

    @Transactional
    public void delItem(Long id, Long userId) {
        NewComplianceCompanyExitItem item = (NewComplianceCompanyExitItem)((NewComplianceCompanyExitItemMapper)this.dao).selectByPrimaryKey(id);
        if (item == null) {
            throw new ServiceException("\u4f20\u5165ID\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
        }
        java.util.Date now = new java.util.Date();
        item.setIsValid(Boolean.FALSE);
        item.setUpdateBy(userId);
        item.setUpdateDate(now);
        ((NewComplianceCompanyExitItemMapper)this.dao).updateByPrimaryKey(item);
        this.exitItemRecordService.addExitItemRecord(null, item, userId, now, (byte)4);
    }

    @Transactional
    public Boolean submitItem(List<NewComplianceCompanyExitItemVo> list, Long userId) {
        Long cid = list.get(0).getCid();
        Long complianceId = list.get(0).getComplianceId();
        Integer type = list.get(0).getType();
        java.util.Date now = new java.util.Date();
        boolean hasStatusOne = false;
        LocalDate latestDate = null;
        boolean needSync = false;
        if (Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_4.getKey(), type) || Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey(), type)) {
            Example example = new Example(NewComplianceCompanyExitItem.class);
            example.createCriteria().andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true).andEqualTo("type", (Object)NewComplianceExitTypeEnum.REFERENCE_DATA.getKey());
            List referenceList = ((NewComplianceCompanyExitItemMapper)this.dao).selectByExample(example);
            for (NewComplianceCompanyExitItem item : referenceList) {
                item.setUpdateBy(userId);
                item.setUpdateDate(now);
                item.setStatus(Integer.valueOf(3));
                ((NewComplianceCompanyExitItemMapper)this.dao).updateByPrimaryKeySelective(item);
            }
        }
        for (NewComplianceCompanyExitItemVo vo : list) {
            boolean shouldUpdateLatestDate = false;
            if (type == 1 && (vo.getLevel() == null || vo.getLevel() != 1 && vo.getLevel() != 5)) {
                if (vo.getStatus() != null && vo.getStatus() != 2) {
                    hasStatusOne = true;
                    shouldUpdateLatestDate = true;
                }
            } else if (type != 1 && vo.getStatus() != null && vo.getStatus() == 1) {
                hasStatusOne = true;
                shouldUpdateLatestDate = true;
            }
            if (!shouldUpdateLatestDate || vo.getDate() == null) continue;
            LocalDate date = Instant.ofEpochMilli(vo.getDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            if (latestDate != null && !date.isAfter(latestDate)) continue;
            latestDate = date;
        }
        this.complianceCompanyLabelService.updateBypLabel(complianceId, Integer.valueOf(1), userId);
        NewComplianceCompanyInfo info = this.complianceCompanyInfoMapper.getInfoById(complianceId);
        if (hasStatusOne && latestDate != null) {
            int currentYear = LocalDate.now().getYear();
            int itemYear = latestDate.getYear();
            if (Objects.equals(NewComplianceExitTypeEnum.FINE.getKey(), type)) {
                if (itemYear == currentYear) {
                    this.updateInfoWithOut(info, userId, now);
                } else if (info != null && (info.getStatus() == NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
                    needSync = this.updateInfoByStatus(info, userId, now);
                }
            } else if (Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_4.getKey(), type)) {
                if (itemYear >= currentYear - 1) {
                    this.updateInfoWithOut(info, userId, now);
                } else if (info != null && (info.getStatus() == NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
                    needSync = this.updateInfoByStatus(info, userId, now);
                }
            } else if (Objects.equals(NewComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey(), type) || Objects.equals(NewComplianceExitTypeEnum.FALSIFICATION.getKey(), type)) {
                if (itemYear >= currentYear - 3) {
                    this.updateInfoWithOut(info, userId, now);
                } else if (info != null && (info.getStatus() == NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
                    needSync = this.updateInfoByStatus(info, userId, now);
                }
            }
        } else if (info != null && (info.getStatus() == NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
            needSync = this.updateInfoByStatus(info, userId, now);
        }
        return needSync;
    }

    public List<NewComplianceCompanyExitItemRecordVo> getRecordData(Long cid, Byte itemType) {
        return this.exitItemRecordMapper.getRecordData(cid, itemType);
    }

    public PageInfo<NewComplianceCompanyExitItemRecordVo> getRecordDataPage(JqGridParam pageParam, NewComplianceCompanyExitItemRecord record) {
        Page page = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        this.exitItemRecordMapper.getRecordDataPage(record);
        return new PageInfo((List)page);
    }

    public List<NewComplianceNeedRefreshModel> queryIsExistExitItems(List<Long> cidList) {
        return ((NewComplianceCompanyExitItemMapper)this.dao).queryIsExistExitItems(cidList);
    }

    @Transactional
    public Boolean updateInfoByStatus(NewComplianceCompanyInfo info, Long userId, java.util.Date now) {
        boolean needSync = false;
        if (info == null) {
            return needSync;
        }
        Boolean itemsExist = ((NewComplianceCompanyExitItemMapper)this.dao).whetherExitItemsExist(info.getId());
        if (!itemsExist.booleanValue()) {
            info.setStatus(NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            this.complianceCompanyInfoService.update((Object)info);
            needSync = true;
        }
        return needSync;
    }

    @Transactional
    public void syncExitItem(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            cidList = this.complianceCompanyInfoService.getCidList();
        }
        List lawExitItems = this.supervisionLawService.countNewCompliancePunishmentNum(cidList);
        List zybExitItems = this.bxZybService.countNewComplianceZybNum(cidList);
        lawExitItems.addAll(zybExitItems);
        if (CollectionUtils.isEmpty((Collection)lawExitItems)) {
            return;
        }
        Map complianceIdMap = this.complianceCompanyInfoService.getComplianceIdByCidList(cidList);
        this.batchUpdateOrInsert(lawExitItems, NewComplianceCompanyExitItemMapper.class, (item, mapper) -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setIsValid(Boolean.valueOf(true));
            item.setCreateDate(new java.util.Date());
            item.setUpdateDate(new java.util.Date());
            item.setCreateBy(Long.valueOf(0L));
            item.setUpdateBy(Long.valueOf(0L));
            Long complianceId = (Long)complianceIdMap.get(item.getCid());
            item.setComplianceId(complianceId);
            if (StringUtils.isNotBlank((CharSequence)item.getDeside())) {
                if (item.getDeside().contains("\u7f5a\u6b3e")) {
                    item.setLevel(Byte.valueOf((byte)2));
                }
                if (item.getDeside().contains("\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a")) {
                    item.setLevel(Byte.valueOf((byte)3));
                }
                String deside = "";
                if (item.getDeside().contains("\u7f5a\u6b3e")) {
                    deside = "\u7f5a\u6b3e";
                }
                if (item.getDeside().contains("\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a")) {
                    deside = "\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a";
                }
                item.setContent(DateUtils.formatDate((java.util.Date)item.getDate()).concat("; ").concat(deside));
            }
            return mapper.insert(item);
        });
        ArrayList<NewComplianceCompanyInfo> infos = new ArrayList<NewComplianceCompanyInfo>();
        ArrayList<NewComplianceCompanyLabel> labels = new ArrayList<NewComplianceCompanyLabel>();
        for (NewComplianceCompanyExitItem lawExitItem : lawExitItems) {
            NewComplianceCompanyInfo info2 = this.complianceCompanyInfoMapper.getInfoById(lawExitItem.getComplianceId());
            if (NewComplianceInfoStatusEnum.COMPLIANT.getKey() == info2.getStatus()) {
                this.prepareSmsService.addPrepareSms(lawExitItem.getComplianceId());
                info2.setLastExitQualifyDate(new java.util.Date());
            }
            infos.add(NewComplianceCompanyInfo.builder().id(lawExitItem.getComplianceId()).status(NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey()).updateDate(new java.util.Date()).build());
            labels.add(NewComplianceCompanyLabel.builder().complianceId(lawExitItem.getComplianceId()).label(NewComplianceInfoLabelEnum.EXITITEMS.getKey()).updateBy(Long.valueOf(0L)).updateDate(new java.util.Date()).createBy(Long.valueOf(0L)).createDate(new java.util.Date()).isValid(Boolean.valueOf(true)).build());
        }
        this.complianceCompanyInfoService.batchUpdateOrInsert(infos, NewComplianceCompanyInfoMapper.class, (info, mapper) -> mapper.refreshComplianceWithoutReformRemainDate((NewComplianceCompanyInfo)info));
        this.complianceCompanyLabelService.updateClashLabel(labels);
        List newlawExitItems2 = lawExitItems.stream().map(m -> {
            NewComplianceCompanyExitItem item1 = new NewComplianceCompanyExitItem();
            BeanUtils.copyProperties((Object)m, (Object)item1);
            return item1;
        }).collect(Collectors.toList());
        this.exitItemRecordService.batchAddExitItemRecord(newlawExitItems2, Long.valueOf(0L), new java.util.Date(), (byte)1);
    }

    public List<NewComplianceCompanyExitItem> queryHasExititems(Long complianceId) {
        return ((NewComplianceCompanyExitItemMapper)this.dao).queryHasExititems(complianceId);
    }

    private void updateInfoWithOut(NewComplianceCompanyInfo info, Long userId, java.util.Date now) {
        if (info != null) {
            Integer oldStatus = info.getStatus();
            info.setUpdateBy(userId);
            info.setUpdateDate(now);
            info.setStatus(NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey());
            info.setComplianceScore(null);
            info.setReformRemainDate(null);
            if (NewComplianceInfoStatusEnum.COMPLIANT.getKey() == oldStatus) {
                this.prepareSmsService.addPrepareSms(info.getId());
                info.setLastExitQualifyDate(new java.util.Date());
            }
            this.complianceCompanyInfoMapper.updateByPrimaryKey(info);
        }
    }
}

