/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanySubitem;
import cn.smarthse.modules.health.pojo.ComplianceTsProjectCount;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class NewTsProjectSimpleScoreCalcHandle
implements NewScoreCalcHandle {
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;

    @Override
    public String support() {
        return "04";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("5");
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List complianceTsProjectCount = this.tsProjectSimpleService.getComplianceTsProjectCount(cids, Integer.valueOf(2));
        Map<Long, List<ComplianceTsProjectCount>> cidMap = complianceTsProjectCount.stream().collect(Collectors.groupingBy(ComplianceTsProjectCount::getCid));
        ArrayList<NewComplianceCompanyItemdata> list = new ArrayList<NewComplianceCompanyItemdata>();
        for (Long cid : cids) {
            ComplianceTsProjectCount tsCount = new ComplianceTsProjectCount();
            List<ComplianceTsProjectCount> complianceTsProjectCounts = cidMap.get(cid);
            if (CollectionUtils.isNotEmpty(complianceTsProjectCounts)) {
                tsCount = complianceTsProjectCounts.get(0);
            }
            NewComplianceCompanyItemdata itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(10401L));
            itemData.setCid(cid);
            itemData.setFieldName("startedNum");
            itemData.setResultData(tsCount.getStartedNum().toString());
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(10401L));
            itemData.setCid(cid);
            itemData.setFieldName("notStartNum");
            itemData.setResultData(tsCount.getNotStartNum().toString());
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(10401L));
            itemData.setCid(cid);
            itemData.setFieldName("totalNum");
            itemData.setResultData(tsCount.getTotalNum().toString());
            list.add(itemData);
        }
        return list;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (MapUtils.isEmpty(fieldsItemDataMap)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        NewComplianceCompanyItemdata notStartData = fieldsItemDataMap.get("notStartNum");
        NewComplianceCompanyItemdata totalData = fieldsItemDataMap.get("totalNum");
        if (totalData != null && StringUtils.isNotEmpty((String)totalData.getResultData()) && "0".equalsIgnoreCase(totalData.getResultData())) {
            return new BigDecimal("0");
        }
        if (notStartData != null && StringUtils.isNotEmpty((String)notStartData.getResultData()) && !"0".equalsIgnoreCase(notStartData.getResultData())) {
            int notStartNum = Integer.parseInt(notStartData.getResultData());
            if (notStartNum >= 5) {
                bigDecimal = new BigDecimal("-5");
            } else {
                for (int i = 0; i < notStartNum; ++i) {
                    bigDecimal = bigDecimal.subtract(new BigDecimal("0.5"));
                }
            }
        }
        return bigDecimal;
    }

    public boolean isComplete(List<NewComplianceCompanySubitem> subItemList) {
        return false;
    }

    @Generated
    public NewTsProjectSimpleScoreCalcHandle() {
    }
}

