/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.NumberUtil;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.calcscore.rule.NewFristStepDataValidRule;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NewProtectScoreCalcHandle
implements NewScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewProtectScoreCalcHandle.class);
    @DubboReference
    private IProtectEquipIssueRecordService protectEquipService;
    @DubboReference
    private IStaffInfoService staffInfoService;

    @Override
    public String support() {
        return "11";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("10");
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<NewComplianceCompanyItemdata> result = new ArrayList<NewComplianceCompanyItemdata>();
        if (CollectionUtils.isEmpty(cids)) {
            return result;
        }
        Map<Long, List<ProtectEquipIssueRecord>> protectEquipMap = this.protectEquipService.getProtectNum(cids, Arrays.asList(4, 5), null).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ProtectEquipIssueRecord::getCid));
        Map workNumMap = this.staffInfoService.getStaffInfoWorkNum(cids, null).stream().filter(Objects::nonNull).collect(Collectors.toMap(StaffInfo::getCid, Function.identity(), (o1, o2) -> o1));
        for (Long cid : cids) {
            String protectEquipNum = String.valueOf(protectEquipMap.get(cid) == null ? 0 : protectEquipMap.get(cid).size());
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("protectEquipNum").setItemcodeId(Long.valueOf(11101L)).setResultData(protectEquipNum));
            String localFSWorkNum = workNumMap.get(cid) == null ? "0" : ((StaffInfo)workNumMap.get(cid)).getLocalFSWorkNum().toString();
            String outFSWorkNum = workNumMap.get(cid) == null ? "0" : ((StaffInfo)workNumMap.get(cid)).getOutFSWorkNum().toString();
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("localFSWorkNum").setItemcodeId(Long.valueOf(11104L)).setResultData(localFSWorkNum));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("outFSWorkNum").setItemcodeId(Long.valueOf(11104L)).setResultData(outFSWorkNum));
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (itemcodeId == null) {
            return BigDecimal.ZERO;
        }
        switch (itemcodeId.toString()) {
            case "11101": {
                if (fieldsItemDataMap.get("protectEquipNum") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("protectEquipNum").getResultData())) {
                    if (Integer.parseInt(fieldsItemDataMap.get("protectEquipNum").getResultData()) > 0) {
                        return BigDecimal.ZERO;
                    }
                    return new BigDecimal("-10");
                }
                return BigDecimal.ZERO;
            }
            case "11102": {
                if (fieldsItemDataMap.get("personalRequire") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("personalRequire").getResultData())) {
                    if (fieldsItemDataMap.get("personalRequire").getResultData().equals("true")) {
                        return BigDecimal.ZERO;
                    }
                    if (fieldsItemDataMap.get("personalRequire").getResultData().equals("false")) {
                        return new BigDecimal("-10");
                    }
                }
                return BigDecimal.ZERO;
            }
            case "11104": {
                if (this.isFsNormal(importantTypeStr).booleanValue() && fieldsItemDataMap.get("localFSWorkNum") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("localFSWorkNum").getResultData()) && fieldsItemDataMap.get("outFSWorkNum") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("outFSWorkNum").getResultData()) && fieldsItemDataMap.get("localUnWorkNum") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("localUnWorkNum").getResultData()) && fieldsItemDataMap.get("outUnWorkNum") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("outUnWorkNum").getResultData())) {
                    int outUnWorkNum;
                    int localFSWorkNum = NumberUtil.isNumber((CharSequence)fieldsItemDataMap.get("localFSWorkNum").getResultData()) ? Integer.parseInt(fieldsItemDataMap.get("localFSWorkNum").getResultData()) : 0;
                    int outFSWorkNum = NumberUtil.isNumber((CharSequence)fieldsItemDataMap.get("outFSWorkNum").getResultData()) ? Integer.parseInt(fieldsItemDataMap.get("outFSWorkNum").getResultData()) : 0;
                    int localUnWorkNum = NumberUtil.isNumber((CharSequence)fieldsItemDataMap.get("localUnWorkNum").getResultData()) ? Integer.parseInt(fieldsItemDataMap.get("localUnWorkNum").getResultData()) : 0;
                    int n = outUnWorkNum = NumberUtil.isNumber((CharSequence)fieldsItemDataMap.get("outUnWorkNum").getResultData()) ? Integer.parseInt(fieldsItemDataMap.get("outUnWorkNum").getResultData()) : 0;
                    if (localFSWorkNum == 0 && outFSWorkNum == 0) {
                        return BigDecimal.ZERO;
                    }
                    return new BigDecimal(-2).multiply(new BigDecimal(localUnWorkNum + outUnWorkNum));
                }
                return BigDecimal.ZERO;
            }
            case "11105": {
                if (this.isFcNormal(importantTypeStr).booleanValue() && fieldsItemDataMap.get("fcState") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("fcState").getResultData())) {
                    if (fieldsItemDataMap.get("fcState").getResultData().equals("2")) {
                        return new BigDecimal("-10");
                    }
                    return BigDecimal.ZERO;
                }
                return BigDecimal.ZERO;
            }
            case "11106": {
                if (this.isYdNormal(importantTypeStr).booleanValue() && fieldsItemDataMap.get("ydState") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("ydState").getResultData())) {
                    if (fieldsItemDataMap.get("ydState").getResultData().equals("2")) {
                        return new BigDecimal("-10");
                    }
                    return BigDecimal.ZERO;
                }
                return BigDecimal.ZERO;
            }
            case "11107": {
                if (this.isGwNormal(importantTypeStr).booleanValue() && fieldsItemDataMap.get("gwState") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("gwState").getResultData())) {
                    if (fieldsItemDataMap.get("gwState").getResultData().equals("2")) {
                        return new BigDecimal("-10");
                    }
                    return BigDecimal.ZERO;
                }
                return BigDecimal.ZERO;
            }
            case "11108": {
                if (this.isJxNormal(importantTypeStr).booleanValue() && fieldsItemDataMap.get("jxState") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("jxState").getResultData())) {
                    if (fieldsItemDataMap.get("jxState").getResultData().equals("2")) {
                        return new BigDecimal("-10");
                    }
                    return BigDecimal.ZERO;
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public List<NewFristStepDataValidRule> fristStepDataValueRule(String importantTypeStr) {
        ArrayList<NewFristStepDataValidRule> rules = new ArrayList<NewFristStepDataValidRule>();
        rules.add(new NewFristStepDataValidRule(11102L, "personalRequire", 1, "\u672a\u586b\u5199"));
        if (this.isFsNormal(importantTypeStr).booleanValue()) {
            rules.add(new NewFristStepDataValidRule(11104L, "localUnWorkNum", 1, "\u672a\u586b\u5199"));
            rules.add(new NewFristStepDataValidRule(11104L, "outUnWorkNum", 1, "\u672a\u586b\u5199"));
            rules.add(new NewFristStepDataValidRule(11104L, "localCompleteWorkNum", 1, "\u672a\u586b\u5199"));
            rules.add(new NewFristStepDataValidRule(11104L, "outCompleteWorkNum", 1, "\u672a\u586b\u5199"));
        }
        if (this.isJxNormal(importantTypeStr).booleanValue()) {
            rules.add(new NewFristStepDataValidRule(11108L, "jxState", 1, "\u672a\u586b\u5199"));
        }
        if (this.isFcNormal(importantTypeStr).booleanValue()) {
            rules.add(new NewFristStepDataValidRule(11105L, "fcState", 1, "\u672a\u586b\u5199"));
        }
        if (this.isYdNormal(importantTypeStr).booleanValue()) {
            rules.add(new NewFristStepDataValidRule(11106L, "ydState", 1, "\u672a\u586b\u5199"));
        }
        if (this.isGwNormal(importantTypeStr).booleanValue()) {
            rules.add(new NewFristStepDataValidRule(11107L, "gwState", 1, "\u672a\u586b\u5199"));
        }
        return rules;
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (itemcodeId == null) {
            return new Pair((Object)false, null);
        }
        if (itemcodeId == 11102L && (fieldsItemDataMap.get("personalRequire") == null || StringUtils.isBlank((CharSequence)fieldsItemDataMap.get("personalRequire").getResultData()))) {
            return new Pair((Object)true, (Object)"personalRequire");
        }
        if (this.isFsNormal(importantTypeStr).booleanValue() && itemcodeId == 11104L) {
            StringBuilder value = new StringBuilder();
            Integer localFSWorkNum = Optional.ofNullable(fieldsItemDataMap.get("localFSWorkNum")).map(NewComplianceCompanyItemdata::getResultData).filter(StringUtils::isNotBlank).map(Integer::valueOf).orElse(0);
            Integer outFSWorkNum = Optional.ofNullable(fieldsItemDataMap.get("outFSWorkNum")).map(NewComplianceCompanyItemdata::getResultData).filter(StringUtils::isNotBlank).map(Integer::valueOf).orElse(0);
            Integer localUnWorkNum = Optional.ofNullable(fieldsItemDataMap.get("localUnWorkNum")).map(NewComplianceCompanyItemdata::getResultData).filter(StringUtils::isNotBlank).map(Integer::valueOf).orElse(null);
            Integer outUnWorkNum = Optional.ofNullable(fieldsItemDataMap.get("outUnWorkNum")).map(NewComplianceCompanyItemdata::getResultData).filter(StringUtils::isNotBlank).map(Integer::valueOf).orElse(null);
            Integer localCompleteWorkNum = Optional.ofNullable(fieldsItemDataMap.get("localCompleteWorkNum")).map(NewComplianceCompanyItemdata::getResultData).filter(StringUtils::isNotBlank).map(Integer::valueOf).orElse(null);
            Integer outCompleteWorkNum = Optional.ofNullable(fieldsItemDataMap.get("outCompleteWorkNum")).map(NewComplianceCompanyItemdata::getResultData).filter(StringUtils::isNotBlank).map(Integer::valueOf).orElse(null);
            if (localUnWorkNum == null || localCompleteWorkNum == null || localUnWorkNum < 0 || localCompleteWorkNum < 0 || localCompleteWorkNum > localFSWorkNum || localUnWorkNum > localFSWorkNum || localUnWorkNum + localCompleteWorkNum != localFSWorkNum) {
                value.append("localFSWorkNum");
            }
            if (outUnWorkNum == null || outCompleteWorkNum == null || outUnWorkNum < 0 || outCompleteWorkNum < 0 || outCompleteWorkNum > outFSWorkNum || outUnWorkNum > outFSWorkNum || outUnWorkNum + outCompleteWorkNum != outFSWorkNum) {
                if (StringUtils.isNotBlank((CharSequence)value.toString())) {
                    value.append(",");
                }
                value.append("outFSWorkNum");
            }
            if (StringUtils.isNotBlank((CharSequence)value.toString())) {
                return new Pair((Object)true, (Object)value.toString());
            }
        }
        if (this.isFcNormal(importantTypeStr).booleanValue() && itemcodeId == 11105L && (fieldsItemDataMap.get("fcState") == null || StringUtils.isBlank((CharSequence)fieldsItemDataMap.get("fcState").getResultData()))) {
            return new Pair((Object)true, (Object)"fcState");
        }
        if (this.isGwNormal(importantTypeStr).booleanValue() && itemcodeId == 11107L && (fieldsItemDataMap.get("gwState") == null || StringUtils.isBlank((CharSequence)fieldsItemDataMap.get("gwState").getResultData()))) {
            return new Pair((Object)true, (Object)"gwState");
        }
        if (this.isYdNormal(importantTypeStr).booleanValue() && itemcodeId == 11106L && (fieldsItemDataMap.get("ydState") == null || StringUtils.isBlank((CharSequence)fieldsItemDataMap.get("ydState").getResultData()))) {
            return new Pair((Object)true, (Object)"ydState");
        }
        if (this.isJxNormal(importantTypeStr).booleanValue() && itemcodeId == 11108L && (fieldsItemDataMap.get("jxState") == null || StringUtils.isBlank((CharSequence)fieldsItemDataMap.get("jxState").getResultData()))) {
            return new Pair((Object)true, (Object)"jxState");
        }
        return new Pair((Object)false, null);
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == null || resultData == null || filedName == null) {
            return resultData;
        }
        switch (itemcodeId.toString()) {
            case "11102": {
                if (filedName.equals("personalRequire")) {
                    if (resultData.equals("true")) {
                        return "\u662f";
                    }
                    if (resultData.equals("false")) {
                        return "\u5426";
                    }
                }
            }
            case "11103": {
                if (filedName.equals("settingRequire")) {
                    if (resultData.equals("true")) {
                        return "\u662f";
                    }
                    if (resultData.equals("false")) {
                        return "\u5426";
                    }
                }
            }
            case "11105": {
                if (filedName.equals("fcState")) {
                    if (resultData.equals("0")) {
                        return "\u65e0\u7c89\u5c18\u5371\u5bb3\u573a\u6240";
                    }
                    if (resultData.equals("1")) {
                        return "\u662f";
                    }
                    if (resultData.equals("2")) {
                        return "\u5426";
                    }
                }
            }
            case "11106": {
                if (filedName.equals("ydState")) {
                    if (resultData.equals("0")) {
                        return "\u65e0\u6709\u6bd2\u7269\u8d28\u573a\u6240";
                    }
                    if (resultData.equals("1")) {
                        return "\u662f";
                    }
                    if (resultData.equals("2")) {
                        return "\u5426";
                    }
                }
            }
            case "11107": {
                if (filedName.equals("gwState")) {
                    if (resultData.equals("0")) {
                        return "\u65e0\u9ad8\u6e29\u573a\u6240";
                    }
                    if (resultData.equals("1")) {
                        return "\u662f";
                    }
                    if (resultData.equals("2")) {
                        return "\u5426";
                    }
                }
            }
            case "11108": {
                if (!filedName.equals("jxState")) break;
                if (resultData.equals("0")) {
                    return "\u65e0\u6025\u6027\u804c\u4e1a\u635f\u4f24\u7684\u573a\u6240";
                }
                if (resultData.equals("1")) {
                    return "\u662f";
                }
                if (!resultData.equals("2")) break;
                return "\u5426";
            }
        }
        return resultData;
    }

    public Boolean isFsNormal(String importantTypeStr) {
        if (StringUtils.isBlank((CharSequence)importantTypeStr)) {
            return true;
        }
        List<Integer> special = Arrays.asList(8, 9, 203, 5941, 5532, 5265, 3523, 811, 336, 195, 231, 171, 2611, 3011, 2671, 2412, 344, 3074, 342, 2925, 3465, 2459, 2652, 385, 3482, 3467, 3984, 3823, 303, 3323, 3089, 202, 2631, 331, 266, 4411, 302, 355, 192, 2130, 3130, 3351, 2441, 2613, 3252, 3831, 381);
        List collect = Arrays.stream(importantTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        for (Integer importantType : collect) {
            if (!special.contains(importantType)) continue;
            return false;
        }
        return true;
    }

    public Boolean isJxNormal(String importantTypeStr) {
        if (StringUtils.isBlank((CharSequence)importantTypeStr)) {
            return true;
        }
        List<Integer> special = Arrays.asList(5265, 5532);
        List collect = Arrays.stream(importantTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        for (Integer importantType : collect) {
            if (!special.contains(importantType)) continue;
            return false;
        }
        return true;
    }

    public Boolean isGwNormal(String importantTypeStr) {
        if (StringUtils.isBlank((CharSequence)importantTypeStr)) {
            return true;
        }
        List<Integer> special = Arrays.asList(811, 231, 344);
        List collect = Arrays.stream(importantTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        for (Integer importantType : collect) {
            if (!special.contains(importantType)) continue;
            return false;
        }
        return true;
    }

    public Boolean isFcNormal(String importantTypeStr) {
        if (StringUtils.isBlank((CharSequence)importantTypeStr)) {
            return true;
        }
        List<Integer> special = Arrays.asList(5941, 231, 5265);
        List collect = Arrays.stream(importantTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        for (Integer importantType : collect) {
            if (!special.contains(importantType)) continue;
            return false;
        }
        return true;
    }

    public Boolean isYdNormal(String importantTypeStr) {
        if (StringUtils.isBlank((CharSequence)importantTypeStr)) {
            return true;
        }
        List<Integer> special = Arrays.asList(3074);
        List collect = Arrays.stream(importantTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toList());
        for (Integer importantType : collect) {
            if (!special.contains(importantType)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public NewProtectScoreCalcHandle() {
    }
}

