/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.lang.Pair;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.noEnvo.PhcPhysicalStaffCheckInfoNoEn;
import cn.smarthse.modules.health.entity.work.check.checkV3221.noEnvo.StaffPhySicalCheckNoEnModel;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class NewPhysicalCheckScoreCalcHandle
implements NewScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewPhysicalCheckScoreCalcHandle.class);
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    private static final List<String> beforeWorkStatus = Collections.singletonList("1");
    private static final List<String> onWorkStatus = Arrays.asList("2", "5");
    private static final List<String> leaveWorkStatus = Arrays.asList("3", "4");
    private static final String ZyjjzConlution = "4";
    private static final String YszybConlution = "3";
    private static final Byte BEFORE_WORK = 1;
    private static final Byte ON_WORK = 2;
    private static final Byte LEAVE_WORK = 3;

    @Override
    public String support() {
        return "05";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("13");
    }

    public Map<Long, List<StaffPhySicalCheckNoEnModel>> loadStaffPhysicalCheckMap(List<Long> cids) {
        List phcPhysicalStaffCheckInfos = this.phcPhysicalStaffCheckInfoService.queryCompliancePhysicalCheckInfo(cids);
        List staffPhySicalCheckModelList = this.staffInfoService.queryNewPhysicalStaffList(cids);
        Map<Long, List<StaffPhySicalCheckNoEnModel>> staffPhySicalCheckMap = staffPhySicalCheckModelList.stream().filter(i -> i.getCardId() != null).collect(Collectors.groupingBy(StaffPhySicalCheckNoEnModel::getCid));
        ArrayList<StaffPhySicalCheckNoEnModel> tempList = new ArrayList<StaffPhySicalCheckNoEnModel>();
        ArrayList<StaffPhySicalCheckNoEnModel> AllList = new ArrayList<StaffPhySicalCheckNoEnModel>();
        HashMap<Long, List<StaffPhySicalCheckNoEnModel>> resultMap = new HashMap<Long, List<StaffPhySicalCheckNoEnModel>>();
        Map<Long, Map<String, List<PhcPhysicalStaffCheckInfoNoEn>>> physicalCheckMap = phcPhysicalStaffCheckInfos.stream().filter(i -> StringUtils.isNotEmpty((String)i.getIdcardCode())).collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfoNoEn::getCid, Collectors.groupingBy(PhcPhysicalStaffCheckInfoNoEn::getIdcardCode)));
        for (Long cid : cids) {
            List<StaffPhySicalCheckNoEnModel> staffList = staffPhySicalCheckMap.get(cid);
            if (CollectionUtils.isEmpty(staffList)) continue;
            Map<String, List<PhcPhysicalStaffCheckInfoNoEn>> idCardPhyCheckMap = physicalCheckMap.get(cid);
            for (StaffPhySicalCheckNoEnModel checkModel : staffList) {
                List<StaffPhySicalCheckNoEnModel> resultList = this.setCheckInfo(checkModel, idCardPhyCheckMap);
                tempList.addAll(resultList);
            }
            resultMap.put(cid, tempList);
            AllList.addAll(tempList);
            tempList = new ArrayList();
        }
        this.staffInfoService.reloadNewCheckData(AllList);
        return resultMap;
    }

    private List<StaffPhySicalCheckNoEnModel> setCheckInfo(StaffPhySicalCheckNoEnModel checkModel, Map<String, List<PhcPhysicalStaffCheckInfoNoEn>> idCardPhyCheckMap) {
        Date compareDate;
        PhcPhysicalStaffCheckInfoNoEn lastBefore;
        Date compareDate2;
        int count;
        List finalYears;
        List<Object> staffCheckInfoList;
        if (MapUtils.isEmpty(idCardPhyCheckMap)) {
            idCardPhyCheckMap = Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(staffCheckInfoList = idCardPhyCheckMap.get(checkModel.getCardId()))) {
            staffCheckInfoList = Collections.emptyList();
        }
        boolean isDoCheck = false;
        HashSet<StaffPhySicalCheckNoEnModel> resultSet = new HashSet<StaffPhySicalCheckNoEnModel>();
        StaffPhySicalCheckNoEnModel result = new StaffPhySicalCheckNoEnModel();
        Date DATE_2023_01_01 = DateUtil.getDate((String)"2023-01-01", (String)"yyyy-MM-dd");
        Date DATE_2023_03_01 = DateUtil.getDate((String)"2023-03-01", (String)"yyyy-MM-dd");
        Date DATE_2024_01_01 = DateUtil.getDate((String)"2024-01-01", (String)"yyyy-MM-dd");
        Date DATE_2022_01_01 = DateUtil.getDate((String)"2022-12-31", (String)"yyyy-MM-dd");
        if (Objects.isNull(checkModel.getLeaveTime())) {
            checkModel.setLeaveTime(DATE_2024_01_01);
        }
        List<PhcPhysicalStaffCheckInfoNoEn> sortedList = staffCheckInfoList.stream().filter(item -> item.getCheckTime() != null).sorted(Comparator.comparing(PhcPhysicalStaffCheckInfoNoEn::getCheckTime)).toList();
        Date validStartTime = null;
        for (int i2 = 0; i2 < sortedList.size() - 1; ++i2) {
            PhcPhysicalStaffCheckInfoNoEn current = sortedList.get(i2);
            PhcPhysicalStaffCheckInfoNoEn next = sortedList.get(i2 + 1);
            if (current.getBodyCheckType() == null || !leaveWorkStatus.contains(current.getBodyCheckType()) || next.getBodyCheckType() == null || !beforeWorkStatus.contains(next.getBodyCheckType())) continue;
            boolean hasLaterLeave = false;
            for (int j = i2 + 2; j < sortedList.size(); ++j) {
                if (sortedList.get(j).getBodyCheckType() == null || !leaveWorkStatus.contains(sortedList.get(j).getBodyCheckType())) continue;
                hasLaterLeave = true;
                break;
            }
            if (hasLaterLeave) continue;
            validStartTime = next.getCheckTime();
        }
        if (validStartTime == null) {
            validStartTime = DateUtil.getDate((String)"1970-01-01", (String)"yyyy-MM-dd");
        }
        if (Objects.nonNull(checkModel.getBeginTime()) && checkModel.getBeginTime().getTime() >= DATE_2023_01_01.getTime()) {
            checkModel.setNeedCheckType(BEFORE_WORK);
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        PhcPhysicalStaffCheckInfoNoEn beforeWork = staffCheckInfoList.stream().filter(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType())).findFirst().orElse(null);
        PhcPhysicalStaffCheckInfoNoEn onWork = staffCheckInfoList.stream().filter(staffCheckInfo -> onWorkStatus.contains(staffCheckInfo.getBodyCheckType())).findFirst().orElse(null);
        PhcPhysicalStaffCheckInfoNoEn leaveWork = staffCheckInfoList.stream().filter(staffCheckInfo -> leaveWorkStatus.contains(staffCheckInfo.getBodyCheckType())).findFirst().orElse(null);
        if (Objects.nonNull(onWork) && Objects.nonNull(leaveWork) && leaveWork.getCheckTime().getTime() <= onWork.getCheckTime().getTime()) {
            checkModel.setNeedCheckType(BEFORE_WORK);
            isDoCheck = staffCheckInfoList.stream().filter(s -> s.getCheckTime().getTime() >= leaveWork.getCheckTime().getTime() && s.getCheckTime().getTime() <= onWork.getCheckTime().getTime()).anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (Objects.isNull(checkModel.getBeginTime())) {
            checkModel.setNeedCheckType(BEFORE_WORK);
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        Date firstBeginTimeRaw = Objects.isNull(checkModel.getFirstBeginTime()) ? DATE_2022_01_01 : checkModel.getFirstBeginTime();
        Date firstBeginTime = firstBeginTimeRaw.before(validStartTime) ? validStartTime : firstBeginTimeRaw;
        Date leaveTime = Objects.isNull(checkModel.getLeaveTime()) ? DATE_2024_01_01 : checkModel.getLeaveTime();
        Date beginTime = checkModel.getBeginTime();
        if (!Objects.isNull(beginTime)) {
            beginTime = beginTime.before(DATE_2023_01_01) ? DATE_2023_01_01 : beginTime;
        }
        List years = DateUtil.findWholeYearsBetween((Date)firstBeginTime, (Date)new Date()).stream().map(Integer::parseInt).filter(i -> i > 2022).collect(Collectors.toList());
        if (StaffWorkStatusEnum.ONWORKING.getValue().equals(checkModel.getWorkStatus()) && CollectionUtils.isNotEmpty(years)) {
            finalYears = years;
            count = (int)staffCheckInfoList.stream().filter(staffCheckInfo -> finalYears.contains(DateUtils.getYear((Date)staffCheckInfo.getCheckTime()))).count();
            isDoCheck = count >= years.size();
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.NOWORKED.getValue().equals(checkModel.getWorkStatus()) && CollectionUtils.isNotEmpty(years = DateUtil.findWholeYearsBetween((Date)firstBeginTime, (Date)leaveTime).stream().map(Integer::parseInt).filter(i -> i > 2022).collect(Collectors.toList()))) {
            finalYears = years;
            count = (int)staffCheckInfoList.stream().filter(staffCheckInfo -> finalYears.contains(DateUtils.getYear((Date)staffCheckInfo.getCheckTime()))).count();
            isDoCheck = count >= years.size();
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.ONWORKING.getValue().equals(checkModel.getWorkStatus()) && Objects.nonNull(compareDate2 = Objects.nonNull(lastBefore = (PhcPhysicalStaffCheckInfoNoEn)staffCheckInfoList.stream().filter(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfoNoEn::getCheckTime)).orElse(null)) ? DateUtils.chooseLastDate((Date)beginTime, (Date)lastBefore.getCheckTime()) : beginTime) && DateUtils.isExpired((Date)DateUtils.addYears((Date)compareDate2, (int)1))) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> onWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && !DateUtils.isMoreThanYearApart((Date)new Date(), (Date)staffCheckInfo.getCheckTime(), (int)1));
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.NOWORKED.getValue().equals(checkModel.getWorkStatus()) && leaveTime.getTime() >= DATE_2024_01_01.getTime() && Objects.nonNull(compareDate = Objects.nonNull(lastBefore = (PhcPhysicalStaffCheckInfoNoEn)staffCheckInfoList.stream().filter(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfoNoEn::getCheckTime)).orElse(null)) ? DateUtils.chooseLastDate((Date)beginTime, (Date)lastBefore.getCheckTime()) : beginTime) && leaveTime != null && leaveTime.compareTo(DateUtils.addYears((Date)compareDate, (int)1)) > 0) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> onWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && !DateUtils.isMoreThanYearApart((Date)leaveTime, (Date)staffCheckInfo.getCheckTime(), (int)1));
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.ONWORKING.getValue().equals(checkModel.getWorkStatus()) && Objects.nonNull(beforeWork) && Objects.nonNull(onWork) && beforeWork.getCheckTime().getTime() > onWork.getCheckTime().getTime()) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> leaveWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setNeedCheckType(LEAVE_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.NOWORKED.getValue().equals(checkModel.getWorkStatus()) && checkModel.getLeaveTime().getTime() >= DATE_2023_03_01.getTime()) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && staffCheckInfo.getCheckTime().getTime() >= DateUtils.addMonth((Date)checkModel.getLeaveTime(), (int)-1).getTime() || onWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && staffCheckInfo.getCheckTime().getTime() >= DateUtils.addMonth((Date)checkModel.getLeaveTime(), (int)-3).getTime() || leaveWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && staffCheckInfo.getCheckTime().getTime() >= DateUtils.addMonth((Date)checkModel.getLeaveTime(), (int)-3).getTime() && staffCheckInfo.getCheckTime().getTime() <= DateUtils.addMonth((Date)checkModel.getLeaveTime(), (int)3).getTime());
            checkModel.setNeedCheckType(LEAVE_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckNoEnModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        Map<Long, List<StaffPhySicalCheckNoEnModel>> map = resultSet.stream().collect(Collectors.groupingBy(StaffPhySicalCheckNoEnModel::getStaffId));
        for (StaffPhySicalCheckNoEnModel staffPhySicalCheckNoEnModel : resultSet) {
            if (!BEFORE_WORK.equals(staffPhySicalCheckNoEnModel.getNeedCheckType()) || staffPhySicalCheckNoEnModel.getDoCheck().booleanValue()) continue;
            List<Object> list = map.get(result.getStaffId());
            if (CollectionUtils.isEmpty(list)) {
                list = Collections.emptyList();
            }
            boolean DoOnCheck = staffCheckInfoList.stream().anyMatch(s -> ON_WORK.toString().equals(s.getBodyCheckType()));
            boolean noDoOnCheck = list.stream().anyMatch(s -> ON_WORK.equals(s.getNeedCheckType()) && s.getDoCheck() == false);
            staffPhySicalCheckNoEnModel.setDoOnWorkCheck(Boolean.valueOf(DoOnCheck));
            if (!DoOnCheck) continue;
            boolean hasProblem = staffCheckInfoList.stream().anyMatch(s -> DateUtils.getYear((Date)s.getCheckTime()) >= 2023 && (ZyjjzConlution.equalsIgnoreCase(s.getConclusion()) || YszybConlution.equalsIgnoreCase(s.getConclusion())));
            boolean hasZyjjz = staffCheckInfoList.stream().anyMatch(s -> DateUtils.getYear((Date)s.getCheckTime()) >= 2023 && ZyjjzConlution.equalsIgnoreCase(s.getConclusion()));
            staffPhySicalCheckNoEnModel.setProblem(Boolean.valueOf(hasProblem));
            staffPhySicalCheckNoEnModel.setZyjjz(Boolean.valueOf(hasZyjjz));
        }
        return new ArrayList<StaffPhySicalCheckNoEnModel>(resultSet);
    }

    private Map<Long, Integer> loadYszybMap(List<Long> cids) {
        List phcPhysicalCheckV3221s = this.phcPhysicalStaffCheckInfoService.countYszybNum(cids, Integer.valueOf(2024));
        return phcPhysicalCheckV3221s.stream().collect(Collectors.toMap(PhcPhysicalCheckV3221::getCid, PhcPhysicalCheckV3221::getNumberOfYszyb));
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        StopWatch sw = new StopWatch("\u52a0\u8f7d <3.9\uff1a\u4f53\u68c0> \u5408\u89c4\u6570\u636e");
        DebugUtils.error((String)"[{}]\uff0c\u5f00\u59cb\u6267\u884c\u3002", (Object[])new Object[]{sw.getId()});
        ArrayList<NewComplianceCompanyItemdata> result = new ArrayList<NewComplianceCompanyItemdata>();
        sw.start("==========>> 1\u3001\u67e5\u8be2 \u5e94\u505a\u4f53\u68c0\u7684\u4fe1\u606f<<==========");
        Map<Long, List<StaffPhySicalCheckNoEnModel>> staffPhySicalCheckMap = this.loadStaffPhysicalCheckMap(cids);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 2\u3001\u67e5\u8be2 \u6ca1\u6709\u5c97\u4f4d\u72b6\u6001\u7684\u4eba\u5458\u6570\u91cf<<==========");
        Map noWorkStatusMap = this.staffInfoService.countNoWorkStatusNum(cids);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 3\u3001\u67e5\u8be2\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u5458\u6570\u91cf<<==========");
        Map<Long, Integer> yszybMap = this.loadYszybMap(cids);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 4\u3001\u83b7\u53d6\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f\u6570\u636e\u5e76\u6784\u5efa\u5bf9\u5e94\u7684 Map<==========");
        List workNums = this.staffInfoService.getStaffInfoWorkNum(cids, params);
        Map<Long, StaffInfo> staffMap = workNums.stream().collect(Collectors.toMap(StaffInfo::getCid, v -> v));
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        for (Long cid : cids) {
            StaffInfo workNum = staffMap.get(cid);
            List<Object> list = staffPhySicalCheckMap.get(cid);
            if (CollectionUtils.isEmpty(list)) {
                list = Collections.emptyList();
            }
            Map<Boolean, List<StaffPhySicalCheckNoEnModel>> partitioned = list.stream().collect(Collectors.partitioningBy(StaffPhySicalCheckNoEnModel::getIsThirdParty));
            List thirdList = partitioned.getOrDefault(true, Collections.emptyList());
            List normalList = partitioned.getOrDefault(false, Collections.emptyList());
            List beforeWork = list.stream().filter(item -> Objects.equals(BEFORE_WORK, item.getNeedCheckType())).collect(Collectors.toList());
            List beforeWorkNormal = normalList.stream().filter(item -> Objects.equals(BEFORE_WORK, item.getNeedCheckType())).collect(Collectors.toList());
            List beforeWorkThird = thirdList.stream().filter(item -> Objects.equals(BEFORE_WORK, item.getNeedCheckType())).collect(Collectors.toList());
            long noBeforeWorkNum = beforeWork.stream().filter(s -> s.getDoCheck() == false).count();
            long noBeforeWorkNumNormal = beforeWorkNormal.stream().filter(s -> s.getDoCheck() == false).count();
            long noBeforeWorkNumThird = beforeWorkThird.stream().filter(s -> s.getDoCheck() == false).count();
            long noBeforeWorkWitOnWorkNoProblemNum = beforeWorkNormal.stream().filter(s -> s.getDoCheck() == false && s.getDoOnWorkCheck() != false && s.getProblem() == false).count();
            long zyjjzNum = beforeWork.stream().filter(s -> s.getDoCheck() == false && s.getDoOnWorkCheck() != false && s.getZyjjz() != false).count();
            long noOnWorkNum = list.stream().filter(item -> Objects.equals(ON_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            long noLeaveWorkNum = list.stream().filter(item -> Objects.equals(LEAVE_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            long noOnWorkNumNormal = normalList.stream().filter(item -> Objects.equals(ON_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            long noLeaveWorkNumNormal = normalList.stream().filter(item -> Objects.equals(LEAVE_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            long noOnWorkNumThird = thirdList.stream().filter(item -> Objects.equals(ON_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            long noLeaveWorkNumThird = thirdList.stream().filter(item -> Objects.equals(LEAVE_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            this.addComplianceItemData(result, cid, 10501L, "noBeforeWorkNum", String.valueOf(noBeforeWorkNum));
            this.addComplianceItemData(result, cid, 10501L, "noBeforeWorkNumNormal", String.valueOf(noBeforeWorkNumNormal));
            this.addComplianceItemData(result, cid, 10501L, "noBeforeWorkNumThird", String.valueOf(noBeforeWorkNumThird));
            this.addComplianceItemData(result, cid, 10501L, "noBeforeWorkWitOnWorkNoProblemNum", String.valueOf(noBeforeWorkWitOnWorkNoProblemNum));
            this.addComplianceItemData(result, cid, 10501L, "zyjjzNum", String.valueOf(zyjjzNum));
            this.addComplianceItemData(result, cid, 10502L, "noOnWorkNum", String.valueOf(noOnWorkNum));
            this.addComplianceItemData(result, cid, 10502L, "noOnWorkNumNormal", String.valueOf(noOnWorkNumNormal));
            this.addComplianceItemData(result, cid, 10502L, "noOnWorkNumThird", String.valueOf(noOnWorkNumThird));
            this.addComplianceItemData(result, cid, 10503L, "noLeaveWorkNum", String.valueOf(noLeaveWorkNum));
            this.addComplianceItemData(result, cid, 10503L, "noLeaveWorkNumNormal", String.valueOf(noLeaveWorkNumNormal));
            this.addComplianceItemData(result, cid, 10503L, "noLeaveWorkNumThird", String.valueOf(noLeaveWorkNumThird));
            Integer ysZybNum = yszybMap.get(cid);
            this.addComplianceItemData(result, cid, 10504L, "ysZybNum", ysZybNum != null ? this.toStr(ysZybNum) : "0");
            Integer noWorkStatusNum = (Integer)noWorkStatusMap.get(cid);
            this.addComplianceItemData(result, cid, 10505L, "noWorkStatusNum", noWorkStatusNum != null ? this.toStr(noWorkStatusNum) : "0");
            this.addComplianceItemData(result, cid, 10502L, "totalWorkNum", workNum != null ? this.toStr(workNum.getLocalWorkNum() + workNum.getOutWorkNum()) : "0");
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (itemcodeId == 10501L) {
            BigDecimal score = BigDecimal.ZERO;
            NewComplianceCompanyItemdata noBeforeWorkNum = fieldsItemDataMap.get("noBeforeWorkNum");
            NewComplianceCompanyItemdata noBeforeWorkWitOnWorkNoProblemNum = fieldsItemDataMap.get("noBeforeWorkWitOnWorkNoProblemNum");
            NewComplianceCompanyItemdata zyjjzNum = fieldsItemDataMap.get("zyjjzNum");
            int total = 0;
            int noProblem = 0;
            int zyjjz = 0;
            if (noBeforeWorkNum != null && StringUtils.isNotEmpty((String)noBeforeWorkNum.getResultData())) {
                total = Integer.parseInt(noBeforeWorkNum.getResultData());
            }
            if (noBeforeWorkWitOnWorkNoProblemNum != null && StringUtils.isNotEmpty((String)noBeforeWorkWitOnWorkNoProblemNum.getResultData())) {
                noProblem = Integer.parseInt(noBeforeWorkWitOnWorkNoProblemNum.getResultData());
            }
            if (zyjjzNum != null && StringUtils.isNotEmpty((String)zyjjzNum.getResultData())) {
                zyjjz = Integer.parseInt(zyjjzNum.getResultData());
            }
            if (noProblem + zyjjz > total) {
                if (noProblem > total) {
                    noProblem = total;
                }
                if (zyjjz > total - noProblem) {
                    zyjjz = total - noProblem;
                }
            }
            int remaining = total - noProblem - zyjjz;
            BigDecimal part1 = BigDecimal.valueOf(remaining).multiply(BigDecimal.valueOf(-0.5));
            BigDecimal part2 = BigDecimal.valueOf(noProblem).multiply(BigDecimal.valueOf(-0.02));
            BigDecimal part3 = BigDecimal.valueOf(zyjjz).multiply(BigDecimal.valueOf(-0.3));
            if (part2.compareTo(new BigDecimal(-2)) < 0) {
                part2 = new BigDecimal(-2);
            }
            if (part3.compareTo(new BigDecimal(-3)) < 0) {
                part3 = new BigDecimal(-3);
            }
            return (score = part1.add(part2).add(part3)).compareTo(new BigDecimal(-5)) < 0 ? new BigDecimal(-5) : score;
        }
        if (itemcodeId == 10502L) {
            NewComplianceCompanyItemdata noOnWorkNum = fieldsItemDataMap.get("noOnWorkNum");
            NewComplianceCompanyItemdata totalWorkNum = fieldsItemDataMap.get("totalWorkNum");
            if (noOnWorkNum == null || totalWorkNum == null || StringUtils.isBlank((CharSequence)noOnWorkNum.getResultData()) || StringUtils.isBlank((CharSequence)totalWorkNum.getResultData())) {
                return BigDecimal.ZERO;
            }
            int unChecked = Integer.parseInt(noOnWorkNum.getResultData());
            int exposed = Integer.parseInt(totalWorkNum.getResultData());
            if (exposed == 0) {
                return BigDecimal.ZERO;
            }
            BigDecimal checkedRate = new BigDecimal(exposed - unChecked).divide(new BigDecimal(exposed), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            if (checkedRate.compareTo(new BigDecimal(80)) < 0) {
                return new BigDecimal("-5");
            }
            BigDecimal score = this.getLoseScore(noOnWorkNum, 0.2);
            return score.compareTo(new BigDecimal(-5)) < 0 ? new BigDecimal("-5") : score;
        }
        if (itemcodeId == 10503L) {
            NewComplianceCompanyItemdata noLeaveWorkNum = fieldsItemDataMap.get("noLeaveWorkNum");
            BigDecimal result = this.getLoseScore(noLeaveWorkNum, 0.05);
            return result.compareTo(new BigDecimal(-2)) < 0 ? new BigDecimal(-2) : result;
        }
        if (itemcodeId == 10504L) {
            NewComplianceCompanyItemdata noLeaveWorkNum = fieldsItemDataMap.get("ysZybNum");
            return this.getLoseScore(noLeaveWorkNum, 1.0);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getLoseScore(NewComplianceCompanyItemdata noBeforeWorkNum, double x) {
        if (Objects.nonNull(noBeforeWorkNum) && StringUtils.isNotEmpty((String)noBeforeWorkNum.getResultData())) {
            int i = Integer.parseInt(noBeforeWorkNum.getResultData());
            return BigDecimal.valueOf(-x).multiply(new BigDecimal(i));
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        int noWorkStatusNum;
        String noWorkStatusNumStr;
        Pair result = new Pair((Object)false, (Object)"");
        if (itemcodeId == 10505L && StringUtils.isNumber((String)(noWorkStatusNumStr = Optional.ofNullable(fieldsItemDataMap.get("noWorkStatusNum")).map(NewComplianceCompanyItemdata::getResultData).orElse("0"))) && (noWorkStatusNum = Integer.parseInt(noWorkStatusNumStr)) > 0) {
            result = new Pair((Object)true, (Object)"noWorkStatusNum");
        }
        return result;
    }

    private void addComplianceItemData(List<NewComplianceCompanyItemdata> result, Long cid, Long itemcodeId, String fieldName, String resultData) {
        NewComplianceCompanyItemdata data = new NewComplianceCompanyItemdata();
        data.setCid(cid);
        data.setItemcodeId(itemcodeId);
        data.setFieldName(fieldName);
        data.setResultData(resultData);
        result.add(data);
    }

    private String toStr(Integer number) {
        return number != null ? number.toString() : "0";
    }

    @Generated
    public NewPhysicalCheckScoreCalcHandle() {
    }
}

