/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.entity.base.ms.MsInfo;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.supervise.dao.phc.PhcCheckResultMapper;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.vo.phccheck.LastPhcCheckReportResultVo;
import cn.smarthse.modules.health.vo.base.company.HealthManagementInfoVo;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewOrgAndRulesScoreCalcHandle
implements NewScoreCalcHandle {
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private IMsInfoService msInfoService;
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    private ICompanyGradeV3RecService gradeV3RecService;
    @Autowired
    private PhcCheckResultMapper phcCheckResultMapper;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberService organizationMemberService;

    @Override
    public String support() {
        return "03";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal(2);
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        NewComplianceCompanyItemdata staffCount;
        if (itemcodeId != null && MapUtils.isNotEmpty(fieldsItemDataMap) && (staffCount = fieldsItemDataMap.get("staffCount")) != null && "0".equals(staffCount.getResultData())) {
            return Pair.of((Object)true, (Object)"staffCount");
        }
        return Pair.of((Object)false, null);
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<NewComplianceCompanyItemdata> list = new ArrayList<NewComplianceCompanyItemdata>();
        if (CollectionUtils.isEmpty(cids)) {
            return list;
        }
        List gradeByCids = this.gradeV3RecService.getGradeByCids(cids);
        Map<Object, Object> cidOccTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)gradeByCids)) {
            cidOccTypeMap = gradeByCids.stream().collect(Collectors.toMap(CompanyGradeV3Rec::getCid, e -> e.getOccType(), (v1, v2) -> v1));
        }
        List<LastPhcCheckReportResultVo> lastPhcCheckReportResultVos = this.phcCheckResultMapper.listLastReportResult(cids);
        Map<Object, Object> lastCheckMap = new HashMap();
        if (CollectionUtils.isNotEmpty(lastPhcCheckReportResultVos)) {
            lastCheckMap = lastPhcCheckReportResultVos.stream().collect(Collectors.toMap(LastPhcCheckReportResultVo::getCid, Function.identity(), (v1, v2) -> v1));
        }
        List listHealthManagementInfoVo = this.organizationMemberService.getListHealthManagementInfoVo(cids, null);
        Map<Object, Object> managementInfoVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)listHealthManagementInfoVo)) {
            managementInfoVoMap = listHealthManagementInfoVo.stream().collect(Collectors.toMap(HealthManagementInfoVo::getCid, Function.identity(), (v1, v2) -> v1));
        }
        List companyReportList = this.companyReportInfoService.getCompanyReportInfoByCids(cids);
        Map<Long, CompanyReportInfo> companyReportInfoMap = companyReportList.stream().collect(Collectors.toMap(CompanyReportInfo::getCid, e -> e, (v1, v2) -> v1));
        List msInfoList = this.msInfoService.getUploadCount(cids);
        Map<Long, MsInfo> msInfoMap = msInfoList.stream().collect(Collectors.toMap(MsInfo::getCid, e -> e, (v1, v2) -> v1));
        for (Long cid : cids) {
            Integer occType = (Integer)cidOccTypeMap.get(cid);
            String occTypeName = CompanyOccTypeEnum.getName((Integer)occType);
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("occType").setItemcodeId(Long.valueOf(10301L)).setResultData(occTypeName));
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("occType").setItemcodeId(Long.valueOf(10302L)).setResultData(occTypeName));
            LastPhcCheckReportResultVo lastPhcCheckReportResultVo = (LastPhcCheckReportResultVo)lastCheckMap.get(cid);
            String detectionOrg = "";
            String detectionTime = "";
            String detectionId = "";
            if (lastPhcCheckReportResultVo != null) {
                detectionOrg = lastPhcCheckReportResultVo.getLastCheckOrgName();
                detectionTime = DateUtils.formatDateTime((Date)lastPhcCheckReportResultVo.getLastCheckOrgDate());
                detectionId = lastPhcCheckReportResultVo.getLastCheckId() == null ? "" : String.valueOf(lastPhcCheckReportResultVo.getLastCheckId());
            }
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("detectionOrg").setItemcodeId(Long.valueOf(10301L)).setResultData(detectionOrg));
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("detectionTime").setItemcodeId(Long.valueOf(10301L)).setResultData(detectionTime));
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("detectionId").setItemcodeId(Long.valueOf(10301L)).setResultData(detectionId));
            CompanyReportInfo companyReportInfo = companyReportInfoMap.get(cid);
            if (companyReportInfo != null) {
                SysFileModel file;
                list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("staffCount").setItemcodeId(Long.valueOf(10302L)).setResultData(this.getNumberStr(companyReportInfo.getStaffCount())));
                list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("staffCount").setItemcodeId(Long.valueOf(10301L)).setResultData(this.getNumberStr(companyReportInfo.getStaffCount())));
                String fileName = "";
                String fileId = "";
                if ("1".equals(companyReportInfo.getManageOrg()) && StringUtils.isNotBlank((CharSequence)companyReportInfo.getManageOrgFiles()) && (file = this.sysFileProvideService.getFileById(Long.valueOf(companyReportInfo.getManageOrgFiles()))) != null) {
                    fileName = file.getFileName();
                    fileId = String.valueOf(file.getId());
                }
                list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("orgFileName").setItemcodeId(Long.valueOf(10302L)).setResultData(fileName));
                list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("orgFileId").setItemcodeId(Long.valueOf(10302L)).setResultData(fileId));
            }
            Integer manageMajorStaffCount = Optional.ofNullable((HealthManagementInfoVo)managementInfoVoMap.get(cid)).map(HealthManagementInfoVo::getHealthManageZZNum).orElse(null);
            Integer managePluralityStaffCount = Optional.ofNullable((HealthManagementInfoVo)managementInfoVoMap.get(cid)).map(HealthManagementInfoVo::getHealthManageJZNum).orElse(null);
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("manageMajorStaffCount").setItemcodeId(Long.valueOf(10302L)).setResultData(this.getNumberStr(manageMajorStaffCount)));
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("managePluralityStaffCount").setItemcodeId(Long.valueOf(10302L)).setResultData(this.getNumberStr(managePluralityStaffCount)));
            MsInfo msInfo = msInfoMap.get(cid);
            String uploadRules = msInfo == null || msInfo.getUploadCount() == null ? "0" : String.valueOf(msInfo.getUploadCount());
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("uploadRules").setItemcodeId(Long.valueOf(10302L)).setResultData(uploadRules));
            list.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("totalRules").setItemcodeId(Long.valueOf(10302L)).setResultData("12"));
        }
        return list;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        String codeIdStr = String.valueOf(itemcodeId);
        if (StringUtils.isBlank((CharSequence)codeIdStr) || MapUtils.isEmpty(fieldsItemDataMap)) {
            return BigDecimal.ZERO;
        }
        switch (codeIdStr) {
            case "10301": {
                return BigDecimal.ZERO;
            }
            case "10302": {
                NewComplianceCompanyItemdata occType = fieldsItemDataMap.get("occType");
                NewComplianceCompanyItemdata staffCount = fieldsItemDataMap.get("staffCount");
                NewComplianceCompanyItemdata orgFileName = fieldsItemDataMap.get("orgFileName");
                NewComplianceCompanyItemdata uploadRules = fieldsItemDataMap.get("uploadRules");
                NewComplianceCompanyItemdata totalRules = fieldsItemDataMap.get("totalRules");
                NewComplianceCompanyItemdata manageMajorStaffCount = fieldsItemDataMap.get("manageMajorStaffCount");
                NewComplianceCompanyItemdata managePluralityStaffCount = fieldsItemDataMap.get("managePluralityStaffCount");
                if ("\u4e25\u91cd".equals(occType.getResultData())) {
                    return this.scoreByOrgFile(orgFileName, uploadRules, totalRules, manageMajorStaffCount);
                }
                if ("\u4e00\u822c".equals(occType.getResultData())) {
                    if (NumberUtil.isInteger((String)staffCount.getResultData()) && Integer.parseInt(staffCount.getResultData()) < 100) {
                        if (StringUtils.isBlank((CharSequence)manageMajorStaffCount.getResultData()) || StringUtils.isBlank((CharSequence)managePluralityStaffCount.getResultData())) {
                            return new BigDecimal(-2);
                        }
                        return this.scoreByRules(uploadRules, totalRules);
                    }
                    return this.scoreByOrgFile(orgFileName, uploadRules, totalRules, manageMajorStaffCount);
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal scoreByOrgFile(NewComplianceCompanyItemdata orgFileName, NewComplianceCompanyItemdata uploadRules, NewComplianceCompanyItemdata totalRules, NewComplianceCompanyItemdata manageMajorStaffCount) {
        String resultData = Optional.ofNullable(orgFileName).map(NewComplianceCompanyItemdata::getResultData).orElse("");
        if (StringUtils.isBlank((CharSequence)resultData)) {
            return new BigDecimal(-2);
        }
        if (StringUtils.isBlank((CharSequence)manageMajorStaffCount.getResultData()) || "0".equals(manageMajorStaffCount.getResultData())) {
            return new BigDecimal(-2);
        }
        return this.scoreByRules(uploadRules, totalRules);
    }

    private BigDecimal scoreByRules(NewComplianceCompanyItemdata uploadRules, NewComplianceCompanyItemdata totalRules) {
        int uploadCount = Integer.parseInt(uploadRules.getResultData());
        int totalCount = Integer.parseInt(totalRules.getResultData());
        return new BigDecimal("-0.1").multiply(BigDecimal.valueOf(totalCount - uploadCount));
    }

    private String getNumberStr(Integer number) {
        if (number == null) {
            return "";
        }
        return String.valueOf(number);
    }

    private String getNumberStr(Long number) {
        if (number == null) {
            return "";
        }
        return String.valueOf(number);
    }
}

