/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.calcscore.rule.NewFristStepDataValidRule;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageService;
import cn.smarthse.modules.health.supervise.dao.company.CompanyMapper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewHarmInformedScoreCalcHandle
implements NewScoreCalcHandle {
    @DubboReference
    private IWarnSignManageService warnSignManageService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @Autowired
    private CompanyMapper companyMapper;

    @Override
    public String support() {
        return "13";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("5");
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List warns = this.warnSignManageService.selectLatestData(cids);
        Map warnsMap = warns.stream().collect(Collectors.toMap(WarnSignManage::getCid, Function.identity(), (v1, v2) -> v2));
        List workNums = this.staffInfoService.getStaffInfoWorkNum(cids, params);
        Map<Long, StaffInfo> staffMap = workNums.stream().collect(Collectors.toMap(StaffInfo::getCid, v -> v));
        List<CompanySuperviseModel> isShowVictims = this.companyMapper.getIsShowVictimsByIds(cids);
        Map<Long, CompanySuperviseModel> companyMap = isShowVictims.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getCid, v -> v));
        ArrayList<NewComplianceCompanyItemdata> result = new ArrayList<NewComplianceCompanyItemdata>();
        for (Long cid : cids) {
            WarnSignManage warnSignManage = (WarnSignManage)warnsMap.get(cid);
            StaffInfo workNum = staffMap.get(cid);
            CompanySuperviseModel isShowVictim = companyMap.get(cid);
            this.addComplianceItemData(result, cid, 11301L, "warnSignCount", warnSignManage != null && !warnSignManage.getRecordDetailList().isEmpty() ? String.valueOf(warnSignManage.getRecordDetailList().size()) : "0");
            this.addComplianceItemData(result, cid, 11301L, "changeTime", warnSignManage != null && !warnSignManage.getRecordDetailList().isEmpty() ? new SimpleDateFormat("yyyy-MM-dd").format(warnSignManage.getChangeTime()) : "--");
            this.addComplianceItemData(result, cid, 11303L, "outWorkNum", workNum != null ? this.toStr(workNum.getOutWorkNum()) : "0");
            this.addComplianceItemData(result, cid, 11303L, "localWorkNum", workNum != null ? this.toStr(workNum.getLocalWorkNum()) : "0");
            this.addComplianceItemData(result, cid, 11303L, "isShowVictims", isShowVictim != null ? this.toStr(isShowVictim.getIsShowVictims()) : "0");
        }
        return result;
    }

    private void addComplianceItemData(List<NewComplianceCompanyItemdata> result, Long cid, Long itemcodeId, String fieldName, String resultData) {
        NewComplianceCompanyItemdata data = new NewComplianceCompanyItemdata();
        data.setCid(cid);
        data.setItemcodeId(itemcodeId);
        data.setFieldName(fieldName);
        data.setResultData(resultData);
        result.add(data);
    }

    private String toStr(Integer number) {
        return number != null ? number.toString() : "0";
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        String itemCodeStr = String.valueOf(itemcodeId);
        if (StringUtils.isBlank((CharSequence)itemCodeStr)) {
            return BigDecimal.ZERO;
        }
        switch (itemCodeStr) {
            case "11301": {
                NewComplianceCompanyItemdata warnSignCount = fieldsItemDataMap.get("warnSignCount");
                if (warnSignCount != null && "0".equals(warnSignCount.getResultData())) {
                    return new BigDecimal("-5");
                }
                return BigDecimal.ZERO;
            }
            case "11302": {
                NewComplianceCompanyItemdata isStandardSet = fieldsItemDataMap.get("isStandardSet");
                if (isStandardSet != null && "false".equals(isStandardSet.getResultData())) {
                    return new BigDecimal("-5");
                }
                return BigDecimal.ZERO;
            }
            case "11303": {
                NewComplianceCompanyItemdata informedCount = fieldsItemDataMap.get("informedCount");
                NewComplianceCompanyItemdata uninformedCount = fieldsItemDataMap.get("uninformedCount");
                if (uninformedCount != null && NumberUtil.isNumber((CharSequence)uninformedCount.getResultData()) && Integer.parseInt(uninformedCount.getResultData()) != 0) {
                    BigDecimal calculatedValue = Convert.toBigDecimal((Object)uninformedCount.getResultData()).multiply(new BigDecimal("-0.1"));
                    return calculatedValue.compareTo(new BigDecimal("-3")) < 0 ? new BigDecimal("-3") : calculatedValue;
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        boolean bool = false;
        StringBuilder sb = new StringBuilder();
        boolean hasContent = false;
        if (11303L == itemcodeId) {
            NewComplianceCompanyItemdata informedCount = fieldsItemDataMap.get("informedCount");
            NewComplianceCompanyItemdata uninformedCount = fieldsItemDataMap.get("uninformedCount");
            NewComplianceCompanyItemdata localNumCommit = fieldsItemDataMap.get("localNumCommit");
            NewComplianceCompanyItemdata outNumCommit = fieldsItemDataMap.get("outNumCommit");
            NewComplianceCompanyItemdata isShowVictims = fieldsItemDataMap.get("isShowVictims");
            if (Objects.nonNull(localNumCommit)) {
                NewComplianceCompanyItemdata localWorkNum = fieldsItemDataMap.get("localWorkNum");
                if (Objects.nonNull(localWorkNum) && !Objects.equals(localNumCommit.getResultData(), localWorkNum.getResultData())) {
                    bool = true;
                    this.appendWithComma(sb, "case1", hasContent);
                    hasContent = true;
                }
            } else {
                bool = true;
                this.appendWithComma(sb, "case2", hasContent);
                hasContent = true;
            }
            if (Objects.nonNull(outNumCommit)) {
                NewComplianceCompanyItemdata outWorkNum = fieldsItemDataMap.get("outWorkNum");
                if (Objects.nonNull(outWorkNum) && !Objects.equals(outNumCommit.getResultData(), outWorkNum.getResultData())) {
                    bool = true;
                    this.appendWithComma(sb, "case1", hasContent);
                    hasContent = true;
                }
            } else {
                bool = true;
                this.appendWithComma(sb, "case2", hasContent);
                hasContent = true;
            }
            if (Objects.nonNull(localNumCommit) && Objects.nonNull(outNumCommit) && Integer.parseInt(localNumCommit.getResultData()) + Integer.parseInt(outNumCommit.getResultData()) == 0) {
                bool = true;
                this.appendWithComma(sb, "case1", hasContent);
                hasContent = true;
            } else if (Objects.nonNull(informedCount) && Objects.nonNull(uninformedCount) && Objects.nonNull(localNumCommit) && Objects.nonNull(outNumCommit) && Integer.parseInt(localNumCommit.getResultData()) + Integer.parseInt(outNumCommit.getResultData()) != Integer.parseInt(informedCount.getResultData()) + Integer.parseInt(uninformedCount.getResultData())) {
                bool = true;
                this.appendWithComma(sb, "case3", hasContent);
                hasContent = true;
            }
            if (Objects.nonNull(localNumCommit) && Objects.nonNull(outNumCommit) && Objects.nonNull(isShowVictims) && Integer.parseInt(localNumCommit.getResultData()) + Integer.parseInt(outNumCommit.getResultData()) <= 2 && Integer.parseInt(isShowVictims.getResultData()) >= 3) {
                bool = true;
                this.appendWithComma(sb, "case4", hasContent);
                hasContent = true;
            }
        }
        return new Pair((Object)bool, (Object)sb.toString());
    }

    public List<NewFristStepDataValidRule> fristStepDataValueRule() {
        ArrayList<NewFristStepDataValidRule> rules = new ArrayList<NewFristStepDataValidRule>();
        rules.add(new NewFristStepDataValidRule(11302L, "isStandardSet", 1, "\u672a\u586b\u5199"));
        rules.add(new NewFristStepDataValidRule(11303L, "informedCount", 1, "\u672a\u586b\u5199"));
        rules.add(new NewFristStepDataValidRule(11303L, "uninformedCount", 1, "\u672a\u586b\u5199"));
        rules.add(new NewFristStepDataValidRule(11303L, "localNumCommit", 1, "\u672a\u586b\u5199"));
        rules.add(new NewFristStepDataValidRule(11303L, "outNumCommit", 1, "\u672a\u586b\u5199"));
        return rules;
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == null) {
            return resultData;
        }
        switch (itemcodeId.toString()) {
            case "11302": {
                if (!filedName.equalsIgnoreCase("isStandardSet") || !StringUtils.isNotBlank((CharSequence)resultData)) break;
                return Boolean.parseBoolean(resultData) ? "\u662f" : "\u5426";
            }
        }
        return resultData;
    }

    private void appendWithComma(StringBuilder sb, String text, boolean hasContent) {
        if (!sb.toString().contains(text)) {
            if (hasContent) {
                sb.append(",");
            }
            sb.append(text);
        }
    }

    @Generated
    public NewHarmInformedScoreCalcHandle() {
    }
}

