/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceCompanyChangeRecordMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewExtraScoreCalcHandle
implements NewScoreCalcHandle {
    @Autowired
    private OssClientBean ossBean;
    @Autowired
    private NewComplianceCompanyChangeRecordMapper recordMapper;
    @DubboReference
    private ICompanyService companyService;
    @DubboReference
    private ICompanyFunctionalOrganizationService functionalOrganizationService;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberService functionalOrganizationMemberService;
    private static final int ID1 = 11501;
    private static final int ID2 = 11502;
    private static final int ID3 = 11503;
    private static final int ID4 = 11504;
    private static final int ID5 = 11505;
    private static final Long ID1L = 11501L;
    private static final Long ID2L = 11502L;
    private static final Long ID3L = 11503L;
    private static final Long ID4L = 11504L;
    private static final Long ID5L = 11505L;
    private static final String IS_JC_JK = "isJcJk";
    private static final String CERT_IS_EXPIRE_NUM = "certIsExpireNum";
    private static final String CERT_NO_EXPIRE_NUM = "certNoExpireNum";
    private static final String MAIN_PERSON_AS_FIRST_LEADER = "mainPersonAsFirstLeader";
    private static final String LEADER_PROVE_FILE_ID = "leaderProveFileId";
    private static final String LEADER_PROVE_FILE_NAME = "leaderProveFileName";
    private static final String LEADER_PROVE_FILE_URL = "leaderProveFileUrl";
    private static final String IS_COMPANY_TRAINING_BASE = "isCompanyTrainingBase";
    private static final String IS_CURRENT_YEAR_USE_THROUGH_TRAIN = "isCurrentYearUseThroughTrain";
    private static final String IS_CURRENT_YEAR_ACTIVELY_DO_ASSISTANT_WORK = "isCurrentYearActivelyDoAssistantWork";

    @Override
    public String support() {
        return "15";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return null;
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cidList, Map<String, Object> params) {
        List jcJkCidList = this.companyService.judgeIsJcAndJk(cidList);
        List<NewComplianceCompanyItemdata> result = cidList.stream().map(cid -> this.createItemData((Long)cid, jcJkCidList.contains(cid))).collect(Collectors.toList());
        List memberList = this.functionalOrganizationMemberService.getComplianceMemberListByCidList(cidList, Boolean.valueOf(true));
        Map<Long, List<CompanyFunctionalOrganizationMember>> memberMap = memberList.stream().collect(Collectors.groupingBy(CompanyFunctionalOrganizationMember::getCid));
        List funcOrgList = this.functionalOrganizationService.getFuncOrgListByCidList(cidList);
        Map<Long, SysFileModel> funcOrgFileInfo = this.getFuncOrgFileInfo(funcOrgList);
        Map<Long, List<CompanyFunctionalOrganization>> funcOrgMap = funcOrgList.stream().collect(Collectors.groupingBy(CompanyFunctionalOrganization::getCid));
        List trainBaseCidList = this.companyService.judgeIsCompanyTrainingBase(cidList);
        List throughTrainCidList = this.companyService.judgeIsCurrentYearUseThroughTrain(cidList);
        List assistantCidList = this.companyService.judgeIsCurrentYearActivelyDoAssistantWork(cidList);
        cidList.forEach(cid -> {
            List memList = memberMap.getOrDefault(cid, Collections.emptyList());
            long isExpire = memList.stream().filter(m -> !this.getIsValid((CompanyFunctionalOrganizationMember)m)).count();
            long noExpire = memList.stream().filter(this::getIsValid).count();
            NewExtraScoreCalcHandle.encapsulateResult(cid, ID2L, CERT_IS_EXPIRE_NUM, isExpire, result);
            NewExtraScoreCalcHandle.encapsulateResult(cid, ID2L, CERT_NO_EXPIRE_NUM, noExpire, result);
            List foList = (List)funcOrgMap.get(cid);
            boolean mainAsFirst = CollUtil.isNotEmpty((Collection)foList) ? foList.stream().anyMatch(o -> o.getMainPersonAsFirstleader() != null && o.getMainPersonAsFirstleader() != false) : Boolean.FALSE.booleanValue();
            NewExtraScoreCalcHandle.encapsulateResult(cid, ID2L, MAIN_PERSON_AS_FIRST_LEADER, mainAsFirst, result);
            SysFileModel file = (SysFileModel)funcOrgFileInfo.get(cid);
            if (file != null) {
                NewExtraScoreCalcHandle.encapsulateResult(cid, ID2L, LEADER_PROVE_FILE_ID, file.getId(), result);
                NewExtraScoreCalcHandle.encapsulateResult(cid, ID2L, LEADER_PROVE_FILE_NAME, file.getFileName(), result);
                NewExtraScoreCalcHandle.encapsulateResult(cid, ID2L, LEADER_PROVE_FILE_URL, file.getOssUrl(), result);
            }
            boolean isCompanyTrainingBase = trainBaseCidList.contains(cid);
            NewExtraScoreCalcHandle.encapsulateResult(cid, ID3L, IS_COMPANY_TRAINING_BASE, isCompanyTrainingBase, result);
            boolean isCurrentYearUseThroughTrain = throughTrainCidList.contains(cid);
            NewExtraScoreCalcHandle.encapsulateResult(cid, ID4L, IS_CURRENT_YEAR_USE_THROUGH_TRAIN, isCurrentYearUseThroughTrain, result);
            boolean isCurrentYearActivelyDoAssistantWork = assistantCidList.contains(cid);
            NewExtraScoreCalcHandle.encapsulateResult(cid, ID5L, IS_CURRENT_YEAR_ACTIVELY_DO_ASSISTANT_WORK, isCurrentYearActivelyDoAssistantWork, result);
        });
        return result;
    }

    private Map<Long, SysFileModel> getFuncOrgFileInfo(List<CompanyFunctionalOrganization> funcOrgList) {
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        funcOrgList.forEach(org -> {
            String fileId = org.getMainPersonAsFirstleaderProvefiles();
            if (CharSequenceUtil.isNotBlank((CharSequence)fileId)) {
                fileIdList.add(Convert.toLong((Object)fileId));
            }
        });
        List fileList = fileIdList.isEmpty() ? Collections.emptyList() : this.recordMapper.selectFileInfoBatch(fileIdList);
        Map<Long, String> fileIdNameMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, SysFileModel::getFileName, (a, b) -> b));
        Map<Long, String> fileIdUrlMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, file -> this.ossBean.getUrl(file.getOssUrl()), (a, b) -> b));
        HashMap<Long, SysFileModel> cidFile = new HashMap<Long, SysFileModel>();
        for (CompanyFunctionalOrganization org2 : funcOrgList) {
            String fileId = org2.getMainPersonAsFirstleaderProvefiles();
            if (!CharSequenceUtil.isNotBlank((CharSequence)fileId)) continue;
            SysFileModel file2 = new SysFileModel();
            Long fileIdL = Convert.toLong((Object)fileId);
            file2.setId(fileIdL);
            file2.setFileName(fileIdNameMap.get(fileIdL));
            file2.setOssUrl(fileIdUrlMap.get(fileIdL));
            cidFile.put(org2.getCid(), file2);
        }
        return cidFile;
    }

    private boolean getIsValid(CompanyFunctionalOrganizationMember m) {
        boolean res = "1".equals(m.getOrgStaffType()) ? m.getLeaderCert() == 1 : ("2".equals(m.getOrgStaffType()) ? m.getManagerCert() == 1 : m.getLeaderCert() == 1 || m.getManagerCert() == 1);
        return res;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (CollUtil.isEmpty(fieldsItemDataMap)) {
            return BigDecimal.ZERO;
        }
        switch (Convert.toInt((Object)itemcodeId)) {
            case 11501: {
                boolean isJcJk = fieldsItemDataMap.entrySet().stream().anyMatch(e -> IS_JC_JK.equals(e.getKey()) && Convert.toBool((Object)((NewComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return isJcJk ? Convert.toBigDecimal((Object)"2") : BigDecimal.ZERO;
            }
            case 11502: {
                boolean valid = fieldsItemDataMap.entrySet().stream().anyMatch(e -> CERT_NO_EXPIRE_NUM.equals(e.getKey()) && Convert.toInt((Object)((NewComplianceCompanyItemdata)e.getValue()).getResultData()) > 0);
                boolean main = fieldsItemDataMap.entrySet().stream().anyMatch(e -> MAIN_PERSON_AS_FIRST_LEADER.equals(e.getKey()) && Convert.toBool((Object)((NewComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return valid && main ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 11503: {
                boolean isCompanyTrainingBase = fieldsItemDataMap.entrySet().stream().anyMatch(e -> IS_COMPANY_TRAINING_BASE.equals(e.getKey()) && Convert.toBool((Object)((NewComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return isCompanyTrainingBase ? Convert.toBigDecimal((Object)"2") : BigDecimal.ZERO;
            }
            case 11504: {
                boolean isCurrentYearUseThroughTrain = fieldsItemDataMap.entrySet().stream().anyMatch(e -> IS_CURRENT_YEAR_USE_THROUGH_TRAIN.equals(e.getKey()) && Convert.toBool((Object)((NewComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return isCurrentYearUseThroughTrain ? Convert.toBigDecimal((Object)"0.2") : BigDecimal.ZERO;
            }
            case 11505: {
                boolean isCurrentYearActivelyDoAssistantWork = fieldsItemDataMap.entrySet().stream().anyMatch(e -> IS_CURRENT_YEAR_ACTIVELY_DO_ASSISTANT_WORK.equals(e.getKey()) && Convert.toBool((Object)((NewComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return isCurrentYearActivelyDoAssistantWork ? Convert.toBigDecimal((Object)"0.3") : BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (Objects.equals(itemcodeId, ID1L) && Objects.equals(filedName, IS_JC_JK) || Objects.equals(itemcodeId, ID2L) && Objects.equals(filedName, MAIN_PERSON_AS_FIRST_LEADER) || Objects.equals(itemcodeId, ID3L) && Objects.equals(filedName, IS_COMPANY_TRAINING_BASE) || Objects.equals(itemcodeId, ID4L) && Objects.equals(filedName, IS_CURRENT_YEAR_USE_THROUGH_TRAIN) || Objects.equals(itemcodeId, ID5L) && Objects.equals(filedName, IS_CURRENT_YEAR_ACTIVELY_DO_ASSISTANT_WORK)) {
            switch (resultData) {
                case "true": {
                    return "\u662f";
                }
                case "false": {
                    return "\u5426";
                }
            }
            return resultData;
        }
        return resultData;
    }

    private NewComplianceCompanyItemdata createItemData(Long cid, boolean isJcJk) {
        return new NewComplianceCompanyItemdata().setCid(cid).setItemcodeId(ID1L).setFieldName(IS_JC_JK).setResultData(Convert.toStr((Object)isJcJk));
    }

    private static void encapsulateResult(Long cid, Long itemcodeId, String fieldName, Object fieldValue, List<NewComplianceCompanyItemdata> result) {
        result.add(new NewComplianceCompanyItemdata().setCid(cid).setItemcodeId(itemcodeId).setFieldName(fieldName).setResultData(Convert.toStr((Object)fieldValue)).setFormat(Integer.valueOf(1)));
    }
}

