/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDeclareModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.calcscore.rule.NewFristStepDataValidRule;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class NewDeclareScoreCalcHandle
implements NewScoreCalcHandle {
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;

    @Override
    public String support() {
        return "10";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("5");
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        List newComplianceCompanyDeclareModel = this.wandaDeclareService.getComplianceCompanyDeclareModel(cids);
        Map<Long, ComplianceCompanyDeclareModel> map = newComplianceCompanyDeclareModel.stream().collect(Collectors.toMap(ComplianceCompanyDeclareModel::getCid, item -> item));
        List refromList = this.reformItemBasicNewService.queryNotAccReform(cids, Collections.singletonList(ReformGenerationSourceEnum.DECLARE.getValue()), Integer.valueOf(2024));
        Map<Long, List<ReformItemBasic>> reformMap = refromList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        ArrayList<NewComplianceCompanyItemdata> list = new ArrayList<NewComplianceCompanyItemdata>();
        for (Long cid : cids) {
            ComplianceCompanyDeclareModel model = map.get(cid);
            if (Objects.isNull(model)) {
                model = new ComplianceCompanyDeclareModel();
            }
            NewComplianceCompanyItemdata itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(11001L));
            itemData.setCid(cid);
            itemData.setFieldName("lastDeclareTime");
            Date lastDeclareTime = model.getLastDeclareTime();
            String dateString = "";
            if (Objects.nonNull(lastDeclareTime)) {
                dateString = DateUtil.format((Date)lastDeclareTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            itemData.setResultData(dateString);
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            List<ReformItemBasic> reformItemBasics = reformMap.get(cid);
            itemData.setItemcodeId(Long.valueOf(11001L));
            itemData.setCid(cid);
            itemData.setFieldName("hasDeclareReform");
            itemData.setResultData(CollectionUtils.isNotEmpty(reformItemBasics) ? "true" : "false");
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(11001L));
            itemData.setCid(cid);
            itemData.setFieldName("isYearlyUpdate");
            itemData.setResultData(model.getIsYearlyUpdate().toString());
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(11001L));
            itemData.setCid(cid);
            itemData.setFieldName("declareType");
            itemData.setResultData(model.getDeclareType());
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(11001L));
            itemData.setCid(cid);
            itemData.setFieldName("declareId");
            itemData.setResultData(String.valueOf(model.getDeclareId()));
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(11001L));
            itemData.setCid(cid);
            itemData.setFieldName("lastDeclareYear");
            itemData.setResultData(model.getLastDeclareYear());
            list.add(itemData);
            itemData = new NewComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(11002L));
            itemData.setCid(cid);
            itemData.setFieldName("hasChange");
            itemData.setResultData(String.valueOf(model.getHasChange()));
            list.add(itemData);
        }
        return list;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        NewComplianceCompanyItemdata hasDeclareReform;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (MapUtils.isEmpty(fieldsItemDataMap)) {
            return bigDecimal;
        }
        NewComplianceCompanyItemdata lastDeclareTime = fieldsItemDataMap.get("lastDeclareTime");
        if (lastDeclareTime != null && StringUtils.isEmpty((CharSequence)lastDeclareTime.getResultData()) && (hasDeclareReform = fieldsItemDataMap.get("hasDeclareReform")) != null && Boolean.parseBoolean(hasDeclareReform.getResultData())) {
            return this.itemTotalScore().negate();
        }
        bigDecimal = this.computedLoseScore(fieldsItemDataMap, "isYearlyUpdate", bigDecimal, "-0.2");
        NewComplianceCompanyItemdata isCarryout = fieldsItemDataMap.get("isCarryout");
        if (isCarryout != null && StringUtils.isNotEmpty((String)isCarryout.getResultData())) {
            if (StringUtils.isNumeric((CharSequence)isCarryout.getResultData())) {
                int i = Integer.parseInt(isCarryout.getResultData());
                if (i == 2) {
                    bigDecimal = bigDecimal.add(new BigDecimal("-1"));
                }
            } else {
                bigDecimal = this.computedLoseScore(fieldsItemDataMap, "isCarryout", bigDecimal, "-1");
            }
        }
        bigDecimal = this.computedLoseScore(fieldsItemDataMap, "isTruthfully", bigDecimal, "-0.5");
        return bigDecimal;
    }

    private BigDecimal computedLoseScore(Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String fieldName, BigDecimal bigDecimal, String val) {
        boolean b;
        NewComplianceCompanyItemdata itemdata = fieldsItemDataMap.get(fieldName);
        if (itemdata != null && StringUtils.isNotEmpty((String)itemdata.getResultData()) && !(b = Boolean.parseBoolean(itemdata.getResultData()))) {
            bigDecimal = bigDecimal.add(new BigDecimal(val));
        }
        return bigDecimal;
    }

    public List<NewFristStepDataValidRule> fristStepDataValueRule() {
        ArrayList<NewFristStepDataValidRule> rules = new ArrayList<NewFristStepDataValidRule>();
        rules.add(new NewFristStepDataValidRule(11002L, "isCarryout", 1, "\u672a\u586b\u5199"));
        rules.add(new NewFristStepDataValidRule(11002L, "declareEvidenceId", 1, "\u672a\u586b\u5199"));
        rules.add(new NewFristStepDataValidRule(11003L, "isTruthfully", 1, "\u672a\u586b\u5199"));
        return rules;
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == null) {
            return resultData;
        }
        switch (itemcodeId.toString()) {
            case "11001": 
            case "11003": {
                if ((filedName.equalsIgnoreCase("isTruthfully") || filedName.equalsIgnoreCase("isYearlyUpdate")) && StringUtils.isNotBlank((CharSequence)resultData)) {
                    return Boolean.parseBoolean(resultData) ? "\u662f" : "\u5426";
                }
            }
            case "11002": {
                if (!filedName.equalsIgnoreCase("isCarryout") || !StringUtils.isNotBlank((CharSequence)resultData)) break;
                if (StringUtils.isNumeric((CharSequence)resultData)) {
                    return this.parseIsCarryout(resultData);
                }
                return Boolean.parseBoolean(resultData) ? "\u662f" : "\u5426";
            }
        }
        return resultData;
    }

    private String parseIsCarryout(String resultData) {
        if ("1".equalsIgnoreCase(resultData)) {
            return "\u662f";
        }
        if ("2".equalsIgnoreCase(resultData)) {
            return "\u5426";
        }
        if ("3".equalsIgnoreCase(resultData)) {
            return "\u5408\u7406\u7f3a\u9879";
        }
        return null;
    }

    @Generated
    public NewDeclareScoreCalcHandle() {
    }
}

