/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class NewCheckScoreCalcHandle
implements NewScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCheckScoreCalcHandle.class);
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @Autowired
    private ICompanyGradeV3RecService companyGradeV3RecService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;

    @Override
    public String support() {
        return "07";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("10");
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<NewComplianceCompanyItemdata> result = new ArrayList<NewComplianceCompanyItemdata>();
        if (CollectionUtils.isEmpty(cids)) {
            return result;
        }
        Example example = new Example(CompanyGradeV3Rec.class);
        example.createCriteria().andIn("occType", Arrays.asList(0, 2)).andIn("cid", cids).andEqualTo("isValid", (Object)true);
        List companyGradeV3Recs = this.companyGradeV3RecService.getListByExample(example);
        if (CollectionUtils.isEmpty((Collection)companyGradeV3Recs)) {
            return Collections.emptyList();
        }
        Map<Long, Date> productionTimeMap = this.companyProvideService.getCompanyBaseInfoList(cids, (Map)MapUtil.of((Object)"getProductionTime", (Object)"")).stream().filter(Objects::nonNull).collect(Collectors.toMap(CompanyBaseInfoModel::getId, CompanyBaseInfoModel::getProductionTime, (k1, k2) -> k1));
        EvQueryParam param = new EvQueryParam().setCidList(cids).setCheckTypeList(Arrays.asList(2L, 3L, 4L)).setStartTime(LocalDateTime.now().withDayOfYear(1).toLocalDate().atStartOfDay().minusYears(3L)).setIsIgnore(Boolean.valueOf(true));
        Map<Long, List<RiskExposeEvaluate>> riskMap = this.riskExposeEvaluateService.getListByParam(param, null).stream().filter(item -> item != null && item.getCheckDate() != null && item.getCheckType() != null).sorted(Comparator.comparing(RiskExposeEvaluate::getCheckDate, Comparator.reverseOrder()).thenComparing(BaseEntity::getUpdateDate, Comparator.reverseOrder())).collect(Collectors.groupingBy(RiskExposeEvaluate::getCid));
        for (CompanyGradeV3Rec gradeV3Rec : companyGradeV3Recs) {
            Long cid = gradeV3Rec.getCid();
            String occType = gradeV3Rec.getOccType().toString();
            if ("0".equals(occType)) {
                occType = "\u4e25\u91cd";
            } else if ("2".equals(occType)) {
                occType = "\u4e00\u822c";
            }
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setResultData(occType).setFieldName("occType").setItemcodeId(Long.valueOf(10701L)));
            List allList = Optional.ofNullable(riskMap.get(cid)).orElse(new ArrayList());
            RiskExposeEvaluate allRiskEvaluate = allList.stream().filter(Objects::nonNull).findFirst().orElse(new RiskExposeEvaluate());
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("allTime").setItemcodeId(Long.valueOf(10701L)).setResultData(allRiskEvaluate.getCheckDateStr()));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("allOrgName").setItemcodeId(Long.valueOf(10701L)).setResultData(allRiskEvaluate.getOrgName()));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("allCheckId").setItemcodeId(Long.valueOf(10701L)).setResultData(String.valueOf(allRiskEvaluate.getCheckPlanId())));
            String checkTypeStr = "";
            if (allRiskEvaluate.getCheckType() != null) {
                long checkType = allRiskEvaluate.getCheckType();
                if (checkType == 2L) {
                    checkTypeStr = "\u5b9a\u671f\u68c0\u6d4b";
                }
                if (checkType == 3L) {
                    checkTypeStr = "\u73b0\u72b6\u8bc4\u4ef7";
                }
                if (checkType == 4L) {
                    checkTypeStr = "\u63a7\u5236\u6548\u679c\u8bc4\u4ef7";
                }
            }
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("allCheckType").setItemcodeId(Long.valueOf(10701L)).setResultData(checkTypeStr));
            RiskExposeEvaluate dqRiskEvaluate = allList.stream().filter(item -> item != null && item.getCheckType().equals(2L)).findFirst().orElse(new RiskExposeEvaluate());
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("dqTime").setItemcodeId(Long.valueOf(10701L)).setResultData(dqRiskEvaluate.getCheckDateStr()));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("dqOrgName").setItemcodeId(Long.valueOf(10701L)).setResultData(dqRiskEvaluate.getOrgName()));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("dqCheckId").setItemcodeId(Long.valueOf(10701L)).setResultData(String.valueOf(dqRiskEvaluate.getCheckPlanId())));
            RiskExposeEvaluate xzRiskEvaluate = allList.stream().filter(item -> item != null && item.getCheckType().equals(3L)).findFirst().orElse(new RiskExposeEvaluate());
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("xzTime").setItemcodeId(Long.valueOf(10701L)).setResultData(xzRiskEvaluate.getCheckDateStr()));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("xzOrgName").setItemcodeId(Long.valueOf(10701L)).setResultData(xzRiskEvaluate.getOrgName()));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("xzCheckId").setItemcodeId(Long.valueOf(10701L)).setResultData(String.valueOf(xzRiskEvaluate.getCheckPlanId())));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("jgTime").setItemcodeId(Long.valueOf(10701L)).setResultData(DateUtils.formatDate((Date)productionTimeMap.get(cid))));
            BigDecimal loseScore = this.getCalcLoseScore(occType, productionTimeMap.get(cid), allList);
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("loseScore").setItemcodeId(Long.valueOf(10701L)).setResultData(String.valueOf(loseScore)));
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (CollectionUtils.isEmpty(fieldsItemDataMap) || itemcodeId != 10701L) {
            return BigDecimal.ZERO;
        }
        if (fieldsItemDataMap.get("loseScore") == null || StringUtils.isBlank((CharSequence)fieldsItemDataMap.get("loseScore").getResultData()) || !NumberUtil.isNumber((CharSequence)fieldsItemDataMap.get("loseScore").getResultData())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(fieldsItemDataMap.get("loseScore").getResultData());
    }

    private BigDecimal getCalcLoseScore(String occType, Date productionTime, List<RiskExposeEvaluate> riskExposeEvaluateList) {
        int currYear = DateUtils.getYear((Date)new Date());
        if (CollectionUtils.isEmpty(riskExposeEvaluateList)) {
            return new BigDecimal("-10");
        }
        if ("\u4e00\u822c".equals(occType)) {
            return BigDecimal.ZERO;
        }
        if ("\u4e25\u91cd".equals(occType)) {
            List partList = riskExposeEvaluateList.stream().filter(item -> item != null && item.getCheckDate().getYear() >= currYear - 2).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(partList)) {
                return new BigDecimal("-10");
            }
            LocalDate currentDate = LocalDate.now();
            LocalDate oneYearLater = null;
            LocalDate twoYearsLater = null;
            LocalDate threeYearsLater = null;
            if (productionTime != null) {
                LocalDate productionDate = DateUtil.getFromDate2((Date)productionTime);
                oneYearLater = productionDate.plusYears(1L);
                twoYearsLater = productionDate.plusYears(2L);
                threeYearsLater = productionDate.plusYears(3L);
            }
            if (productionTime == null || currentDate.isEqual(threeYearsLater) || currentDate.isAfter(threeYearsLater)) {
                if (partList.stream().anyMatch(item -> item != null && item.getCheckType() == 3L) && (int)partList.stream().filter(Objects::nonNull).map(item -> item.getCheckDate().getYear()).distinct().count() >= 3) {
                    return BigDecimal.ZERO;
                }
                if (partList.stream().anyMatch(item -> item != null && item.getCheckType() == 3L) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 2) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 1) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().plusYears(1L).compareTo(LocalDateTime.now().toLocalDate().atStartOfDay()) >= 0)) {
                    return BigDecimal.ZERO;
                }
                if (partList.stream().noneMatch(item -> item != null && item.getCheckType() == 3L) && (int)partList.stream().filter(Objects::nonNull).map(item -> item.getCheckDate().getYear()).distinct().count() >= 3) {
                    return new BigDecimal("-2");
                }
                if (partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 2) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 1) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().plusYears(1L).compareTo(LocalDateTime.now().toLocalDate().atStartOfDay()) >= 0)) {
                    return new BigDecimal("-2");
                }
                if (partList.stream().anyMatch(item -> item != null && item.getCheckType() == 3L) && (int)partList.stream().filter(Objects::nonNull).map(item -> item.getCheckDate().getYear()).distinct().count() == 2) {
                    return new BigDecimal("-3");
                }
                if (partList.stream().anyMatch(item -> item != null && item.getCheckType() == 3L && item.getCheckDate().getYear() == currYear - 1) && partList.stream().anyMatch(item -> item != null && item.getCheckType() == 3L && item.getCheckDate().getYear() == currYear - 1 && item.getCheckDate().plusYears(1L).compareTo(LocalDateTime.now().toLocalDate().atStartOfDay()) >= 0)) {
                    return new BigDecimal("-3");
                }
                if (partList.stream().noneMatch(item -> item != null && item.getCheckType() == 3L) && (int)partList.stream().filter(Objects::nonNull).map(item -> item.getCheckDate().getYear()).distinct().count() == 2) {
                    return new BigDecimal("-4");
                }
                if (partList.stream().noneMatch(item -> item != null && item.getCheckType() == 3L) && partList.stream().noneMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 2) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 1) && partList.stream().anyMatch(item -> item != null && item.getCheckDate().plusYears(1L).compareTo(LocalDateTime.now().toLocalDate().atStartOfDay()) >= 0)) {
                    return new BigDecimal("-4");
                }
                if (partList.stream().anyMatch(item -> item != null && item.getCheckType() == 3L) && (int)partList.stream().filter(Objects::nonNull).map(item -> item.getCheckDate().getYear()).distinct().count() == 1) {
                    return new BigDecimal("-5");
                }
                if ((int)partList.stream().filter(Objects::nonNull).map(item -> item.getCheckDate().getYear()).distinct().count() == 1) {
                    return new BigDecimal("-6");
                }
                return new BigDecimal("-10");
            }
            if ((currentDate.isAfter(twoYearsLater) || currentDate.isEqual(twoYearsLater)) && currentDate.isBefore(threeYearsLater)) {
                if (partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear - 1)) {
                    if (partList.stream().anyMatch(item -> item != null && item.getCheckDate().plusYears(1L).compareTo(LocalDateTime.now().toLocalDate().atStartOfDay()) >= 0)) {
                        return BigDecimal.ZERO;
                    }
                    return new BigDecimal("-5");
                }
                if (partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear)) {
                    return new BigDecimal("-5");
                }
                return new BigDecimal("-10");
            }
            if ((currentDate.isAfter(oneYearLater) || currentDate.isEqual(oneYearLater)) && currentDate.isBefore(twoYearsLater)) {
                if (partList.stream().anyMatch(item -> item != null && item.getCheckDate().getYear() == currYear)) {
                    return BigDecimal.ZERO;
                }
                return new BigDecimal("-10");
            }
            return BigDecimal.ZERO;
        }
        return new BigDecimal("-10");
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (itemcodeId == null || itemcodeId != 10701L) {
            return new Pair((Object)false, null);
        }
        if (fieldsItemDataMap.get("occType") == null) {
            return new Pair((Object)true, (Object)"occType");
        }
        return new Pair((Object)false, null);
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == null) {
            return resultData;
        }
        switch (itemcodeId.toString()) {
            case "10701": {
                if (!filedName.contains("Time") || !StringUtils.isNotBlank((CharSequence)resultData)) break;
                Date date = DateUtils.parseDate((Object)resultData);
                return DateUtils.format((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5");
            }
        }
        return resultData;
    }

    @Generated
    public NewCheckScoreCalcHandle() {
    }
}

