/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore.handle;

import cn.hutool.core.util.NumberUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.newcompliance.calcscore.handle.NewScoreCalcHandle;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class NewCheckFactoryScoreCalcHandle
implements NewScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCheckFactoryScoreCalcHandle.class);
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @Lazy
    @Autowired
    private IImportantIndustryCategoryService categoryService;
    @Autowired
    private RedisClient redisClient;

    @Override
    public String support() {
        return "08";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("10");
    }

    @Override
    public List<NewComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<NewComplianceCompanyItemdata> result = new ArrayList<NewComplianceCompanyItemdata>();
        if (CollectionUtils.isEmpty(cids)) {
            return result;
        }
        List riskExposeEvaluateList = this.riskExposeEvaluateService.getLastEv(new EvQueryParam().setCidList(cids).setStartTime(DateUtil.parseDateTime((String)"2024-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss")).setIsQueryRiskData(Boolean.valueOf(true)).setIsIgnore(Boolean.valueOf(true)));
        List checkPlanIdList = riskExposeEvaluateList.stream().filter(Objects::nonNull).map(RiskExposeEvaluate::getCheckPlanId).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("factoryName", "\u9ad8\u6e29");
        Set gaoWenPassCheckIds = this.reformItemBasicNewService.getReformOverCheckRiskId2(checkPlanIdList, map);
        map.put("factoryName", "\u566a\u58f0");
        Set zaoShenPassCheckIds = this.reformItemBasicNewService.getReformOverCheckRiskId2(checkPlanIdList, map);
        for (RiskExposeEvaluate evaluate : riskExposeEvaluateList) {
            if (evaluate == null) continue;
            Long checkId = evaluate.getCheckPlanId();
            Long cid = evaluate.getCid();
            String orgName = evaluate.getOrgName();
            String checkDate = evaluate.getCheckDateStr();
            List dataList = ((List)Optional.ofNullable(evaluate.getDataList()).orElse(new ArrayList())).stream().filter(item -> item != null && item.getCheckTouchLevel() == 1 && StringUtils.isNotBlank((CharSequence)item.getFactorName()) && StringUtils.isNotBlank((CharSequence)item.getFactorId())).peek(item -> {
                if (item.getFactorId().equals("1") || item.getFactorId().equals("63") || item.getFactorId().equals("64") || item.getFactorId().equals("65")) {
                    item.setFactorId("64");
                    item.setFactorName("\u77fd\u5c18");
                    item.setFactorNature(Integer.valueOf(2));
                }
            }).collect(Collectors.toList());
            List yzFactorList = dataList.stream().filter(item -> item != null && item.getFactorNature() == 2).map(RiskExposeEvaluateData::getFactorName).distinct().collect(Collectors.toList());
            Integer yzNum = yzFactorList.size();
            String yzFactorStr = StringUtils.join(yzFactorList, (String)",");
            String yzFactorIdStr = dataList.stream().filter(item -> item != null && item.getFactorNature() == 2).map(RiskExposeEvaluateData::getFactorId).distinct().collect(Collectors.joining(","));
            List qtFactorList = dataList.stream().filter(item -> item != null && item.getFactorNature() != 2).map(RiskExposeEvaluateData::getFactorName).distinct().collect(Collectors.toList());
            Integer qtNum = qtFactorList.size();
            String qtFactorStr = StringUtils.join(qtFactorList, (String)",");
            String qtFactorIdStr = dataList.stream().filter(item -> item != null && item.getFactorNature() != 2).map(RiskExposeEvaluateData::getFactorId).distinct().collect(Collectors.joining(","));
            HashSet<String> passRiskFactoryIdSet = new HashSet<String>();
            if (gaoWenPassCheckIds.contains(checkId)) {
                passRiskFactoryIdSet.add("568");
            }
            if (zaoShenPassCheckIds.contains(checkId)) {
                passRiskFactoryIdSet.add("567");
            }
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("passRiskFactorIdStr").setItemcodeId(Long.valueOf(10801L)).setResultData(String.join((CharSequence)",", passRiskFactoryIdSet)));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("passRiskFactorIdStr").setItemcodeId(Long.valueOf(10802L)).setResultData(String.join((CharSequence)",", passRiskFactoryIdSet)));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkId").setItemcodeId(Long.valueOf(10801L)).setResultData(String.valueOf(checkId)));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkId").setItemcodeId(Long.valueOf(10802L)).setResultData(String.valueOf(checkId)));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkDate").setItemcodeId(Long.valueOf(10801L)).setResultData(checkDate));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("orgName").setItemcodeId(Long.valueOf(10801L)).setResultData(orgName));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("yzNum").setItemcodeId(Long.valueOf(10801L)).setResultData(String.valueOf(yzNum)));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("yzFactorStr").setItemcodeId(Long.valueOf(10801L)).setResultData(yzFactorStr));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("yzFactorIdStr").setItemcodeId(Long.valueOf(10801L)).setResultData(yzFactorIdStr));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkDate").setItemcodeId(Long.valueOf(10802L)).setResultData(checkDate));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("orgName").setItemcodeId(Long.valueOf(10802L)).setResultData(orgName));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("qtNum").setItemcodeId(Long.valueOf(10802L)).setResultData(String.valueOf(qtNum)));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("qtFactorStr").setItemcodeId(Long.valueOf(10802L)).setResultData(qtFactorStr));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("qtFactorIdStr").setItemcodeId(Long.valueOf(10802L)).setResultData(qtFactorIdStr));
        }
        Set alreadyAddCidList = result.stream().filter(Objects::nonNull).map(NewComplianceCompanyItemdata::getCid).collect(Collectors.toSet());
        for (Long cid : cids) {
            if (cid == null || alreadyAddCidList.contains(cid)) continue;
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("passRiskFactorIdStr").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("passRiskFactorIdStr").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkId").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkId").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkDate").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("orgName").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("yzNum").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("yzFactorStr").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("yzFactorIdStr").setItemcodeId(Long.valueOf(10801L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("checkDate").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("orgName").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("qtNum").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("qtFactorStr").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
            result.add(new NewComplianceCompanyItemdata().setCid(cid).setFieldName("qtFactorIdStr").setItemcodeId(Long.valueOf(10802L)).setResultData(null));
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (itemcodeId == null) {
            return BigDecimal.ZERO;
        }
        switch (itemcodeId.toString()) {
            case "10801": {
                if (StringUtils.isNotBlank((CharSequence)importantTypeStr) && Arrays.asList("5265", "3465").contains(importantTypeStr)) {
                    return this.calcItemLoseScore("yzNum", "yzFactorIdStr", 2, fieldsItemDataMap, importantTypeStr);
                }
                return this.calcItemLoseScore("yzNum", "yzFactorIdStr", 1, fieldsItemDataMap, importantTypeStr);
            }
            case "10802": {
                return this.calcItemLoseScore("qtNum", "qtFactorIdStr", 1, fieldsItemDataMap, importantTypeStr);
            }
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal calcItemLoseScore(String column1, String column2, int base, Map<String, NewComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        BigDecimal total = new BigDecimal("0");
        String passRiskFactorIdStr = "";
        if (fieldsItemDataMap.get("passRiskFactorIdStr") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("passRiskFactorIdStr").getResultData())) {
            passRiskFactorIdStr = fieldsItemDataMap.get("passRiskFactorIdStr").getResultData();
        }
        List<Object> factors = new ArrayList();
        if (fieldsItemDataMap.get(column2) != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get(column2).getResultData())) {
            factors = Arrays.stream(fieldsItemDataMap.get(column2).getResultData().split(",")).filter(f -> NumberUtil.isNumber((CharSequence)f)).map(Long::parseLong).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)importantTypeStr)) {
            Set importantTypeList = Arrays.stream(importantTypeStr.split(",")).map(Integer::valueOf).collect(Collectors.toSet());
            Map categoryTypeFactoryIdList = (Map)this.redisClient.get("importantIndustryCategory", "getCategoryTypeFactoryIdListByCache", (long)IImportantIndustryCategoryService.cacheTimeOut.intValue(), () -> ((IImportantIndustryCategoryService)this.categoryService).getCategoryTypeFactoryIdListByCache(), (TypeReference)new TypeReference<Map<Integer, List<Long>>>(){});
            for (Integer importantType : importantTypeList) {
                List factoryIdList = (List)categoryTypeFactoryIdList.get(importantType);
                if (CollectionUtils.isEmpty((Collection)factoryIdList)) continue;
                for (Long l : factors) {
                    if (l == 567L && passRiskFactorIdStr.contains(l.toString()) || l == 568L && passRiskFactorIdStr.contains(l.toString())) continue;
                    if (factoryIdList.contains(l)) {
                        total = total.add(new BigDecimal(-3));
                        continue;
                    }
                    total = total.add(new BigDecimal(-1));
                }
                return total;
            }
        }
        if (fieldsItemDataMap.get(column1) != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get(column1).getResultData())) {
            int yzNum = Integer.parseInt(fieldsItemDataMap.get(column1).getResultData());
            if (factors.contains(567L) && passRiskFactorIdStr.contains("567")) {
                --yzNum;
            }
            if (factors.contains(568L) && passRiskFactorIdStr.contains("568")) {
                --yzNum;
            }
            total = total.add(new BigDecimal(-yzNum).multiply(new BigDecimal(base)));
        }
        return total;
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == null) {
            return resultData;
        }
        switch (itemcodeId.toString()) {
            case "10801": {
                if (filedName.contains("checkDate") && StringUtils.isNotBlank((CharSequence)resultData)) {
                    Date date = DateUtils.parseDate((Object)resultData);
                    return DateUtils.format((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                }
            }
            case "10802": {
                if (!filedName.contains("checkDate") || !StringUtils.isNotBlank((CharSequence)resultData)) break;
                Date date = DateUtils.parseDate((Object)resultData);
                return DateUtils.format((Date)date, (String)"yyyy\u5e74MM\u6708dd\u65e5");
            }
        }
        return resultData;
    }

    @Generated
    public NewCheckFactoryScoreCalcHandle() {
    }
}

