/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompliance.calcscore;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.health.compliance.calcscore.CalcLog;
import cn.smarthse.modules.health.newcompliance.calcscore.NewCalcScoreBusService;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceTryCompanyInfoMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemcode;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyItemdata;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceScoreChangeRecord;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceScoreChangeRecordV2;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceTryCompanyInfo;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceInfoStatusEnum;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceCompanyDataModel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceNeedRefreshModel;
import cn.smarthse.modules.health.newcompliance.model.NewComplianceValidModel;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyExitItemService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyItemdataService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyLabelService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreChangeRecordService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreChangeRecordV2Service;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceScoreRefreshService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceTryCompanyInfoService;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceTryCompanyWorkService;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class NewComplianceScoreRefreshServiceImpl
implements INewComplianceScoreRefreshService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewComplianceScoreRefreshServiceImpl.class);
    private static final String COLLECTSCOREREFRESHMUTIL_LOCKNAME = "new-third-service:ComplianceScoreRefreshMutil:lock";
    private static final String COLLECTSCOREREFRESHSINGLE_LOCKNAME = "new-third-service:ComplianceScoreRefreshSingle:lock";
    private static final String COLLECTSCOREREFRESH_DELAY_SET = "new-third-service:ComplianceScoreRefresh:delayset";
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private NewCalcScoreBusService busService;
    @Autowired
    private INewComplianceCompanyInfoService infoService;
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    @Autowired
    INewComplianceCompanyItemcodeService itemcodeService;
    @Autowired
    INewComplianceCompanyItemdataService itemdataService;
    @Autowired
    INewComplianceCompanyLabelService labelService;
    @Autowired
    INewComplianceTryCompanyWorkService tryCompanyWorkService;
    @Autowired
    INewComplianceTryCompanyInfoService tryCompanyInfoService;
    ThreadPoolExecutor limiterExecutor = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNamePrefix("\u5408\u89c4\u524d\u7f6e\u6295\u9012\u4efb\u52a1-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u5408\u89c4\u524d\u7f6e\u6295\u9012\u4efb\u52a1\uff1a{}\uff0c \u5408\u89c4\u4f01\u4e1a\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0ce:", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    log.error("\u5408\u89c4\u524d\u7f6e\u6295\u9012\u4efb\u52a1\uff1a{}\uff0c \u5f02\u5e38\u7ec8\u6b62\uff0ce:{}", (Object)Thread.currentThread(), (Object)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    });
    @Autowired
    private INewComplianceCompanyExitItemService complianceCompanyExitItemService;
    @Autowired
    INewComplianceScoreChangeRecordService complianceScoreChangeRecordService;
    @Autowired
    INewComplianceScoreChangeRecordV2Service complianceScoreChangeRecordV2Service;
    @Autowired
    INewComplianceCompanyInfoService complianceCompanyInfoService;

    public void syncRefresh(Long cid, Map<String, Object> params, String ... itemCodes) {
        if (cid == null) {
            log.warn("cid\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        Set<String> codeSet = allItemcode.stream().filter(f -> Objects.equals(f.getType(), 1)).map(NewComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        if (ArrayUtils.isEmpty((Object[])itemCodes)) {
            itemCodes = codeSet.toArray(new String[0]);
        }
        this.reloadRefData(Arrays.asList(cid), params, itemCodes);
    }

    public void reloadRefData(List<Long> cids, Map<String, Object> params, String ... itemCodes) {
        long jobId;
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List complianceStatuCids = this.infoService.getComplianceCids(cids, Arrays.asList(NewComplianceInfoStatusEnum.COMPLIANT.getKey(), NewComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey()));
        if (CollectionUtils.isEmpty((Collection)complianceStatuCids)) {
            return;
        }
        cids = complianceStatuCids.stream().map(NewComplianceCompanyInfo::getCid).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if ((jobId = XxlJobHelper.getJobId()) > 0L) {
            params.put("_jobId", jobId);
            this.redisClient.delPrefix("newcompliance_calc_score_loadtime:" + jobId);
            ScheduledExecutorService debugExecutor = Executors.newSingleThreadScheduledExecutor();
            debugExecutor.scheduleAtFixedRate(() -> CalcLog.printTaskInfo("newcompliance_calc_score_loadtime", jobId), 10L, 15L, TimeUnit.SECONDS);
            Map<String, Object> finalParams = params;
            CompletableFuture[] loadfutures = (CompletableFuture[])ListUtil.partition(cids, (int)200).stream().map(itemCidList -> CompletableFuture.runAsync(() -> {
                CalcLog calcLog = new CalcLog("newcompliance_calc_score_loadtime:" + jobId + ":step1:loadDataPart", jobId);
                this.busService.refreshRefData((List<Long>)itemCidList, finalParams, false, itemCodes);
                calcLog.stop();
            }, this.limiterExecutor)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(loadfutures).join();
            CompletableFuture[] refreshfutures = (CompletableFuture[])ListUtil.partition(cids, (int)500).stream().map(itemCidList -> CompletableFuture.runAsync(() -> {
                CalcLog calcLog = new CalcLog("newcompliance_calc_score_loadtime:" + jobId + ":step2:refreshSocreParttime", jobId);
                this.refreshScore((List<Long>)itemCidList);
                calcLog.stop();
            }, this.limiterExecutor)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(refreshfutures).join();
            debugExecutor.shutdownNow();
            CalcLog.printTaskInfo("newcompliance_calc_score_loadtime", jobId);
            this.redisClient.delPrefix("newcompliance_calc_score_loadtime:" + jobId);
        } else {
            for (List itemCidList2 : ListUtil.partition(cids, (int)500)) {
                try {
                    this.busService.refreshRefData(itemCidList2, params, false, itemCodes);
                }
                catch (Exception e) {
                    log.error("\u603b\u7ebf\u52a0\u8f7d\u5408\u89c4\u7cfb\u7edf\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
            for (List itemCidList2 : ListUtil.partition(cids, (int)1000)) {
                try {
                    this.refreshScore(itemCidList2);
                }
                catch (Exception e) {
                    log.error("\u603b\u7ebf\u5237\u65b0\u5408\u89c4\u4f01\u4e1a\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
        }
    }

    public void reloadRefDataV2(List<Long> cids, Map<String, Object> params, String ... itemCodes) {
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List complianceStatuCids = this.infoService.getComplianceCids(cids, Arrays.asList(NewComplianceInfoStatusEnum.COMPLIANT.getKey(), NewComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), NewComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), NewComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey()));
        if (CollectionUtils.isEmpty((Collection)complianceStatuCids)) {
            return;
        }
        cids = complianceStatuCids.stream().map(NewComplianceCompanyInfo::getCid).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        ScheduledExecutorService debugExecutor = null;
        long jobId = XxlJobHelper.getJobId();
        if (jobId > 0L) {
            if (params != null) {
                params.put("_jobId", jobId);
            }
            this.redisClient.delPrefix("newcompliance_calc_score_loadtime:" + CalcLog.getJobId());
            debugExecutor = Executors.newSingleThreadScheduledExecutor();
            debugExecutor.scheduleAtFixedRate(() -> CalcLog.printTaskInfo("newcompliance_calc_score_loadtime", CalcLog.getJobId()), 10L, 15L, TimeUnit.SECONDS);
        }
        CompletableFuture[] loadfutures = (CompletableFuture[])ListUtil.partition(cids, (int)20).stream().map(itemCidList -> CompletableFuture.runAsync(() -> {
            CalcLog calcLog = new CalcLog("newcompliance_calc_score_loadtime:" + jobId + ":step1:loadDataPart", jobId);
            this.busService.refreshRefData((List<Long>)itemCidList, params, false, itemCodes);
            calcLog.stop();
        }, this.limiterExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(loadfutures).join();
        CompletableFuture[] refreshfutures = (CompletableFuture[])ListUtil.partition(cids, (int)20).stream().map(itemCidList -> CompletableFuture.runAsync(() -> {
            CalcLog calcLog = new CalcLog("newcompliance_calc_score_loadtime:" + jobId + ":step2:refreshSocreParttime", jobId);
            this.refreshScore((List<Long>)itemCidList);
            calcLog.stop();
        }, this.limiterExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(refreshfutures).join();
    }

    public void tryToolsReloadRefData(Long workId) {
        if (workId == null) {
            log.warn("workId\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List tryCompanyWorks = this.tryCompanyWorkService.getTryCompanyRefInfo(workId);
        if (CollectionUtils.isEmpty((Collection)tryCompanyWorks)) {
            return;
        }
        List tryCompanyInfos = tryCompanyWorks.stream().filter(f -> f.getId() == null).map(m -> {
            NewComplianceTryCompanyInfo info = new NewComplianceTryCompanyInfo();
            info.setCid(m.getCid());
            info.setId(Long.valueOf(this.idworker.nextId()));
            info.setIsValid(Boolean.valueOf(true));
            info.setCreateDate(new Date());
            return info;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tryCompanyInfos)) {
            this.tryCompanyInfoService.batchUpdateOrInsert(tryCompanyInfos, NewComplianceTryCompanyInfoMapper.class, (item, mapper) -> mapper.insert(item));
        }
        List<Long> cids = tryCompanyWorks.stream().map(m -> m.getCid()).collect(Collectors.toList());
        String[] itemCodes = new String[]{"01", "02", "05", "07", "08", "10"};
        int page = 0;
        for (List itemCidList : ListUtil.partition(cids, (int)1000)) {
            ++page;
            try {
                this.busService.refreshRefData(itemCidList, null, true, itemCodes);
                this.busService.doRefreshScore(cids, true);
            }
            catch (Exception e) {
                log.error("\u603b\u7ebf\u5237\u65b0\u5408\u89c4\u8bd5\u7b97\u4f01\u4e1a\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
    }

    public List<NewComplianceCompanyItemdata> loadItemData(Long cid, Long complianceId, String itemCode, Integer loadRefFlag) {
        List<NewComplianceCompanyItemdata> loadRefDataList;
        List lastByCid;
        ArrayList<NewComplianceCompanyItemdata> result = new ArrayList<NewComplianceCompanyItemdata>();
        if (complianceId == null && cid != null && (lastByCid = this.infoService.getComplianceCids(Arrays.asList(cid))) != null) {
            complianceId = ((NewComplianceCompanyInfo)lastByCid.get(0)).getId();
        }
        if (Objects.equals("02", itemCode)) {
            if (cid == null) {
                log.error("cid\u4e3a\u7a7a\u4e0d\u8fdb\u884c02\u6570\u636e\u52a0\u8f7d...");
                return result;
            }
            List riskTypeVos = this.riskCompletionService.selectRiskTypeListData(Collections.singletonList(cid), false);
            for (RiskTypeVo riskTypeVo : riskTypeVos) {
                if (riskTypeVo == null) continue;
                result.add(new NewComplianceCompanyItemdata().setCid(riskTypeVo.getCid()).setFieldName(riskTypeVo.getRiskTypeCode()).setItemcodeId(Long.valueOf(10201L)).setResultData(riskTypeVo.getRiskTypeStatus()));
            }
        }
        List dbItemDataList = this.itemdataService.listItemDataByCode(complianceId, itemCode);
        Map<Object, Object> codeIdFieldMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbItemDataList)) {
            codeIdFieldMap = dbItemDataList.stream().collect(Collectors.toMap(k -> k.getItemcodeId().toString() + k.getFieldName(), v -> v, (v1, v2) -> v1));
        }
        if (Objects.equals(loadRefFlag, 1) && CollectionUtils.isNotEmpty(loadRefDataList = this.busService.loadRefData(cid, null, itemCode))) {
            result.addAll(loadRefDataList);
            for (NewComplianceCompanyItemdata itemdata : loadRefDataList) {
                if (!codeIdFieldMap.containsKey(itemdata.getItemcodeId().toString() + itemdata.getFieldName())) continue;
                codeIdFieldMap.remove(itemdata.getItemcodeId().toString() + itemdata.getFieldName());
            }
        }
        if (MapUtils.isNotEmpty(codeIdFieldMap)) {
            List itemdataList = codeIdFieldMap.values().stream().collect(Collectors.toList());
            result.addAll(itemdataList);
        }
        return result;
    }

    public Boolean savePromiseData(List<NewComplianceCompanyItemdata> promiseDataList) {
        if (CollectionUtils.isEmpty(promiseDataList)) {
            return null;
        }
        NewComplianceCompanyItemdata promiseData = promiseDataList.get(0);
        Long complianceId = promiseData.getComplianceId();
        NewComplianceCompanyInfo info = (NewComplianceCompanyInfo)this.infoService.getById(complianceId);
        Long cid = info.getCid();
        boolean needRefresh = true;
        if (info.getStatus() == null || Objects.equals(info.getStatus(), NewComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey()) || Objects.equals(info.getStatus(), NewComplianceInfoStatusEnum.NON_COMPLIANCE.getKey())) {
            needRefresh = false;
        }
        this.busService.savePromiseData(promiseDataList, cid, needRefresh);
        if (needRefresh) {
            this.refreshScore(Arrays.asList(cid));
        }
        return true;
    }

    public void refreshScore(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        for (List cidList : ListUtil.partition(cids, (int)1000)) {
            this.doRefreshScore(cidList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefreshScore(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        RSet delayCidSet = this.redissonClient.getSet("new-third-service:ComplianceScoreRefresh:doRefreshScoreHanderset");
        ArrayList<Long> needAdd = new ArrayList<Long>();
        try {
            for (Long cid : cids) {
                if (!delayCidSet.contains((Object)cid)) {
                    needAdd.add(cid);
                    continue;
                }
                log.error("\u91cd\u590d\u5408\u89c4\u4efb\u52a1\u5237\u65b0\uff0c cid:{}", (Object)cid);
            }
            if (CollectionUtils.isEmpty(needAdd)) {
                return;
            }
            delayCidSet.addAll(needAdd);
            this.busService.doRefreshScore(needAdd, false);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5408\u89c4\u7b97\u5206\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
        finally {
            delayCidSet.removeAll(needAdd);
        }
    }

    public List<NewComplianceValidModel> validaFristStepData(Long cid, String ... itemCodes) {
        return this.busService.validaFristStepData(cid, itemCodes);
    }

    public void newComplianceDayScoreChangeRecord(List<Long> cidList) {
        int pageSize = 1000;
        log.info("=========================\u8bb0\u5f55\u5408\u89c4\u4f01\u4e1a\u6bcf\u65e5\u5206\u6570\u53d8\u5316\u65e5\u5fd7\u4efb\u52a1\u5f00\u59cbV2=========================");
        if (CollectionUtils.isEmpty(cidList)) {
            cidList = this.infoService.getCidList();
        }
        XxlJobHelper.log((String)"\u603b\u5171\u9700\u5904\u7406cidList:{}", (Object[])new Object[]{cidList.size()});
        List split = ListUtils.split((List)cidList, (int)pageSize);
        for (List cids : split) {
            ArrayList<NewComplianceScoreChangeRecordV2> logList = new ArrayList<NewComplianceScoreChangeRecordV2>();
            List newScoreList = this.infoService.queryScoreByCidList(cids);
            XxlJobHelper.log((String)"newScoreList:{}", (Object[])new Object[]{newScoreList.size()});
            List complianceIds = newScoreList.stream().map(NewComplianceCompanyInfo::getId).collect(Collectors.toList());
            List yesterdayRecords = this.complianceScoreChangeRecordV2Service.queryLatestRecordsV2(complianceIds);
            XxlJobHelper.log((String)"yesterdayRecords:{}", (Object[])new Object[]{yesterdayRecords.size()});
            Map<Object, Object> yesterdayMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)yesterdayRecords)) {
                yesterdayMap = yesterdayRecords.stream().collect(Collectors.toMap(NewComplianceScoreChangeRecordV2::getComplianceId, Function.identity()));
            }
            for (NewComplianceCompanyInfo newScore : newScoreList) {
                Date preUpdateDate;
                long l;
                NewComplianceScoreChangeRecordV2 preRecord = (NewComplianceScoreChangeRecordV2)yesterdayMap.get(newScore.getId());
                if (preRecord != null && preRecord.getUpdateDate() != null && (l = DateUtil.betweenDay((Date)(preUpdateDate = preRecord.getUpdateDate()), (Date)new Date(), (boolean)true)) == 0L || preRecord != null && Objects.equals(preRecord.getStatus(), NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey()) && Objects.equals(newScore.getStatus(), NewComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) continue;
                this.addLogs(newScore, preRecord, logList);
            }
            if (!CollectionUtils.isNotEmpty(logList)) continue;
            this.complianceScoreChangeRecordV2Service.insertComplianceScoreChangeBatch(logList);
            XxlJobHelper.log((String)"\u672c\u6b21\u9700\u4fdd\u6301\u65e5\u5fd7\u6570\uff0c logList:{}", (Object[])new Object[]{logList.size()});
        }
        log.info("=========================\u8bb0\u5f55\u5408\u89c4\u4f01\u4e1a\u6bcf\u65e5\u5206\u6570\u53d8\u5316\u65e5\u5fd7\u4efb\u52a1\u7ed3\u675fV2=========================");
    }

    private void addLogs(NewComplianceCompanyInfo newScore, NewComplianceScoreChangeRecordV2 preRecord, List<NewComplianceScoreChangeRecordV2> logList) {
        NewComplianceScoreChangeRecordV2 log = new NewComplianceScoreChangeRecordV2();
        log.setId(Long.valueOf(this.idworker.nextId()));
        log.setComplianceId(newScore.getId());
        log.setComplianceScore(newScore.getComplianceScore());
        log.setPreComplianceScore(preRecord == null ? null : preRecord.getComplianceScore());
        log.setStatus(newScore.getStatus());
        log.setComplianceAccordingType(newScore.getComplianceAccordingType());
        log.setUpdateDate(new Date());
        log.setIsValid(Boolean.valueOf(true));
        logList.add(log);
    }

    private List<NewComplianceNeedRefreshModel> queryRowData(List<Long> cidList) {
        ArrayList<NewComplianceNeedRefreshModel> result = new ArrayList<NewComplianceNeedRefreshModel>();
        List exitItemList = this.complianceCompanyExitItemService.queryIsExistExitItems(cidList);
        Map<Long, NewComplianceNeedRefreshModel> exitItemMap = exitItemList.stream().collect(Collectors.toMap(NewComplianceNeedRefreshModel::getCid, v -> v));
        List exitSuperviseObjectionList = this.complianceCompanyInfoService.judgeExistObjectionByCidList(cidList);
        Map<Long, NewComplianceNeedRefreshModel> superviseObjMap = exitSuperviseObjectionList.stream().collect(Collectors.toMap(NewComplianceNeedRefreshModel::getCid, v -> v));
        for (Long cid : cidList) {
            NewComplianceNeedRefreshModel exitItem = exitItemMap.get(cid);
            NewComplianceNeedRefreshModel superviseObj = superviseObjMap.get(cid);
            NewComplianceNeedRefreshModel info = null;
            if (Objects.nonNull(exitItem)) {
                info = new NewComplianceNeedRefreshModel();
                BeanUtils.copyProperties((Object)exitItem, (Object)info);
            }
            if (Objects.nonNull(superviseObj)) {
                if (Objects.isNull(info)) {
                    info = new NewComplianceNeedRefreshModel();
                    BeanUtils.copyProperties((Object)superviseObj, (Object)info);
                } else {
                    info.setExitSuperviseObjection(superviseObj.getExitSuperviseObjection());
                }
            }
            if (!Objects.nonNull(info)) continue;
            result.add(info);
        }
        return result;
    }

    private NewComplianceCompanyDataModel getByItemCodeId(Long itemCodeId, String fileName, List<NewComplianceCompanyDataModel> sysItemList) {
        return sysItemList.stream().filter(i -> i.getFieldName().equalsIgnoreCase(fileName) && i.getCodeId().equals(itemCodeId)).findFirst().orElse(null);
    }

    private NewComplianceScoreChangeRecord getById(Long id, List<NewComplianceScoreChangeRecord> yesterdayRecords) {
        return yesterdayRecords.stream().filter(i -> i.getComplianceId().equals(id)).findFirst().orElse(null);
    }

    @Transactional
    public void addDefaultValue(Long complianceId, String type) {
        this.itemdataService.addDefaultValue(complianceId, type);
    }
}

