/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.task;

import cn.smarthse.modules.health.newcompanyguide.enums.ChangeTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideChangeRecordModel;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideProgressService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideSmsRecordService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideInfoVo;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewCompanyGuideSend2SmsTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideSend2SmsTask.class);
    @Autowired
    private INewCompanyGuideInfoService guideInfoService;
    @Autowired
    private INewCompanyGuideSmsRecordService guideSmsRecordService;
    @Autowired
    private INewCompanyGuideProgressService newCompanyGuideProgressService;

    @XxlJob(value="NewCompanyGuideSend2SmsTask-send2Sms")
    public void send2Sms() {
        List cidList = this.newCompanyGuideProgressService.convert2normalCompany(null);
        log.info("\u5f00\u59cb---\u7533\u62a5\u5b8c\u6210\u4f01\u4e1a\u77ed\u4fe1\u53d1\u9001");
        List list = this.guideInfoService.getSend2SmsInfoVos(cidList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        try {
            this.guideSmsRecordService.batchSendSms(list, Byte.valueOf((byte)2));
        }
        catch (Exception e) {
            log.error("\u7533\u62a5\u77ed\u4fe1\u53d1\u9001\u5931\u8d25{}", (Throwable)e);
        }
        log.info("\u7ed3\u675f---\u7533\u62a5\u5b8c\u6210\u4f01\u4e1a\u77ed\u4fe1\u53d1\u9001");
    }

    @XxlJob(value="NewCompanyGuideSend2SmsTask-typeChange")
    public void typeChange() {
        List list = this.guideInfoService.getAllNewInfoToTask();
        List needChange = list.stream().map(this::convertToNewCompanyGuideInfo).filter(Objects::nonNull).collect(Collectors.toList());
        if (!needChange.isEmpty()) {
            XxlJobHelper.log((String)"\u672c\u6b21\u53d8\u66f4\u65b0\u5efa\u4f01\u4e1a\u72b6\u6001\u6570\u636e\u6570\uff1a{}...", (Object[])new Object[]{needChange.size()});
            for (NewCompanyGuideChangeRecordModel model : needChange) {
                this.guideInfoService.doSingleChange(model);
            }
        }
    }

    private NewCompanyGuideChangeRecordModel convertToNewCompanyGuideInfo(NewCompanyGuideInfoVo vo) {
        if (vo.getIrsBusinessState() != null && Objects.equals((byte)0, vo.getIrsBusinessState()) && (vo.getType() == null || vo.getType() == 0)) {
            return this.createNewCompanyGuideInfo(vo, ChangeTypeEnum.CANCELLED.getKey());
        }
        if (vo.getPauseTime() != null && Objects.equals(ChangeTypeEnum.PAUSED.getKey(), vo.getType()) && vo.getPauseDay() > 365L) {
            return this.createNewCompanyGuideInfo(vo, ChangeTypeEnum.TERMINATED.getKey());
        }
        return null;
    }

    private NewCompanyGuideChangeRecordModel createNewCompanyGuideInfo(NewCompanyGuideInfoVo vo, Byte type) {
        NewCompanyGuideChangeRecordModel model = new NewCompanyGuideChangeRecordModel();
        model.setNewCompanyId(vo.getId());
        model.setType(type);
        model.setUpdateDate(new Date());
        model.setUpdatedBy(Long.valueOf(0L));
        return model;
    }
}

