/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.task;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class NewCompanyGuideReportTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideReportTask.class);
    Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private INewCompanyGuideFinishedReportService finishedReportService;
    @Resource
    private INewCompanyGuideInfoService newCompanyGuideInfoService;

    @XxlJob(value="NewCompanyGuideReportTask-refreshReport")
    public void refreshReport() {
        this.logger.info("\u5f00\u59cb---\u5237\u65b0\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5b8c\u6210\u62a5\u8868");
        List newCompanyGuideInfos = this.newCompanyGuideInfoService.listAllNewCompanyGuideInfo();
        if (CollectionUtils.isEmpty((Collection)newCompanyGuideInfos)) {
            return;
        }
        List cids = newCompanyGuideInfos.stream().map(NewCompanyGuideInfo::getCid).distinct().collect(Collectors.toList());
        try {
            this.finishedReportService.refreshFinishReport(cids, NewCompanyGuideRefreshModelEnum.BASIC, new StepEnum[]{StepEnum.Step2, StepEnum.Step3, StepEnum.Step4, StepEnum.Step5});
            this.finishedReportService.collectOtherGuideFinishedReport(cids, ListUtil.of((Object[])new NewCompanyGuideRefreshModelEnum[]{NewCompanyGuideRefreshModelEnum.PERSONSHIELD, NewCompanyGuideRefreshModelEnum.WMBASE, NewCompanyGuideRefreshModelEnum.CHECK, NewCompanyGuideRefreshModelEnum.TRAIN, NewCompanyGuideRefreshModelEnum.PHC, NewCompanyGuideRefreshModelEnum.DECARE}));
        }
        catch (Exception e) {
            log.error("\u5237\u65b0\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5b8c\u6210\u62a5\u8868\u5f02\u5e38\uff1a", (Throwable)e);
        }
        this.logger.info("\u7ed3\u675f---\u5237\u65b0\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5b8c\u6210\u62a5\u8868");
    }
}

