/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.task;

import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NewCompanyGuideImportTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideImportTask.class);
    @Resource
    private INewCompanyGuideInfoService guideInfoService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService sysParamProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;

    @XxlJob(value="NewCompanyGuideImportTask-importNewCompanyGuideInfoTask")
    @Transactional(readOnly=false)
    public void importNewCompanyGuideInfoTask() {
        try {
            List needAddCompanyList;
            XxlJobHelper.log((String)"\u3010\u5bfc\u5165\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5f85\u786e\u8ba4\u6e05\u5355\u3011\u5f00\u59cb\u5bfc\u5165\u5f85\u786e\u8ba4\u6570\u636e...", (Object[])new Object[0]);
            List companySuperviseModels = this.guideInfoService.listWaitSureNewCompanyData();
            if (CollectionUtils.isEmpty((Collection)companySuperviseModels)) {
                return;
            }
            List needRemoveList = companySuperviseModels.stream().filter(f -> {
                Long id = f.getId();
                Integer reportType = f.getOccType();
                return id != null && reportType == null && Objects.equals((byte)0, f.getBusinessState());
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"\u672c\u6b21\u9700\u8981\u79fb\u9664\u7684\u6570\u636e\u6570\uff1a{}...", (Object[])new Object[]{companySuperviseModels.size()});
            if (CollectionUtils.isNotEmpty(needRemoveList)) {
                for (CompanySuperviseModel companySuperviseModel : needRemoveList) {
                    Long id = companySuperviseModel.getId();
                    NewCompanyGuideInfo guideInfo = new NewCompanyGuideInfo();
                    guideInfo.setId(id);
                    guideInfo.setIsValid(Boolean.valueOf(false));
                    guideInfo.setDelReason("\u4f01\u4e1a\u5df2\u6ce8\u9500");
                    this.guideInfoService.update((Object)guideInfo);
                }
            }
            if (CollectionUtils.isNotEmpty(needAddCompanyList = companySuperviseModels.stream().filter(f -> {
                Long id = f.getId();
                Integer reportType = f.getOccType();
                String businessStateName = f.getBusinessStateName();
                return f.getCid() == null && Objects.equals((byte)1, f.getBusinessState());
            }).collect(Collectors.toList()))) {
                List sysParamListByChildren = this.sysParamProvideService.getSysParamListByChildrenSearch("registration_type", null);
                List childByPrefix = this.areaProvideService.getChildByPrefix("33");
                Map<String, Long> regsiterTypeMap = sysParamListByChildren.stream().collect(Collectors.toMap(SysParamModel::getParamValue, SysParamModel::getId, (v1, v2) -> v1));
                XxlJobHelper.log((String)"\u672c\u6b21\u5bfc\u5165\u6570\u636e\u6570\uff1a{}...", (Object[])new Object[]{needAddCompanyList.size()});
                String regex = "(?<province>.*?\u7701)|(?<city>.*?\u5e02)|(?<district>.*?\u533a)";
                Pattern pattern = Pattern.compile(regex, 34);
                for (CompanySuperviseModel companySuperviseModel : needAddCompanyList) {
                    String businessStateName = companySuperviseModel.getBusinessStateName();
                    String registerTypeName = companySuperviseModel.getRegisterTypeName();
                    companySuperviseModel.setBusinessState(Byte.valueOf((byte)1));
                    companySuperviseModel.setRegisterType(regsiterTypeMap.get(registerTypeName));
                    String registerAddress = companySuperviseModel.getRegisterAddress();
                    Matcher matcher = pattern.matcher(registerAddress);
                    String province = "";
                    String city = "";
                    String district = "";
                    while (matcher.find()) {
                        if (matcher.group("province") != null) {
                            province = matcher.group("province");
                            continue;
                        }
                        if (matcher.group("city") != null) {
                            city = matcher.group("city");
                            continue;
                        }
                        if (matcher.group("district") == null) continue;
                        district = matcher.group("district");
                    }
                    Long areaId = this.getAreaIdByName(childByPrefix, province, city, district);
                    companySuperviseModel.setAreaId(areaId);
                }
                this.guideInfoService.batchAddCompanyGuideInfo(needAddCompanyList);
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5bfc\u5165\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5f85\u786e\u8ba4\u6e05\u5355\u3011\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    @XxlJob(value="NewCompanyGuideImportTask-importNewCompanyGuideInfoTask2")
    @Transactional(readOnly=false)
    public void importNewCompanyGuideInfoTask2() {
        try {
            XxlJobHelper.log((String)"\u3010\u5bfc\u5165\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5f85\u786e\u8ba4\u6e05\u5355\u3011\u5f00\u59cb\u5bfc\u5165\u5f85\u786e\u8ba4\u6570\u636e...", (Object[])new Object[0]);
            List companySuperviseModels = this.guideInfoService.listWaitSureNewCompanyData2();
            if (CollectionUtils.isEmpty((Collection)companySuperviseModels)) {
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)companySuperviseModels)) {
                List childByPrefix = this.areaProvideService.getChildByPrefix("33");
                XxlJobHelper.log((String)"\u672c\u6b21\u5bfc\u5165\u6570\u636e\u6570\uff1a{}...", (Object[])new Object[]{companySuperviseModels.size()});
                for (CompanySuperviseModel companySuperviseModel : companySuperviseModels) {
                    String registerTypeName = companySuperviseModel.getRegisterTypeName();
                    companySuperviseModel.setBusinessState(Byte.valueOf((byte)1));
                    companySuperviseModel.setRegisterType(this.getRegisterType(registerTypeName));
                    Long areaId = this.getAreaIdByName(childByPrefix, companySuperviseModel.getProvinceName(), companySuperviseModel.getCityName(), companySuperviseModel.getAreaName());
                    companySuperviseModel.setAreaId(areaId);
                }
                this.guideInfoService.batchAddCompanyGuideInfo(companySuperviseModels);
            }
        }
        catch (Exception e) {
            log.error("\u3010\u5bfc\u5165\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u5f85\u786e\u8ba4\u6e05\u5355\u3011\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    public Long getRegisterType(String registerTypeName) {
        String[][] data;
        for (String[] strings : data = new String[][]{{"\u4e2a\u4f53\u5de5\u5546\u6237", "4261"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8(\u81ea\u7136\u4eba\u72ec\u8d44)", "11"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8(\u81ea\u7136\u4eba\u6295\u8d44\u6216\u63a7\u80a1)", "11"}, {"\u5176\u4ed6\u6709\u9650\u8d23\u4efb\u516c\u53f8", "11"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8(\u53f0\u6e2f\u6fb3\u6cd5\u4eba\u72ec\u8d44)", "23"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8\uff08\u81ea\u7136\u4eba\u6295\u8d44\u6216\u63a7\u80a1\u7684\u6cd5\u4eba\u72ec\u8d44\uff09", "11"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8\u5206\u516c\u53f8(\u81ea\u7136\u4eba\u6295\u8d44\u6216\u63a7\u80a1)", "23"}, {"\u5176\u4ed6\u6709\u9650\u8d23\u4efb\u516c\u53f8\u5206\u516c\u53f8", "11"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8\uff08\u975e\u81ea\u7136\u4eba\u6295\u8d44\u6216\u63a7\u80a1\u7684\u6cd5\u4eba\u72ec\u8d44\uff09", "11"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8\u5206\u516c\u53f8(\u81ea\u7136\u4eba\u72ec\u8d44)", "11"}, {"\u6709\u9650\u8d23\u4efb\u516c\u53f8\uff08\u5916\u5546\u6295\u8d44\u3001\u975e\u72ec\u8d44\uff09", "29"}}) {
            if (!registerTypeName.equals(strings[0])) continue;
            return Long.valueOf(strings[1]);
        }
        return null;
    }

    public Long getAreaIdByName(List<AreaModel> areaList, String province, String city, String district) {
        List list1 = areaList.stream().filter(f -> Objects.equals(f.getProvinceName(), province) && Objects.equals(f.getCityName(), city) && Objects.equals(f.getAreaName(), district)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list1)) {
            return ((AreaModel)list1.get(0)).getId();
        }
        List list2 = areaList.stream().filter(f -> Objects.equals(f.getProvinceName(), province) && Objects.equals(f.getCityName(), city)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list2)) {
            return ((AreaModel)list2.get(0)).getId();
        }
        Long areaId = areaList.stream().filter(f -> Objects.equals(f.getAreaName(), district)).findFirst().map(AreaModel::getId).orElse(null);
        Long cityId = areaList.stream().filter(f -> Objects.equals(f.getAreaName(), city)).findFirst().map(AreaModel::getId).orElse(null);
        Long provideId = areaList.stream().filter(f -> Objects.equals(f.getAreaName(), province)).findFirst().map(AreaModel::getId).orElse(null);
        if (areaId != null) {
            return areaId;
        }
        if (cityId != null) {
            return cityId;
        }
        if (provideId != null) {
            return provideId;
        }
        return 330000000000L;
    }
}

