/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideFinishedReportMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideThreeWhilstInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideFinishedReport;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOccupationalHazardInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideOccupationalHazardInfoModel;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOccupationalHazardInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideProgressService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideThreeWhilstInfoService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class NewCompanyGuideThreeWhilstInfoServiceImpl
extends BaseServiceImpl<NewCompanyGuideThreeWhilstInfoMapper, NewCompanyGuideThreeWhilstInfo>
implements INewCompanyGuideThreeWhilstInfoService {
    @Lazy
    @Autowired
    private INewCompanyGuideFinishedReportService finishedReportService;
    @Lazy
    @Autowired
    private INewCompanyGuideProgressService newCompanyGuideProgressService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    private NewCompanyGuideFinishedReportMapper finishedReportMapper;
    @Autowired
    private INewCompanyGuideOccupationalHazardInfoService occupationalHazardInfoService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private NewCompanyGuideInfoMapper newCompanyGuideInfoMapper;

    @Transactional(readOnly=false)
    public CompanyBaseInfoModel getCompanyInfo(Long cid) {
        List reportList = this.finishedReportService.getInfoByCid(Collections.singletonList(cid));
        if (reportList == null || reportList.size() == 0) {
            NewCompanyGuideFinishedReport report = new NewCompanyGuideFinishedReport();
            report.setCid(cid);
            this.finishedReportService.batchSaveGuideFinishedReport(Collections.singletonList(report));
        }
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        IndustryModel model = this.industryProvideService.getIndustryById(company.getIndustryCategory());
        NewCompanyGuideThreeWhilstInfoServiceImpl.setIndustryCodeBasedOnLevel(model, company);
        return company;
    }

    private static void setIndustryCodeBasedOnLevel(IndustryModel model, CompanyBaseInfoModel company) {
        if (model != null) {
            String industryCode = null;
            switch (model.getLevel()) {
                case 1: {
                    industryCode = model.getIndustryCode1();
                    break;
                }
                case 2: {
                    industryCode = model.getIndustryCode2();
                    break;
                }
                case 3: 
                case 4: {
                    industryCode = model.getIndustryCode3();
                    break;
                }
            }
            company.setIndustryCode(industryCode);
        }
    }

    public Long saveCompany(CompanyBaseInfoModel companyModel, Long loginId) throws Exception {
        if (ObjectUtil.isNotNull((Object)companyModel.getAreaDetailId())) {
            companyModel.setAreaId(companyModel.getAreaDetailId());
        } else if (!ObjectUtil.isNotNull((Object)companyModel.getAreaId())) {
            if (ObjectUtil.isNotNull((Object)companyModel.getCityId())) {
                companyModel.setAreaId(companyModel.getCityId());
            } else if (ObjectUtil.isNotNull((Object)companyModel.getProvinceId())) {
                companyModel.setAreaId(companyModel.getProvinceId());
            }
        }
        if (ObjectUtil.isNotNull((Object)companyModel.getRegisterStreetId())) {
            companyModel.setRegisterAddressRegionId(companyModel.getRegisterStreetId());
        } else if (ObjectUtil.isNotNull((Object)companyModel.getRegisterAreaId())) {
            companyModel.setRegisterAddressRegionId(companyModel.getRegisterAreaId());
        } else if (ObjectUtil.isNotNull((Object)companyModel.getRegisterCityId())) {
            companyModel.setRegisterAddressRegionId(companyModel.getRegisterCityId());
        } else if (ObjectUtil.isNotNull((Object)companyModel.getRegisterProvinceId())) {
            companyModel.setRegisterAddressRegionId(companyModel.getRegisterProvinceId());
        }
        companyModel.setRegisterAddress(companyModel.getRegisterAreaDetailName());
        CompanyBaseInfoModel company = this.companyProvideByHSEService.saveOrUpdateCompany(companyModel, loginId, companyModel.getCid());
        this.finishedReportService.refreshFinishReport(Collections.singletonList(companyModel.getCid()), NewCompanyGuideRefreshModelEnum.COMPANY_BASIC, new StepEnum[0]);
        this.newCompanyGuideProgressService.addNextProgress(companyModel.getCid(), loginId, StepEnum.Step1.getKey());
        return company.getId();
    }

    private void addParameterValidation(CompanyBaseInfoModel companyBaseInfoModel) {
        if (ObjectUtil.isNull((Object)companyBaseInfoModel)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)companyBaseInfoModel.getName())) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companyBaseInfoModel.getScale())) {
            throw new ServiceException("\u4f01\u4e1a\u89c4\u6a21\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companyBaseInfoModel.getIndustryCategory())) {
            throw new ServiceException("\u4f01\u4e1a\u884c\u4e1a\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companyBaseInfoModel.getRegisterType())) {
            throw new ServiceException("\u4f01\u4e1a\u7ecf\u6d4e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companyBaseInfoModel.getAreaId())) {
            throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companyBaseInfoModel.getWorkAddress())) {
            throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companyBaseInfoModel.getRegisterAddressRegionId())) {
            throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companyBaseInfoModel.getRegisterAddress())) {
            throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(companyBaseInfoModel.getAreaId());
        if (ObjectUtil.isNull((Object)areaModel) || ObjectUtil.isNull((Object)areaModel.getLevel()) || areaModel.getLevel() != 4) {
            throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u884c\u653f\u533a\u5212\u5fc5\u987b\u7cbe\u786e\u5230\u8857\u9053\uff01");
        }
        AreaModel areaModelRegister = this.sysAreaProvideService.getAreaById(companyBaseInfoModel.getRegisterAddressRegionId());
        if (ObjectUtil.isNull((Object)areaModelRegister) || ObjectUtil.isNull((Object)areaModelRegister.getLevel()) || areaModelRegister.getLevel() != 4) {
            throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u884c\u653f\u533a\u5212\u5fc5\u987b\u7cbe\u786e\u5230\u8857\u9053\uff01");
        }
        String legalName = companyBaseInfoModel.getLegalName();
        String legalTel = companyBaseInfoModel.getLegalTel();
        String mainLeaderName = companyBaseInfoModel.getMainLeaderName();
        String mainLeaderTel = companyBaseInfoModel.getMainLeaderTel();
        String occManagerName = companyBaseInfoModel.getOccManagerName();
        String occManagerTel = companyBaseInfoModel.getOccManagerTel();
        if (StringUtils.isBlank((CharSequence)legalName)) {
            throw new ServiceException("\u4f01\u4e1a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)legalTel) || legalTel.length() != 11) {
            throw new ServiceException("\u4f01\u4e1a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)mainLeaderName)) {
            throw new ServiceException("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)mainLeaderTel) || mainLeaderTel.length() != 11) {
            throw new ServiceException("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)occManagerName)) {
            throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)occManagerTel) || occManagerTel.length() != 11) {
            throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        HashMap phoneToNamesMap = new HashMap();
        if (!phoneToNamesMap.containsKey(legalTel)) {
            phoneToNamesMap.put(legalTel, new ArrayList());
        }
        ((List)phoneToNamesMap.get(legalTel)).add(legalName);
        if (!phoneToNamesMap.containsKey(mainLeaderTel)) {
            phoneToNamesMap.put(mainLeaderTel, new ArrayList());
        }
        ((List)phoneToNamesMap.get(mainLeaderTel)).add(mainLeaderName);
        if (!phoneToNamesMap.containsKey(occManagerTel)) {
            phoneToNamesMap.put(occManagerTel, new ArrayList());
        }
        ((List)phoneToNamesMap.get(occManagerTel)).add(occManagerName);
        for (Map.Entry entry : phoneToNamesMap.entrySet()) {
            HashSet uniqueNames;
            List names = (List)entry.getValue();
            if (names.size() <= 1 || (uniqueNames = new HashSet(names)).size() <= 1) continue;
            throw new ServiceException("\u51b2\u7a81\u53d1\u73b0: \u624b\u673a\u53f7 " + (String)entry.getKey() + " \u88ab\u4e0d\u540c\u59d3\u540d\u4f7f\u7528\uff01");
        }
    }

    public NewCompanyGuideThreeWhilstInfo getThreeWhilstInfoByCid(Long cid) {
        Example example = new Example(NewCompanyGuideThreeWhilstInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List whilstInfoList = ((NewCompanyGuideThreeWhilstInfoMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)whilstInfoList)) {
            NewCompanyGuideThreeWhilstInfo whilstInfo = (NewCompanyGuideThreeWhilstInfo)whilstInfoList.get(0);
            Example e = new Example(NewCompanyGuideFinishedReport.class);
            e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
            List finishedReportList = this.finishedReportMapper.selectByExample(e);
            if (CollectionUtils.isNotEmpty((Collection)finishedReportList)) {
                whilstInfo.setCompanyFinished(((NewCompanyGuideFinishedReport)finishedReportList.get(0)).getCompanyFinished());
            }
            Example iExample = new Example(NewCompanyGuideInfo.class);
            iExample.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Boolean.TRUE);
            List infoList = this.newCompanyGuideInfoMapper.selectByExample(iExample);
            if (CollUtil.isNotEmpty((Collection)infoList)) {
                NewCompanyGuideInfo info = (NewCompanyGuideInfo)infoList.get(0);
                whilstInfo.setNewCompanyDatasource(info.getNewCompanyDatasource());
            }
            return whilstInfo;
        }
        return null;
    }

    public Long saveThreeWhilstInfo(NewCompanyGuideThreeWhilstInfo info, Long loginId) {
        Byte step = info.getStep();
        Date date = new Date();
        if (info.getId() == null) {
            if (info.getProjectApprovalTime() == null) {
                throw new RuntimeException("\u8bf7\u586b\u5199\u201c\u4e09\u540c\u65f6\u201d\u9879\u76ee\u7684\u7acb\u9879\u65f6\u95f4\u3002");
            }
            info.setId(Long.valueOf(this.idworker.nextId()));
            info.setCreateDate(date);
            info.setCreateBy(loginId);
            info.setUpdateDate(date);
            ((NewCompanyGuideThreeWhilstInfoMapper)this.dao).insertSelective(info);
        } else {
            NewCompanyGuideThreeWhilstInfo dbInfo = (NewCompanyGuideThreeWhilstInfo)((NewCompanyGuideThreeWhilstInfoMapper)this.dao).selectByPrimaryKey(info.getId());
            List occupationalHazardInfoList = this.occupationalHazardInfoService.listHazardInfo(Collections.singletonList(info.getCid()), Arrays.asList(StepEnum.Step2.getKey(), StepEnum.Step3.getKey(), StepEnum.Step4.getKey()));
            if (Objects.equals(step, StepEnum.Step1.getKey())) {
                if (info.getProjectApprovalTime() == null) {
                    throw new RuntimeException("\u8bf7\u586b\u5199\u201c\u4e09\u540c\u65f6\u201d\u9879\u76ee\u7684\u7acb\u9879\u65f6\u95f4\u3002");
                }
            } else if (Objects.equals(step, StepEnum.Step2.getKey())) {
                if (dbInfo.getProjectApprovalTime() == null) {
                    throw new RuntimeException("\u8bf7\u586b\u5199\u201c\u4e09\u540c\u65f6\u201d\u9879\u76ee\u7684\u7acb\u9879\u65f6\u95f4\u3002");
                }
            } else if (Objects.equals(step, StepEnum.Step3.getKey())) {
                if (info.getTestRunBeginTime() == null) {
                    throw new RuntimeException("\u8bf7\u586b\u5199\u201c\u4e09\u540c\u65f6\u201d\u9879\u76ee\u7684\u8bd5\u8fd0\u884c\u65f6\u95f4\u3002");
                }
                if (info.getTestRunBeginTime().before(dbInfo.getProjectApprovalTime())) {
                    throw new RuntimeException("\u8bd5\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4\u3002");
                }
                if (info.getActualStartTime() == null) {
                    throw new RuntimeException("\u8bf7\u586b\u5199\u201c\u4e09\u540c\u65f6\u201d\u9879\u76ee\u7684\u5b9e\u9645\u5f00\u5de5\u65f6\u95f4\u3002");
                }
                if (info.getActualStartTime().before(dbInfo.getProjectApprovalTime())) {
                    throw new RuntimeException("\u5b9e\u9645\u5f00\u5de5\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4\u3002");
                }
                if (CollectionUtils.isNotEmpty((Collection)occupationalHazardInfoList)) {
                    Date pjDate = null;
                    List pjList = occupationalHazardInfoList.stream().filter(e -> Objects.equals(StepEnum.Step2.getKey(), e.getStep()) && e.getCompleteTime() != null).collect(Collectors.toList());
                    if (pjList.size() > 0) {
                        pjDate = pjList.stream().max(Comparator.comparing(NewCompanyGuideOccupationalHazardInfo::getCompleteTime)).get().getCompleteTime();
                    }
                    if (pjDate != null && info.getTestRunBeginTime().before(pjDate)) {
                        throw new RuntimeException("\u8bd5\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8bc4\u4ef7\u5b8c\u6210\u65f6\u95f4\u3002");
                    }
                    Date sjDate = null;
                    List sjList = occupationalHazardInfoList.stream().filter(e -> Objects.equals(StepEnum.Step3.getKey(), e.getStep()) && e.getCompleteTime() != null).collect(Collectors.toList());
                    if (sjList.size() > 0) {
                        sjDate = sjList.stream().max(Comparator.comparing(NewCompanyGuideOccupationalHazardInfo::getCompleteTime)).get().getCompleteTime();
                    }
                    if (sjDate != null && info.getTestRunBeginTime().before(sjDate)) {
                        throw new RuntimeException("\u8bd5\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8bbe\u8ba1\u5b8c\u6210\u65f6\u95f4\u3002");
                    }
                }
            } else if (Objects.equals(step, StepEnum.Step4.getKey())) {
                if (info.getCompleteTime() == null) {
                    throw new RuntimeException("\u8bf7\u586b\u5199\u201c\u4e09\u540c\u65f6\u201d\u9879\u76ee\u7684\u7ae3\u5de5\u65f6\u95f4\u3002");
                }
                if (info.getCompleteTime().before(dbInfo.getTestRunBeginTime())) {
                    throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8bd5\u8fd0\u884c\u65f6\u95f4\u3002");
                }
                if (CollectionUtils.isNotEmpty((Collection)occupationalHazardInfoList)) {
                    Date pjDate = null;
                    List pjList = occupationalHazardInfoList.stream().filter(e -> Objects.equals(StepEnum.Step4.getKey(), e.getStep()) && e.getCompleteTime() != null).collect(Collectors.toList());
                    if (pjList.size() > 0) {
                        pjDate = pjList.stream().max(Comparator.comparing(NewCompanyGuideOccupationalHazardInfo::getCompleteTime)).get().getCompleteTime();
                    }
                    if (pjDate != null && info.getCompleteTime().before(pjDate)) {
                        throw new RuntimeException("\u7ae3\u5de5\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u8bc4\u4ef7\u5b8c\u6210\u65f6\u95f4\u3002");
                    }
                }
            }
            info.setUpdateDate(date);
            info.setUpdateBy(loginId);
            ((NewCompanyGuideThreeWhilstInfoMapper)this.dao).updateByPrimaryKeySelective(info);
        }
        this.finishedReportService.refreshFinishReport(Collections.singletonList(info.getCid()), NewCompanyGuideRefreshModelEnum.THREE_WHILST_BASIC, new StepEnum[0]);
        return info.getId();
    }

    public void saveEvaluationInfo(NewCompanyGuideOccupationalHazardInfoModel hazardInfoModel, Long cid, Long loginStaffId) {
        NewCompanyGuideThreeWhilstInfo threeWhilstInfo = hazardInfoModel.getThreeWhilstInfo();
        threeWhilstInfo.setCid(cid);
        this.saveThreeWhilstInfo(threeWhilstInfo, loginStaffId);
        this.occupationalHazardInfoService.saveOccEvaluate(hazardInfoModel.getList(), cid, loginStaffId);
        this.newCompanyGuideProgressService.addNextProgress(cid, loginStaffId, ((NewCompanyGuideOccupationalHazardInfo)hazardInfoModel.getList().get(0)).getStep());
    }
}

