/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideSmsRecordMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideSmsRecord;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideSmsRecordService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideInfoVo;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class NewCompanyGuideSmsRecordServiceImpl
extends BaseServiceImpl<NewCompanyGuideSmsRecordMapper, NewCompanyGuideSmsRecord>
implements INewCompanyGuideSmsRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideSmsRecordServiceImpl.class);
    private final INewCompanyGuideInfoService infoService;
    @DubboReference
    private ISMSProvideMasService smsProvideMasService;
    private static final Gson gson = new Gson();
    private static final String SEND1_TEMPLATE = "\u8d35\u516c\u53f8\u65b0\u5efa\u9879\u76ee\u3010%s\u3011\u5df2\u7eb3\u5165\u65b0\u5efa\u4f01\u4e1a\u804c\u4e1a\u5065\u5eb7\u7ba1\u7406\u76d1\u7763\u8303\u56f4\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u6d59\u91cc\u536b\u4f01\u5e73\u53f0\u5e76\u6839\u636e\u5f15\u5bfc\u5b8c\u6210\u76f8\u5173\u5de5\u4f5c\u3002\u5355\u4f4d\u8d26\u53f7\u4e3a\u8d35\u516c\u53f8\u4e2d\u6587\u540d\u79f0\u5168\u79f0\uff0c\u9ed8\u8ba4\u5bc6\u7801\uff1aZyj@2022\u3002\u4e3a\u4fdd\u969c\u8d26\u53f7\u5b89\u5168\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u5e76\u4fee\u6539\u5bc6\u7801\u3002\u6d59\u91cc\u536b\u4f01\u7f51\u5740\uff1ahttps://ohonline.wsjkw.zj.gov.cn";
    private static final String SEND2_TEMPLATE = "\u8d35\u516c\u53f8\u65b0\u5efa\u9879\u76ee\u3010%s\u3011\u7684\u201c\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u201d\u6570\u636e\u5df2\u901a\u8fc7\u5ba1\u6838\u5e76\u5f52\u96c6\u81f3\u201c\u6d59\u91cc\u536b\u4f01\u201d\u5e73\u53f0\uff0c\u8bf7\u5c3d\u5feb\u767b\u5f55\u5e73\u53f0\u5b8c\u6210\u201c\u98ce\u9669\u5316\u89e3\u201d\u3001\u201c\u5206\u7c7b\u81ea\u67e5\u201d\u7b49\u5de5\u4f5c\u3002\u6d59\u91cc\u536b\u4f01\u7f51\u5740:https://ohonline.wsjkw.zj.gov.cn\u3002";
    @Value(value="${sms.switch}")
    private Boolean smsSwitch;

    @Transactional
    public ResponseData<String> batchSendSms(List<NewCompanyGuideInfoVo> list, Byte type) {
        if (list == null || list.isEmpty()) {
            return ResponseData.fail((String)"\u53d1\u9001\u4f01\u4e1a\u6570\u4e3a0");
        }
        Date now = new Date();
        ArrayList records = new ArrayList();
        ArrayList infos = new ArrayList();
        try {
            list.forEach(vo -> {
                String content = "";
                content = Objects.equals((byte)1, type) ? String.format(SEND1_TEMPLATE, vo.getProjectName()) : String.format(SEND2_TEMPLATE, vo.getProjectName());
                System.out.println(content);
                String response = "";
                response = this.smsSwitch != false ? this.smsProvideMasService.sendSms(vo.getLegalTel(), content) : "{\"rspcod\": \"\u77ed\u4fe1\u53d1\u9001\u51fa\u6210\u529f\", \"success\": true}";
                Response responseData = (Response)gson.fromJson(response, Response.class);
                boolean success = responseData.isSuccess();
                NewCompanyGuideSmsRecord record = new NewCompanyGuideSmsRecord();
                record.setCid(vo.getCid());
                record.setNewCompanyId(vo.getId());
                record.setSendType(type);
                record.setIsValid(Boolean.valueOf(true));
                record.setRecords(responseData.getRspcod());
                if (success) {
                    record.setIsSucceed(Byte.valueOf((byte)1));
                    if (Objects.equals((byte)1, type)) {
                        vo.setSendStatus(Byte.valueOf((byte)1));
                        vo.setSendDate(now);
                    } else {
                        vo.setSend2Status(Byte.valueOf((byte)1));
                        vo.setSend2Date(now);
                    }
                } else {
                    record.setIsSucceed(Byte.valueOf((byte)2));
                    if (Objects.equals((byte)1, type)) {
                        vo.setSendStatus(Byte.valueOf((byte)2));
                    } else {
                        vo.setSend2Status(Byte.valueOf((byte)2));
                    }
                }
                records.add(record);
                NewCompanyGuideInfo info = new NewCompanyGuideInfo();
                BeanUtils.copyBeanProp((Object)info, (Object)vo);
                infos.add(info);
            });
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return ResponseData.fail();
        }
        this.infoService.batchUpdateOrInsert(infos, NewCompanyGuideInfoMapper.class, (item, mapper) -> {
            item.setUpdateDate(now);
            return mapper.updateByPrimaryKeySelective(item);
        });
        this.batchUpdateOrInsert(records, NewCompanyGuideSmsRecordMapper.class, (item, mapper) -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setUpdateDate(now);
            item.setCreateDate(now);
            return mapper.insert(item);
        });
        return ResponseData.success();
    }

    @Generated
    public NewCompanyGuideSmsRecordServiceImpl(INewCompanyGuideInfoService infoService) {
        this.infoService = infoService;
    }

    static class Response {
        private String rspcod;
        private Boolean success;

        Response() {
        }

        public String getRspcod() {
            return this.rspcod;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

