/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.NewCompanyMergeTsVo;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleDataSourceEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleRelatedEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleRemarkEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideFinishedReportMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideOrgShowMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideProgressMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideFinishedReport;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOccupationalHazardInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOrgShow;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideProgress;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.LackStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.LackTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideLackMaterialService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOccupationalHazardInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideProgressService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideThreeWhilstInfoService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyExceptionProgressGuideVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideSummaryVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideTodoListVo;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import cn.smarthse.modules.health.vo.riskResolve.RiskResolveInfoVo;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class NewCompanyGuideProgressImpl
extends BaseServiceImpl<NewCompanyGuideProgressMapper, NewCompanyGuideProgress>
implements INewCompanyGuideProgressService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideProgressImpl.class);
    private final INewCompanyGuideThreeWhilstInfoService threeWhilstInfoService;
    private final INewCompanyGuideOccupationalHazardInfoService hazardInfoService;
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideService companyProvideService;
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    private final INewCompanyGuideInfoService companyGuideInfoService;
    private final NewCompanyGuideOrgShowMapper orgShowMapper;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    private final INewCompanyGuideLackMaterialService newCompanyGuideLackMaterialService;
    private final NewCompanyGuideFinishedReportMapper finishedReportMapper;
    @Resource
    private ThreadPoolExecutor poolTaskExecutor;

    @Transactional
    public Byte addNextProgress(Long cid, Long staffId, Byte step) {
        NewCompanyGuideInfo guideInfo = this.companyGuideInfoService.getByCid(cid);
        byte nextStep = StepEnum.getNextStep((Byte)step);
        if (StepEnum.Step5.getKey().equals(nextStep)) {
            List<Byte> list = Arrays.asList(StepEnum.Step5.getKey(), StepEnum.Step5_1.getKey(), StepEnum.Step5_2.getKey());
            ((NewCompanyGuideProgressMapper)this.dao).addProgressBatch(list, cid, staffId);
        } else {
            ((NewCompanyGuideProgressMapper)this.dao).addNextProgress(nextStep, cid, staffId);
        }
        if (Objects.isNull(guideInfo.getStep()) || guideInfo.getStep() < nextStep) {
            this.companyGuideInfoService.updateStep(cid, Byte.valueOf(nextStep));
        }
        return nextStep;
    }

    @Transactional
    public void autoConvert2To1AfterFinishGuide(Long cid, Long staffId) {
        if (cid == null) {
            return;
        }
        ((NewCompanyGuideProgressMapper)this.dao).autoConvert2To1AfterFinishGuide(cid, staffId);
    }

    public Byte getMaxStep(Long cid) {
        return ((NewCompanyGuideProgressMapper)this.dao).getMaxStep(cid);
    }

    @Transactional
    public void autoRelatedTsProject(Long cid, Long tsProjectId) {
        NewCompanyGuideThreeWhilstInfo threeWhilstInfo = this.threeWhilstInfoService.getThreeWhilstInfoByCid(cid);
        List hazardInfoList = this.hazardInfoService.getListByCid(cid);
        Map<Byte, List<NewCompanyGuideOccupationalHazardInfo>> hazardInfoMap = hazardInfoList.stream().collect(Collectors.groupingBy(NewCompanyGuideOccupationalHazardInfo::getStep));
        if (Objects.isNull(threeWhilstInfo) || CollectionUtils.isEmpty((Collection)hazardInfoList)) {
            log.error("\u5339\u914d\u4e09\u540c\u65f6\u5931\u8d25\uff1a\u6570\u636e\u6e90\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002");
            return;
        }
        List newGuideProjectList = this.tsProjectSimpleService.getNewGuideProjectList(Collections.singletonList(cid), Boolean.valueOf(true));
        if (!CollectionUtils.isEmpty((Collection)newGuideProjectList)) {
            throw new RuntimeException("\u5df2\u5173\u8054\u8fc7\u4e09\u540c\u65f6\u9879\u76ee\u4e86\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        TsProjectSimple tsProjectSimple = (TsProjectSimple)this.tsProjectSimpleService.getById(tsProjectId);
        if (Objects.isNull(tsProjectSimple)) {
            tsProjectSimple = new TsProjectSimple();
            tsProjectSimple.setProjectCode(threeWhilstInfo.getProjectCode());
            tsProjectSimple.setDataSource(TsProjectSimpleDataSourceEnum.NEW_COMPANY_GUIDE.getCode());
            tsProjectSimple.setNewCompanyGuideRelated(TsProjectSimpleRelatedEnum.WAIT_RELATED.getCode());
            tsProjectSimple.setProjectName(threeWhilstInfo.getProjectName());
            tsProjectSimple.setProjectTime(threeWhilstInfo.getProjectApprovalTime());
            tsProjectSimple.setRemark(TsProjectSimpleRemarkEnum.NEW_COMPANY_GUIDE.getName());
            tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode());
        } else {
            tsProjectSimple.setNewCompanyGuideRelated(TsProjectSimpleRelatedEnum.RELATED.getCode());
            tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.DRAFT.getCode());
        }
        this.mergeTsBaseInfo(cid, threeWhilstInfo, hazardInfoMap, tsProjectSimple);
        try {
            tsProjectSimple = this.tsProjectSimpleService.saveOrUpdateTsProject(tsProjectSimple, Long.valueOf(0L), cid);
            this.liteArchiveService.syncTsProjectArchive(tsProjectSimple);
        }
        catch (Exception e) {
            log.error("\u4e09\u540c\u65f6\u540c\u6b65\u65b0\u5efa\u4f01\u4e1a\u6570\u636e\u5931\u8d25\uff0ccid:{},{}", (Object)cid, (Object)e.getMessage());
            throw new RuntimeException("\u4e09\u540c\u65f6\u540c\u6b65\u65b0\u5efa\u4f01\u4e1a\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    @Transactional
    public void manualRelatedTsProject(Long cid, Long tsProjectId) {
        List newGuideProjectList = this.tsProjectSimpleService.getNewGuideProjectList(Collections.singletonList(cid), Boolean.valueOf(true));
        if (CollectionUtils.isEmpty((Collection)newGuideProjectList)) {
            throw new RuntimeException("\u672a\u627e\u5230\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        TsProjectSimple relatedTs = newGuideProjectList.stream().filter(t -> t.getNewCompanyGuideRelated().equals(TsProjectSimpleRelatedEnum.RELATED.getCode())).findFirst().orElse(null);
        if (Objects.nonNull(relatedTs)) {
            throw new RuntimeException("\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u6570\u636e\u5df2\u6709\u5173\u8054\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        TsProjectSimple noRelatedTs = newGuideProjectList.stream().filter(t -> t.getNewCompanyGuideRelated().equals(TsProjectSimpleRelatedEnum.WAIT_RELATED.getCode())).findFirst().orElse(null);
        if (Objects.isNull(noRelatedTs)) {
            throw new RuntimeException("\u6ca1\u7528\u5f85\u5173\u8054\u7684\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        TsProjectSimple tsProjectSimple = (TsProjectSimple)this.tsProjectSimpleService.getById(tsProjectId);
        if (Objects.isNull(tsProjectSimple)) {
            throw new RuntimeException("tsProjectId\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        BeanUtil.copyProperties((Object)noRelatedTs, (Object)tsProjectSimple, (String[])new String[]{"id", "cid", "projectName", "projectTime", "projectCode", "dataSource", "remark"});
        tsProjectSimple.setStatus(TsProjectSimpleStatusEnum.DRAFT.getCode());
        tsProjectSimple.setNewCompanyGuideRelated(TsProjectSimpleRelatedEnum.RELATED.getCode());
        noRelatedTs.setIsValid(Boolean.valueOf(false));
        this.tsProjectSimpleService.update((Object)tsProjectSimple);
        this.tsProjectSimpleService.updateByPrimaryKey((Object)noRelatedTs, Long.valueOf(0L));
        this.liteArchiveService.syncTsProjectArchive(tsProjectSimple);
    }

    public void cancelRelatedTsProject(Long cid, Long tsProjectId) throws Exception {
        List newGuideProjectList = this.tsProjectSimpleService.getNewGuideProjectList(Collections.singletonList(cid), null);
        if (CollectionUtils.isEmpty((Collection)newGuideProjectList)) {
            throw new RuntimeException("\u672a\u627e\u5230\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        TsProjectSimple relatedTs = newGuideProjectList.stream().filter(t -> t.getNewCompanyGuideRelated().equals(TsProjectSimpleRelatedEnum.RELATED.getCode())).findFirst().orElse(null);
        if (Objects.isNull(relatedTs)) {
            throw new RuntimeException("\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u6570\u636e\u6ca1\u6709\u5173\u8054\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        if (!relatedTs.getId().equals(tsProjectId)) {
            throw new RuntimeException("\u65b0\u5efa\u4f01\u4e1a\u4e09\u540c\u65f6\u6570\u636e\u5173\u8054\u7684\u4e09\u540c\u65f6\u4e0e\u4f20\u53c2\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        if (TsProjectSimpleStatusEnum.AUDITED.getCode().equals(relatedTs.getStatus())) {
            throw new RuntimeException("\u5ba1\u6838\u901a\u8fc7\u7684\u4e09\u540c\u65f6\u4e0d\u80fd\u53d6\u6d88\u5173\u8054");
        }
        TsProjectSimple noRelatedTs = newGuideProjectList.stream().filter(t -> t.getNewCompanyGuideRelated().equals(TsProjectSimpleRelatedEnum.WAIT_RELATED.getCode())).findFirst().orElse(null);
        if (Objects.isNull(noRelatedTs)) {
            NewCompanyGuideThreeWhilstInfo threeWhilstInfo = this.threeWhilstInfoService.getThreeWhilstInfoByCid(cid);
            List hazardInfoList = this.hazardInfoService.getListByCid(cid);
            Map<Byte, List<NewCompanyGuideOccupationalHazardInfo>> hazardInfoMap = hazardInfoList.stream().collect(Collectors.groupingBy(NewCompanyGuideOccupationalHazardInfo::getStep));
            if (Objects.isNull(threeWhilstInfo) || CollectionUtils.isEmpty((Collection)hazardInfoList)) {
                log.error("\u5339\u914d\u4e09\u540c\u65f6\u5931\u8d25\uff1a\u6570\u636e\u6e90\u4e3a\u7a7a\u3002\u3002\u3002\u3002\u3002");
                return;
            }
            noRelatedTs = new TsProjectSimple();
            noRelatedTs.setProjectCode(threeWhilstInfo.getProjectCode());
            noRelatedTs.setDataSource(TsProjectSimpleDataSourceEnum.NEW_COMPANY_GUIDE.getCode());
            noRelatedTs.setNewCompanyGuideRelated(TsProjectSimpleRelatedEnum.WAIT_RELATED.getCode());
            noRelatedTs.setProjectName(threeWhilstInfo.getProjectName());
            noRelatedTs.setProjectTime(threeWhilstInfo.getProjectApprovalTime());
            noRelatedTs.setRemark(TsProjectSimpleRemarkEnum.NEW_COMPANY_GUIDE.getName());
            noRelatedTs.setStatus(TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode());
            this.mergeTsBaseInfo(cid, threeWhilstInfo, hazardInfoMap, noRelatedTs);
        } else {
            noRelatedTs.setIsValid(Boolean.valueOf(true));
        }
        if (noRelatedTs.getProjectCode().equalsIgnoreCase(relatedTs.getProjectCode())) {
            throw new RuntimeException("\u9879\u76ee\u4ee3\u7801\u5339\u914d\u7684\u4e09\u540c\u65f6\u4e0d\u80fd\u53d6\u6d88\u5173\u8054");
        }
        BeanUtil.copyProperties((Object)new TsProjectSimple(), (Object)relatedTs, (String[])new String[]{"id", "cid", "projectName", "projectTime", "projectCode", "dataSource", "remark"});
        relatedTs.setStatus(TsProjectSimpleStatusEnum.DRAFT.getCode());
        relatedTs.setIsValid(Boolean.valueOf(true));
        this.tsProjectSimpleService.saveOrUpdateTsProject(noRelatedTs, Long.valueOf(0L), cid);
        this.liteArchiveService.syncTsProjectArchive(noRelatedTs);
        this.tsProjectSimpleService.updateByPrimaryKey((Object)relatedTs, Long.valueOf(0L));
    }

    private void mergeTsBaseInfo(Long cid, NewCompanyGuideThreeWhilstInfo threeWhilstInfo, Map<Byte, List<NewCompanyGuideOccupationalHazardInfo>> hazardInfoMap, TsProjectSimple tsProjectSimple) {
        tsProjectSimple.setCid(cid);
        tsProjectSimple.setProjectFinishTime(threeWhilstInfo.getCompleteTime());
        List lackMaterialVoList = this.newCompanyGuideLackMaterialService.listData(cid, null);
        List<NewCompanyGuideOccupationalHazardInfo> newCompanyGuideOccupationalHazardInfos = hazardInfoMap.get(StepEnum.Step2.getKey());
        NewCompanyGuideOccupationalHazardInfo preEvaluation = newCompanyGuideOccupationalHazardInfos.stream().filter(NewCompanyGuideOccupationalHazardInfo::getRequired).findFirst().orElse(new NewCompanyGuideOccupationalHazardInfo());
        tsProjectSimple.setHarmEvalOrgId1(preEvaluation.getOrgId());
        tsProjectSimple.setHarmEvalOrgName1(preEvaluation.getOrgName());
        tsProjectSimple.setEvalEvidenceId1(preEvaluation.getEvaluateReportFileId() != null ? preEvaluation.getEvaluateReportFileId().toString() : "");
        tsProjectSimple.setHarmEvalFinishTime1(preEvaluation.getCompleteTime());
        boolean isLackYp = lackMaterialVoList.stream().anyMatch(l -> l.getLackType().equals(LackTypeEnum.YP.getKey()) && l.getStatus().equals(LackStatusEnum.PASS.getKey()));
        if (isLackYp) {
            tsProjectSimple.setEvalState(TsProjectSimpleStateEnum.NOT_START.getCode());
        } else {
            tsProjectSimple.setEvalState(TsProjectSimpleStateEnum.FINISH.getCode());
        }
        preEvaluation = newCompanyGuideOccupationalHazardInfos.stream().filter(s -> s.getRequired() == false).findFirst().orElse(new NewCompanyGuideOccupationalHazardInfo());
        tsProjectSimple.setHarmEvalOrgId2(preEvaluation.getOrgId());
        tsProjectSimple.setHarmEvalOrgName2(preEvaluation.getOrgName());
        tsProjectSimple.setEvalEvidenceId2(preEvaluation.getEvaluateReportFileId() != null ? preEvaluation.getEvaluateReportFileId().toString() : "");
        tsProjectSimple.setHarmEvalFinishTime2(preEvaluation.getCompleteTime());
        newCompanyGuideOccupationalHazardInfos = hazardInfoMap.get(StepEnum.Step3.getKey());
        NewCompanyGuideOccupationalHazardInfo design = newCompanyGuideOccupationalHazardInfos.stream().filter(NewCompanyGuideOccupationalHazardInfo::getRequired).findFirst().orElse(new NewCompanyGuideOccupationalHazardInfo());
        tsProjectSimple.setDesignOrgId(design.getOrgId());
        tsProjectSimple.setDesignOrgName(design.getOrgName());
        tsProjectSimple.setDesignEvidenceId(design.getEvaluateReportFileId() != null ? design.getEvaluateReportFileId().toString() : "");
        tsProjectSimple.setDesignFinishTime(design.getCompleteTime());
        boolean isLackDesign = lackMaterialVoList.stream().anyMatch(l -> l.getLackType().equals(LackTypeEnum.SJ.getKey()) && l.getStatus().equals(LackStatusEnum.PASS.getKey()));
        if (isLackDesign) {
            tsProjectSimple.setDesignState(TsProjectSimpleStateEnum.NOT_START.getCode());
        } else {
            tsProjectSimple.setDesignState(TsProjectSimpleStateEnum.FINISH.getCode());
        }
        newCompanyGuideOccupationalHazardInfos = hazardInfoMap.get(StepEnum.Step4.getKey());
        NewCompanyGuideOccupationalHazardInfo control = newCompanyGuideOccupationalHazardInfos.stream().filter(NewCompanyGuideOccupationalHazardInfo::getRequired).findFirst().orElse(new NewCompanyGuideOccupationalHazardInfo());
        tsProjectSimple.setConEvalOrgId1(control.getOrgId());
        tsProjectSimple.setConEvalOrgName1(control.getOrgName());
        if (control.getEvaluateReportFileId() != null) {
            tsProjectSimple.setControlEvidenceId1(control.getEvaluateReportFileId().toString());
        }
        tsProjectSimple.setConFinishTime1(control.getCompleteTime());
        boolean isLackKp = lackMaterialVoList.stream().anyMatch(l -> l.getLackType().equals(LackTypeEnum.KP.getKey()) && l.getStatus().equals(LackStatusEnum.PASS.getKey()));
        if (isLackKp) {
            tsProjectSimple.setControlState(TsProjectSimpleStateEnum.NOT_START.getCode());
        } else {
            tsProjectSimple.setControlState(TsProjectSimpleStateEnum.FINISH.getCode());
        }
        tsProjectSimple.setRiskType(this.convertRiskType(control.getOccType()));
        control = newCompanyGuideOccupationalHazardInfos.stream().filter(s -> s.getRequired() == false).findFirst().orElse(new NewCompanyGuideOccupationalHazardInfo());
        tsProjectSimple.setConEvalOrgId2(control.getOrgId());
        tsProjectSimple.setConEvalOrgName2(control.getOrgName());
        tsProjectSimple.setControlEvidenceId2(control.getEvaluateReportFileId() != null ? control.getEvaluateReportFileId().toString() : "");
        tsProjectSimple.setConFinishTime2(control.getCompleteTime());
    }

    private Byte convertRiskType(Byte occType) {
        if (occType == null) {
            return null;
        }
        if (occType == 1) {
            return (byte)2;
        }
        if (occType == 3) {
            return (byte)1;
        }
        return null;
    }

    public List<String> finishGuide(Long cid, Long staffId, Long tsProjectId) {
        boolean isFinished;
        List<String> warningList = this.verifyItem(cid);
        boolean bl = isFinished = warningList.size() == 0;
        if (isFinished) {
            this.autoRelatedTsProject(cid, tsProjectId);
            this.addNextProgress(cid, staffId, StepEnum.Step5.getKey());
            this.autoConvert2To1AfterFinishGuide(cid, staffId);
        }
        return warningList;
    }

    public List<String> verifyItem(Long cid) {
        Example e = new Example(NewCompanyGuideFinishedReport.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List finishedReportList = this.finishedReportMapper.selectByExample(e);
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)finishedReportList)) {
            result.add("\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u8bd5\u3002");
        }
        if (finishedReportList != null && finishedReportList.size() > 0) {
            NewCompanyGuideFinishedReport report = (NewCompanyGuideFinishedReport)finishedReportList.get(0);
            if (!report.getCompanyFinished().booleanValue()) {
                result.add("\u201c\u57fa\u7840\u4fe1\u606f\u5b8c\u5584\u201d\u9636\u6bb5\u4fe1\u606f\u672a\u5b8c\u5584");
            }
            if (!report.getThreeWhilstFinished().booleanValue()) {
                result.add("\u201c\u4e09\u540c\u65f6\u201d\u4fe1\u606f\u672a\u5b8c\u5584");
            }
            if (!report.getPreEvaluateFinished().booleanValue()) {
                result.add("\u201c\u53ef\u7814\u9636\u6bb5\u4fe1\u606f\u201d\u9636\u6bb5\u4fe1\u606f\u672a\u5b8c\u5584");
            }
            if (!report.getDesignFinished().booleanValue()) {
                result.add("\u201c\u8bbe\u8ba1\u9636\u6bb5\u4fe1\u606f\u201d\u9636\u6bb5\u4fe1\u606f\u672a\u5b8c\u5584");
            }
            if (!report.getContrEvaluateFinished().booleanValue()) {
                result.add("\u201c\u8bd5\u8fd0\u884c\u9636\u6bb5\u4fe1\u606f\u201d\u9636\u6bb5\u4fe1\u606f\u672a\u5b8c\u5584");
            }
        }
        return result;
    }

    public NewCompanyGuideSummaryVo summaryInfo(Long cid) {
        NewCompanyGuideThreeWhilstInfo threeWhilstInfo = this.threeWhilstInfoService.getThreeWhilstInfoByCid(cid);
        List newGuideProjectList = this.tsProjectSimpleService.getNewGuideProjectList(Collections.singletonList(cid), Boolean.valueOf(true));
        TsProjectSimple tsProjectSimple = new TsProjectSimple();
        if (!CollectionUtils.isEmpty((Collection)newGuideProjectList)) {
            tsProjectSimple = (TsProjectSimple)newGuideProjectList.get(0);
        }
        NewCompanyGuideSummaryVo summaryVo = new NewCompanyGuideSummaryVo();
        summaryVo.setCid(cid);
        summaryVo.setTsId(tsProjectSimple.getId());
        summaryVo.setProjectName(threeWhilstInfo.getProjectName());
        summaryVo.setIsCompleted(Boolean.valueOf(TsProjectSimpleStatusEnum.NO_NEED_AUDITED.getCode().equals(tsProjectSimple.getStatus())));
        RiskListSearch search = new RiskListSearch();
        search.setCid(cid);
        search.setSearchStatus(Byte.valueOf((byte)7));
        List riskListData = this.reformItemBasicService.getRiskListData(search, Integer.valueOf(ReformDataSourceEnum.XJQY.getValue().intValue()));
        summaryVo.setReformItemBasicList(riskListData);
        return summaryVo;
    }

    public NewCompanyGuideTodoListVo getTodoWork(Long areaId, Byte areaLevel) {
        NewCompanyGuideTodoListVo vo = new NewCompanyGuideTodoListVo();
        CountDownLatch latch = new CountDownLatch(2);
        this.poolTaskExecutor.execute(() -> {
            try {
                NewCompanyGuideTodoListVo todo = ((NewCompanyGuideProgressMapper)this.dao).countNoSendAndNoConfirmedCompanyNum(areaId, areaLevel);
                vo.setUnConfirmedCompanyNum(todo.getUnConfirmedCompanyNum());
                vo.setNoSendCompanyNum(todo.getNoSendCompanyNum());
            }
            finally {
                latch.countDown();
            }
        });
        this.poolTaskExecutor.execute(() -> {
            try {
                SearchParam searchVo = new SearchParam();
                searchVo.setAreaId(areaId);
                searchVo.setLevel(areaLevel);
                searchVo.setDataSource(ReformDataSourceEnum.XJQY.getValue());
                searchVo.setType(Byte.valueOf((byte)0));
                searchVo.setStatus(Byte.valueOf((byte)7));
                Map<Byte, Integer> map = this.reformItemBasicNewService.getRiskCountList(searchVo).stream().filter(Objects::nonNull).collect(Collectors.toMap(RiskResolveInfoVo::getType, RiskResolveInfoVo::getCountNum));
                vo.setTrainRiskNum(map.getOrDefault(ReformGenerationSourceEnum.TRAIN.getValue(), 0));
                vo.setProtectRiskNum(map.getOrDefault(ReformGenerationSourceEnum.PROTECTION.getValue(), 0));
                vo.setWarningSignsRiskNum(map.getOrDefault(ReformGenerationSourceEnum.WARNING_SIGNS.getValue(), 0));
                vo.setAreaId(areaId);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return vo;
    }

    public NewCompanyGuideProgress getByStep(Long cid, Long areaId, Byte step) {
        NewCompanyGuideProgress progress = new NewCompanyGuideProgress();
        Example example = new Example(NewCompanyGuideProgress.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        if (Objects.equals(StepEnum.Step5.getKey(), step)) {
            criteria.andIn("step", Arrays.asList(StepEnum.Step5.getKey(), StepEnum.Step5_1.getKey(), StepEnum.Step5_2.getKey()));
        } else {
            criteria.andEqualTo("step", (Object)step);
        }
        List progressList = ((NewCompanyGuideProgressMapper)this.dao).selectByExample(example);
        if (progressList != null && progressList.size() > 0) {
            if (progressList.size() == 1) {
                progress = (NewCompanyGuideProgress)progressList.get(0);
            } else {
                progress = (NewCompanyGuideProgress)progressList.stream().filter(e -> StepEnum.Step5.getKey().byteValue() == e.getStep().byteValue()).collect(Collectors.toList()).get(0);
                for (NewCompanyGuideProgress guideProgress : progressList) {
                    if (StepEnum.Step5_1.getKey().byteValue() == guideProgress.getStep().byteValue()) {
                        progress.setIsShowShengBao(guideProgress.getIsShowTips());
                    }
                    if (StepEnum.Step5_2.getKey().byteValue() != guideProgress.getStep().byteValue()) continue;
                    progress.setIsShowFenLei(guideProgress.getIsShowTips());
                }
            }
        }
        Example orgExample = new Example(NewCompanyGuideOrgShow.class);
        orgExample.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("isShow", (Object)1).andEqualTo("isValid", (Object)true);
        List distinctOrgIds = this.orgShowMapper.selectByExample(orgExample).stream().map(NewCompanyGuideOrgShow::getThirdOrgId).distinct().collect(Collectors.toList());
        progress.setOrgNum(Integer.valueOf(distinctOrgIds.size()));
        return progress;
    }

    @Transactional
    public void confirmTips(Long cid, Byte step, Long loginId) {
        Example example = new Example(NewCompanyGuideProgress.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("step", (Object)step).andEqualTo("isValid", (Object)true);
        NewCompanyGuideProgress guideProgress = new NewCompanyGuideProgress();
        guideProgress.setIsShowTips(Boolean.valueOf(false));
        guideProgress.setUpdateDate(new Date());
        guideProgress.setUpdateBy(loginId);
        ((NewCompanyGuideProgressMapper)this.dao).updateByExampleSelective(guideProgress, example);
    }

    public NewCompanyExceptionProgressGuideVo exceptionProgressCount(NewCompanyExceptionProgressGuideVo param) {
        return ((NewCompanyGuideProgressMapper)this.dao).exceptionProgressCount(param);
    }

    @Transactional
    public List<Long> convert2normalCompany(List<Long> cidList) {
        this.logger.info("\u8f6c\u6362\u4e3a\u6b63\u5e38\u4f01\u4e1a\u4efb\u52a1\u5f00\u59cb\u3002\u3002\u3002\u3002");
        long startTime = System.currentTimeMillis();
        ArrayList<Long> updateCidList = new ArrayList<Long>();
        ArrayList<WandaDeclare> updateDeclareList = new ArrayList<WandaDeclare>();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("newCompanyGuide", true);
        List companyList = this.companyProvideService.getCompanyBaseInfoList(cidList, map);
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            this.logger.info("\u6682\u65e0\u9700\u8981\u8f6c\u6362\u7684\u4f01\u4e1a\u3002\u3002\u3002\u3002");
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(cidList) && CollectionUtils.isEmpty(cidList = companyList.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getId())).map(CompanyBaseInfoModel::getId).distinct().collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        cidList = this.companyGuideInfoService.getStagebyCids(cidList, StepEnum.Step6.getKey());
        List tsList = this.tsProjectSimpleService.getNewGuideProjectList(cidList, Boolean.valueOf(true));
        List creditCodeList = companyList.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).collect(Collectors.toList());
        List wandaDeclareList = this.wandaDeclareService.getListByCreditCodeList(creditCodeList);
        Map<Long, List<TsProjectSimple>> tsMap = tsList.stream().collect(Collectors.groupingBy(TsProjectSimple::getCid));
        Map<String, List<WandaDeclare>> declareMap = wandaDeclareList.stream().collect(Collectors.groupingBy(WandaDeclare::getCreditCode));
        for (CompanyBaseInfoModel company : companyList) {
            List<WandaDeclare> declareList = declareMap.get(company.getUnifiedSocialCc());
            if (!CollectionUtil.isNotEmpty(declareList)) continue;
            List<WandaDeclare> lastDeclareList = declareList.stream().filter(d -> StringUtils.isNotEmpty((String)d.getEmpName()) && d.getEmpName().equals(company.getName())).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty((Collection)tsMap.get(company.getId())) || !CollectionUtil.isNotEmpty(lastDeclareList)) continue;
            updateCidList.add(company.getId());
            lastDeclareList.forEach(d -> d.setCid(company.getId()));
            updateDeclareList.addAll(lastDeclareList);
        }
        if (CollectionUtils.isEmpty(updateCidList)) {
            return Collections.emptyList();
        }
        ((NewCompanyGuideProgressMapper)this.dao).updateNewGuideCompany2normal(updateCidList);
        this.companyGuideInfoService.updateStep2completed(updateCidList);
        this.wandaDeclareService.updateCidBatch(updateDeclareList);
        Date date = new Date();
        ((NewCompanyGuideProgressMapper)this.dao).updateCompanyGradeReasonByCidList(updateCidList, CompanyGradeReasonEnum.DECLARATIONIMPORT.getValue(), date, null);
        this.logger.error("\u8f6c\u6362\u4e3a\u6b63\u5e38\u4f01\u4e1a\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002\u3002\u5171\u8f6c\u5316{}\u5bb6\u5355\u4f4d\uff0c\u8017\u65f6{}\u79d2", (Object)updateCidList.size(), (Object)((System.currentTimeMillis() - startTime) / 1000L));
        return updateCidList;
    }

    @Transactional
    public void testConvert2normalCompany(String cids) {
        if (StringUtils.isEmpty((CharSequence)cids)) {
            return;
        }
        List<Long> cidList = Arrays.stream(cids.split(",")).map(Long::valueOf).collect(Collectors.toList());
        this.companyGuideInfoService.updateStep2completed(cidList);
        ((NewCompanyGuideProgressMapper)this.dao).updateNewGuideCompany2normal(cidList);
    }

    public List<NewCompanyMergeTsVo> matchingTsProjectList(Long cid) {
        NewCompanyGuideThreeWhilstInfo threeWhilstInfo = this.threeWhilstInfoService.getThreeWhilstInfoByCid(cid);
        if (Objects.isNull(threeWhilstInfo) || StringUtils.isEmpty((CharSequence)threeWhilstInfo.getProjectCode())) {
            return Collections.emptyList();
        }
        SearchParam param = new SearchParam();
        param.setCid(cid);
        param.setStatusList(Arrays.asList(TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.BACK.getCode()));
        List list = this.tsProjectSimpleService.list(param);
        return list.stream().map(t -> {
            NewCompanyMergeTsVo vo = new NewCompanyMergeTsVo();
            vo.setTsProjectSimple(t);
            if (threeWhilstInfo.getProjectCode().equalsIgnoreCase(t.getProjectCode())) {
                vo.setMatched(Boolean.valueOf(true));
            }
            return vo;
        }).collect(Collectors.toList());
    }

    @Generated
    public NewCompanyGuideProgressImpl(INewCompanyGuideThreeWhilstInfoService threeWhilstInfoService, INewCompanyGuideOccupationalHazardInfoService hazardInfoService, INewCompanyGuideInfoService companyGuideInfoService, NewCompanyGuideOrgShowMapper orgShowMapper, INewCompanyGuideLackMaterialService newCompanyGuideLackMaterialService, NewCompanyGuideFinishedReportMapper finishedReportMapper) {
        this.threeWhilstInfoService = threeWhilstInfoService;
        this.hazardInfoService = hazardInfoService;
        this.companyGuideInfoService = companyGuideInfoService;
        this.orgShowMapper = orgShowMapper;
        this.newCompanyGuideLackMaterialService = newCompanyGuideLackMaterialService;
        this.finishedReportMapper = finishedReportMapper;
    }
}

