/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideOrgShowMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOrgShow;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideOrgShowDto;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideOrgShowModel;
import cn.smarthse.modules.health.newcompanyguide.model.SortRequest;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOrgShowService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideOrgShowCountVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideOrgShowVo;
import cn.smarthse.modules.health.newcompanyguide.vo.ThirdOrgShowVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewCompanyGuideOrgShowServiceImpl
extends BaseServiceImpl<NewCompanyGuideOrgShowMapper, NewCompanyGuideOrgShow>
implements INewCompanyGuideOrgShowService {
    public PageInfo<NewCompanyGuideOrgShowVo> listData(NewCompanyGuideOrgShowModel orgShowModel) {
        PageHelper.startPage((int)orgShowModel.getPage(), (int)orgShowModel.getRows());
        List<NewCompanyGuideOrgShowVo> list = ((NewCompanyGuideOrgShowMapper)this.dao).listData(orgShowModel);
        return new PageInfo(list);
    }

    public PageInfo<NewCompanyGuideOrgShowVo> listOrgDataByCid(NewCompanyGuideOrgShowModel orgShowModel) {
        PageHelper.startPage((int)orgShowModel.getPage(), (int)orgShowModel.getRows());
        List<NewCompanyGuideOrgShowVo> list = ((NewCompanyGuideOrgShowMapper)this.dao).listOrgDataByCid(orgShowModel);
        return new PageInfo(list);
    }

    @Transactional
    public ResponseData<String> batchEditDisplay(NewCompanyGuideOrgShowDto dto, Long userId) {
        Long areaId = dto.getAreaId();
        Byte orgType = dto.getOrgType();
        List thirdOrgIds = dto.getThirdOrgIds();
        Date now = new Date();
        if (Objects.equals(dto.getIsShow(), (byte)1)) {
            Integer base = ((NewCompanyGuideOrgShowMapper)this.dao).selectMaxSortNo(areaId, orgType);
            int seq = base == null ? 0 : base;
            for (Long thirdOrgId : thirdOrgIds) {
                NewCompanyGuideOrgShow existed = ((NewCompanyGuideOrgShowMapper)this.dao).selectOneByUnique(areaId, thirdOrgId, orgType);
                if (existed == null) {
                    NewCompanyGuideOrgShow ins = new NewCompanyGuideOrgShow();
                    ins.setId(Long.valueOf(this.idworker.nextId()));
                    ins.setAreaId(areaId);
                    ins.setThirdOrgId(thirdOrgId);
                    ins.setOrgType(orgType);
                    ins.setIsShow(Byte.valueOf((byte)1));
                    ins.setIsValid(Boolean.valueOf(true));
                    ins.setSortNo(Integer.valueOf(++seq));
                    ins.setCreateBy(userId);
                    ins.setUpdateDate(now);
                    ins.setCreateDate(now);
                    ins.setUpdatedBy(userId);
                    ((NewCompanyGuideOrgShowMapper)this.dao).insertSelective(ins);
                    continue;
                }
                NewCompanyGuideOrgShow up = new NewCompanyGuideOrgShow();
                up.setId(existed.getId());
                up.setIsShow(Byte.valueOf((byte)1));
                up.setIsValid(Boolean.valueOf(true));
                if (existed.getSortNo() == null || existed.getSortNo() == 0) {
                    up.setSortNo(Integer.valueOf(++seq));
                }
                up.setUpdatedBy(userId);
                up.setUpdateDate(now);
                ((NewCompanyGuideOrgShowMapper)this.dao).updateByPrimaryKeySelective(up);
            }
        } else {
            Example example = new Example(NewCompanyGuideOrgShow.class);
            example.createCriteria().andIn("thirdOrgId", (Iterable)thirdOrgIds).andEqualTo("areaId", (Object)areaId).andEqualTo("orgType", (Object)orgType).andEqualTo("isValid", (Object)true).andEqualTo("isShow", (Object)1);
            NewCompanyGuideOrgShow up = new NewCompanyGuideOrgShow();
            up.setIsShow(Byte.valueOf((byte)0));
            up.setIsValid(Boolean.valueOf(false));
            up.setUpdatedBy(userId);
            up.setUpdateDate(new Date());
            ((NewCompanyGuideOrgShowMapper)this.dao).updateByExampleSelective(up, example);
        }
        return ResponseData.success();
    }

    public NewCompanyGuideOrgShowCountVo showOrgCount(Long areaId) {
        NewCompanyGuideOrgShowCountVo vo = ((NewCompanyGuideOrgShowMapper)this.dao).showOrgCount(areaId);
        if (vo == null) {
            return new NewCompanyGuideOrgShowCountVo();
        }
        return vo;
    }

    public List<NewCompanyGuideOrgShowCountVo> listAreaData(NewCompanyGuideOrgShowModel orgShowModel) {
        List<NewCompanyGuideOrgShowCountVo> list = ((NewCompanyGuideOrgShowMapper)this.dao).listAreaData(orgShowModel);
        list.forEach(vo -> {
            if (Objects.equals((byte)2, vo.getAreaLevel())) {
                vo.setAreaName(vo.getAreaName() + "\u5e02\u672c\u7ea7");
                vo.setAreaLevel(Byte.valueOf((byte)3));
            }
        });
        return list;
    }

    @Transactional
    public void editPrincipal(NewCompanyGuideOrgShowModel model, Long loginUserId) {
        int rowsUpdated;
        Example example = new Example(NewCompanyGuideOrgShow.class);
        example.createCriteria().andEqualTo("areaId", (Object)model.getAreaId()).andEqualTo("thirdOrgId", (Object)model.getThirdOrgId()).andEqualTo("isShow", (Object)1).andEqualTo("isValid", (Object)true);
        NewCompanyGuideOrgShow updateRecord = new NewCompanyGuideOrgShow();
        updateRecord.setUpdatedBy(loginUserId);
        updateRecord.setUpdateDate(new Date());
        if (model.getPrincipal() != null && !model.getPrincipal().isEmpty()) {
            updateRecord.setPrincipal(model.getPrincipal());
        }
        if (model.getPrincipalPhone() != null && !model.getPrincipalPhone().isEmpty()) {
            updateRecord.setPrincipalPhone(model.getPrincipalPhone());
        }
        if ((rowsUpdated = ((NewCompanyGuideOrgShowMapper)this.dao).updateByExampleSelective(updateRecord, example)) == 0) {
            throw new ServiceException("\u672a\u627e\u5230\u5408\u9002\u7684\u6570\u636e");
        }
    }

    public List<ThirdOrgShowVo> getAllAndAreaId(Byte areaLevel, Byte orgType) {
        return ((NewCompanyGuideOrgShowMapper)this.dao).getAllAndAreaId(areaLevel, orgType);
    }

    public PageInfo<NewCompanyGuideOrgShowVo> addListData(NewCompanyGuideOrgShowModel orgShowModel) {
        PageHelper.startPage((int)orgShowModel.getPage(), (int)orgShowModel.getRows());
        List<NewCompanyGuideOrgShowVo> list = ((NewCompanyGuideOrgShowMapper)this.dao).addListData(orgShowModel);
        return new PageInfo(list);
    }

    @Transactional
    public void updateSort(List<SortRequest> sortList) {
        if (CollectionUtils.isEmpty(sortList)) {
            return;
        }
        List<Integer> sortNos = sortList.stream().map(SortRequest::getSortNo).sorted().toList();
        for (int i = 0; i < sortList.size(); ++i) {
            SortRequest req = sortList.get(i);
            Integer newSortNo = sortNos.get(i);
            NewCompanyGuideOrgShow record = new NewCompanyGuideOrgShow();
            record.setId(req.getId());
            record.setSortNo(newSortNo);
            record.setUpdateDate(new Date());
            ((NewCompanyGuideOrgShowMapper)this.dao).updateByPrimaryKeySelective(record);
        }
    }
}

