/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideOccupationalHazardInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOccupationalHazardInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOccupationalHazardInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideThreeWhilstInfoService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideOccupationalHazardInfoVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class NewCompanyGuideOccupationalHazardInfoServiceImpl
extends BaseServiceImpl<NewCompanyGuideOccupationalHazardInfoMapper, NewCompanyGuideOccupationalHazardInfo>
implements INewCompanyGuideOccupationalHazardInfoService {
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Lazy
    @Autowired
    private INewCompanyGuideFinishedReportService finishedReportService;
    @Lazy
    @Autowired
    private INewCompanyGuideThreeWhilstInfoService threeWhilstInfoService;

    public List<NewCompanyGuideOccupationalHazardInfoVo> getEvaluateList(Long cid, Byte step) {
        List<NewCompanyGuideOccupationalHazardInfoVo> evaluateList = ((NewCompanyGuideOccupationalHazardInfoMapper)this.dao).getEvaluateList(cid, step);
        if (CollectionUtils.isNotEmpty(evaluateList)) {
            for (NewCompanyGuideOccupationalHazardInfoVo hazardInfoVo : evaluateList) {
                if (hazardInfoVo.getEvaluateReportFileId() != null) {
                    SysFileModel file1 = this.sysFileProvideService.getFileById(hazardInfoVo.getEvaluateReportFileId());
                    hazardInfoVo.setEvaluateReportFile(file1);
                }
                if (hazardInfoVo.getReviewCommentFileId() == null) continue;
                SysFileModel file2 = this.sysFileProvideService.getFileById(hazardInfoVo.getReviewCommentFileId());
                hazardInfoVo.setReviewCommentFile(file2);
            }
        }
        return evaluateList;
    }

    public List<NewCompanyGuideOccupationalHazardInfo> listHazardInfo(List<Long> cids, List<Byte> step) {
        Example e = new Example(NewCompanyGuideOccupationalHazardInfo.class);
        Example.Criteria criteria = e.createCriteria().andIn("cid", cids).andEqualTo("isValid", (Object)true);
        if (CollectionUtils.isNotEmpty(step)) {
            if (step.size() == 1) {
                criteria.andEqualTo("step", (Object)step.get(0));
            } else {
                criteria.andIn("step", step);
            }
        }
        return ((NewCompanyGuideOccupationalHazardInfoMapper)this.dao).selectByExample(e);
    }

    public void saveOccEvaluate(List<NewCompanyGuideOccupationalHazardInfo> list, Long cid, Long loginId) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Example example = new Example(NewCompanyGuideOccupationalHazardInfo.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)true);
        NewCompanyGuideThreeWhilstInfo threeWhilstInfo = this.threeWhilstInfoService.getThreeWhilstInfoByCid(cid);
        for (NewCompanyGuideOccupationalHazardInfo info : list) {
            if (info.getCompleteTime() == null) continue;
            if (Objects.equals(info.getStep(), StepEnum.Step2.getKey())) {
                if (threeWhilstInfo.getProjectApprovalTime() != null && info.getCompleteTime().before(threeWhilstInfo.getProjectApprovalTime())) {
                    throw new RuntimeException("\u8bc4\u4ef7\u5b8c\u6210\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4\u3002");
                }
                if (threeWhilstInfo.getTestRunBeginTime() == null || !info.getCompleteTime().after(threeWhilstInfo.getTestRunBeginTime())) continue;
                throw new RuntimeException("\u8bc4\u4ef7\u5b8c\u6210\u65f6\u95f4\u4e0d\u5f97\u665a\u4e8e\u8bd5\u8fd0\u884c\u5f00\u59cb\u65f6\u95f4\u3002");
            }
            if (Objects.equals(info.getStep(), StepEnum.Step3.getKey())) {
                if (threeWhilstInfo.getProjectApprovalTime() != null && info.getCompleteTime().before(threeWhilstInfo.getProjectApprovalTime())) {
                    throw new RuntimeException("\u8bbe\u8ba1\u5b8c\u6210\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u7acb\u9879\u65f6\u95f4\u3002");
                }
                if (threeWhilstInfo.getTestRunBeginTime() == null || !info.getCompleteTime().after(threeWhilstInfo.getTestRunBeginTime())) continue;
                throw new RuntimeException("\u8bbe\u8ba1\u5b8c\u6210\u65f6\u95f4\u4e0d\u5f97\u665a\u4e8e\u8bd5\u8fd0\u884c\u5f00\u59cb\u65f6\u95f4\u3002");
            }
            if (!Objects.equals(info.getStep(), StepEnum.Step4.getKey()) || threeWhilstInfo.getCompleteTime() == null || !info.getCompleteTime().after(threeWhilstInfo.getCompleteTime())) continue;
            throw new RuntimeException("\u8bc4\u4ef7\u5b8c\u6210\u65f6\u95f4\u4e0d\u5f97\u665a\u4e8e\u7ae3\u5de5\u65f6\u95f4\u65f6\u95f4\u3002");
        }
        Date date = new Date();
        this.batchUpdateOrInsert(list, NewCompanyGuideOccupationalHazardInfoMapper.class, (e, mapper) -> {
            e.setCid(cid);
            if (e.getId() == null) {
                e.setId(Long.valueOf(this.idworker.nextId()));
                e.setCreateDate(date);
                e.setCreateBy(loginId);
                e.setUpdateDate(date);
                return mapper.insertSelective(e);
            }
            e.setUpdateDate(date);
            e.setUpdateBy(loginId);
            criteria.andEqualTo("id", (Object)e.getId());
            List dbInfo = mapper.selectByExample(example);
            if (dbInfo != null && dbInfo.size() > 0) {
                Long dbReviewCommentFileId;
                Long dbEvaluateReportFileId = ((NewCompanyGuideOccupationalHazardInfo)dbInfo.get(0)).getEvaluateReportFileId();
                if (dbEvaluateReportFileId != null && !dbEvaluateReportFileId.equals(e.getEvaluateReportFileId())) {
                    this.sysFileProvideService.delFile(dbEvaluateReportFileId.toString(), loginId);
                }
                if ((dbReviewCommentFileId = ((NewCompanyGuideOccupationalHazardInfo)dbInfo.get(0)).getReviewCommentFileId()) != null && !dbReviewCommentFileId.equals(e.getReviewCommentFileId())) {
                    this.sysFileProvideService.delFile(dbReviewCommentFileId.toString(), loginId);
                }
            }
            mapper.updateInfo((NewCompanyGuideOccupationalHazardInfo)e);
            return null;
        }, 1000);
        this.finishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.BASIC, new StepEnum[]{StepEnum.getEnumByKey((Byte)list.get(0).getStep())});
    }

    public List<NewCompanyGuideOccupationalHazardInfo> getListByCid(Long cid) {
        return this.listHazardInfo(Collections.singletonList(cid), null);
    }
}

