/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideLackMaterialHistoryMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideLackMaterialMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideLackMaterial;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideLackMaterialHistory;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.LackStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.LackTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideLackMaterialHistoryModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideLackMaterialModel;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideLackMaterialHistoryService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideLackMaterialService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideThreeWhilstInfoService;
import cn.smarthse.modules.health.newcompanyguide.vo.LackMaterialVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideLackMaterialHistoryVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideLackMaterialVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideThreeWhilstInfoVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewCompanyGuideLackMaterialServiceImpl
extends BaseServiceImpl<NewCompanyGuideLackMaterialMapper, NewCompanyGuideLackMaterial>
implements INewCompanyGuideLackMaterialService {
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    @Lazy
    private INewCompanyGuideFinishedReportService companyGuideFinishedReportService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService regionService;
    @Autowired
    private INewCompanyGuideThreeWhilstInfoService companyGuideThreeWhilstInfoService;
    @Autowired
    private INewCompanyGuideLackMaterialHistoryService newCompanyGuideLackMaterialHistoryService;
    @Autowired
    private NewCompanyGuideLackMaterialHistoryMapper lackMaterialHistoryMapper;

    public List<LackMaterialVo> listData(Long cid, List<Byte> statusList) {
        Example example = new Example(NewCompanyGuideLackMaterial.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid);
        if (CollectionUtils.isNotEmpty(statusList)) {
            criteria.andIn("status", statusList);
        }
        example.setOrderByClause("create_date desc");
        List list = this.getListByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(i -> {
            LackMaterialVo vo = new LackMaterialVo();
            BeanUtils.copyProperties((Object)i, (Object)vo);
            if (i.getEvidence() != null) {
                SysFileModel sysFileModel = this.sysFileProvideService.getFileById(i.getEvidence());
                vo.setEvidenceFile(sysFileModel);
            }
            return vo;
        }).collect(Collectors.toList());
    }

    public PageInfo<LackMaterialVo> listPage(JqGridParam jqGridParam, Long cid) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        Example example = new Example(NewCompanyGuideLackMaterial.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid);
        example.setOrderByClause("create_date desc");
        List list = this.getListByExample(example);
        PageInfo pageInfo = new PageInfo(list);
        PageInfo lackMaterialVoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)lackMaterialVoPageInfo);
        List result = list.stream().map(i -> {
            LackMaterialVo vo = new LackMaterialVo();
            BeanUtils.copyProperties((Object)i, (Object)vo);
            if (i.getEvidence() != null) {
                SysFileModel sysFileModel = this.sysFileProvideService.getFileById(i.getEvidence());
                vo.setEvidenceFile(sysFileModel);
            }
            return vo;
        }).collect(Collectors.toList());
        lackMaterialVoPageInfo.setList(result);
        return lackMaterialVoPageInfo;
    }

    public PageInfo<LackMaterialVo> getPageCompanyLackMaterial(JqGridParam jqGridParam, LackMaterialVo param) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        return new PageInfo(this.getListCompanyLackMaterial(param));
    }

    public List<LackMaterialVo> getListCompanyLackMaterial(LackMaterialVo param) {
        List<LackMaterialVo> list = ((NewCompanyGuideLackMaterialMapper)this.dao).getListCompanyLackMaterial(param);
        for (LackMaterialVo item : list) {
            if (item == null || item.getEvidence() == null || !param.getIsShowFile().booleanValue()) continue;
            SysFileModel sysFileModel = this.sysFileProvideService.getFileById(item.getEvidence());
            item.setEvidenceFile(sysFileModel);
        }
        return list;
    }

    @Transactional
    public void audit(NewCompanyGuideLackMaterialModel auditModel) {
        Long lackMaterialId = auditModel.getId();
        Byte status = auditModel.getStatus();
        String backReason = auditModel.getBackReason();
        Long updateBy = auditModel.getUpdateBy();
        LocalDateTime now = LocalDateTime.now();
        if (lackMaterialId == null) {
            throw new ServiceException("\u7f3a\u5931\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (status == null) {
            throw new ServiceException("\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        NewCompanyGuideLackMaterial searchParam = new NewCompanyGuideLackMaterial().setIsValid(Boolean.TRUE).setId(lackMaterialId);
        NewCompanyGuideLackMaterial dbLack = (NewCompanyGuideLackMaterial)((NewCompanyGuideLackMaterialMapper)this.dao).selectOne(searchParam);
        if (dbLack == null) {
            throw new ServiceException("\u627e\u4e0d\u5230\u6570\u636e\uff01");
        }
        if (!Objects.equals(dbLack.getStatus(), LackStatusEnum.WAIT_AUDIT.getKey())) {
            throw new ServiceException("\u975e\u5f85\u5ba1\u6838\u6570\u636e\uff0c\u4e0d\u53ef\u64cd\u4f5c\uff01");
        }
        NewCompanyGuideLackMaterial modLack = new NewCompanyGuideLackMaterial().setId(lackMaterialId).setStatus(status).setBackReason(backReason).setAuditTime(now).setUpdateDate(now).setUpdateBy(updateBy);
        ((NewCompanyGuideLackMaterialMapper)this.dao).updateByPrimaryKeySelective(modLack);
        NewCompanyGuideLackMaterialHistory lackRecord = new NewCompanyGuideLackMaterialHistory().setId(Long.valueOf(this.idworker.nextId())).setLackMaterialId(lackMaterialId).setStatus(status).setReportReason(dbLack.getReportReason()).setBackReason(modLack.getBackReason()).setSubmitTime(now).setAuditTime(now).setEvidence(dbLack.getEvidence()).setIsValid(Boolean.TRUE).setCreateBy(updateBy).setCreateDate(now).setUpdatedBy(updateBy).setUpdateDate(now);
        this.lackMaterialHistoryMapper.insert(lackRecord);
        if (auditModel.getLackType() == null) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5!");
        }
        StepEnum step = null;
        if (auditModel.getLackType().equals(LackTypeEnum.YP.getKey())) {
            step = StepEnum.Step2;
        } else if (auditModel.getLackType().equals(LackTypeEnum.SJ.getKey())) {
            step = StepEnum.Step3;
        } else if (auditModel.getLackType().equals(LackTypeEnum.KP.getKey())) {
            step = StepEnum.Step4;
        } else {
            throw new HealthException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(dbLack.getCid()), NewCompanyGuideRefreshModelEnum.BASIC, new StepEnum[]{step});
    }

    public PageInfo<LackMaterialVo> getLackMaterialCompanyList(JqGridParam pageParam, LackMaterialVo searchParam) {
        this.preSetRegionInfo(searchParam);
        Page lackPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<LackMaterialVo> lackList = ((NewCompanyGuideLackMaterialMapper)this.dao).getLackMaterialCompanyList(searchParam);
        return new PageInfo((List)lackPage);
    }

    public LackMaterialVo getLackMaterialHeadInfoByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        LackMaterialVo companyHead = ((NewCompanyGuideLackMaterialMapper)this.dao).getLackMaterialHeadInfoByCid(cid);
        if (companyHead == null) {
            return null;
        }
        this.postSetRegionFullName(companyHead);
        return companyHead;
    }

    public PageInfo<LackMaterialVo> getSimpleLackMaterialList(JqGridParam pageParam, NewCompanyGuideLackMaterialModel searchParam) {
        Long cid = searchParam.getCid();
        if (cid == null) {
            return null;
        }
        Page lackPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<LackMaterialVo> lackList = ((NewCompanyGuideLackMaterialMapper)this.dao).getSimpleLackMaterialList(searchParam);
        lackList.forEach(l -> Optional.ofNullable(l.getEvidence()).map(arg_0 -> ((ISysFileProvideService)this.sysFileProvideService).getFileById(arg_0)).ifPresent(arg_0 -> ((LackMaterialVo)l).setEvidenceFile(arg_0)));
        return new PageInfo((List)lackPage);
    }

    public PageInfo<LackMaterialVo> getLackMaterialList(JqGridParam pageParam, NewCompanyGuideLackMaterialModel searchParam) {
        Long cid = searchParam.getCid();
        if (cid == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Page lackPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<LackMaterialVo> lackList = ((NewCompanyGuideLackMaterialMapper)this.dao).getLackMaterialList(searchParam);
        return new PageInfo((List)lackPage);
    }

    public LackMaterialVo getLackMaterialDetail(LackMaterialVo searchParam) {
        Long cid = searchParam.getCid();
        Long lackMaterialId = searchParam.getLackMaterialId();
        if (cid == null || lackMaterialId == null) {
            return null;
        }
        Example example = new Example(NewCompanyGuideLackMaterial.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("id", (Object)lackMaterialId).andEqualTo("isValid", (Object)Boolean.TRUE);
        NewCompanyGuideLackMaterial lack = (NewCompanyGuideLackMaterial)this.getOneByExample(example);
        if (lack == null) {
            return null;
        }
        LackMaterialVo lackVo = new LackMaterialVo();
        BeanUtils.copyProperties((Object)lack, (Object)lackVo);
        Optional.ofNullable(lackVo.getEvidence()).map(arg_0 -> ((ISysFileProvideService)this.sysFileProvideService).getFileById(arg_0)).ifPresent(arg_0 -> ((LackMaterialVo)lackVo).setEvidenceFile(arg_0));
        return lackVo;
    }

    public NewCompanyGuideThreeWhilstInfoVo getLackMaterialDetail(Long cid, Long projectId, Long lackMaterialId) {
        if (cid == null || projectId == null || lackMaterialId == null) {
            return null;
        }
        NewCompanyGuideThreeWhilstInfoVo detailInfo = ((NewCompanyGuideLackMaterialMapper)this.dao).getLackMaterialDetail(cid, projectId, lackMaterialId);
        if (detailInfo == null) {
            return null;
        }
        this.postSetEvidenceFile(detailInfo);
        return detailInfo;
    }

    @Transactional
    public void submitLackMaterial(NewCompanyGuideLackMaterialModel lackModel) {
        this.lackMaterialDataVerification(lackModel);
        Long lackMaterialId = lackModel.getId();
        LocalDateTime now = LocalDateTime.now();
        NewCompanyGuideLackMaterial lackEntity = new NewCompanyGuideLackMaterial();
        BeanUtils.copyProperties((Object)lackModel, (Object)lackEntity);
        if (lackMaterialId == null) {
            lackEntity.setId(Long.valueOf(this.idworker.nextId()));
            lackEntity.setSubmitTime(now);
            lackEntity.setStatus(LackStatusEnum.WAIT_AUDIT.getKey());
            lackEntity.setCreateDate(now);
            lackEntity.setUpdateDate(now);
            lackEntity.setIsValid(Boolean.TRUE);
            ((NewCompanyGuideLackMaterialMapper)this.dao).insert(lackEntity);
        } else {
            NewCompanyGuideLackMaterial dbMaterial = (NewCompanyGuideLackMaterial)((NewCompanyGuideLackMaterialMapper)this.dao).selectByPrimaryKey(lackMaterialId);
            if (dbMaterial == null) {
                throw new ServiceException("\u6ca1\u627e\u5230\u7f3a\u5931\u6750\u6599\u62a5\u5907\u4fe1\u606f\uff1a" + lackMaterialId);
            }
            dbMaterial.setLackType(lackModel.getLackType());
            dbMaterial.setReportReason(lackModel.getReportReason());
            dbMaterial.setSubmitTime(now);
            dbMaterial.setStatus(LackStatusEnum.WAIT_AUDIT.getKey());
            dbMaterial.setEvidence(lackModel.getEvidence());
            dbMaterial.setUpdateDate(now);
            dbMaterial.setUpdateBy(lackModel.getUpdateBy());
            ((NewCompanyGuideLackMaterialMapper)this.dao).updateByPrimaryKey(dbMaterial);
        }
        NewCompanyGuideLackMaterialHistory lackRecord = new NewCompanyGuideLackMaterialHistory();
        lackRecord.setId(Long.valueOf(this.idworker.nextId()));
        lackRecord.setLackMaterialId(lackEntity.getId());
        lackRecord.setStatus(LackStatusEnum.WAIT_AUDIT.getKey());
        lackRecord.setReportReason(lackEntity.getReportReason());
        lackRecord.setBackReason(lackEntity.getBackReason());
        lackRecord.setSubmitTime(now);
        lackRecord.setAuditTime(now);
        lackRecord.setEvidence(lackEntity.getEvidence());
        lackRecord.setIsValid(Boolean.TRUE);
        lackRecord.setCreateBy(lackEntity.getCreateBy());
        lackRecord.setCreateDate(now);
        lackRecord.setUpdatedBy(lackEntity.getUpdateBy());
        lackRecord.setUpdateDate(now);
        this.lackMaterialHistoryMapper.insert(lackRecord);
    }

    public PageInfo<NewCompanyGuideLackMaterialHistoryVo> getLackMaterialAuditRecord(JqGridParam pageParam, NewCompanyGuideLackMaterialHistoryModel searchParam) {
        Long lackMaterialId = searchParam.getLackMaterialId();
        if (lackMaterialId == null) {
            return null;
        }
        Page recordPage = PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<NewCompanyGuideLackMaterialHistoryVo> recordList = ((NewCompanyGuideLackMaterialMapper)this.dao).getLackMaterialAuditRecord(searchParam);
        recordList.forEach(r -> Optional.ofNullable(r.getEvidence()).map(arg_0 -> ((ISysFileProvideService)this.sysFileProvideService).getFileById(arg_0)).ifPresent(arg_0 -> ((NewCompanyGuideLackMaterialHistoryVo)r).setEvidenceFile(arg_0)));
        return new PageInfo((List)recordPage);
    }

    public List<NewCompanyGuideLackMaterialVo> getLackMaterialListByLackModel(NewCompanyGuideLackMaterialModel lackModel) {
        if (lackModel == null || lackModel.getCid() == null || lackModel.getProjectId() == null) {
            throw new ServiceException("\u53c2\u6570cid\u3001projectId\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Example example = new Example(NewCompanyGuideLackMaterial.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("cid", (Object)lackModel.getCid()).andEqualTo("projectId", (Object)lackModel.getProjectId());
        List lackList = this.getListByExample(example);
        if (CollUtil.isEmpty(lackList)) {
            return Collections.emptyList();
        }
        List<NewCompanyGuideLackMaterialVo> lackVoList = lackList.stream().map(lack -> {
            NewCompanyGuideLackMaterialVo lackVo = new NewCompanyGuideLackMaterialVo();
            org.springframework.beans.BeanUtils.copyProperties((Object)lack, (Object)lackVo);
            return lackVo;
        }).collect(Collectors.toList());
        lackVoList.forEach(l -> {
            l.setLackTypeName(LackTypeEnum.getValue((Byte)l.getLackType()));
            l.setStatusName(LackStatusEnum.getValue((Byte)l.getStatus()));
        });
        return lackVoList;
    }

    public void preSetRegionInfo(LackMaterialVo searchParam) {
        if (searchParam == null || searchParam.getAreaId() == null) {
            throw new ServiceException("\u884c\u653f\u533a\u5212id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long regionId = searchParam.getAreaId();
        AreaModel region = this.regionService.getAreaById(regionId);
        if (region == null) {
            throw new ServiceException("\u5f53\u524d\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728\uff1a" + regionId);
        }
        searchParam.setAreaLevel(region.getLevel());
    }

    private void lackMaterialDataVerification(NewCompanyGuideLackMaterialModel lackModel) {
        Long id = lackModel.getId();
        Long cid = lackModel.getCid();
        Long projectId = lackModel.getProjectId();
        Byte lackType = lackModel.getLackType();
        if (projectId == null) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u9879\u76eeid\uff01");
        }
        if (lackType == null) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u7f3a\u5931\u8d44\u6599\u7c7b\u578b\uff01");
        }
        Example pExample = new Example(NewCompanyGuideThreeWhilstInfo.class);
        Example.Criteria pCriteria = pExample.createCriteria();
        pCriteria.andEqualTo("cid", (Object)cid).andEqualTo("id", (Object)projectId).andEqualTo("isValid", (Object)Boolean.TRUE);
        List projectList = this.companyGuideThreeWhilstInfoService.getListByExample(pExample);
        if (CollUtil.isEmpty((Collection)projectList)) {
            throw new ServiceException("\u5f53\u524d\u4f01\u4e1a\u4e0d\u5b58\u5728\u5efa\u8bbe\u9879\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u6599\u7f3a\u5931\u767b\u8bb0\uff01");
        }
        Example lExample = new Example(NewCompanyGuideLackMaterial.class);
        lExample.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("projectId", (Object)projectId).andEqualTo("lackType", (Object)lackType).andEqualTo("isValid", (Object)Boolean.TRUE);
        List lackList = this.getListByExample(lExample);
        if (id != null && CollUtil.isEmpty(lackList)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        for (NewCompanyGuideLackMaterial lack : lackList) {
            boolean isAudit;
            Byte dbLackType = lack.getLackType();
            Byte dbStatus = lack.getStatus();
            boolean isPass = Objects.equals(dbLackType, lackType) && Objects.equals(dbStatus, LackStatusEnum.PASS.getKey());
            boolean bl = isAudit = Objects.equals(dbLackType, lackType) && Objects.equals(dbStatus, LackStatusEnum.WAIT_AUDIT.getKey());
            if (isPass) {
                throw new ServiceException("\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0a\u62a5\uff01");
            }
            if (!isAudit) continue;
            throw new ServiceException("\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u4e0a\u62a5\uff01");
        }
    }

    public void postSetRegionFullName(LackMaterialVo companyHead) {
        AreaModel region = this.regionService.getAreaById(companyHead.getAreaId());
        Byte regionLevel = region.getLevel();
        String regionFullName = switch (regionLevel) {
            case 0 -> "\u56fd\u5bb6";
            case 1 -> region.getProvinceName();
            case 2 -> region.getProvinceName() + region.getCityName();
            case 3 -> region.getProvinceName() + region.getCityName() + region.getAreaName();
            case 4 -> region.getProvinceName() + region.getCityName() + region.getAreaName() + region.getStreetName();
            default -> "";
        };
        companyHead.setRegionFullName(regionFullName);
    }

    private void postSetEvidenceFile(NewCompanyGuideThreeWhilstInfoVo detailInfo) {
        List lackList = detailInfo.getLackMaterialList();
        if (CollUtil.isEmpty((Collection)lackList)) {
            return;
        }
        List<Long> evidenceList = lackList.stream().filter(l -> !CollUtil.isEmpty((Collection)l.getLackMaterialAuditRecordList())).flatMap(l -> l.getLackMaterialAuditRecordList().stream()).map(NewCompanyGuideLackMaterialHistoryVo::getEvidence).distinct().toList();
        if (CollUtil.isEmpty(evidenceList)) {
            return;
        }
        List evidenceFileList = this.sysFileProvideService.getListByIds(evidenceList);
        Map evidenceFileMap = evidenceFileList.stream().collect(Collectors.toMap(SysFileModel::getId, Function.identity(), (v1, v2) -> v2));
        lackList.forEach(l -> l.getLackMaterialAuditRecordList().forEach(r -> r.setEvidenceFile((SysFileModel)evidenceFileMap.get(r.getEvidence()))));
    }

    @Generated
    public NewCompanyGuideLackMaterialServiceImpl() {
    }
}

