/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyGradeReasonEnum;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseResultModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ICompanyStorageProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.bx.entity.BxLastMonthZybSummary;
import cn.smarthse.modules.health.bx.service.IBxLastMonthZybSummaryService;
import cn.smarthse.modules.health.compliance.entity.AreaToOld;
import cn.smarthse.modules.health.compliance.service.IAreaToOldService;
import cn.smarthse.modules.health.dataservice.service.ICompanyBaseDcInfoService;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideChangeRecordMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideThreeWhilstInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideChangeRecord;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideLackMaterial;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOccupationalHazardInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.ChangeStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.ChangeTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.ExceptionProgressEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.LackMaterialSituationEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.LackStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.LackTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.model.CompanyUnDeclareModel;
import cn.smarthse.modules.health.newcompanyguide.model.CompanyUnDeclareStatModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideChangeRecordModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideInfoModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideLackMaterialModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideProcessModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyInfoEditModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyInfoModifyModel;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideChangeRecordService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideLackMaterialService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOccupationalHazardInfoService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideChangeRecordVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideInfoVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideLackMaterialVo;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetail;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeDetailStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoDetailService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.services.wanda.api.entity.irs.IrsMarketEntities;
import cn.smarthse.services.wanda.api.service.irs.IIrsMarketEntitiesService;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewCompanyGuideInfoServiceImpl
extends BaseServiceImpl<NewCompanyGuideInfoMapper, NewCompanyGuideInfo>
implements INewCompanyGuideInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideInfoServiceImpl.class);
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService regionService;
    private final INewCompanyGuideChangeRecordService changeRecordService;
    private final NewCompanyGuideChangeRecordMapper changeRecordMapper;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService paramProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyStorageProvideService companyStorageProvideService;
    @DubboReference
    private IIrsMarketEntitiesService irsMarketEntitiesService;
    private final IAreaToOldService areaToOldService;
    @DubboReference
    private CompanyReportInfoService companyReportInfoService;
    private final ICompanyChangeInfoDetailService changeInfoDetailService;
    @DubboReference
    private ICompanyBaseDcInfoService companyBaseDcInfoService;
    private final ISysUserThirdService sysUserThirdService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference
    private IBxLastMonthZybSummaryService zybSummaryService;
    @Autowired
    private INewCompanyGuideFinishedReportService finishedReportService;
    @Autowired
    private NewCompanyGuideThreeWhilstInfoMapper newCompanyGuideThreeWhilstInfoMapper;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    @Lazy
    private INewCompanyGuideLackMaterialService lackMaterialService;
    @Autowired
    private INewCompanyGuideOccupationalHazardInfoService hazardInfoService;
    @DubboReference
    private ILiteArchiveUpdateService archiveUpdateService;
    private static final String IRS_COMPANY_INFO_CACHE = "IrsCompanyInfoCache";
    private static final String IRS_COMPANY_INFO_CACHE2 = "IrsCompanyInfoCache2";
    private static final Integer IRS_CACHE_TIME = 86400;

    public List<NewCompanyGuideInfo> listAllNewCompanyGuideInfo() {
        Example e = new Example(NewCompanyGuideInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true);
        List newCompanyGuideInfos = ((NewCompanyGuideInfoMapper)this.dao).selectByExample(e);
        return newCompanyGuideInfos;
    }

    @Transactional(readOnly=false)
    public ImportCompanySuperviseResultModel batchAddCompanyGuideInfo(List<CompanySuperviseModel> companyList) {
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }
        companyList.forEach(f -> {
            f.setDataSource(CompanyDataSourceEnum.NEW_COMPANY_GUIDE.getValue());
            f.setIsDec(Boolean.valueOf(false));
        });
        try {
            ImportCompanySuperviseResultModel importCompanyList = this.companyService.batchAddCompany(companyList, Boolean.valueOf(false));
            List validList = importCompanyList.getSuccList();
            if (CollUtil.isNotEmpty((Collection)validList)) {
                ArrayList<NewCompanyGuideInfo> ngiList = new ArrayList<NewCompanyGuideInfo>();
                for (ImportCompanySuperviseModel companySuperviseModel : validList) {
                    NewCompanyGuideInfo ngi = new NewCompanyGuideInfo();
                    ngi.setId(Long.valueOf(this.idworker.nextId()));
                    ngi.setCreateBy(Long.valueOf(7788L));
                    ngi.setCreateDate(new Date());
                    ngi.setCid(companySuperviseModel.getId());
                    ngiList.add(ngi);
                }
                this.batchUpdateOrInsert(ngiList, NewCompanyGuideInfoMapper.class, (item, mapper) -> mapper.insertSelective(item));
            }
            return importCompanyList;
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u65b0\u589e\u65b0\u5efa\u4f01\u4e1a\u5f15\u5bfc\u51fa\u9519\uff1a", (Throwable)e);
            return null;
        }
    }

    public PageInfo<NewCompanyGuideInfoVo> getNewCompanyInfoPage(JqGridParam pageParam, NewCompanyGuideInfoModel newCompanyModel) {
        this.preSetRegionInfo(newCompanyModel);
        NewCompanyGuideInfoServiceImpl.preSetIndustryCategoryList(newCompanyModel);
        this.preSetNextRemindTimeCondition(newCompanyModel);
        this.preSetNewCompanyIdList(newCompanyModel);
        Page newCompanyInfoPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<NewCompanyGuideInfoVo> newCompanyInfoList = ((NewCompanyGuideInfoMapper)this.dao).getNewCompanyInfoPage(newCompanyModel);
        this.postSetRegionFullName(newCompanyInfoList);
        NewCompanyGuideInfoServiceImpl.postSetSmsSendStatusName(newCompanyInfoList);
        this.postSetNewCompanyInfo(newCompanyInfoList);
        this.postSetExceptionProgress(newCompanyInfoList);
        this.postSetLackMaterialSituationByMySQL(newCompanyInfoList);
        this.postSetStepName(newCompanyInfoList);
        return new PageInfo((List)newCompanyInfoPage);
    }

    public NewCompanyGuideProcessModel detailCollectGuideInfo(NewCompanyGuideInfoModel newCompanyModel) {
        this.preSetRegionInfo(newCompanyModel);
        NewCompanyGuideInfoServiceImpl.preSetIndustryCategoryList(newCompanyModel);
        this.preSetNextRemindTimeCondition(newCompanyModel);
        this.preSetNewCompanyIdList(newCompanyModel);
        NewCompanyGuideProcessModel detailCollectGuideInfo = ((NewCompanyGuideInfoMapper)this.dao).getDetailCollectGuideInfo(newCompanyModel);
        if (ObjectUtil.isNotNull((Object)detailCollectGuideInfo)) {
            return detailCollectGuideInfo;
        }
        return new NewCompanyGuideProcessModel();
    }

    public List<NewCompanyGuideLackMaterialVo> getLackMaterialListByLackModel(NewCompanyGuideLackMaterialModel lackModel) {
        if (lackModel == null || lackModel.getCid() == null) {
            throw new ServiceException("\u53c2\u6570cid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long cid = lackModel.getCid();
        List<NewCompanyGuideOccupationalHazardInfo> hazardList = this.getHazardInfoList(cid);
        List<NewCompanyGuideLackMaterial> lackMaterialList = this.getLackMaterialList(cid);
        Map<Byte, List<NewCompanyGuideOccupationalHazardInfo>> hazardStepMap = hazardList.stream().collect(Collectors.groupingBy(NewCompanyGuideOccupationalHazardInfo::getStep));
        Map<Byte, List<NewCompanyGuideLackMaterial>> lackTypeMap = lackMaterialList.stream().collect(Collectors.groupingBy(NewCompanyGuideLackMaterial::getLackType));
        NewCompanyGuideOccupationalHazardInfo ypHazard = this.getHazardByStep(hazardStepMap, StepEnum.Step2);
        NewCompanyGuideOccupationalHazardInfo sjHazard = this.getHazardByStep(hazardStepMap, StepEnum.Step3);
        NewCompanyGuideOccupationalHazardInfo kpHazard = this.getHazardByStep(hazardStepMap, StepEnum.Step4);
        ArrayList<NewCompanyGuideLackMaterial> resultList = new ArrayList<NewCompanyGuideLackMaterial>();
        this.processMaterialType(cid, ypHazard, lackTypeMap, resultList, LackTypeEnum.YP);
        this.processMaterialType(cid, sjHazard, lackTypeMap, resultList, LackTypeEnum.SJ);
        this.processMaterialType(cid, kpHazard, lackTypeMap, resultList, LackTypeEnum.KP);
        List<NewCompanyGuideLackMaterialVo> voList = this.convertToVoList(resultList);
        return voList;
    }

    private List<NewCompanyGuideOccupationalHazardInfo> getHazardInfoList(Long cid) {
        Example example = new Example(NewCompanyGuideOccupationalHazardInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("required", (Object)Boolean.TRUE).andEqualTo("cid", (Object)cid).andIsNotNull("orgName").andIsNotNull("completeTime").andIsNotNull("evaluateReportFileId");
        return this.hazardInfoService.getListByExample(example);
    }

    private List<NewCompanyGuideLackMaterial> getLackMaterialList(Long cid) {
        Example example = new Example(NewCompanyGuideLackMaterial.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("cid", (Object)cid);
        return this.lackMaterialService.getListByExample(example);
    }

    private NewCompanyGuideOccupationalHazardInfo getHazardByStep(Map<Byte, List<NewCompanyGuideOccupationalHazardInfo>> hazardStepMap, StepEnum step) {
        List<NewCompanyGuideOccupationalHazardInfo> stepList = hazardStepMap.get(step.getKey());
        return CollUtil.isEmpty(stepList) ? null : (NewCompanyGuideOccupationalHazardInfo)stepList.stream().findAny().orElse(null);
    }

    private NewCompanyGuideLackMaterial getMaterialByStatus(List<NewCompanyGuideLackMaterial> materials, LackStatusEnum status) {
        if (CollUtil.isEmpty(materials)) {
            return null;
        }
        return materials.stream().filter(material -> Objects.equals(material.getStatus(), status.getKey())).findAny().orElse(null);
    }

    private void processMaterialType(Long cid, NewCompanyGuideOccupationalHazardInfo hazard, Map<Byte, List<NewCompanyGuideLackMaterial>> lackTypeMap, List<NewCompanyGuideLackMaterial> resultList, LackTypeEnum lackType) {
        List<NewCompanyGuideLackMaterial> typeMaterials = lackTypeMap.get(lackType.getKey());
        NewCompanyGuideLackMaterial waitMaterial = this.getMaterialByStatus(typeMaterials, LackStatusEnum.WAIT_AUDIT);
        NewCompanyGuideLackMaterial backMaterial = this.getMaterialByStatus(typeMaterials, LackStatusEnum.BACK);
        NewCompanyGuideLackMaterial passMaterial = this.getMaterialByStatus(typeMaterials, LackStatusEnum.PASS);
        this.processMaterialLogic(cid, hazard, waitMaterial, backMaterial, passMaterial, lackType, resultList);
    }

    private void processMaterialLogic(Long cid, NewCompanyGuideOccupationalHazardInfo hazard, NewCompanyGuideLackMaterial waitMaterial, NewCompanyGuideLackMaterial backMaterial, NewCompanyGuideLackMaterial passMaterial, LackTypeEnum lackType, List<NewCompanyGuideLackMaterial> resultList) {
        boolean complete;
        boolean review;
        boolean improvement;
        boolean hasMaterials = passMaterial != null || waitMaterial != null || backMaterial != null;
        boolean bl = improvement = hazard == null && (!hasMaterials || backMaterial != null);
        if (improvement) {
            NewCompanyGuideLackMaterial material = backMaterial != null ? backMaterial : new NewCompanyGuideLackMaterial().setCid(cid).setLackType(lackType.getKey()).setStatus(LackStatusEnum.TO_BE_IMPROVED.getKey());
            resultList.add(material);
        }
        boolean bl2 = review = hazard == null && waitMaterial != null;
        if (review) {
            resultList.add(waitMaterial);
        }
        boolean bl3 = complete = hazard != null || passMaterial != null;
        if (complete) {
            NewCompanyGuideLackMaterial material = passMaterial != null ? passMaterial : new NewCompanyGuideLackMaterial().setCid(cid).setLackType(lackType.getKey()).setStatus(LackStatusEnum.PASS.getKey());
            resultList.add(material);
        }
    }

    private List<NewCompanyGuideLackMaterialVo> convertToVoList(List<NewCompanyGuideLackMaterial> list) {
        ArrayList<NewCompanyGuideLackMaterialVo> voList = new ArrayList<NewCompanyGuideLackMaterialVo>();
        List<Byte> showStatusList = List.of(LackStatusEnum.WAIT_AUDIT.getKey(), LackStatusEnum.BACK.getKey(), LackStatusEnum.TO_BE_IMPROVED.getKey());
        for (NewCompanyGuideLackMaterial material : list) {
            String statusName;
            String lackTypeName;
            if (!showStatusList.contains(material.getStatus())) continue;
            NewCompanyGuideLackMaterialVo vo = new NewCompanyGuideLackMaterialVo();
            org.springframework.beans.BeanUtils.copyProperties((Object)material, (Object)vo);
            Byte lackType = vo.getLackType();
            LackTypeEnum lackTypeEnum = LackTypeEnum.getEnumByKey((Byte)lackType);
            if (lackTypeEnum == null) {
                lackTypeName = "";
            } else {
                lackTypeName = switch (lackTypeEnum) {
                    default -> throw new IncompatibleClassChangeError();
                    case LackTypeEnum.YP -> "\u9884\u8bc4\u62a5\u544a";
                    case LackTypeEnum.SJ -> "\u8bbe\u8ba1\u62a5\u544a";
                    case LackTypeEnum.KP -> "\u63a7\u5236\u6548\u679c\u8bc4\u4ef7\u62a5\u544a";
                };
            }
            vo.setLackTypeName(lackTypeName);
            Byte status = vo.getStatus();
            LackStatusEnum statusEnum = LackStatusEnum.getEnumByKey((Byte)status);
            if (statusEnum == null) {
                statusName = "";
            } else {
                statusName = switch (statusEnum) {
                    default -> throw new IncompatibleClassChangeError();
                    case LackStatusEnum.WAIT_AUDIT -> "\u5f85\u5ba1\u6838";
                    case LackStatusEnum.BACK -> "\u5f85\u5b8c\u5584";
                    case LackStatusEnum.PASS -> "\u901a\u8fc7";
                    case LackStatusEnum.TO_BE_IMPROVED -> "\u5f85\u5b8c\u5584";
                };
            }
            vo.setStatusName(statusName);
            voList.add(vo);
        }
        return voList;
    }

    public String[] getExportColumArray() {
        return new String[]{"\u4f01\u4e1a\u540d\u79f0|cname", "\u6570\u636e\u6765\u6e90|newCompanyDatasourceName", "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801|ucc", "\u6240\u5728\u884c\u653f\u533a\u5212|regionFullName", "\u8be6\u7ec6\u5730\u5740|detailAddress", "\u6ce8\u518c\u5730\u5740|registerAddress", "\u4f01\u4e1a\u89c4\u6a21|scale", "\u6240\u5c5e\u884c\u4e1a|industryCategoryName", "\u7ecf\u6d4e\u7c7b\u578b|registerTypeName", "\u662f\u5426\u975e\u533b\u7528\u653e\u5c04\u7528\u4eba\u5355\u4f4d|isExistRadioactivityName", "\u77ed\u4fe1\u53d1\u9001\u72b6\u6001|sendStatusName", "\u5f02\u5e38\u8fdb\u5ea6|exceptionProgressStr"};
    }

    public PageInfo<NewCompanyGuideInfoVo> getNewCompanyChangePage(JqGridParam pageParam, NewCompanyGuideInfoModel newCompanyModel) {
        this.preSetRegionInfo(newCompanyModel);
        Page newCompanyChangePage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<NewCompanyGuideInfoVo> newCompanyChangeList = ((NewCompanyGuideInfoMapper)this.dao).getNewCompanyChangePage(newCompanyModel);
        NewCompanyGuideInfoServiceImpl.judgeJoinList(newCompanyModel, newCompanyChangeList);
        this.postSetNewCompanyInfo(newCompanyChangeList);
        return new PageInfo((List)newCompanyChangePage);
    }

    public Integer getToChangeCompanyCount(NewCompanyGuideInfoModel newCompanyModel, Long loginUserId) {
        if (loginUserId == null) {
            throw new ServiceException("\u76d1\u7ba1\u7528\u6237id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        return this.changeRecordMapper.getToChangeCompanyCount(newCompanyModel, loginUserId);
    }

    @Transactional
    public void doChange(NewCompanyGuideChangeRecordModel changeModel) {
        Byte type = changeModel.getType();
        if (type == null) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1a\u7c7b\u578btype\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        String newCompanyIds = changeModel.getNewCompanyIds();
        List<Object> idList = new ArrayList();
        if (CharSequenceUtil.isNotBlank((CharSequence)newCompanyIds)) {
            idList = Arrays.stream(newCompanyIds.split(",")).map(String::trim).map(Long::parseLong).collect(Collectors.toList());
        }
        ArrayList finalIdList = idList;
        Long loginUserId = changeModel.getUpdatedBy();
        List currChangeList = this.changeRecordService.currSupUserChangeListNew(loginUserId);
        if (Objects.equals(ChangeTypeEnum.RENEW.getKey(), type)) {
            List<NewCompanyGuideChangeRecordVo> preRecordList = ((NewCompanyGuideInfoMapper)this.dao).preTypeInfo(currChangeList);
            Map<Long, NewCompanyGuideChangeRecordVo> recordMap = preRecordList.stream().collect(Collectors.toMap(NewCompanyGuideChangeRecordVo::getNewCompanyId, item -> item, (v1, v2) -> v1));
            currChangeList.forEach(e -> {
                NewCompanyGuideChangeRecordVo record = (NewCompanyGuideChangeRecordVo)recordMap.get(e.getNewCompanyId());
                if (Objects.nonNull(record)) {
                    e.setLastStatus(record.getLastStatus());
                    e.setLastAccountStatus(record.getLastAccountStatus());
                }
            });
        }
        if (CollUtil.isEmpty((Collection)currChangeList)) {
            throw new ServiceException("\u5f53\u524d\u9875\u9762\u4f01\u4e1a\u5df2\u5b8c\u6210\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\uff01");
        }
        currChangeList.forEach(r -> {
            r.setType(type);
            r.setChangeReason(changeModel.getChangeReason());
            r.setMaterials(changeModel.getMaterials());
        });
        this.makeChanges(currChangeList, loginUserId, Boolean.TRUE);
    }

    @Transactional
    public void doSingleChange(NewCompanyGuideChangeRecordModel changeModel) {
        Long newCompanyId = changeModel.getNewCompanyId();
        Byte type = changeModel.getType();
        Long loginUserId = changeModel.getUpdatedBy();
        if (newCompanyId == null) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (type == null) {
            throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        NewCompanyGuideInfo info = (NewCompanyGuideInfo)((NewCompanyGuideInfoMapper)this.dao).selectByPrimaryKey(newCompanyId);
        if (info == null) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1a\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        Byte preType = info.getType();
        Long cid = info.getCid();
        if (Objects.equals(type, preType)) {
            throw new ServiceException("\u5f53\u524d\u65b0\u5efa\u4f01\u4e1a\u5df2\u5904\u4e8e\u6b64\u7c7b\u578b\uff0c\u65e0\u9700\u53d8\u66f4\uff01");
        }
        List companyList = this.companyService.getOnlyCompanyByCid((List)ListUtil.toList((Object[])new Long[]{cid}));
        String cname = null;
        if (CollUtil.isNotEmpty((Collection)companyList)) {
            CompanySuperviseModel company = (CompanySuperviseModel)companyList.get(0);
            cname = company.getName();
        }
        List currChangeList = Convert.toList(NewCompanyGuideChangeRecordVo.class, (Object)new NewCompanyGuideChangeRecordVo().setNewCompanyId(newCompanyId).setPreType(preType).setType(type).setCid(cid).setCname(cname).setUpdatedBy(loginUserId).setChangeReason(changeModel.getChangeReason()).setNextRemindTime(changeModel.getNextRemindTime()).setMaterials(changeModel.getMaterials()));
        if (Objects.equals(ChangeTypeEnum.RENEW.getKey(), type)) {
            List<NewCompanyGuideChangeRecordVo> preRecordList = ((NewCompanyGuideInfoMapper)this.dao).preTypeInfo(currChangeList);
            Map<Long, NewCompanyGuideChangeRecordVo> recordMap = preRecordList.stream().collect(Collectors.toMap(NewCompanyGuideChangeRecordVo::getNewCompanyId, item -> item, (v1, v2) -> v1));
            currChangeList.forEach(e -> {
                NewCompanyGuideChangeRecordVo record = (NewCompanyGuideChangeRecordVo)recordMap.get(e.getNewCompanyId());
                if (Objects.nonNull(record)) {
                    e.setLastStatus(record.getLastStatus());
                    e.setLastAccountStatus(record.getLastAccountStatus());
                }
            });
        }
        this.makeChanges(currChangeList, loginUserId, Boolean.FALSE);
    }

    @Transactional
    public void doModify(NewCompanyInfoModifyModel modifyModel) {
        Long newCompanyId = modifyModel.getNewCompanyId();
        Long loginUserId = modifyModel.getUpdatedBy();
        if (newCompanyId == null) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        NewCompanyGuideInfo info = (NewCompanyGuideInfo)((NewCompanyGuideInfoMapper)this.dao).selectByPrimaryKey(newCompanyId);
        if (info == null) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        Long cid = info.getCid();
        List comList = this.companyService.getOnlyCompanyByCid(Convert.toList(Long.class, (Object)cid));
        if (CollUtil.isEmpty((Collection)comList)) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        CompanySuperviseModel com = (CompanySuperviseModel)comList.get(0);
        ArrayList changeTypeList = ListUtil.toList((Object[])new Integer[]{CompanyChangeTypeEnum.crossMigration.getCode(), CompanyChangeTypeEnum.intraMigration.getCode(), CompanyChangeTypeEnum.districtMigration.getCode()});
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("cid", (Object)cid).andIn("changeType", (Iterable)changeTypeList).andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        List detailList = this.changeInfoDetailService.getListByExample(example);
        if (CollUtil.isNotEmpty((Collection)detailList)) {
            throw new ServiceException(String.format("\u65b0\u5efa\u4f01\u4e1a\u3010%s\u3011\u62df\u8fc1\u79fb\uff0c\u4e0d\u53ef\u7f16\u8f91\uff01", com.getName()));
        }
        com.setAreaId(modifyModel.getRegionId());
        com.setWorkAddress(modifyModel.getDetailAddress());
        com.setRegisterAddress(modifyModel.getRegisterAddress());
        com.setIndustryCategory(modifyModel.getIndustryCategory());
        com.setLegalName(modifyModel.getLegalName());
        com.setLegalTel(modifyModel.getLegalTel());
        this.companyService.updateCompanyAndCompanySuperviseByOne(com, loginUserId);
    }

    public List<NewCompanyGuideInfoVo> getSend1SmsInfoVos(List<Long> ids) {
        return ((NewCompanyGuideInfoMapper)this.dao).getSend1SmsInfoVos(ids);
    }

    public List<NewCompanyGuideInfoVo> getSend2SmsInfoVos(List<Long> cidList) {
        return ((NewCompanyGuideInfoMapper)this.dao).getSendSmsInfoVos(cidList);
    }

    public PageInfo<NewCompanyGuideInfoVo> getModifyRecordPage(JqGridParam pageParam, NewCompanyInfoModifyModel modifyModel) {
        return null;
    }

    public NewCompanyGuideInfo getByCid(Long cid) {
        if (cid == null) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Example example = new Example(NewCompanyGuideInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        return (NewCompanyGuideInfo)this.getOneByExample(example);
    }

    @Transactional
    public void updateStep2completed(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return;
        }
        ((NewCompanyGuideInfoMapper)this.dao).updateStep2completed(cidList);
    }

    @Transactional
    public void updateStep(Long cid, Byte step) {
        if (cid == null || step == null) {
            return;
        }
        Example example = new Example(NewCompanyGuideInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        NewCompanyGuideInfo info = new NewCompanyGuideInfo();
        info.setStep(step);
        ((NewCompanyGuideInfoMapper)this.dao).updateByExampleSelective(info, example);
    }

    public void makeChanges(List<NewCompanyGuideChangeRecordVo> changeList, Long loginUserId, boolean batch) {
        Date now = new Date();
        if (CollUtil.isNotEmpty(changeList)) {
            List cidList = changeList.stream().map(NewCompanyGuideChangeRecordVo::getCid).collect(Collectors.toList());
            ArrayList changeTypeList = ListUtil.toList((Object[])new Integer[]{CompanyChangeTypeEnum.crossMigration.getCode(), CompanyChangeTypeEnum.intraMigration.getCode(), CompanyChangeTypeEnum.districtMigration.getCode()});
            Example example = new Example(CompanyChangeInfoDetail.class);
            example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andIn("cid", cidList).andIn("changeType", (Iterable)changeTypeList).andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
            List detailList = this.changeInfoDetailService.getListByExample(example);
            if (CollUtil.isNotEmpty((Collection)detailList)) {
                List moveCidList = detailList.stream().map(CompanyChangeInfoDetail::getCid).collect(Collectors.toList());
                List moveCnameList = changeList.stream().filter(c -> moveCidList.contains(c.getCid())).map(NewCompanyGuideChangeRecordVo::getCname).collect(Collectors.toList());
                String msgInfo = moveCnameList.toString().replace("[", "\u3010").replace("]", "\u3011");
                throw new ServiceException(String.format("\u65b0\u5efa\u4f01\u4e1a%s\u62df\u8fc1\u79fb\uff0c\u4e0d\u53ef\u53d8\u66f4\uff01", msgInfo));
            }
            Byte type = changeList.get(0).getType();
            changeList.forEach(c -> {
                if (Objects.equals(ChangeTypeEnum.PAUSED.getKey(), type)) {
                    c.setPauseTime(now);
                }
                if (Objects.equals(ChangeTypeEnum.PAUSED.getKey(), c.getPreType())) {
                    c.setPauseTime(null);
                }
                if (Objects.equals(ChangeTypeEnum.RENEW.getKey(), c.getType())) {
                    if (!(Objects.equals(ChangeTypeEnum.PAUSED.getKey(), c.getPreType()) || Objects.equals(ChangeTypeEnum.NOT_NEW.getKey(), c.getPreType()) || Objects.equals(ChangeTypeEnum.TERMINATED.getKey(), c.getPreType()))) {
                        throw new ServiceException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u6267\u884c\u6062\u590d\u52a8\u4f5c");
                    }
                    c.setType(c.getLastStatus());
                }
                c.setUpdatedBy(loginUserId);
            });
            ((NewCompanyGuideInfoMapper)this.dao).doInfoChange(changeList);
            this.handleAccountByType(changeList, loginUserId);
            if (batch) {
                List recordList = changeList.stream().map(e -> {
                    NewCompanyGuideChangeRecord record = new NewCompanyGuideChangeRecord();
                    record.setId(e.getId());
                    record.setStatus(ChangeStatusEnum.IS_CONFIRM.getKey());
                    record.setType(e.getType());
                    record.setPreviousStatus(e.getPreType());
                    record.setPreviousAccountStatus(e.getPreAccountStatus());
                    record.setChangeReason(e.getChangeReason());
                    record.setMaterials(e.getMaterials());
                    record.setUpdatedBy(loginUserId);
                    return record;
                }).collect(Collectors.toList());
                this.changeRecordService.batchUpdateOrInsert(recordList, NewCompanyGuideChangeRecordMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
            } else {
                NewCompanyGuideChangeRecordVo recVo = changeList.get(0);
                NewCompanyGuideChangeRecord recBean = new NewCompanyGuideChangeRecord();
                recBean.setId(Long.valueOf(IdWorker.getId()));
                recBean.setNewCompanyId(recVo.getNewCompanyId());
                recBean.setChangeReason(recVo.getChangeReason());
                recBean.setMaterials(recVo.getMaterials());
                recBean.setPreviousStatus(recVo.getPreType());
                recBean.setPreviousAccountStatus(recVo.getPreAccountStatus());
                recBean.setStatus(ChangeStatusEnum.IS_CONFIRM.getKey());
                recBean.setType(recVo.getType());
                recBean.setCreateBy(recVo.getUpdatedBy());
                recBean.setCreateDate(now);
                recBean.setUpdatedBy(recVo.getUpdatedBy());
                recBean.setUpdateDate(now);
                this.changeRecordMapper.insert(recBean);
            }
        }
    }

    private void handleAccountByType(List<NewCompanyGuideChangeRecordVo> changeList, Long loginUserId) {
        Byte type = changeList.get(0).getType();
        try {
            List cids = changeList.stream().map(NewCompanyGuideChangeRecordVo::getCid).collect(Collectors.toList());
            List userList = this.sysUserThirdService.getUserInfoByCidList(cids);
            Set existingCids = userList.stream().map(SysUser::getCid).collect(Collectors.toSet());
            if (Objects.equals(ChangeTypeEnum.HAZARD.getKey(), type)) {
                ArrayList<Long> cidsToCreate = new ArrayList<Long>();
                ArrayList<Long> cidsToEnable = new ArrayList<Long>();
                for (Long cid : cids) {
                    if (existingCids.contains(cid)) {
                        cidsToEnable.add(cid);
                        continue;
                    }
                    cidsToCreate.add(cid);
                }
                if (!cidsToEnable.isEmpty()) {
                    this.processUserUpdates(cidsToEnable, 0, loginUserId);
                }
                if (!cidsToCreate.isEmpty()) {
                    this.sysUserThirdService.createSysUser(cidsToCreate, loginUserId);
                }
            } else if (Objects.equals(ChangeTypeEnum.RENEW.getKey(), type)) {
                ArrayList<Long> cidsToDisable = new ArrayList<Long>();
                ArrayList<Long> cidsToEnable = new ArrayList<Long>();
                changeList.forEach(c -> {
                    if (c.getPreAccountStatus() != null && Objects.equals((byte)1, c.getPreAccountStatus())) {
                        cidsToDisable.add(c.getCid());
                    } else if (c.getPreAccountStatus() != null && Objects.equals((byte)0, c.getPreAccountStatus())) {
                        cidsToEnable.add(c.getCid());
                    }
                });
                if (!cidsToEnable.isEmpty()) {
                    this.processUserUpdates(cidsToEnable, 0, loginUserId);
                }
                if (!cidsToDisable.isEmpty()) {
                    this.processUserUpdates(cidsToDisable, 1, loginUserId);
                }
            } else if (!Objects.equals(ChangeTypeEnum.PAUSED.getKey(), type)) {
                ArrayList<Long> cidsToDisable = new ArrayList<Long>();
                for (Long cid : cids) {
                    if (!existingCids.contains(cid)) continue;
                    cidsToDisable.add(cid);
                }
                if (!cidsToDisable.isEmpty()) {
                    this.processUserUpdates(cidsToDisable, 1, loginUserId);
                }
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u5efa\u4f01\u4e1a\u5904\u7406\u8d26\u53f7\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5904\u7406\u8d26\u53f7\u5931\u8d25");
        }
    }

    public void preSetRegionInfo(NewCompanyGuideInfoModel newCompanyModel) {
        if (newCompanyModel == null || newCompanyModel.getRegionId() == null) {
            throw new ServiceException("\u884c\u653f\u533a\u5212id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long regionId = newCompanyModel.getRegionId();
        AreaModel region = this.regionService.getAreaById(regionId);
        if (region == null) {
            throw new ServiceException("\u5f53\u524d\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728\uff1a" + regionId);
        }
        newCompanyModel.setRegionLevel(region.getLevel());
        Byte level = newCompanyModel.getRegionLevel();
        if (level == 0) {
            newCompanyModel.setBelongType(Integer.valueOf(3));
        } else if (level == 1) {
            newCompanyModel.setBelongType(CompanyBelongTypeEnum.SHENG.getValue());
        } else if (level == 2) {
            newCompanyModel.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
        } else {
            newCompanyModel.setBelongType(CompanyBelongTypeEnum.NO.getValue());
        }
    }

    public static void preSetIndustryCategoryList(NewCompanyGuideInfoModel newCompanyModel) {
        List industryCategoryList = newCompanyModel.getIndustryCategoryList();
        if (CollUtil.isNotEmpty((Collection)industryCategoryList)) {
            industryCategoryList = industryCategoryList.stream().filter(Objects::nonNull).collect(Collectors.toList());
            newCompanyModel.setIndustryCategoryList(industryCategoryList);
        }
    }

    private void preSetNextRemindTimeCondition(NewCompanyGuideInfoModel newCompanyModel) {
        Integer nextRemindDay = newCompanyModel.getNextRemindDay();
        if (nextRemindDay != null) {
            if (nextRemindDay < 0) {
                throw new ServiceException("\u8ddd\u79bb\u4e0b\u6b21\u63d0\u9192\u5929\u6570\u4e0d\u53ef\u5c0f\u4e8e0\uff01");
            }
            LocalDate nextRemindDate = LocalDate.now().plusDays(nextRemindDay.intValue());
            LocalDateTime nextRemindTime = nextRemindDate.atTime(LocalTime.of(23, 59, 59));
            newCompanyModel.setNextRemindTime(nextRemindTime);
        }
    }

    private void preSetNewCompanyIdList(NewCompanyGuideInfoModel newCompanyModel) {
        String ids = newCompanyModel.getIds();
        if (CharSequenceUtil.isNotBlank((CharSequence)ids)) {
            List<Long> idList = Arrays.stream(ids.split(",")).map(String::trim).filter(CharSequenceUtil::isNotBlank).map(Long::valueOf).distinct().toList();
            newCompanyModel.setIdList(idList);
        }
    }

    public void postSetRegionFullName(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (CollUtil.isNotEmpty(newCompanyInfoList)) {
            Map<Long, String> regionMap = this.regionService.getAreaListByIds(newCompanyInfoList.stream().map(NewCompanyGuideInfoVo::getRegionId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","))).stream().collect(Collectors.toMap(AreaModel::getId, region -> {
                switch (region.getLevel()) {
                    case 0: {
                        return "\u56fd\u5bb6";
                    }
                    case 1: {
                        return region.getProvinceName();
                    }
                    case 2: {
                        return region.getProvinceName() + "/" + region.getCityName();
                    }
                    case 3: {
                        return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName();
                    }
                    case 4: {
                        return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName() + "/" + region.getStreetName();
                    }
                }
                return "";
            }));
            newCompanyInfoList.forEach(n -> n.setRegionFullName((String)regionMap.get(n.getRegionId())));
        }
    }

    public static void postSetSmsSendStatusName(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (CollUtil.isNotEmpty(newCompanyInfoList)) {
            for (NewCompanyGuideInfoVo newCompany : newCompanyInfoList) {
                Byte sendStatus = newCompany.getSendStatus();
                if (sendStatus == null) continue;
                newCompany.setSendStatusName(switch (Convert.toInt((Object)sendStatus)) {
                    case 0 -> "\u672a\u53d1\u9001";
                    case 1 -> "\u5df2\u53d1\u9001";
                    case 2 -> "\u53d1\u9001\u5931\u8d25";
                    default -> "";
                });
            }
        }
    }

    public static void judgeJoinList(NewCompanyGuideInfoModel newCompanyModel, List<NewCompanyGuideInfoVo> newCompanyChangeList) {
        for (NewCompanyGuideInfoVo inf : newCompanyChangeList) {
            boolean isNowUserAdd;
            Byte toType = inf.getToType();
            boolean bl = isNowUserAdd = toType != null && Objects.equals(inf.getCreateBy(), newCompanyModel.getLoginUserId());
            if (isNowUserAdd) {
                inf.setIsChoose(Boolean.TRUE);
                continue;
            }
            inf.setIsChoose(Boolean.FALSE);
        }
    }

    public void postSetNewCompanyInfo(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (CollUtil.isNotEmpty(newCompanyInfoList)) {
            newCompanyInfoList.forEach(c -> c.setTypeName(ChangeTypeEnum.getValue((Byte)c.getType())));
            newCompanyInfoList.forEach(c -> c.setToTypeName(ChangeTypeEnum.getValue((Byte)c.getToType())));
            String variable = cn.smarthse.modules.health.enums.company.CompanySizeEnum.getName((Byte)1);
            newCompanyInfoList.forEach(c -> c.setScale(CompanySizeEnum.getName((Integer)Convert.toInt((Object)c.getScale()))));
            String registerTypes = newCompanyInfoList.stream().map(NewCompanyGuideInfoVo::getRegisterType).filter(Objects::nonNull).map(String::valueOf).filter(s -> !s.isEmpty()).distinct().collect(Collectors.joining(","));
            List registerTypeList = this.paramProvideService.getListByIds(registerTypes);
            Map<Long, SysParamModel> registerTypeMap = registerTypeList.stream().collect(Collectors.toMap(SysParamModel::getId, r -> r, (a, b) -> a));
            for (NewCompanyGuideInfoVo nc : newCompanyInfoList) {
                SysParamModel register = registerTypeMap.get(nc.getRegisterType());
                if (register != null) {
                    String registerTypeName = register.getParamValue();
                    nc.setRegisterTypeName(registerTypeName);
                }
                Integer datasource = nc.getNewCompanyDatasource();
                String datasourceName = "-";
                if (datasource != null) {
                    datasourceName = switch (datasource) {
                        case 1 -> "\u5e02\u573a\u76d1\u7ba1\u6570\u636e";
                        case 2 -> "\u81ea\u4e3b\u65b0\u589e";
                        default -> "-";
                    };
                }
                nc.setNewCompanyDatasourceName(datasourceName);
                Boolean isExistRadioactivity = nc.getIsExistRadioactivity();
                if (Boolean.TRUE.equals(isExistRadioactivity)) {
                    nc.setIsExistRadioactivityName("\u662f");
                }
                if (!Boolean.FALSE.equals(isExistRadioactivity)) continue;
                nc.setIsExistRadioactivityName("\u5426");
            }
        }
    }

    private void postSetExceptionProgress(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (newCompanyInfoList != null && !newCompanyInfoList.isEmpty()) {
            Date now = new Date();
            newCompanyInfoList.forEach(info -> {
                if (info.getSendStatus() == 1) {
                    if (info.getLastLoginTime() != null) {
                        info.setExceptionProgress(ExceptionProgressEnum.NO_EXCEPTION.getKey());
                        info.setExceptionProgressStr(ExceptionProgressEnum.NO_EXCEPTION.getValue());
                    } else {
                        long diffInMillis = now.getTime() - info.getSendDate().getTime();
                        long diffInDays = diffInMillis / 86400000L;
                        if (diffInDays > 30L) {
                            info.setExceptionProgress(ExceptionProgressEnum.IS_EXCEPTION_ONE_MONTH.getKey());
                            info.setExceptionProgressStr(ExceptionProgressEnum.IS_EXCEPTION_ONE_MONTH.getValue());
                        } else if (diffInDays > 7L) {
                            info.setExceptionProgress(ExceptionProgressEnum.IS_EXCEPTION_ONE_WEEK.getKey());
                            info.setExceptionProgressStr(ExceptionProgressEnum.IS_EXCEPTION_ONE_WEEK.getValue());
                        } else {
                            info.setExceptionProgress(ExceptionProgressEnum.NO_EXCEPTION.getKey());
                            info.setExceptionProgressStr(ExceptionProgressEnum.NO_EXCEPTION.getValue());
                        }
                    }
                } else {
                    info.setExceptionProgress(ExceptionProgressEnum.NO_EXCEPTION.getKey());
                    info.setExceptionProgressStr(ExceptionProgressEnum.NO_EXCEPTION.getValue());
                }
                if (Objects.equals(StepEnum.Step4.getKey(), info.getStep()) && info.getTestRunBeginTime() != null && (now.getTime() - info.getTestRunBeginTime().getTime()) / 86400000L > 180L) {
                    info.setExceptionProgress(ExceptionProgressEnum.TESTRUN_OVERTIME_180_DAYS.getKey());
                    info.setExceptionProgressStr(ExceptionProgressEnum.TESTRUN_OVERTIME_180_DAYS.getValue());
                }
            });
        }
    }

    private void postSetLackMaterialSituationByMemory(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (CollUtil.isEmpty(newCompanyInfoList)) {
            return;
        }
        List<Long> projectIdList = newCompanyInfoList.stream().map(NewCompanyGuideInfoVo::getProjectId).toList();
        if (CollUtil.isEmpty(projectIdList)) {
            return;
        }
        Example example = new Example(NewCompanyGuideLackMaterial.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andIn("projectId", projectIdList);
        List lackCollection = this.lackMaterialService.getListByExample(example);
        Map<Long, List<NewCompanyGuideLackMaterial>> pidLackMap = lackCollection.stream().collect(Collectors.groupingBy(NewCompanyGuideLackMaterial::getProjectId));
        for (NewCompanyGuideInfoVo info : newCompanyInfoList) {
            List<NewCompanyGuideLackMaterial> lackList;
            boolean isFinishProjectStep;
            Byte step = info.getStep();
            boolean bl = isFinishProjectStep = step != null && step.compareTo(StepEnum.Step5.getKey()) >= 0;
            LackMaterialSituationEnum situation = isFinishProjectStep ? (CollUtil.isEmpty(lackList = pidLackMap.get(info.getProjectId())) ? LackMaterialSituationEnum.YP : this.judgeLackMaterialSituation(lackList)) : LackMaterialSituationEnum.NULL;
            info.setLackMaterialSituation(situation.getKey());
            info.setLackMaterialSituationName(situation.getValue());
        }
    }

    private void postSetLackMaterialSituationByMySQL(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (CollUtil.isEmpty(newCompanyInfoList)) {
            return;
        }
        for (NewCompanyGuideInfoVo vo2 : newCompanyInfoList) {
            boolean as2;
            Byte step = vo2.getStep();
            ArrayList<String> list1 = CharSequenceUtil.isNotBlank((CharSequence)vo2.getGroupData1()) ? CharSequenceUtil.split((CharSequence)vo2.getGroupData1(), (CharSequence)",") : new ArrayList();
            ArrayList<String> list2 = CharSequenceUtil.isNotBlank((CharSequence)vo2.getGroupData2()) ? CharSequenceUtil.split((CharSequence)vo2.getGroupData2(), (CharSequence)",") : new ArrayList();
            boolean contains3 = this.containsAny(list1, list2, "3");
            boolean contains4 = this.containsAny(list1, list2, "4");
            boolean contains5 = this.containsAny(list1, list2, "5");
            boolean as1 = contains3 && contains4 && contains5;
            boolean bl = as2 = !contains3 || !contains4 || !contains5;
            if (step == null || step < StepEnum.Step5.getKey()) {
                vo2.setLackMaterialSituation(LackMaterialSituationEnum.NULL.getKey());
                continue;
            }
            if (as1) {
                vo2.setLackMaterialSituation(LackMaterialSituationEnum.OK.getKey());
                continue;
            }
            if (!as2) continue;
            vo2.setLackMaterialSituation(LackMaterialSituationEnum.NONE.getKey());
        }
        newCompanyInfoList.forEach(vo -> vo.setLackMaterialSituationName(LackMaterialSituationEnum.getValue((Byte)vo.getLackMaterialSituation())));
    }

    private boolean containsAny(List<String> list1, List<String> list2, String value) {
        return list1.contains(value) || list2.contains(value);
    }

    private void postSetStepName(List<NewCompanyGuideInfoVo> newCompanyInfoList) {
        if (CollUtil.isEmpty(newCompanyInfoList)) {
            return;
        }
        newCompanyInfoList.forEach(i -> i.setStepName(StepEnum.getValue((Byte)i.getStep())));
        for (NewCompanyGuideInfoVo vo : newCompanyInfoList) {
            String stepName;
            Byte step = vo.getStep();
            StepEnum stepEnum = StepEnum.getEnumByKey((Byte)step);
            if (stepEnum == null) {
                stepName = "";
            } else {
                stepName = switch (stepEnum) {
                    default -> throw new IncompatibleClassChangeError();
                    case StepEnum.Step1 -> "\u57fa\u7840\u4fe1\u606f\u9636\u6bb5";
                    case StepEnum.Step2 -> "\u53ef\u7814\u9636\u6bb5";
                    case StepEnum.Step3 -> "\u8bbe\u8ba1\u9636\u6bb5";
                    case StepEnum.Step4 -> "\u8bd5\u8fd0\u884c\u9636\u6bb5";
                    case StepEnum.Step5 -> "\u7ae3\u5de5\u9a8c\u6536\u540e";
                    case StepEnum.Step5_1 -> "\u7ae3\u5de5\u9a8c\u6536\u540e-\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u5de5\u4f5c\u5185\u5bb9\u544a\u77e5";
                    case StepEnum.Step5_2 -> "\u7ae3\u5de5\u9a8c\u6536\u540e-\u5206\u7c7b\u81ea\u67e5\u5de5\u4f5c\u5185\u5bb9\u544a\u77e5";
                    case StepEnum.Step6 -> "\u6c47\u603b\u9636\u6bb5";
                    case StepEnum.Step7 -> "\u5df2\u6709\u7533\u62a5\u6570\u636e\uff0c\u8f6c\u6362\u4e3a\u6b63\u5e38\u4f01\u4e1a";
                };
            }
            vo.setStepName(stepName);
        }
    }

    private LackMaterialSituationEnum judgeLackMaterialSituation(List<NewCompanyGuideLackMaterial> lackList) {
        if (!this.hasValidPassLackMaterial(lackList, LackTypeEnum.YP)) {
            return LackMaterialSituationEnum.YP;
        }
        if (!this.hasValidPassLackMaterial(lackList, LackTypeEnum.SJ)) {
            return LackMaterialSituationEnum.SJ;
        }
        if (!this.hasValidPassLackMaterial(lackList, LackTypeEnum.KP)) {
            return LackMaterialSituationEnum.KP;
        }
        return LackMaterialSituationEnum.OK;
    }

    private boolean hasValidPassLackMaterial(List<NewCompanyGuideLackMaterial> lackList, LackTypeEnum lackType) {
        return lackList.stream().anyMatch(l -> Objects.equals(l.getLackType(), lackType.getKey()) && Boolean.TRUE.equals(l.getIsValid()) && Objects.equals(l.getStatus(), LackStatusEnum.PASS.getKey()));
    }

    public List<CompanySuperviseModel> listWaitSureNewCompanyData() {
        return ((NewCompanyGuideInfoMapper)this.dao).listWaitSureNewCompanyData();
    }

    public List<CompanySuperviseModel> listWaitSureNewCompanyData2() {
        return ((NewCompanyGuideInfoMapper)this.dao).listWaitSureNewCompanyData2();
    }

    public JqGridData<CompanySuperviseModel> getCompanyPage(JqGridParam pageParam, CompanySuperviseSearchModel companyParam) {
        companyParam.setSystemDeploymentSource(SystemDeploymentSourceEnum.NO.getCode());
        int page = pageParam.getPage();
        int rows = pageParam.getRows();
        PageInfo companyPage = this.companyService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(companyParam, page, rows, Boolean.TRUE);
        if (companyPage == null || CollUtil.isEmpty((Collection)companyPage.getList())) {
            return new JqGridData();
        }
        return new JqGridData(companyPage, new JqGridParam(rows, page));
    }

    public CompanySuperviseModel getCompanyInfo(CompanySuperviseSearchModel searchParam) {
        String regstate;
        List irsCompanyList;
        String unifiedSocialCc = searchParam.getUnifiedSocialCc();
        if (CharSequenceUtil.isBlank((CharSequence)unifiedSocialCc)) {
            throw new ServiceException("\u4fe1\u7528\u4ee3\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        String cacheKey = String.format("%s:%s:%s:", IRS_COMPANY_INFO_CACHE, "getUnifiedSocialCc", unifiedSocialCc);
        if (this.redisClient.hasKey(cacheKey)) {
            irsCompanyList = (List)this.redisClient.get(cacheKey);
        } else {
            irsCompanyList = this.irsMarketEntitiesService.queryIrsMarketEntitiesByUnifiedSocialCc(unifiedSocialCc);
            this.redisClient.set(cacheKey, (Object)irsCompanyList, (long)IRS_CACHE_TIME.intValue());
        }
        if (CollUtil.isEmpty((Collection)irsCompanyList)) {
            throw new ServiceException("\u672a\u627e\u5230\u76f8\u5173IRS\u4f01\u4e1a\u4fe1\u606f\uff01");
        }
        IrsMarketEntities irsCompany = (IrsMarketEntities)irsCompanyList.get(0);
        CompanySuperviseModel company = new CompanySuperviseModel();
        company.setName(irsCompany.getEntname());
        company.setUnifiedSocialCc(irsCompany.getUniscid());
        company.setRegisterAddressRegionId(this.getSysRegionIdByOldRegionId(irsCompany));
        company.setRegisterAddress(irsCompany.getDom());
        company.setWorkAddress(irsCompany.getOploc());
        company.setSettingTime(irsCompany.getEstdate());
        company.setProductionTime(irsCompany.getEstdate());
        IndustryModel industry = this.industryProvideService.getIndustryByName(irsCompany.getIndustryco());
        if (industry != null) {
            company.setIndustryCategory(industry.getId());
            company.setIndustryCategoryName(irsCompany.getIndustryco());
        }
        if (StringUtils.isNotBlank((CharSequence)(regstate = irsCompany.getRegstate())) && regstate.contains("\u5f00\u4e1a")) {
            company.setIrsBusinessState(Byte.valueOf((byte)1));
        }
        String reporttype = irsCompany.getReporttype();
        return company;
    }

    private Long getSysRegionIdByOldRegionId(IrsMarketEntities irsCompany) {
        String oldRegionId = irsCompany.getDomdistrict();
        if (CharSequenceUtil.isBlank((CharSequence)oldRegionId)) {
            return null;
        }
        String oldId6 = oldRegionId.substring(0, 6);
        Example e = new Example(AreaToOld.class);
        e.createCriteria().andEqualTo("oldAreaId", (Object)Convert.toLong((Object)oldId6)).andEqualTo("isValid", (Object)Boolean.TRUE);
        List regionMapList = this.areaToOldService.getListByExample(e);
        String oldRegion = irsCompany.getDom();
        return regionMapList.stream().map(AreaToOld::getAreaId).findFirst().orElse(null);
    }

    @Transactional
    public CompanyBaseInfoModel submitCompanyInfo(CompanyBaseInfoModel companyParam, CompanyReportInfo companyReportInfo, Long loginStaffId) {
        CompanyBaseInfoModel companyModel = null;
        CompanySuperviseModel onlineTrainCom = null;
        try {
            NewCompanyGuideInfoServiceImpl.inputCompanyParamCheck(companyParam);
            onlineTrainCom = this.companyService.getCompanyInfoById(companyParam.getId());
            companyModel = this.maintenanceCompanyInfo(companyParam, onlineTrainCom, loginStaffId);
            this.companyStorageProvideService.saveOrUpdateCompanyStorage(companyModel, loginStaffId);
            companyReportInfo.setCid(companyModel.getCid());
            this.maintenanceCompanyReportInfo(companyReportInfo, loginStaffId);
            this.doProcessYsZyb(companyModel);
            this.autoCreateSysUser(companyModel, loginStaffId);
            this.companyBaseDcInfoService.updateChuangdePushInfo(companyModel.getUnifiedSocialCc());
        }
        catch (Throwable ex) {
            log.error("\u76d1\u7ba1\u65b0\u589e\u7528\u4eba\u5355\u4f4d\u5f02\u5e38", ex);
            if (companyModel != null && companyModel.getCid() != null) {
                Long cid = companyModel.getCid();
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                def.setPropagationBehavior(3);
                TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
                if (onlineTrainCom == null) {
                    ((NewCompanyGuideInfoMapper)this.dao).physicallyDelCompanyAndCompanySuperviseInfo(cid, loginStaffId);
                } else {
                    this.companyService.updateCompanyAndCompanySuperviseByOne(onlineTrainCom, loginStaffId);
                }
                ((NewCompanyGuideInfoMapper)this.dao).physicallyDeleteStorageInfo(cid, loginStaffId);
                ((NewCompanyGuideInfoMapper)this.dao).physicallyDeleteAccountInfo(cid, loginStaffId);
                this.txManager.commit(status);
            }
            throw new HealthException(ex.getMessage());
        }
        return companyModel;
    }

    private void doProcessYsZyb(CompanyBaseInfoModel companyParam) {
        if (companyParam != null && Objects.equals(companyParam.getStorageReason(), CompanyGradeReasonEnum.ZYB_RISK_PUSH.getValue()) && StringUtils.isNotBlank((CharSequence)companyParam.getDataSourceId())) {
            BxLastMonthZybSummary zybSummary = new BxLastMonthZybSummary();
            zybSummary.setId(Convert.toLong((Object)companyParam.getDataSourceId()));
            zybSummary.setCompanyId(companyParam.getCid());
            this.zybSummaryService.saveOrUpdateData(Arrays.asList(zybSummary));
        }
    }

    private void autoCreateSysUser(CompanyBaseInfoModel companyModel, Long loginStaffId) {
        List dbUserList = this.sysUserThirdService.getUserInfoByCidList((List)ListUtil.toList((Object[])new Long[]{companyModel.getCid()}));
        if (CollUtil.isEmpty((Collection)dbUserList)) {
            this.sysUserThirdService.createSysUser((List)ListUtil.toList((Object[])new Long[]{companyModel.getCid()}), loginStaffId);
        }
    }

    private static void inputCompanyParamCheck(CompanyBaseInfoModel companyParam) {
        if (companyParam == null) {
            throw new ServiceException("\u4f01\u4e1a\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        String ucc = companyParam.getUnifiedSocialCc();
        if (CharSequenceUtil.isBlank((CharSequence)ucc)) {
            throw new ServiceException("\u4fe1\u7528\u4ee3\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Integer storageReason = companyParam.getStorageReason();
        if (storageReason == null) {
            throw new ServiceException("\u8bf7\u6307\u5b9a\u5206\u7c7b\u4f01\u4e1a\u5165\u5e93\u539f\u56e0\uff01");
        }
    }

    private void maintenanceCompanyReportInfo(CompanyReportInfo reportInfo, Long loginStaffId) {
        Date now = new Date();
        reportInfo.setId(null);
        this.companyReportInfoService.addCompanyReportInfo(reportInfo, loginStaffId, reportInfo.getCid(), null);
    }

    private CompanyBaseInfoModel maintenanceCompanyInfo(CompanyBaseInfoModel companyParam, CompanySuperviseModel onlineTrainCom, Long loginStaffId) {
        if (onlineTrainCom == null) {
            return this.addCompanyInfo(companyParam, loginStaffId);
        }
        return this.modCompanyInfo(companyParam, loginStaffId);
    }

    private CompanyBaseInfoModel addCompanyInfo(CompanyBaseInfoModel companyParam, Long loginStaffId) {
        CompanyBaseInfoModel companyModel = new CompanyBaseInfoModel();
        try {
            BeanUtils.copyProperties((Object)companyModel, (Object)companyParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String ucc = companyModel.getUnifiedSocialCc();
        String cname = companyModel.getName();
        List comListByName = this.companyService.getOnlyCompanyByName((List)CollUtil.toList((Object[])new String[]{cname}));
        if (CollUtil.isNotEmpty((Collection)comListByName)) {
            throw new ServiceException("\u6d59\u91cc\u536b\u4f01\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0\uff01");
        }
        List comListByUcc = this.companyService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete((List)ListUtil.toList((Object[])new String[]{ucc}));
        if (CollUtil.isNotEmpty((Collection)comListByUcc)) {
            throw new ServiceException("\u6b64\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\u4e8e\u6d59\u91cc\u536b\u4f01\uff0c\u4e0d\u53ef\u63d0\u4ea4\uff01");
        }
        companyModel.setId(null);
        companyModel.setCid(null);
        CompanySuperviseModel com = new CompanySuperviseModel();
        com.setName(companyModel.getName());
        com.setUnifiedSocialCc(companyModel.getUnifiedSocialCc());
        com.setAreaId(companyModel.getAreaId());
        com.setWorkAddress(companyModel.getWorkAddress());
        com.setRegisterAddressRegionId(companyModel.getRegisterAddressRegionId());
        com.setRegisterAddress(companyModel.getRegisterAddress());
        com.setRegisterType(companyModel.getRegisterType());
        com.setScale(companyModel.getScale());
        com.setIndustryCategory(companyModel.getIndustryCategory());
        com.setOccupationalRiskClassify(companyModel.getOccupationalRiskClassify());
        com.setPickupCount(companyModel.getPickupCount());
        com.setLegalName(companyModel.getLegalName());
        com.setLegalTel(companyModel.getLegalTel());
        com.setMainLeaderName(companyModel.getMainLeaderName());
        com.setMainLeaderTel(companyModel.getMainLeaderTel());
        com.setOccManagerName(companyModel.getOccManagerName());
        com.setOccManagerTel(companyModel.getOccManagerTel());
        com.setSupervisionUnit(companyModel.getSupervisionUnit());
        com.setIsDecCurrentYear(companyModel.getIsDecCurrentYear());
        com.setSettingTime(companyModel.getSettingTime());
        com.setProductionTime(companyModel.getProductionTime());
        com.setGradeReason(companyModel.getStorageReason());
        com.setGradeCreateDate(new Date());
        com.setBusinessState(Byte.valueOf((byte)1));
        com.setIrsBusinessState(Byte.valueOf((byte)1));
        com.setIsDec(Boolean.TRUE);
        com.setStaffCount(companyModel.getStaffCount());
        com.setDataSourceId(companyModel.getDataSourceId());
        com.setInsertCompanyType(Byte.valueOf((byte)3));
        com.setIsExistRadioactivity(companyModel.getIsExistRadioactivity());
        this.companyService.saveCompanyAndCompanySuperviseByOne(com, loginStaffId);
        List dbComList = this.companyService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete((List)CollUtil.toList((Object[])new String[]{ucc}));
        if (!CollUtil.isNotEmpty((Collection)dbComList)) {
            throw new ServiceException("\u65b0\u589e\u7528\u4eba\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CompanySuperviseModel dbCom = (CompanySuperviseModel)dbComList.get(0);
        companyModel.setCid(dbCom.getCid());
        return companyModel;
    }

    private CompanyBaseInfoModel modCompanyInfo(CompanyBaseInfoModel companyParam, Long loginStaffId) {
        CompanyBaseInfoModel companyModel = new CompanyBaseInfoModel();
        try {
            BeanUtils.copyProperties((Object)companyModel, (Object)companyParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Long cid = companyParam.getId();
        String ucc = companyParam.getUnifiedSocialCc();
        List comList = this.companyService.getOnlyCompanyByCid((List)CollUtil.toList((Object[])new Long[]{cid}));
        if (CollUtil.isEmpty((Collection)comList)) {
            throw new ServiceException("\u672a\u627e\u5230\u76f8\u5173\u4f01\u4e1a\u4fe1\u606f\uff01");
        }
        CompanySuperviseModel com = (CompanySuperviseModel)comList.get(0);
        com.setName(companyModel.getName());
        com.setUnifiedSocialCc(companyModel.getUnifiedSocialCc());
        com.setAreaId(companyModel.getAreaId());
        com.setWorkAddress(companyModel.getWorkAddress());
        com.setRegisterAddressRegionId(companyModel.getRegisterAddressRegionId());
        com.setRegisterAddress(companyModel.getRegisterAddress());
        com.setRegisterType(companyModel.getRegisterType());
        com.setScale(companyModel.getScale());
        com.setIndustryCategory(companyModel.getIndustryCategory());
        com.setOccupationalRiskClassify(companyModel.getOccupationalRiskClassify());
        com.setPickupCount(companyModel.getPickupCount());
        com.setLegalName(companyModel.getLegalName());
        com.setLegalTel(companyModel.getLegalTel());
        com.setMainLeaderName(companyModel.getMainLeaderName());
        com.setMainLeaderTel(companyModel.getMainLeaderTel());
        com.setOccManagerName(companyModel.getOccManagerName());
        com.setOccManagerTel(companyModel.getOccManagerTel());
        com.setSupervisionUnit(companyModel.getSupervisionUnit());
        com.setIsDecCurrentYear(companyModel.getIsDecCurrentYear());
        com.setGradeReason(companyModel.getStorageReason());
        com.setGradeCreateDate(new Date());
        com.setBusinessState(Byte.valueOf((byte)1));
        com.setIrsBusinessState(Byte.valueOf((byte)1));
        com.setIsDec(Boolean.TRUE);
        com.setStaffCount(companyModel.getStaffCount());
        com.setIsExistRadioactivity(companyParam.getIsExistRadioactivity());
        RpcContext.getContext().setAttachment("skip_sensitive_log", "true");
        this.companyService.updateCompanyAndCompanySuperviseByOne(com, loginStaffId);
        companyModel.setCid(cid);
        return companyModel;
    }

    public List<Long> getAllUnSendNewId(NewCompanyGuideInfoModel newCompanyModel) {
        this.preSetRegionInfo(newCompanyModel);
        return ((NewCompanyGuideInfoMapper)this.dao).getAllUnSendNewId(newCompanyModel);
    }

    public List<CompanySuperviseModel> judgeIrsCompanyIsExistInSystem(CompanySuperviseSearchModel companyParam) {
        String unifiedSocialCc = companyParam.getUnifiedSocialCc();
        if (CharSequenceUtil.isNotBlank((CharSequence)unifiedSocialCc) && NewCompanyGuideInfoServiceImpl.containsChinese(unifiedSocialCc)) {
            throw new ServiceException("\u586b\u5199\u7684\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u6838\u5b9e\u8981\u65b0\u589e\u4f01\u4e1a\u7684\u4fe1\u7528\u4ee3\u7801\uff01");
        }
        List companyList = this.companyService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete((List)ListUtil.toList((Object[])new String[]{unifiedSocialCc}));
        if (CollUtil.isNotEmpty((Collection)companyList)) {
            List<CompanySuperviseModel> onlineTrainCompanyList = companyList.stream().filter(c -> c.getIsRegulationVisible() != null && c.getIsRegulationVisible() == 0).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(onlineTrainCompanyList)) {
                return onlineTrainCompanyList;
            }
            throw new ServiceException("\u8be5\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\u4e8e\u201c\u6d59\u91cc\u536b\u4f01\u201d\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u6838\u5b9e\u8981\u65b0\u589e\u4f01\u4e1a\u7684\u4fe1\u7528\u4ee3\u7801\uff01");
        }
        return Collections.emptyList();
    }

    public static boolean isAlphanumericOrHyphen(String str) {
        return str.matches("^[a-zA-Z0-9-]+$");
    }

    public static boolean containsChinese(String str) {
        return str.matches(".*[\\u4e00-\\u9fa5]+.*");
    }

    public List<NewCompanyGuideInfoVo> getAllNewInfoToTask() {
        return ((NewCompanyGuideInfoMapper)this.dao).getAllNewInfoToTask();
    }

    private CompanyBaseInfoModel encapsulateModelByParam(CompanyBaseInfoModel companyParam) throws Exception {
        String unifiedSocialCc = companyParam.getUnifiedSocialCc();
        if (CharSequenceUtil.isBlank((CharSequence)unifiedSocialCc)) {
            throw new ServiceException("\u4fe1\u7528\u4ee3\u7801\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        List sysCompanyList = this.companyService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete((List)ListUtil.toList((Object[])new String[]{unifiedSocialCc}));
        if (CollUtil.isNotEmpty((Collection)sysCompanyList)) {
            throw new ServiceException("\u4f01\u4e1a\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u63d0\u4ea4\uff01");
        }
        Integer storageReason = companyParam.getStorageReason();
        if (storageReason == null) {
            throw new ServiceException("\u8bf7\u6307\u5b9a\u5206\u7c7b\u4f01\u4e1a\u5165\u5e93\u539f\u56e0\uff01");
        }
        CompanyBaseInfoModel companyModel = new CompanyBaseInfoModel();
        BeanUtils.copyProperties((Object)companyModel, (Object)companyParam);
        companyModel.setId(null);
        companyModel.setCid(null);
        return companyModel;
    }

    public void postSetRegionInfo(CompanySuperviseModel companyInfo) {
        Long regionId = companyInfo.getAreaDetailId();
        if (regionId == null) {
            return;
        }
        AreaModel region = this.regionService.getAreaById(regionId);
        if (region == null || region.getId() == null) {
            return;
        }
        companyInfo.setProvinceId(region.getProvinceId());
        companyInfo.setProvinceName(region.getProvinceName());
        companyInfo.setCityId(region.getCityId());
        companyInfo.setCityName(region.getCityName());
        companyInfo.setAreaId(region.getAreaId());
        companyInfo.setAreaName(region.getAreaName());
        companyInfo.setStreetId(region.getStreetId());
        companyInfo.setStreetName(region.getStreetName());
        companyInfo.setAreaLevel(region.getLevel());
    }

    private void postSetRegisterInfo(CompanySuperviseModel companyInfo) {
        SysParamModel sysParamModel;
        Long registerType = companyInfo.getRegisterType();
        if (registerType != null && registerType > 0L && (sysParamModel = this.paramProvideService.getById(registerType)) != null) {
            companyInfo.setRegisterTypeName(sysParamModel.getParamValue());
        }
    }

    private void postSetIndustryInfo(CompanySuperviseModel companyInfo) {
        IndustryModel industryModel;
        Long industryCategory = companyInfo.getIndustryCategory();
        if (industryCategory != null && (industryModel = this.industryProvideService.getIndustryById(industryCategory)) != null) {
            companyInfo.setIndustryCategoryCode(industryModel.getCode());
            companyInfo.setIndustryCategoryName(industryModel.getName());
        }
    }

    private void processUserUpdates(List<Long> cids, int status, Long loginUserId) {
        if (!cids.isEmpty()) {
            String cidsStr = cids.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.sysUserThirdService.disableOrEnableUserByCids(cidsStr, Integer.valueOf(status), loginUserId);
        }
    }

    private CompanySuperviseModel getOnlineTrainCompany(String ucc) {
        CompanySuperviseModel company;
        boolean onlineTrain;
        if (CharSequenceUtil.isBlank((CharSequence)ucc)) {
            return null;
        }
        List companyList = this.companyService.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete((List)ListUtil.toList((Object[])new String[]{ucc}));
        if (CollUtil.isNotEmpty((Collection)companyList) && (onlineTrain = NewCompanyGuideInfoServiceImpl.isOnlineTrain(company = (CompanySuperviseModel)companyList.get(0)))) {
            return company;
        }
        return null;
    }

    private static boolean isOnlineTrain(CompanySuperviseModel company) {
        if (company == null) {
            return Boolean.FALSE;
        }
        Integer isRegulationVisible = company.getIsRegulationVisible();
        return isRegulationVisible != null && isRegulationVisible == 0;
    }

    public PageInfo<CompanyUnDeclareStatModel> getUnDeclareCompanyStatModel(JqGridParam jqGridParam, CompanyUnDeclareStatModel searchParam) {
        AreaModel areaModel;
        if (searchParam.getAreaLevel() > 3) {
            return new PageInfo();
        }
        if ((searchParam.getIsAllCity().booleanValue() || searchParam.getIsAllArea().booleanValue()) && (areaModel = this.areaProvideService.getAreaById(searchParam.getAreaId())) != null) {
            searchParam.setAreaId(areaModel.getProvinceId());
        }
        if (Objects.equals(searchParam.getBelongType(), (byte)2)) {
            searchParam.setAreaLevel(Byte.valueOf((byte)3));
        }
        List<CompanyUnDeclareStatModel> list = ((NewCompanyGuideInfoMapper)this.dao).getUnDeclareCompanyStatModel(searchParam);
        if (Objects.equals(searchParam.getAreaLevel(), (byte)2) && searchParam.getBelongType() == null) {
            searchParam.setBelongType(Byte.valueOf((byte)2));
            List<CompanyUnDeclareStatModel> list2 = ((NewCompanyGuideInfoMapper)this.dao).getUnDeclareCompanyStatModel(searchParam);
            if (CollectionUtils.isNotEmpty(list2) && list2.get(0).getIsDecCount() != 0) {
                list.add(list2.get(0));
            }
            searchParam.setBelongType(null);
        }
        if (!Objects.equals(searchParam.getBelongType(), (byte)2)) {
            this.supplyList(list, searchParam);
        }
        return PageUtil.getPageInfo(list, (int)jqGridParam.getPage(), (int)jqGridParam.getRows());
    }

    private void supplyList(List<CompanyUnDeclareStatModel> list, CompanyUnDeclareStatModel searchParam) {
        Long parentId = searchParam.getAreaId();
        Integer areaLevel = (int)searchParam.getAreaLevel();
        if (searchParam.getIsAllCity().booleanValue()) {
            areaLevel = 1;
        } else if (searchParam.getIsAllArea().booleanValue()) {
            areaLevel = 5;
        }
        List areaInfo = new ArrayList();
        if (areaLevel == 1) {
            areaInfo = (List)this.redisClient.get("areaInfo", "city" + parentId, 86400L, () -> this.areaProvideService.getCityList(parentId));
        } else if (areaLevel == 2) {
            areaInfo = (List)this.redisClient.get("areaInfo", "area" + parentId, 86400L, () -> this.areaProvideService.getAreaList(parentId));
        } else if (areaLevel == 3) {
            areaInfo = (List)this.redisClient.get("areaInfo", "street" + parentId, 86400L, () -> this.areaProvideService.getStreetList(parentId));
        } else if (areaLevel == 5) {
            areaInfo = (List)this.redisClient.get("areaInfo", "areaAll", 86400L, () -> this.areaProvideService.getListByLevel(parentId, Byte.valueOf((byte)3), Byte.valueOf((byte)1)));
        }
        Set collect = list.stream().filter(Objects::nonNull).map(CompanyUnDeclareStatModel::getTbAreaId).collect(Collectors.toSet());
        if (areaInfo.size() == collect.size()) {
            return;
        }
        for (AreaModel model : areaInfo) {
            if (model == null || collect.contains(model.getId())) continue;
            CompanyUnDeclareStatModel data = new CompanyUnDeclareStatModel();
            data.setIsDecCount(Integer.valueOf(0));
            data.setReason2Num(Integer.valueOf(0));
            data.setReason3Num(Integer.valueOf(0));
            data.setReason4Num(Integer.valueOf(0));
            data.setReason5Num(Integer.valueOf(0));
            data.setReason6Num(Integer.valueOf(0));
            data.setTbAreaId(model.getId());
            data.setAreaLevel(model.getLevel());
            data.setTbAreaName(model.getName());
            list.add(data);
        }
        list.sort(Comparator.comparing(CompanyUnDeclareStatModel::getIsDecCount, Comparator.reverseOrder()));
    }

    public CompanyUnDeclareStatModel getUnDeclareCompanyStatHead(CompanyUnDeclareStatModel searchParam) {
        AreaModel areaModel;
        CompanyUnDeclareStatModel model;
        AreaModel areaModel2;
        if ((searchParam.getIsAllCity().booleanValue() || searchParam.getIsAllArea().booleanValue()) && (areaModel2 = this.areaProvideService.getAreaById(searchParam.getAreaId())) != null) {
            searchParam.setAreaId(areaModel2.getProvinceId());
            searchParam.setAreaLevel(Byte.valueOf((byte)1));
        }
        if ((model = ((NewCompanyGuideInfoMapper)this.dao).getUnDeclareCompanyStatHead(searchParam)).getIsDecCount() == 0 && searchParam.getBelongType() == null && (areaModel = this.areaProvideService.getAreaById(searchParam.getAreaId())) != null) {
            model.setTbAreaId(areaModel.getId());
            model.setTbAreaLevel(areaModel.getLevel());
            model.setTbAreaName(areaModel.getName());
        }
        return model;
    }

    public PageInfo<CompanyUnDeclareModel> getUnDeclareCompanyPage(JqGridParam jqGridParam, CompanyUnDeclareModel searchParam) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        return new PageInfo(this.getUnDeclareCompanyList(searchParam));
    }

    public List<CompanyUnDeclareModel> getUnDeclareCompanyList(CompanyUnDeclareModel searchParam) {
        return ((NewCompanyGuideInfoMapper)this.dao).getUnDeclareCompanyList(searchParam);
    }

    @Transactional
    public CompanySuperviseModel batchAddCompanyGuide(List<CompanySuperviseModel> companyList, Long loginUserId, Boolean falg) throws Exception {
        CompanySuperviseModel companySuperviseModel;
        NewCompanyGuideInfo newCompanyGuideInfo;
        block13: {
            this.addParameterValidation(companyList, falg);
            if (CollectionUtils.isEmpty(companyList)) {
                return null;
            }
            ArrayList addList = new ArrayList();
            ArrayList<CompanySuperviseModel> updateList = new ArrayList<CompanySuperviseModel>();
            companyList.forEach(f -> {
                f.setDataSource(CompanyDataSourceEnum.NEW_COMPANY_GUIDE.getValue());
                if (ObjectUtil.isNull((Object)f.getId())) {
                    f.setInsertCompanyType(Byte.valueOf((byte)1));
                    f.setIsDec(Boolean.valueOf(false));
                    f.setId(Long.valueOf(this.idworker.nextId()));
                    addList.add(f);
                } else {
                    updateList.add((CompanySuperviseModel)f);
                }
                Organization orgById = this.organizationService.getOrgById(f.getSupervisionUnit());
                if (ObjectUtil.isNotNull((Object)orgById)) {
                    f.setSupervisionAreaId(orgById.getAreaId());
                }
                if (ObjectUtil.isNotNull((Object)orgById) && ObjectUtil.isNotNull((Object)orgById.getLevel())) {
                    if (orgById.getLevel() == 1) {
                        f.setBelongType(Integer.valueOf(1));
                    } else if (orgById.getLevel() == 2) {
                        f.setBelongType(Integer.valueOf(2));
                    } else {
                        f.setBelongType(Integer.valueOf(0));
                    }
                }
            });
            newCompanyGuideInfo = new NewCompanyGuideInfo();
            if (CollUtil.isNotEmpty(addList)) {
                ArrayList<Long> idList = new ArrayList<Long>();
                ArrayList<CreateUserModel> createUserModeList = new ArrayList<CreateUserModel>();
                try {
                    this.companyService.saveCompanyAndCompanySuperviseByList(addList, loginUserId);
                    List companySuperviseModelList = addList.stream().filter(c -> ObjectUtil.isNotNull((Object)c.getId())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(companySuperviseModelList)) {
                        ArrayList ngiList = new ArrayList();
                        for (CompanySuperviseModel companySuperviseModel2 : companySuperviseModelList) {
                            Long id = companySuperviseModel2.getId();
                            idList.add(id);
                            CreateUserModel createUserModel = new CreateUserModel();
                            createUserModel.setCid(id);
                            createUserModel.setUsername(companySuperviseModel2.getName());
                            createUserModel.setPassword("Zyj@2022");
                            createUserModel.setCreateBy(loginUserId);
                            createUserModeList.add(createUserModel);
                            Date date = new Date();
                            NewCompanyGuideInfo ngi = new NewCompanyGuideInfo();
                            ngi.setId(Long.valueOf(this.idworker.nextId()));
                            ngi.setCreateBy(loginUserId);
                            ngi.setCreateDate(date);
                            ngi.setNewCompanyDatasource(companySuperviseModel2.getNewCompanyDatasource());
                            ngi.setCid(id);
                            ngi.setType(Byte.valueOf((byte)1));
                            ngiList.add(ngi);
                            CompanyReportInfo companyReportInfo = new CompanyReportInfo();
                            companyReportInfo.setCid(id);
                            companyReportInfo.setLegalCardId(companySuperviseModel2.getLegalCardId());
                            companyReportInfo.setLegalCardType(companySuperviseModel2.getLegalCardType());
                            this.companyReportInfoService.addCompanyReportInfo(companyReportInfo, loginUserId, id, "1");
                            NewCompanyGuideThreeWhilstInfo info = new NewCompanyGuideThreeWhilstInfo();
                            info.setId(Long.valueOf(this.idworker.nextId()));
                            info.setCreateDate(date);
                            info.setCreateBy(loginUserId);
                            info.setUpdateDate(date);
                            info.setProjectCode(companySuperviseModel2.getProjectCode());
                            info.setProjectApprovalTime(companySuperviseModel2.getProjectApprovalTime());
                            info.setProjectName(companySuperviseModel2.getProjectName());
                            info.setCid(id);
                            this.newCompanyGuideThreeWhilstInfoMapper.insertSelective(info);
                            this.finishedReportService.refreshFinishReport(Collections.singletonList(info.getCid()), NewCompanyGuideRefreshModelEnum.THREE_WHILST_BASIC, new StepEnum[0]);
                        }
                        this.batchUpdateOrInsert(ngiList, NewCompanyGuideInfoMapper.class, (item, mapper) -> mapper.insertSelective(item));
                        newCompanyGuideInfo = (NewCompanyGuideInfo)ngiList.get(0);
                    }
                    this.sysUserThirdService.create(createUserModeList);
                }
                catch (Exception e) {
                    this.companyService.rollbackImportCompanyAndCompanySuperviseData(idList);
                    this.sysUserThirdService.rollbackImportUserData(idList);
                    if (CollectionUtils.isNotEmpty(idList)) {
                        this.newCompanyGuideThreeWhilstInfoMapper.rollbackCompanyGuideThreeWhilstInfo(idList);
                        ((NewCompanyGuideInfoMapper)this.dao).rollNewCompanyGuideInfo(idList);
                    }
                    throw e;
                }
            }
            if (CollUtil.isNotEmpty(updateList)) {
                List<Long> newCompanyGuideInfos = ((NewCompanyGuideInfoMapper)this.dao).selectNewCompanyListByCids(updateList);
                if (CollUtil.isNotEmpty(newCompanyGuideInfos)) {
                    throw new ServiceException("\u5df2\u7ecf\u5b58\u5728\u65b0\u5efa\u4f01\u4e1a\u5217\u8868\uff0c\u8bf7\u786e\u8ba4\uff01");
                }
                ArrayList<NewCompanyGuideInfo> ngiList = new ArrayList<NewCompanyGuideInfo>();
                ArrayList<Long> idList = new ArrayList<Long>();
                try {
                    for (CompanySuperviseModel companySuperviseModel3 : updateList) {
                        Long id = companySuperviseModel3.getId();
                        companySuperviseModel3.setCid(id);
                        idList.add(id);
                        this.companyService.updateCompanyOldIsNullField(companySuperviseModel3, loginUserId);
                        Date date = new Date();
                        NewCompanyGuideInfo ngi = new NewCompanyGuideInfo();
                        ngi.setId(Long.valueOf(this.idworker.nextId()));
                        ngi.setCreateBy(loginUserId);
                        ngi.setCreateDate(date);
                        ngi.setNewCompanyDatasource(companySuperviseModel3.getNewCompanyDatasource());
                        ngi.setCid(id);
                        ngi.setType(Byte.valueOf((byte)1));
                        ngiList.add(ngi);
                        ((NewCompanyGuideInfoMapper)this.dao).updateCompanyReportInfo(companySuperviseModel3.getLegalCardId(), companySuperviseModel3.getLegalCardType(), loginUserId, id);
                        this.archiveUpdateService.refreshArchive(id, "202");
                        NewCompanyGuideThreeWhilstInfo info = new NewCompanyGuideThreeWhilstInfo();
                        info.setId(Long.valueOf(this.idworker.nextId()));
                        info.setCreateDate(date);
                        info.setCreateBy(loginUserId);
                        info.setUpdateDate(date);
                        info.setProjectApprovalTime(companySuperviseModel3.getProjectApprovalTime());
                        info.setProjectName(companySuperviseModel3.getProjectName());
                        info.setCid(id);
                        this.newCompanyGuideThreeWhilstInfoMapper.insertSelective(info);
                        this.finishedReportService.refreshFinishReport(Collections.singletonList(info.getCid()), NewCompanyGuideRefreshModelEnum.THREE_WHILST_BASIC, new StepEnum[0]);
                    }
                    this.batchUpdateOrInsert(ngiList, NewCompanyGuideInfoMapper.class, (item, mapper) -> mapper.insertSelective(item));
                    newCompanyGuideInfo = (NewCompanyGuideInfo)ngiList.get(0);
                }
                catch (Exception e) {
                    if (!CollectionUtils.isNotEmpty(idList)) break block13;
                    this.newCompanyGuideThreeWhilstInfoMapper.rollbackCompanyGuideThreeWhilstInfo(idList);
                    ((NewCompanyGuideInfoMapper)this.dao).rollNewCompanyGuideInfo(idList);
                }
            }
        }
        if (ObjectUtil.isNotNull((Object)(companySuperviseModel = companyList.get(0)))) {
            companySuperviseModel.setId(newCompanyGuideInfo.getId());
        }
        return companySuperviseModel;
    }

    private void addParameterValidation(List<CompanySuperviseModel> companyList, Boolean falg) {
        if (CollectionUtils.isEmpty(companyList)) {
            return;
        }
        for (CompanySuperviseModel companySuperviseModel : companyList) {
            if (StringUtils.isBlank((CharSequence)companySuperviseModel.getName())) {
                throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)companySuperviseModel.getUnifiedSocialCc()) || companySuperviseModel.getUnifiedSocialCc().length() != 18) {
                throw new ServiceException("\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
            if (StringUtils.isBlank((CharSequence)companySuperviseModel.getScale())) {
                throw new ServiceException("\u4f01\u4e1a\u89c4\u6a21\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtil.isNull((Object)companySuperviseModel.getIndustryCategory())) {
                throw new ServiceException("\u4f01\u4e1a\u884c\u4e1a\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtil.isNull((Object)companySuperviseModel.getRegisterType())) {
                throw new ServiceException("\u4f01\u4e1a\u7ecf\u6d4e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtil.isNull((Object)companySuperviseModel.getAreaId())) {
                throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)companySuperviseModel.getWorkAddress())) {
                throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (ObjectUtil.isNull((Object)companySuperviseModel.getRegisterAddressRegionId())) {
                throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)companySuperviseModel.getRegisterAddress())) {
                throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String legalName = companySuperviseModel.getLegalName();
            String legalTel = companySuperviseModel.getLegalTel();
            String mainLeaderName = companySuperviseModel.getMainLeaderName();
            String mainLeaderTel = companySuperviseModel.getMainLeaderTel();
            String occManagerName = companySuperviseModel.getOccManagerName();
            String occManagerTel = companySuperviseModel.getOccManagerTel();
            if (StringUtils.isBlank((CharSequence)legalName)) {
                throw new ServiceException("\u4f01\u4e1a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)legalTel) || legalTel.length() != 11) {
                throw new ServiceException("\u4f01\u4e1a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
            if (StringUtils.isBlank((CharSequence)mainLeaderName)) {
                throw new ServiceException("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)mainLeaderTel) || mainLeaderTel.length() != 11) {
                throw new ServiceException("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
            if (StringUtils.isBlank((CharSequence)occManagerName)) {
                throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)occManagerTel) || occManagerTel.length() != 11) {
                throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
            HashMap phoneToNamesMap = new HashMap();
            if (!phoneToNamesMap.containsKey(legalTel)) {
                phoneToNamesMap.put(legalTel, new ArrayList());
            }
            ((List)phoneToNamesMap.get(legalTel)).add(legalName);
            if (!phoneToNamesMap.containsKey(mainLeaderTel)) {
                phoneToNamesMap.put(mainLeaderTel, new ArrayList());
            }
            ((List)phoneToNamesMap.get(mainLeaderTel)).add(mainLeaderName);
            if (!phoneToNamesMap.containsKey(occManagerTel)) {
                phoneToNamesMap.put(occManagerTel, new ArrayList());
            }
            ((List)phoneToNamesMap.get(occManagerTel)).add(occManagerName);
            for (Map.Entry entry : phoneToNamesMap.entrySet()) {
                HashSet uniqueNames;
                List names = (List)entry.getValue();
                if (names.size() <= 1 || (uniqueNames = new HashSet(names)).size() <= 1) continue;
                throw new ServiceException("\u51b2\u7a81\u53d1\u73b0: \u624b\u673a\u53f7 " + (String)entry.getKey() + " \u88ab\u4e0d\u540c\u59d3\u540d\u4f7f\u7528\uff01");
            }
            if (falg.booleanValue()) {
                SysParamModel byId = this.paramProvideService.getById(companySuperviseModel.getRegisterType());
                if (ObjectUtil.isNotNull((Object)byId) && ("\u4e2a\u4f53\u5de5\u5546\u6237".equals(byId.getParamValue()) || "\u5176\u4ed6".equals(byId.getParamValue())) && (ObjectUtil.isNull((Object)companySuperviseModel.getLegalCardType()) || ObjectUtil.isNull((Object)companySuperviseModel.getLegalCardId()))) {
                    throw new ServiceException("\u5f53\u7ecf\u6d4e\u7c7b\u578b\u4e3a900-\u5176\u4ed6\u548c400-\u4e2a\u4f53\u5de5\u5546\u6237\u65f6\uff0c\u6cd5\u4eba\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtil.isNull((Object)companySuperviseModel.getSupervisionUnit())) {
                    throw new ServiceException("\u4f01\u4e1a\u76d1\u7763\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (ObjectUtil.isNull((Object)companySuperviseModel.getIsExistRadioactivity())) {
                    throw new ServiceException("\u662f\u5426\u975e\u533b\u7528\u653e\u5c04\u7528\u4eba\u5355\u4f4d\u672a\u786e\u5b9a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)companySuperviseModel.getProjectName()) || ObjectUtil.isNull((Object)companySuperviseModel.getProjectApprovalTime())) {
                    throw new ServiceException("\u5efa\u8bbe\u9879\u76ee\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (falg.booleanValue() || !StringUtils.isBlank((CharSequence)companySuperviseModel.getFatherDept())) continue;
            throw new ServiceException("\u4f01\u4e1a\u4e0a\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Transactional
    public void editNewCompany(NewCompanyInfoEditModel modifyModel) {
        Long newCompanyId = modifyModel.getNewCompanyId();
        Long loginUserId = modifyModel.getUpdatedBy();
        this.editParameterValidation(modifyModel);
        if (newCompanyId == null) {
            CompanySuperviseModel com = new CompanySuperviseModel();
            com.setName(modifyModel.getCompanyName());
            com.setUnifiedSocialCc(modifyModel.getUnifiedSocialCc());
            com.setScale(modifyModel.getScale());
            com.setIndustryCategory(modifyModel.getIndustryCategory());
            com.setFatherDept(modifyModel.getFatherDept());
            com.setRegisterType(modifyModel.getRegisterType());
            com.setAreaId(modifyModel.getAreaId());
            com.setWorkAddress(modifyModel.getWorkAddress());
            com.setRegisterAddress(modifyModel.getRegisterAddress());
            com.setRegisterAddressRegionId(modifyModel.getRegisterAddressRegionId());
            com.setLegalName(modifyModel.getLegalName());
            com.setLegalTel(modifyModel.getLegalTel());
            com.setMainLeaderName(modifyModel.getMainLeaderName());
            com.setMainLeaderTel(modifyModel.getMainLeaderTel());
            com.setOccManagerName(modifyModel.getOccManagerName());
            com.setOccManagerTel(modifyModel.getOccManagerTel());
            return;
        }
        CompanySuperviseModel model = this.companyService.getCompanyInfoById(newCompanyId);
        if (ObjectUtil.isNull((Object)model) || ObjectUtil.isNull((Object)model.getId())) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        Long cid = model.getId();
        List comList = this.companyService.getOnlyCompanyByCid(Convert.toList(Long.class, (Object)cid));
        if (CollUtil.isEmpty((Collection)comList)) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        CompanySuperviseModel com = (CompanySuperviseModel)comList.get(0);
        if (this.companyService.isHaveThisName(modifyModel.getCompanyName(), com.getId(), Boolean.TRUE).booleanValue()) {
            throw new ServiceException("\u8be5\u4f01\u4e1a\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        ArrayList changeTypeList = ListUtil.toList((Object[])new Integer[]{CompanyChangeTypeEnum.crossMigration.getCode(), CompanyChangeTypeEnum.intraMigration.getCode(), CompanyChangeTypeEnum.districtMigration.getCode()});
        Example example = new Example(CompanyChangeInfoDetail.class);
        example.createCriteria().andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("cid", (Object)cid).andIn("changeType", (Iterable)changeTypeList).andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        List detailList = this.changeInfoDetailService.getListByExample(example);
        if (CollUtil.isNotEmpty((Collection)detailList)) {
            throw new ServiceException(String.format("\u65b0\u5efa\u4f01\u4e1a\u3010%s\u3011\u62df\u8fc1\u79fb\uff0c\u4e0d\u53ef\u7f16\u8f91\uff01", com.getName()));
        }
        com.setName(modifyModel.getCompanyName());
        com.setUnifiedSocialCc(modifyModel.getUnifiedSocialCc());
        com.setScale(modifyModel.getScale());
        com.setIndustryCategory(modifyModel.getIndustryCategory());
        com.setFatherDept(modifyModel.getFatherDept());
        com.setRegisterType(modifyModel.getRegisterType());
        com.setAreaId(modifyModel.getAreaId());
        com.setWorkAddress(modifyModel.getWorkAddress());
        com.setRegisterAddress(modifyModel.getRegisterAddress());
        com.setRegisterAddressRegionId(modifyModel.getRegisterAddressRegionId());
        com.setLegalName(modifyModel.getLegalName());
        com.setLegalTel(modifyModel.getLegalTel());
        com.setMainLeaderName(modifyModel.getMainLeaderName());
        com.setMainLeaderTel(modifyModel.getMainLeaderTel());
        com.setOccManagerName(modifyModel.getOccManagerName());
        com.setOccManagerTel(modifyModel.getOccManagerTel());
        this.companyService.updateCompanyAndCompanySuperviseByOne(com, loginUserId);
    }

    public CompanySuperviseModel companyInfoNoDesensitization(CompanySuperviseSearchModel searchParam) {
        List irsCompanyList;
        String cacheKey;
        String unifiedSocialCc = searchParam.getUnifiedSocialCc();
        if (StringUtils.isEmpty((CharSequence)unifiedSocialCc)) {
            throw new HealthException("\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String regex = "^(([0-9A-Za-z]{15})|([0-9A-Za-z]{18})|([0-9A-Za-z]{20}))$";
        if (!unifiedSocialCc.matches(regex)) {
            throw new HealthException("\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        Long cid = null;
        List<CompanySuperviseModel> companyList = ((NewCompanyGuideInfoMapper)this.dao).getZLWQCompanyInfoList(ListUtil.toList((Object[])new String[]{unifiedSocialCc}));
        if (CollUtil.isNotEmpty(companyList)) {
            List companySuperviseModels = companyList.stream().filter(c -> c.getIsRegulationVisible() != null && c.getIsRegulationVisible() == 1).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(companySuperviseModels)) {
                throw new HealthException("\u8be5\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\u4e8e\u201c\u6d59\u91cc\u536b\u4f01\u201d\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u6838\u5b9e\u8981\u65b0\u589e\u4f01\u4e1a\u7684\u4fe1\u7528\u4ee3\u7801\uff01");
            }
            List collect = companyList.stream().filter(c -> c.getIsRegulationVisible() != null && c.getIsRegulationVisible() == 0).collect(Collectors.toList());
            cid = ((CompanySuperviseModel)collect.get(0)).getId();
        }
        if (this.redisClient.hasKey(cacheKey = String.format("%s:%s:%s:", IRS_COMPANY_INFO_CACHE2, "getUnifiedSocialCc2", unifiedSocialCc))) {
            irsCompanyList = (List)this.redisClient.get(cacheKey);
        } else {
            irsCompanyList = this.irsMarketEntitiesService.queryIrsMarketEntitiesByUnifiedSocialCc4irs(unifiedSocialCc);
            this.redisClient.set(cacheKey, (Object)irsCompanyList, (long)IRS_CACHE_TIME.intValue());
        }
        CompanySuperviseModel companyInfo = new CompanySuperviseModel();
        if (CollUtil.isNotEmpty((Collection)irsCompanyList)) {
            IndustryModel industry;
            IrsMarketEntities irsMarketEntities = (IrsMarketEntities)irsCompanyList.get(0);
            companyInfo.setId(cid);
            companyInfo.setName(irsMarketEntities.getEntname());
            companyInfo.setUnifiedSocialCc(irsMarketEntities.getUniscid());
            companyInfo.setRegisterAddressRegionId(this.getSysRegionIdByOldRegionId(irsMarketEntities));
            AreaModel area = this.areaProvideService.getAreaById(companyInfo.getRegisterAddressRegionId());
            companyInfo.setRegisterAreaDetailId(companyInfo.getRegisterAddressRegionId());
            if (area != null) {
                companyInfo.setRegisterAreaId(area.getAreaId());
                companyInfo.setRegisterAreaName(area.getAreaName());
                companyInfo.setRegisterCityId(area.getCityId());
                companyInfo.setRegisterCityName(area.getCityName());
                companyInfo.setRegisterStreetId(area.getStreetId());
                companyInfo.setRegisterStreetName(area.getStreetName());
                companyInfo.setRegisterProvinceId(area.getProvinceId());
                companyInfo.setRegisterProvinceName(area.getProvinceName());
                companyInfo.setRegisterAreaLevel(area.getLevel());
            }
            if ((industry = this.industryProvideService.getIndustryByName(irsMarketEntities.getIndustryco())) != null) {
                companyInfo.setIndustryCategory(industry.getId());
                companyInfo.setIndustryCategoryName(irsMarketEntities.getIndustryco());
            }
            companyInfo.setRegisterAddress(irsMarketEntities.getDom());
            companyInfo.setWorkAddress(irsMarketEntities.getOploc());
        } else {
            companyInfo = this.companyService.getCompanyInfoById(searchParam.getId());
            if (ObjectUtil.isNull((Object)companyInfo)) {
                companyInfo = new CompanySuperviseModel();
            }
            AreaModel area = this.areaProvideService.getAreaById(companyInfo.getRegisterAddressRegionId());
            companyInfo.setRegisterAreaDetailId(companyInfo.getRegisterAddressRegionId());
            if (area != null) {
                companyInfo.setRegisterAreaId(area.getAreaId());
                companyInfo.setRegisterAreaName(area.getAreaName());
                companyInfo.setRegisterCityId(area.getCityId());
                companyInfo.setRegisterCityName(area.getCityName());
                companyInfo.setRegisterStreetId(area.getStreetId());
                companyInfo.setRegisterStreetName(area.getStreetName());
                companyInfo.setRegisterProvinceId(area.getProvinceId());
                companyInfo.setRegisterProvinceName(area.getProvinceName());
                companyInfo.setRegisterAreaLevel(area.getLevel());
            }
        }
        return companyInfo;
    }

    public List<Long> getStagebyCids(List<Long> cidList, Byte step) {
        Example e = new Example(NewCompanyGuideInfo.class);
        Example.Criteria criteria = e.createCriteria();
        criteria.andIn("cid", cidList).andEqualTo("step", (Object)step).andEqualTo("isValid", (Object)true);
        List newCompanyGuideInfos = ((NewCompanyGuideInfoMapper)this.dao).selectByExample(e);
        if (CollectionUtils.isEmpty((Collection)newCompanyGuideInfos)) {
            return Collections.emptyList();
        }
        List<Long> cids = newCompanyGuideInfos.stream().map(NewCompanyGuideInfo::getCid).filter(i -> ObjectUtil.isNotNull((Object)i)).distinct().collect(Collectors.toList());
        return cids;
    }

    private void editParameterValidation(NewCompanyInfoEditModel companySuperviseModel) {
        if (ObjectUtil.isNull((Object)companySuperviseModel)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)companySuperviseModel.getCompanyName())) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companySuperviseModel.getUnifiedSocialCc()) || companySuperviseModel.getUnifiedSocialCc().length() != 18) {
            throw new ServiceException("\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companySuperviseModel.getScale())) {
            throw new ServiceException("\u4f01\u4e1a\u89c4\u6a21\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companySuperviseModel.getIndustryCategory())) {
            throw new ServiceException("\u4f01\u4e1a\u884c\u4e1a\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companySuperviseModel.getRegisterType())) {
            throw new ServiceException("\u4f01\u4e1a\u7ecf\u6d4e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companySuperviseModel.getAreaId())) {
            throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companySuperviseModel.getWorkAddress())) {
            throw new ServiceException("\u4f01\u4e1a\u5de5\u4f5c\u573a\u6240\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isNull((Object)companySuperviseModel.getRegisterAddressRegionId())) {
            throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u884c\u653f\u533a\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companySuperviseModel.getRegisterAddress())) {
            throw new ServiceException("\u4f01\u4e1a\u6ce8\u518c\u5730\u5740\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String legalName = companySuperviseModel.getLegalName();
        String legalTel = companySuperviseModel.getLegalTel();
        String mainLeaderName = companySuperviseModel.getMainLeaderName();
        String mainLeaderTel = companySuperviseModel.getMainLeaderTel();
        String occManagerName = companySuperviseModel.getOccManagerName();
        String occManagerTel = companySuperviseModel.getOccManagerTel();
        if (StringUtils.isBlank((CharSequence)legalName)) {
            throw new ServiceException("\u4f01\u4e1a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)legalTel) || legalTel.length() != 11) {
            throw new ServiceException("\u4f01\u4e1a\u6cd5\u5b9a\u4ee3\u8868\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)mainLeaderName)) {
            throw new ServiceException("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)mainLeaderTel) || mainLeaderTel.length() != 11) {
            throw new ServiceException("\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)occManagerName)) {
            throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)occManagerTel) || occManagerTel.length() != 11) {
            throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        HashMap phoneToNamesMap = new HashMap();
        if (!phoneToNamesMap.containsKey(legalTel)) {
            phoneToNamesMap.put(legalTel, new ArrayList());
        }
        ((List)phoneToNamesMap.get(legalTel)).add(legalName);
        if (!phoneToNamesMap.containsKey(mainLeaderTel)) {
            phoneToNamesMap.put(mainLeaderTel, new ArrayList());
        }
        ((List)phoneToNamesMap.get(mainLeaderTel)).add(mainLeaderName);
        if (!phoneToNamesMap.containsKey(occManagerTel)) {
            phoneToNamesMap.put(occManagerTel, new ArrayList());
        }
        ((List)phoneToNamesMap.get(occManagerTel)).add(occManagerName);
        for (Map.Entry entry : phoneToNamesMap.entrySet()) {
            HashSet uniqueNames;
            List names = (List)entry.getValue();
            if (names.size() <= 1 || (uniqueNames = new HashSet(names)).size() <= 1) continue;
            throw new ServiceException("\u51b2\u7a81\u53d1\u73b0: \u624b\u673a\u53f7 " + (String)entry.getKey() + " \u88ab\u4e0d\u540c\u59d3\u540d\u4f7f\u7528\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companySuperviseModel.getFatherDept())) {
            throw new ServiceException("\u4f01\u4e1a\u4e0a\u5c5e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @Generated
    public NewCompanyGuideInfoServiceImpl(INewCompanyGuideChangeRecordService changeRecordService, NewCompanyGuideChangeRecordMapper changeRecordMapper, IAreaToOldService areaToOldService, ICompanyChangeInfoDetailService changeInfoDetailService, ISysUserThirdService sysUserThirdService) {
        this.changeRecordService = changeRecordService;
        this.changeRecordMapper = changeRecordMapper;
        this.areaToOldService = areaToOldService;
        this.changeInfoDetailService = changeInfoDetailService;
        this.sysUserThirdService = sysUserThirdService;
    }
}

