/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemListVo;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideFinishedReportMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideFinishedReport;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideOccupationalHazardInfo;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideThreeWhilstInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.LackStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.LackTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.StepEnum;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideProcessModel;
import cn.smarthse.modules.health.newcompanyguide.params.NewCompanyGuideProcessParam;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideLackMaterialService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideOccupationalHazardInfoService;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideThreeWhilstInfoService;
import cn.smarthse.modules.health.newcompanyguide.vo.LackMaterialVo;
import cn.smarthse.modules.health.service.base.wmbase.IWarnSignManageService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.vo.work.certificate.CertificateStaffCountVo;
import cn.smarthse.services.hfi.api.pojo.bo.CheckPlanCountBo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewCompanyGuideFinishedReportServiceImpl
extends BaseServiceImpl<NewCompanyGuideFinishedReportMapper, NewCompanyGuideFinishedReport>
implements INewCompanyGuideFinishedReportService {
    private final INewCompanyGuideOccupationalHazardInfoService hazardInfoService;
    @DubboReference
    private IProtectEquipIssueRecordService protectEquipIssueRecordService;
    @DubboReference
    private IWarnSignManageService warnSignManageService;
    @DubboReference
    private IPhcPhysicalCheckV3221Service phycheckService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private ICertificateStaffDetailService certifiDetailService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @Autowired
    private INewCompanyGuideFinishedReportService selfService;
    @DubboReference
    IWandaDeclareService wandaDeclareService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @Autowired
    private INewCompanyGuideThreeWhilstInfoService threeWhilstInfoService;
    @Autowired
    @Lazy
    private INewCompanyGuideLackMaterialService lackMaterialService;

    public void refreshFinishReport(List<Long> cids, NewCompanyGuideRefreshModelEnum refreshModel, StepEnum ... step) {
        if (Objects.equals(NewCompanyGuideRefreshModelEnum.BASIC, refreshModel)) {
            this.collectPhaseInfo(cids, step);
        } else {
            this.collectOtherGuideFinishedReport(cids, ListUtil.of((Object[])new NewCompanyGuideRefreshModelEnum[]{refreshModel}));
        }
    }

    @Transactional(readOnly=false)
    public void collectPhaseInfo(List<Long> cids, StepEnum ... steps) {
        if (ArrayUtils.isEmpty((Object[])steps) || CollectionUtils.isEmpty(cids)) {
            return;
        }
        List<NewCompanyGuideFinishedReport> dbReports = this.getInfoByCid(cids);
        Map<Object, Object> dbReportMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dbReports)) {
            dbReportMap = dbReports.stream().collect(Collectors.toMap(NewCompanyGuideFinishedReport::getCid, NewCompanyGuideFinishedReport::getId, (v1, v2) -> v1));
        }
        List stepKeys = Arrays.stream(steps).map(StepEnum::getKey).collect(Collectors.toList());
        List newHazardInfos = this.hazardInfoService.listHazardInfo(cids, stepKeys);
        Map<Object, Object> hazardInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)newHazardInfos)) {
            hazardInfoMap = newHazardInfos.stream().collect(Collectors.groupingBy(NewCompanyGuideOccupationalHazardInfo::getCid));
        }
        List listCompanyLackMaterial = this.lackMaterialService.getListCompanyLackMaterial(new LackMaterialVo().setStatus(LackStatusEnum.PASS.getKey()).setCidList(cids));
        ArrayList<NewCompanyGuideFinishedReport> newReport = new ArrayList<NewCompanyGuideFinishedReport>();
        for (Long cid : cids) {
            NewCompanyGuideFinishedReport report = new NewCompanyGuideFinishedReport();
            report.setCid(cid);
            report.setId((Long)dbReportMap.get(cid));
            List cidnewHazardInfos = (List)hazardInfoMap.get(cid);
            for (StepEnum step : steps) {
                boolean validateFinishedReport = this.validateFinishedReport(cidnewHazardInfos, step);
                if (Objects.equals(step, StepEnum.Step2)) {
                    report.setPreEvaluateFinished(Boolean.valueOf(validateFinishedReport));
                    continue;
                }
                if (Objects.equals(step, StepEnum.Step3)) {
                    report.setDesignFinished(Boolean.valueOf(validateFinishedReport));
                    continue;
                }
                if (Objects.equals(step, StepEnum.Step4)) {
                    report.setContrEvaluateFinished(Boolean.valueOf(validateFinishedReport));
                    continue;
                }
                if (!Objects.equals(step, StepEnum.Step5)) continue;
            }
            for (LackMaterialVo lackMaterialVo : listCompanyLackMaterial) {
                if (lackMaterialVo == null) continue;
                Byte lackType = lackMaterialVo.getLackType();
                if (Objects.equals(LackTypeEnum.YP.getKey(), lackType)) {
                    report.setPreEvaluateFinished(Boolean.valueOf(true));
                    continue;
                }
                if (Objects.equals(LackTypeEnum.SJ.getKey(), lackType)) {
                    report.setDesignFinished(Boolean.valueOf(true));
                    continue;
                }
                if (!Objects.equals(LackTypeEnum.KP.getKey(), lackType)) continue;
                report.setContrEvaluateFinished(Boolean.valueOf(true));
            }
            newReport.add(report);
        }
        this.selfService.batchSaveGuideFinishedReport(newReport);
    }

    public void collectOtherGuideFinishedReport(List<Long> cids, List<NewCompanyGuideRefreshModelEnum> refreshModels) {
        List<NewCompanyGuideFinishedReport> dbReports = this.getInfoByCid(cids);
        Map<Object, Object> dbReportMap = new HashMap();
        if (CollectionUtils.isNotEmpty(dbReports)) {
            dbReportMap = dbReports.stream().collect(Collectors.toMap(NewCompanyGuideFinishedReport::getCid, NewCompanyGuideFinishedReport::getId, (v1, v2) -> v1));
        }
        Set<Object> hasPersonShieldBusinessDataSet = new HashSet();
        Set<Object> hasWarnSignBusinessDataSet = new HashSet();
        Map cidDeclareCountMap = new HashMap();
        Map<Object, Object> phcPhysModelMap = new HashMap();
        Map<Object, Object> certificateStaffCountVoMap = new HashMap();
        Map<Object, Object> checkPlanCountBoMap = new HashMap();
        HashMap<Long, Boolean> companyBaseMap = new HashMap<Long, Boolean>();
        HashMap<Long, Boolean> threeWhilstBaseMap = new HashMap<Long, Boolean>();
        List reformCompletedList = this.reformItemBasicService.countReformCompletedGenerateSource(cids, ListUtil.of((Object[])new Integer[]{10, 12, 13, 14, 15, 16, 17, 18}));
        Map<Object, Object> reformCompletedMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)reformCompletedList)) {
            reformCompletedMap = reformCompletedList.stream().collect(Collectors.groupingBy(ReformItemListVo::getCid, Collectors.toMap(ReformItemListVo::getGenerationSource, Function.identity())));
        }
        for (NewCompanyGuideRefreshModelEnum refreshModel : refreshModels) {
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.PERSONSHIELD, refreshModel)) {
                ProtectEquipIssueRecord searchModel = new ProtectEquipIssueRecord();
                searchModel.setCids(cids);
                List fullData = this.protectEquipIssueRecordService.getFullData(searchModel);
                if (!CollectionUtils.isNotEmpty((Collection)fullData)) continue;
                hasPersonShieldBusinessDataSet = fullData.stream().map(ProtectEquipIssueRecord::getCid).collect(Collectors.toSet());
                continue;
            }
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.WMBASE, refreshModel)) {
                WarnSignManage signManage = new WarnSignManage();
                signManage.setCids(cids);
                List fullSignManage = this.warnSignManageService.getFullSignManage(signManage);
                if (!CollectionUtils.isNotEmpty((Collection)fullSignManage)) continue;
                hasWarnSignBusinessDataSet = fullSignManage.stream().map(WarnSignManage::getCid).collect(Collectors.toSet());
                continue;
            }
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.CHECK, refreshModel)) {
                List checkPlanCountBos = this.checkPlanService.collectFinishCheck(cids);
                if (!CollectionUtils.isNotEmpty((Collection)checkPlanCountBos)) continue;
                checkPlanCountBoMap = checkPlanCountBos.stream().collect(Collectors.toMap(CheckPlanCountBo::getCid, Function.identity(), (v1, v2) -> v1));
                continue;
            }
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.TRAIN, refreshModel)) {
                List certificateStaffCountVos = this.certifiDetailService.countCertByCids(cids);
                if (!CollectionUtils.isNotEmpty((Collection)certificateStaffCountVos)) continue;
                certificateStaffCountVoMap = certificateStaffCountVos.stream().collect(Collectors.toMap(CertificateStaffCountVo::getCid, Function.identity(), (v1, v2) -> v1));
                continue;
            }
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.PHC, refreshModel)) {
                List phcPhysicalStatisticsModels = this.phycheckService.queryCompliancePhysical5Data(cids, Integer.valueOf(2024));
                if (!CollectionUtils.isNotEmpty((Collection)phcPhysicalStatisticsModels)) continue;
                phcPhysModelMap = phcPhysicalStatisticsModels.stream().collect(Collectors.toMap(PhcPhysicalStatisticsModel::getCid, Function.identity(), (v1, v2) -> v1));
                continue;
            }
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.DECARE, refreshModel)) {
                cidDeclareCountMap = this.wandaDeclareService.countByCids(cids);
                XxlJobHelper.log((String)"cidDeclareCountMap:{}", (Object[])new Object[]{cidDeclareCountMap});
                continue;
            }
            if (Objects.equals(NewCompanyGuideRefreshModelEnum.COMPANY_BASIC, refreshModel)) {
                for (Long cid : cids) {
                    CompanyBaseInfoModel dbCompany = this.companyProvideByHSEService.getCompanyById(cids.get(0));
                    if (!this.companyFinished(dbCompany)) continue;
                    companyBaseMap.put(cid, true);
                }
                continue;
            }
            if (!Objects.equals(NewCompanyGuideRefreshModelEnum.THREE_WHILST_BASIC, refreshModel)) continue;
            for (Long cid : cids) {
                NewCompanyGuideThreeWhilstInfo threeWhilstInfo = this.threeWhilstInfoService.getThreeWhilstInfoByCid(cid);
                if (threeWhilstInfo.getProjectApprovalTime() == null || !StringUtils.isNotEmpty((String)threeWhilstInfo.getProjectCode()) || !StringUtils.isNotEmpty((String)threeWhilstInfo.getProjectName()) || threeWhilstInfo.getTestRunBeginTime() == null || threeWhilstInfo.getCompleteTime() == null || threeWhilstInfo.getActualStartTime() == null) continue;
                threeWhilstBaseMap.put(cid, true);
            }
        }
        ArrayList<NewCompanyGuideFinishedReport> newReport = new ArrayList<NewCompanyGuideFinishedReport>();
        for (Long cid : cids) {
            NewCompanyGuideFinishedReport report = new NewCompanyGuideFinishedReport();
            report.setCid(cid);
            report.setId((Long)dbReportMap.get(cid));
            HashMap reformItemListVoMap = (HashMap)reformCompletedMap.get(cid);
            if (reformItemListVoMap == null) {
                reformItemListVoMap = new HashMap();
            }
            for (NewCompanyGuideRefreshModelEnum refreshModel : refreshModels) {
                ReformItemListVo reformItemListVo;
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.PERSONSHIELD, refreshModel)) {
                    if (hasPersonShieldBusinessDataSet.contains(cid)) {
                        report.setPersonshieldFinished(Boolean.valueOf(true));
                        continue;
                    }
                    reformItemListVo = (ReformItemListVo)reformItemListVoMap.get(ReformGenerationSourceEnum.PROTECTION.getValue());
                    if (reformItemListVo != null && reformItemListVo.getAccNum() > 0) {
                        report.setPersonshieldFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setPersonshieldFinished(Boolean.valueOf(false));
                    continue;
                }
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.WMBASE, refreshModel)) {
                    if (hasWarnSignBusinessDataSet.contains(cid)) {
                        report.setWmbaseFinished(Boolean.valueOf(true));
                        continue;
                    }
                    reformItemListVo = (ReformItemListVo)reformItemListVoMap.get(ReformGenerationSourceEnum.WARNING_SIGNS.getValue());
                    if (reformItemListVo != null && reformItemListVo.getAccNum() > 0) {
                        report.setWmbaseFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setWmbaseFinished(Boolean.valueOf(false));
                    continue;
                }
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.CHECK, refreshModel)) {
                    if (checkPlanCountBoMap.containsKey(cid)) {
                        report.setFactorcheckFinished(Boolean.valueOf(true));
                        continue;
                    }
                    reformItemListVo = (ReformItemListVo)reformItemListVoMap.get(ReformGenerationSourceEnum.DETECTION.getValue());
                    if (reformItemListVo != null && reformItemListVo.getAccNum() > 0) {
                        report.setFactorcheckFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setFactorcheckFinished(Boolean.valueOf(false));
                    continue;
                }
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.TRAIN, refreshModel)) {
                    if (certificateStaffCountVoMap.containsKey(cid)) {
                        report.setMastertrainFinished(Boolean.valueOf(true));
                        continue;
                    }
                    reformItemListVo = (ReformItemListVo)reformItemListVoMap.get(ReformGenerationSourceEnum.TRAIN.getValue());
                    if (reformItemListVo != null && reformItemListVo.getAccNum() > 0) {
                        report.setMastertrainFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setMastertrainFinished(Boolean.valueOf(false));
                    continue;
                }
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.PHC, refreshModel)) {
                    if (phcPhysModelMap.containsKey(cid)) {
                        report.setPhccheckFinished(Boolean.valueOf(true));
                        continue;
                    }
                    reformItemListVo = (ReformItemListVo)reformItemListVoMap.get(ReformGenerationSourceEnum.TJ.getValue());
                    if (reformItemListVo != null && reformItemListVo.getAccNum() > 0) {
                        report.setPhccheckFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setPhccheckFinished(Boolean.valueOf(false));
                    continue;
                }
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.DECARE, refreshModel)) {
                    if (cidDeclareCountMap.containsKey(cid) && cidDeclareCountMap.get(cid) != null && (Integer)cidDeclareCountMap.get(cid) > 0) {
                        report.setDecareFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setDecareFinished(Boolean.valueOf(false));
                    continue;
                }
                if (Objects.equals(NewCompanyGuideRefreshModelEnum.COMPANY_BASIC, refreshModel)) {
                    if (companyBaseMap.containsKey(cid)) {
                        report.setCompanyFinished(Boolean.valueOf(true));
                        continue;
                    }
                    report.setCompanyFinished(Boolean.valueOf(false));
                    continue;
                }
                if (!Objects.equals(NewCompanyGuideRefreshModelEnum.THREE_WHILST_BASIC, refreshModel)) continue;
                if (threeWhilstBaseMap.containsKey(cid)) {
                    report.setThreeWhilstFinished(Boolean.valueOf(true));
                    continue;
                }
                report.setThreeWhilstFinished(Boolean.valueOf(false));
            }
            newReport.add(report);
        }
        this.selfService.batchSaveGuideFinishedReport(newReport);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void batchSaveGuideFinishedReport(List<NewCompanyGuideFinishedReport> newReport) {
        this.batchUpdateOrInsert(newReport, NewCompanyGuideFinishedReportMapper.class, (item, mapper) -> {
            if (item.getId() == null) {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setCreateDate(new Date());
                return mapper.insertSelective(item);
            }
            item.setUpdateDate(new Date());
            return mapper.updateByPrimaryKeySelective(item);
        });
    }

    public List<NewCompanyGuideFinishedReport> getInfoByCid(List<Long> cids) {
        Example e = new Example(NewCompanyGuideFinishedReport.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cids);
        return ((NewCompanyGuideFinishedReportMapper)this.dao).selectByExample(e);
    }

    public boolean validateFinishedReport(List<NewCompanyGuideOccupationalHazardInfo> hazardInfoVos, StepEnum step) {
        if (CollectionUtils.isEmpty(hazardInfoVos)) {
            return false;
        }
        Optional<NewCompanyGuideOccupationalHazardInfo> hazardInfoVoOpt = hazardInfoVos.stream().filter(f -> Objects.equals(f.getStep(), step.getKey()) && Objects.equals(f.getRequired(), true)).findFirst();
        if (hazardInfoVoOpt.isPresent()) {
            NewCompanyGuideOccupationalHazardInfo infoVo = hazardInfoVoOpt.get();
            if (!Objects.equals(step, StepEnum.Step1)) {
                if (Objects.equals(step, StepEnum.Step2)) {
                    if (infoVo.getCompleteTime() != null && infoVo.getEvaluateReportFileId() != null && StringUtils.isNotBlank((CharSequence)infoVo.getOrgName())) {
                        return true;
                    }
                } else if (Objects.equals(step, StepEnum.Step3)) {
                    if (infoVo.getCompleteTime() != null && infoVo.getEvaluateReportFileId() != null && StringUtils.isNotBlank((CharSequence)infoVo.getOrgName())) {
                        return true;
                    }
                } else if (Objects.equals(step, StepEnum.Step4)) {
                    if (infoVo.getCompleteTime() != null && infoVo.getEvaluateReportFileId() != null && StringUtils.isNotBlank((CharSequence)infoVo.getOrgName()) && infoVo.getOccType() != null) {
                        return true;
                    }
                } else if (Objects.equals(step, StepEnum.Step5)) {
                    // empty if block
                }
            }
        }
        return false;
    }

    public PageInfo<NewCompanyGuideProcessModel> pageCollectGuideInfo(JqGridParam param, NewCompanyGuideProcessParam gparam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<NewCompanyGuideProcessModel> newCompanyGuideProcessModels = ((NewCompanyGuideFinishedReportMapper)this.dao).pageCollectGuideInfo(gparam);
        PageInfo page = new PageInfo(newCompanyGuideProcessModels);
        return page;
    }

    public NewCompanyGuideProcessModel detailCollectGuideInfo(NewCompanyGuideProcessParam gparam) {
        PageHelper.startPage((int)1, (int)1);
        Byte areaLevel = gparam.getAreaLevel();
        if (areaLevel == 0) {
            gparam.setBelongType(Integer.valueOf(3));
        } else if (areaLevel == 1) {
            gparam.setBelongType(CompanyBelongTypeEnum.SHENG.getValue());
        } else if (areaLevel == 2) {
            gparam.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
        } else {
            gparam.setBelongType(CompanyBelongTypeEnum.NO.getValue());
        }
        List<NewCompanyGuideProcessModel> newCompanyGuideProcessModels = ((NewCompanyGuideFinishedReportMapper)this.dao).pageCollectGuideInfo(gparam);
        PageInfo page = new PageInfo(newCompanyGuideProcessModels);
        if (page != null && CollectionUtils.isNotEmpty((Collection)page.getList())) {
            return (NewCompanyGuideProcessModel)page.getList().get(0);
        }
        return new NewCompanyGuideProcessModel();
    }

    private boolean companyFinished(CompanyBaseInfoModel model) {
        return StringUtils.isNotEmpty((String)model.getName()) && StringUtils.isNotEmpty((String)model.getWorkAddress()) && StringUtils.isNotEmpty((String)model.getRegisterAddress()) && StringUtils.isNotEmpty((String)model.getScale()) && model.getRegisterType() != null && StringUtils.isNotEmpty((String)model.getLegalName()) && StringUtils.isNotEmpty((String)model.getLegalTel()) && StringUtils.isNotEmpty((String)model.getMainLeaderName()) && StringUtils.isNotEmpty((String)model.getMainLeaderTel()) && StringUtils.isNotEmpty((String)model.getOccManagerName()) && StringUtils.isNotEmpty((String)model.getOccManagerTel());
    }

    @Generated
    public NewCompanyGuideFinishedReportServiceImpl(INewCompanyGuideOccupationalHazardInfoService hazardInfoService) {
        this.hazardInfoService = hazardInfoService;
    }
}

