/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.newcompanyguide.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideChangeRecordMapper;
import cn.smarthse.modules.health.newcompanyguide.dao.NewCompanyGuideInfoMapper;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideChangeRecord;
import cn.smarthse.modules.health.newcompanyguide.entity.NewCompanyGuideInfo;
import cn.smarthse.modules.health.newcompanyguide.enums.ChangeStatusEnum;
import cn.smarthse.modules.health.newcompanyguide.enums.ChangeTypeEnum;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyChangeImportModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideChangeRecordModel;
import cn.smarthse.modules.health.newcompanyguide.model.NewCompanyGuideInfoModel;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideChangeRecordService;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyChangePrevCurrVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideChangeRecordVo;
import cn.smarthse.modules.health.newcompanyguide.vo.NewCompanyGuideInfoVo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class NewCompanyGuideChangeRecordServiceImpl
extends BaseServiceImpl<NewCompanyGuideChangeRecordMapper, NewCompanyGuideChangeRecord>
implements INewCompanyGuideChangeRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewCompanyGuideChangeRecordServiceImpl.class);
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    private final NewCompanyGuideInfoMapper newCompanyGuideInfoMapper;
    public static final String EXCEL_ERROR_DATA = "excel_error_data";
    public static final String EXCEL_DATA = "excel_data";

    @Transactional
    public void addNewCompanyChange(NewCompanyGuideChangeRecordModel changeModel) {
        String newCompanyIds = changeModel.getNewCompanyIds();
        Byte type = changeModel.getType();
        Long loginUserId = changeModel.getCreateBy();
        if (CharSequenceUtil.isBlank((CharSequence)newCompanyIds)) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (type == null) {
            throw new ServiceException("\u53d8\u66f4\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Date currDate = new Date();
        List<Long> newCompanyIdList = NewCompanyGuideChangeRecordServiceImpl.parseStringToLongList(newCompanyIds);
        Example e = new Example(NewCompanyGuideChangeRecord.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("status", (Object)ChangeStatusEnum.NO_CONFIRM.getKey()).andIn("newCompanyId", newCompanyIdList);
        List dbChangeList = ((NewCompanyGuideChangeRecordMapper)this.dao).selectByExample(e);
        if (CollUtil.isNotEmpty((Collection)dbChangeList)) {
            List<Long> alreadyExistIdList = dbChangeList.stream().map(NewCompanyGuideChangeRecord::getNewCompanyId).filter(newCompanyIdList::contains).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(alreadyExistIdList)) {
                List<String> cnameList = ((NewCompanyGuideChangeRecordMapper)this.dao).selectCnameByNewCompanyIdList(alreadyExistIdList);
                throw new ServiceException("\u65b0\u5efa\u4f01\u4e1a\uff1a" + String.valueOf(cnameList) + "\u5df2\u5b58\u5728\u53d8\u66f4\u5217\u8868\u4e2d\uff01");
            }
        }
        if (CollUtil.isNotEmpty(newCompanyIdList)) {
            ArrayList<NewCompanyGuideChangeRecord> changeList = new ArrayList<NewCompanyGuideChangeRecord>();
            for (Long newCompanyId : newCompanyIdList) {
                NewCompanyGuideChangeRecord changeBean = new NewCompanyGuideChangeRecord();
                changeBean.setId(Long.valueOf(IdWorker.getId()));
                changeBean.setNewCompanyId(newCompanyId);
                changeBean.setStatus(ChangeStatusEnum.NO_CONFIRM.getKey());
                changeBean.setType(type);
                changeBean.setCreateBy(loginUserId);
                changeBean.setCreateDate(currDate);
                changeBean.setUpdatedBy(loginUserId);
                changeBean.setUpdateDate(currDate);
                changeList.add(changeBean);
            }
            ((NewCompanyGuideChangeRecordMapper)this.dao).insertList2(changeList);
        }
    }

    @Transactional
    public void removeNewCompanyChange(NewCompanyGuideChangeRecordModel changeModel) {
        String newCompanyIds = changeModel.getNewCompanyIds();
        Long loginUserId = changeModel.getUpdatedBy();
        if (CharSequenceUtil.isBlank((CharSequence)newCompanyIds)) {
            throw new ServiceException("\u65b0\u5efa\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        List<NewCompanyGuideChangeRecordVo> currChangeList = this.currSupUserChangeListNew(loginUserId);
        if (CollUtil.isNotEmpty(currChangeList)) {
            List<Long> newCompanyIdList = NewCompanyGuideChangeRecordServiceImpl.parseStringToLongList(newCompanyIds);
            List idList = currChangeList.stream().filter(o -> newCompanyIdList.contains(o.getNewCompanyId())).map(NewCompanyGuideChangeRecordVo::getId).collect(Collectors.toList());
            String ids = CharSequenceUtil.join((CharSequence)",", idList);
            ((NewCompanyGuideChangeRecordMapper)this.dao).deleteByIds(ids);
        }
    }

    public List<NewCompanyGuideChangeRecordVo> currSupUserChangeListNew(Long loginUserId) {
        if (loginUserId == null) {
            throw new ServiceException("\u672a\u6307\u5b9a\u5f53\u524d\u767b\u5f55\u76d1\u7ba1\u7528\u6237id\uff01");
        }
        NewCompanyGuideChangeRecordModel changeRecordModel = new NewCompanyGuideChangeRecordModel();
        changeRecordModel.setCreateBy(loginUserId);
        changeRecordModel.setStatus(ChangeStatusEnum.NO_CONFIRM.getKey());
        return ((NewCompanyGuideChangeRecordMapper)this.dao).getCurrSupUserChangeList(changeRecordModel);
    }

    public PageInfo<NewCompanyChangePrevCurrVo> getChangeRecordPage(JqGridParam pageParam, NewCompanyGuideChangeRecordModel changeRecordModel) {
        Page changeRecordPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<NewCompanyChangePrevCurrVo> changeRecordList = ((NewCompanyGuideChangeRecordMapper)this.dao).getChangeRecordPage(changeRecordModel);
        NewCompanyGuideChangeRecordServiceImpl.setEnumFieldValue(changeRecordList);
        changeRecordList.stream().filter(c -> CharSequenceUtil.isBlank((CharSequence)c.getPrevTypeName())).forEach(c -> c.setPrevTypeName("-"));
        IntStream.range(0, changeRecordList.size()).forEach(i -> {
            NewCompanyChangePrevCurrVo rec = (NewCompanyChangePrevCurrVo)changeRecordList.get(i);
            ChangeTypeEnum prevTypeEnum = ChangeTypeEnum.getEnum((Byte)rec.getPrevType());
            ChangeTypeEnum currTypeEnum = ChangeTypeEnum.getEnum((Byte)rec.getCurrType());
            if (prevTypeEnum == ChangeTypeEnum.MIGRATED) {
                NewCompanyChangePrevCurrVo prevRec;
                NewCompanyChangePrevCurrVo newCompanyChangePrevCurrVo = prevRec = i + 1 < changeRecordList.size() ? (NewCompanyChangePrevCurrVo)changeRecordList.get(i + 1) : null;
                Byte prevType = prevRec == null ? (currTypeEnum == ChangeTypeEnum.HAZARD ? ChangeTypeEnum.NO_HAZARD.getKey() : (currTypeEnum == ChangeTypeEnum.NO_HAZARD ? ChangeTypeEnum.HAZARD.getKey() : null)) : prevRec.getPrevType();
                rec.setPrevType(prevType);
                rec.setPrevTypeName(ChangeTypeEnum.getValue((Byte)prevType));
            }
        });
        changeRecordList.forEach(r -> Optional.ofNullable(Convert.toLong((Object)r.getMaterials())).map(arg_0 -> ((ISysFileProvideService)this.sysFileProvideService).getFileById(arg_0)).ifPresent(arg_0 -> ((NewCompanyChangePrevCurrVo)r).setMaterialsFile(arg_0)));
        return new PageInfo((List)changeRecordPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<NewCompanyChangeImportModel>> getNewCompanyChangeInfoFromExcel(String fileUrl, Long loginRegionId, Byte loginRegionLevel) {
        Map<String, List<NewCompanyChangeImportModel>> changeInfoMap = Collections.emptyMap();
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)ExcelUtil.getInstance().getOssInputStream(fileUrl));
        }
        catch (Exception e) {
            log.error("\u65b0\u5efa\u4f01\u4e1a\u53d8\u66f4\u5bfc\u5165\u5931\u8d25::", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(wb)) {
                try {
                    Sheet sheet = wb.getSheetAt(0);
                    changeInfoMap = this.getNewCompanyChangeInfoFromSheet(sheet, loginRegionId, loginRegionLevel);
                    wb.close();
                }
                catch (IOException e) {
                    log.error("\u65b0\u5efa\u4f01\u4e1a\u53d8\u66f4\u5bfc\u5165\u5931\u8d25::", (Throwable)e);
                }
            }
        }
        return changeInfoMap;
    }

    @Transactional
    public int addNewCompanyChangeInfoFromDataList(List<NewCompanyChangeImportModel> dataList, Long loginRegionId, Long loginUserId, Byte nowType, Byte type) {
        if (CollUtil.isEmpty(dataList)) {
            return 0;
        }
        if (nowType == null) {
            throw new ServiceException("\u8bf7\u63d0\u4f9b\u5f53\u524d\u53d8\u66f4\u9875\u6570\u636e\u7c7b\u578bnowType\uff01");
        }
        if (type == null) {
            throw new ServiceException("\u53d8\u66f4\u7c7b\u578btype\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        NewCompanyGuideInfoModel newCompanyModel = new NewCompanyGuideInfoModel();
        newCompanyModel.setRegionId(loginRegionId);
        newCompanyModel.setType(nowType);
        List<NewCompanyGuideInfoVo> newCompanyChangeList = this.newCompanyGuideInfoMapper.getNewCompanyChangePage(newCompanyModel);
        if (CollUtil.isEmpty(newCompanyChangeList)) {
            throw new ServiceException("\u5f53\u524d\u9875\u9762\u65e0\u53ef\u8fdb\u884c\u53d8\u66f4\u7684\u6570\u636e\uff01");
        }
        List cnameList = newCompanyChangeList.stream().map(NewCompanyGuideInfoVo::getCname).collect(Collectors.toList());
        List uccList = newCompanyChangeList.stream().map(NewCompanyGuideInfoVo::getUcc).collect(Collectors.toList());
        List outList = dataList.stream().filter(d -> !cnameList.contains(d.getCname()) || !uccList.contains(d.getUcc())).map(NewCompanyChangeImportModel::getCname).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(outList)) {
            throw new ServiceException("\u4f01\u4e1a\uff1a" + String.valueOf(outList) + "\uff0c\u4e0d\u5728\u5f53\u524d\u9875\u9762\u53ef\u53d8\u66f4\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List cnameList1 = dataList.stream().map(NewCompanyChangeImportModel::getCname).collect(Collectors.toList());
        List uccList1 = dataList.stream().map(NewCompanyChangeImportModel::getUcc).collect(Collectors.toList());
        List outList1 = newCompanyChangeList.stream().filter(c -> cnameList1.contains(c.getCname()) && uccList1.contains(c.getUcc()) && c.getIsChoose() != false).map(NewCompanyGuideInfoVo::getCname).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(outList1)) {
            throw new ServiceException("\u4f01\u4e1a\uff1a" + String.valueOf(outList1) + "\uff0c\u5df2\u5904\u4e8e\u53d8\u66f4\u6e05\u5355\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        List cidList = dataList.stream().map(NewCompanyChangeImportModel::getCid).collect(Collectors.toList());
        Example example = new Example(NewCompanyGuideInfo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Boolean.TRUE).andIn("cid", cidList);
        List newCompanyList = this.newCompanyGuideInfoMapper.selectByExample(example);
        Map<Long, Long> cidNewCompanyIdMap = newCompanyList.stream().collect(Collectors.toMap(NewCompanyGuideInfo::getCid, NewCompanyGuideInfo::getId, (v1, v2) -> v2));
        ArrayList<NewCompanyGuideChangeRecord> changeList = new ArrayList<NewCompanyGuideChangeRecord>(dataList.size());
        Date now = new Date();
        for (NewCompanyChangeImportModel data : dataList) {
            Long cid = data.getCid();
            Long newCompanyId = cidNewCompanyIdMap.get(cid);
            NewCompanyGuideChangeRecord changeBean = new NewCompanyGuideChangeRecord();
            changeBean.setId(Long.valueOf(IdWorker.getId()));
            changeBean.setNewCompanyId(newCompanyId);
            changeBean.setStatus(ChangeStatusEnum.NO_CONFIRM.getKey());
            changeBean.setType(type);
            changeBean.setCreateBy(loginUserId);
            changeBean.setCreateDate(now);
            changeBean.setUpdatedBy(loginUserId);
            changeBean.setUpdateDate(now);
            changeList.add(changeBean);
        }
        return ((NewCompanyGuideChangeRecordMapper)this.dao).insertList2(changeList);
    }

    private Map<String, List<NewCompanyChangeImportModel>> getNewCompanyChangeInfoFromSheet(Sheet sheet, Long loginRegionId, Byte loginRegionLevel) {
        LinkedList<NewCompanyChangeImportModel> dataList = new LinkedList<NewCompanyChangeImportModel>();
        LinkedList<NewCompanyChangeImportModel> errDataList = new LinkedList<NewCompanyChangeImportModel>();
        int rowIndex = 0;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1 || rowIndex == 2 || this.isRowEmpty(row) || row.getZeroHeight()) continue;
            NewCompanyChangeImportModel data = new NewCompanyChangeImportModel();
            data.setSerial(Integer.valueOf(rowIndex - 2));
            if (this.validCellIsBlank(row.getCell(1))) {
                data.setHaveError(Boolean.TRUE);
                data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(2) + ", \u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
            } else {
                row.getCell(1).setCellType(CellType.STRING);
                String cname2 = row.getCell(1).getStringCellValue().trim();
                data.setCname(cname2);
            }
            if (this.validCellIsBlank(row.getCell(2))) {
                data.setHaveError(Boolean.TRUE);
                data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(3) + ", \u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
            } else {
                row.getCell(2).setCellType(CellType.STRING);
                String ucc2 = row.getCell(2).getStringCellValue().trim();
                data.setUcc(ucc2);
            }
            if (data.getHaveError().booleanValue()) {
                errDataList.add(data);
                continue;
            }
            dataList.add(data);
        }
        HashMap<Long, NewCompanyChangeImportModel> newCompanyDataMap = new HashMap<Long, NewCompanyChangeImportModel>();
        loginRegionLevel = loginRegionLevel > 2 ? (byte)0 : loginRegionLevel;
        if (CollUtil.isNotEmpty(dataList) && CollUtil.isEmpty(errDataList)) {
            Set cnameSet = dataList.stream().map(NewCompanyChangeImportModel::getCname).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
            List cnameModelCollection = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByNameExcludeDelete(new ArrayList(cnameSet));
            Map<Object, Object> cnameModelMap = new HashMap();
            if (CollUtil.isNotEmpty((Collection)cnameModelCollection)) {
                cnameModelMap = cnameModelCollection.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getName));
            }
            Set uccSet = dataList.stream().map(NewCompanyChangeImportModel::getUcc).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
            List uccModelCollection = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByUnitCode(new ArrayList(uccSet));
            Map<Object, Object> uccModelMap = new HashMap();
            if (CollUtil.isNotEmpty((Collection)uccModelCollection)) {
                uccModelMap = uccModelCollection.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
            }
            Map<String, String> uccCnameMap = dataList.stream().collect(Collectors.toMap(NewCompanyChangeImportModel::getUcc, NewCompanyChangeImportModel::getCname, (v1, v2) -> v2));
            List<NewCompanyGuideInfoVo> newCompanyCollection = this.newCompanyGuideInfoMapper.getNewCompanyInfoByUccCname(uccCnameMap);
            for (NewCompanyChangeImportModel data : dataList) {
                rowIndex = data.getSerial() + 2;
                List cnameModelList = (List)cnameModelMap.get(data.getCname());
                if (CollUtil.isNotEmpty((Collection)cnameModelList)) {
                    CompanySuperviseModel cnameModel = (CompanySuperviseModel)cnameModelList.get(0);
                    data.setCid(cnameModel.getId());
                    data.setBusinessStatus(cnameModel.getBusinessState());
                    if (Objects.equals(data.getUcc(), "0")) {
                        if (CharSequenceUtil.isNotBlank((CharSequence)cnameModel.getUnifiedSocialCc())) {
                            data.setHaveError(Boolean.TRUE);
                            data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\u8be5\u4f01\u4e1a\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u4fe1\u7528\u4ee3\u7801\uff0c\u8bf7\u6b63\u786e\u586b\u5199;<br/>");
                        }
                    } else if (!Objects.equals(data.getUcc(), cnameModel.getUnifiedSocialCc())) {
                        data.setHaveError(Boolean.TRUE);
                        data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\u4f01\u4e1a\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\uff0c\u4f46\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u76f8\u540c\uff0c\u8bf7\u6838\u5b9e;<br/>");
                    }
                    if (!this.containAuthArea(cnameModel.getAreaId(), loginRegionId)) {
                        data.setHaveError(Boolean.TRUE);
                        data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\u4f01\u4e1a\u4e0d\u5728\u8f96\u533a\u5185\uff0c\u8bf7\u6838\u5b9e;<br/>");
                    }
                    if (Objects.equals(cnameModel.getBusinessState().intValue(), CompanyBusinessState.CLOSE.getCode())) {
                        data.setHaveError(Boolean.TRUE);
                        data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\u4f01\u4e1a\u5df2\u5173\u95ed;<br/>");
                    }
                } else {
                    data.setHaveError(Boolean.TRUE);
                    data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ",\u4f01\u4e1a\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e;<br/>");
                }
                if (!Objects.equals(data.getUcc(), "0")) {
                    List uccModelList = (List)uccModelMap.get(data.getUcc());
                    if (CollUtil.isNotEmpty((Collection)uccModelList)) {
                        CompanySuperviseModel uccModel = (CompanySuperviseModel)uccModelList.get(0);
                        if (!Objects.equals(data.getUcc(), uccModel.getUnifiedSocialCc())) {
                            data.setHaveError(Boolean.TRUE);
                            data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(3) + ", \u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0d\u76f8\u540c\uff0c\u8bf7\u6838\u5b9e;<br/>");
                        }
                    } else {
                        data.setHaveError(Boolean.TRUE);
                        data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(3) + ", \u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e;<br/>");
                    }
                }
                String uccMatch = newCompanyCollection.stream().map(NewCompanyGuideInfoVo::getUcc).filter(ucc -> CharSequenceUtil.isNotBlank((CharSequence)data.getUcc()) && Objects.equals(data.getUcc().trim(), ucc)).findAny().orElse(null);
                String cnameMatch = newCompanyCollection.stream().map(NewCompanyGuideInfoVo::getCname).filter(cname -> CharSequenceUtil.isNotBlank((CharSequence)data.getCname()) && Objects.equals(data.getCname().trim(), cname)).findAny().orElse(null);
                if (uccMatch == null) {
                    data.setHaveError(Boolean.TRUE);
                    data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(3) + ", \u6b64\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u5c5e\u4e8e\u65b0\u5efa\u4f01\u4e1a\uff0c\u8bf7\u6838\u5b9e;<br/>");
                }
                if (cnameMatch == null) {
                    data.setHaveError(Boolean.TRUE);
                    data.setErrorReason(data.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + " , \u5217\u53f7\uff1a" + this.getExcelColName(2) + ", \u6b64\u4f01\u4e1a\u540d\u79f0\u4e0d\u5c5e\u4e8e\u65b0\u5efa\u4f01\u4e1a\uff0c\u8bf7\u6838\u5b9e;<br/>");
                }
                if (data.getHaveError().booleanValue()) {
                    errDataList.add(data);
                }
                newCompanyDataMap.put(data.getCid(), data);
            }
        }
        if (CollUtil.isEmpty(errDataList) && CollUtil.isNotEmpty(dataList) && newCompanyDataMap.size() < dataList.size()) {
            NewCompanyChangeImportModel data = new NewCompanyChangeImportModel();
            data.setHaveError(Boolean.TRUE);
            data.setErrorReason("\u8868\u683c\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff01\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u6838\u5bf9\u3002");
            errDataList.add(data);
        }
        HashMap<String, List<NewCompanyChangeImportModel>> changeInfoMap = new HashMap<String, List<NewCompanyChangeImportModel>>();
        if (CollUtil.isEmpty(errDataList)) {
            changeInfoMap.put(EXCEL_DATA, dataList);
        } else {
            changeInfoMap.put(EXCEL_ERROR_DATA, errDataList);
        }
        return changeInfoMap;
    }

    private boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell.getCellType() == CellType.BLANK) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean validCellIsBlank(Cell cell) {
        if (cell == null) {
            return Boolean.TRUE;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return Boolean.TRUE;
        }
        cell.setCellType(CellType.STRING);
        if (CharSequenceUtil.isBlank((CharSequence)cell.getStringCellValue().trim())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + (char)(65 + b - 1);
    }

    public boolean containAuthArea(Long regionId, Long loginRegionId) {
        if (loginRegionId == null || regionId == null) {
            return Boolean.FALSE;
        }
        if (Objects.equals(loginRegionId, 0L)) {
            return Boolean.TRUE;
        }
        String areaIdStr = regionId.toString();
        String orgAreaIdStr = loginRegionId.toString();
        areaIdStr = areaIdStr.replaceAll("(0+)$", "");
        orgAreaIdStr = orgAreaIdStr.replaceAll("(0+)$", "");
        return areaIdStr.startsWith(orgAreaIdStr);
    }

    public static List<Long> parseStringToLongList(String str) {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            return Collections.emptyList();
        }
        return Arrays.stream(str.split(",")).map(String::trim).filter(CharSequenceUtil::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
    }

    private static void setEnumFieldValue(List<NewCompanyChangePrevCurrVo> changeRecordList) {
        if (CollUtil.isNotEmpty(changeRecordList)) {
            changeRecordList.forEach(rec -> rec.setStatusName(ChangeStatusEnum.getValue((Byte)rec.getStatus())));
            changeRecordList.forEach(rec -> rec.setPrevTypeName(ChangeTypeEnum.getValue((Byte)rec.getPrevType())));
            changeRecordList.forEach(rec -> rec.setCurrTypeName(ChangeTypeEnum.getValue((Byte)rec.getCurrType())));
        }
    }

    @Generated
    public NewCompanyGuideChangeRecordServiceImpl(NewCompanyGuideInfoMapper newCompanyGuideInfoMapper) {
        this.newCompanyGuideInfoMapper = newCompanyGuideInfoMapper;
    }
}

