/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartDocMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicroWarnSignParam;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicroWarnSignVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarnSignSmartDocHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WarnSignSmartDocHandle.class);
    @Autowired
    protected MicrocomPreSmartContentMapper microcomPreSmartContentMapper;
    @Autowired
    protected MicrocomPreSmartDocMapper microcomPreSmartDocMapper;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.WARNSIGN;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cids, LocalDate generateDate, PreSmartDocStaskEvent staskEvent, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        MicroWarnSignParam protectParam = this.preSetWarnSignParam(cids, generateDate, staskEvent);
        List<MicroWarnSignVo> warnSignVoList = this.microcomPreSmartContentMapper.getMicroWarnSignList(protectParam, protectParam.getYear() - 2);
        List<MicrocomPreSmartContent> contentList = this.preSetContentList(cids, protectParam, warnSignVoList, cidRemindNumMap);
        return contentList;
    }

    private List<MicrocomPreSmartContent> preSetContentList(List<Long> cidList, MicroWarnSignParam param, List<MicroWarnSignVo> warnSignVoList, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        ArrayList<MicrocomPreSmartContent> contentList = new ArrayList<MicrocomPreSmartContent>();
        Map<Long, List<MicroWarnSignVo>> warnSignMap = warnSignVoList.stream().collect(Collectors.groupingBy(MicroWarnSignVo::getCid));
        Integer year = param.getYear();
        for (Long cid : cidList) {
            boolean shouldGenerate;
            Boolean noPersonProtect = Optional.ofNullable(warnSignMap.get(cid)).map(list -> list.stream().noneMatch(d -> d.getChangeTime().toInstant().atOffset(ZoneOffset.UTC).getYear() <= year && d.getChangeTime().toInstant().atOffset(ZoneOffset.UTC).getYear() >= year - 2)).orElse(Boolean.TRUE);
            Boolean lessThree = true;
            if (!cidRemindNumMap.isEmpty()) {
                lessThree = Optional.ofNullable(cidRemindNumMap.get(cid)).map(remind -> remind.getRemindNum() < 3).orElse(Boolean.FALSE);
            }
            if (!(shouldGenerate = noPersonProtect != false && lessThree != false)) continue;
            contentList.add(new MicrocomPreSmartContent(cid, this.getRiskType().getCode(), "\u65e0" + year + "\u5e74\u8b66\u793a\u6807\u8bc6", Integer.valueOf(11), null));
        }
        return contentList;
    }

    public MicroWarnSignParam preSetWarnSignParam(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event) {
        MicroWarnSignParam warnSignParam = new MicroWarnSignParam();
        warnSignParam.setCids(cidList);
        warnSignParam.setGenerateDate(generateDate);
        warnSignParam.setEvent(event.getKey());
        int generateYear = generateDate.getYear();
        int personYear = switch (event) {
            case PreSmartDocStaskEvent.YEAR_REMIND -> generateYear + 1;
            case PreSmartDocStaskEvent.RISK_REMIND, PreSmartDocStaskEvent.WORK_REMIND -> generateYear;
            default -> LocalDate.now().getYear();
        };
        warnSignParam.setYear(Integer.valueOf(personYear));
        return warnSignParam;
    }
}

