/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicroCompanyTsProjectSimpleParam;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartTemplateVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TsProjectSimplePreSmartDocRiskHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TsProjectSimplePreSmartDocRiskHandle.class);
    @Autowired
    protected MicrocomPreSmartContentMapper microcomPreSmartContentMapper;
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.THREESIMULTANEOUS;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        if (event != PreSmartDocStaskEvent.YEAR_REMIND && event != PreSmartDocStaskEvent.RISK_REMIND) {
            return Collections.emptyList();
        }
        MicroCompanyTsProjectSimpleParam tsParam = TsProjectSimplePreSmartDocRiskHandle.preSetTsParam(cidList, generateDate, event);
        List<MicrocomPreSmartContent> contentList = this.microcomPreSmartContentMapper.getMicroCompanyTsProjectSimpleList(tsParam);
        this.postSetTsContentList(contentList);
        return contentList;
    }

    private static MicroCompanyTsProjectSimpleParam preSetTsParam(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event) {
        MicroCompanyTsProjectSimpleParam tsParam = new MicroCompanyTsProjectSimpleParam();
        tsParam.setCidList(cidList);
        tsParam.setGenerateDate(generateDate);
        tsParam.setEvent(event.getKey());
        ArrayList statusList = ListUtil.toList((Object[])new Byte[]{TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.AUDIT.getCode(), TsProjectSimpleStatusEnum.BACK.getCode(), TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode()});
        tsParam.setStatusList((List)statusList);
        return tsParam;
    }

    private void postSetTsContentList(List<MicrocomPreSmartContent> contentList) {
        for (MicrocomPreSmartContent content : contentList) {
            content.setCode(this.getRiskType().getCode());
            String projectName = content.getDynamicData();
            String workName = Objects.equals(content.getEvalState(), TsProjectSimpleStateEnum.ING.getCode()) ? "\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7" : (Objects.equals(content.getDesignState(), TsProjectSimpleStateEnum.ING.getCode()) ? "\u804c\u4e1a\u75c5\u5371\u5bb3\u9632\u62a4\u8bbe\u65bd\u8bbe\u8ba1\u4e13\u7bc7" : (Objects.equals(content.getControlState(), TsProjectSimpleStateEnum.ING.getCode()) ? "\u804c\u4e1a\u75c5\u5371\u5bb3\u63a7\u5236\u6548\u679c\u8bc4\u4ef7" : "\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7"));
            JSONObject jsonObj = new JSONObject();
            jsonObj.set("projectName", (Object)projectName);
            jsonObj.set("workName", (Object)workName);
            String jsonData = JSONUtil.toJsonStr((JSON)jsonObj);
            content.setDynamicData(jsonData);
            content.setExpireMonth(Integer.valueOf(LocalDate.now().getMonthValue()));
        }
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchRiskData(List<Long> cids, Map<Long, Set<String>> cidBusinessIdMap) {
        ReformSearchVo reformSearchVo = new ReformSearchVo().setCidList(cids).setGenerationSource(ReformGenerationSourceEnum.THREE_TIME.getValue()).setIsCompleted(Boolean.valueOf(false)).setYear(Integer.valueOf(DateUtils.getThisYear()));
        List<String> existList = cidBusinessIdMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).flatMap(str -> Arrays.stream(str.split(","))).map(String::trim).filter(s -> !s.isEmpty()).distinct().toList();
        List<ReformItemBasic> reformCollection = this.itemBasicCommandService.getReformItemBasicList(reformSearchVo).stream().filter(itemBasic -> itemBasic != null && !cidBusinessIdMap.computeIfAbsent(itemBasic.getCid(), k -> new HashSet()).contains(itemBasic.getId().toString())).filter(r -> !existList.contains(r.getId().toString())).toList();
        if (CollUtil.isEmpty(reformCollection)) {
            return Collections.emptyList();
        }
        Map<Long, List<ReformItemBasic>> reformGroup = reformCollection.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        List<Long> cidList = reformCollection.stream().map(ReformItemBasic::getCid).toList();
        String code = RiskTypeEnum.THREESIMULTANEOUS.getCode();
        int currentMonth = DateUtils.getMonth((Date)new Date());
        MicroCompanyTsProjectSimpleParam tsParam = TsProjectSimplePreSmartDocRiskHandle.preSetTsParam(cidList, null, PreSmartDocStaskEvent.WORK_REMIND);
        List<MicrocomPreSmartContent> contentList = this.microcomPreSmartContentMapper.getMicroCompanyTsProjectSimpleList(tsParam);
        this.postSetTsContentList(contentList);
        for (MicrocomPreSmartContent content : contentList) {
            Long cid = content.getCid();
            List<ReformItemBasic> reformList = reformGroup.get(cid);
            if (CollUtil.isEmpty(reformList)) continue;
            ReformItemBasic reform = reformList.get(0);
            content.setBussinessId(reform.getId().toString());
            content.setExpireMonth(Integer.valueOf(currentMonth));
            content.setCode(code);
        }
        return contentList;
    }

    @Override
    public String generateFrontData(List<MicrocomPreSmartContentVo> contentList, MicrocomPreSmartTemplateVo template) {
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < contentList.size(); ++i) {
                MicrocomPreSmartContentVo content = contentList.get(i);
                String dynamicData = content.getDynamicData();
                if (StrUtil.isBlank((CharSequence)dynamicData)) continue;
                JSONObject jsonObject = JSONUtil.parseObj((String)dynamicData);
                String projectName = jsonObject.getStr((Object)"projectName");
                String workName = jsonObject.getStr((Object)"workName");
                sb.append("\u3010").append(projectName).append("\u3011\u9879\u76ee\u9700\u59d4\u6258\u6280\u672f\u670d\u52a1\u673a\u6784\u5f00\u5c55\u3010").append(workName).append("\u3011");
                if (i >= contentList.size() - 1) continue;
                sb.append("\uff1b");
            }
            String replaceData = sb.toString();
            String templateContent = template.getTemplate();
            String replacedTemplate = templateContent.replace("{tsMethod1}", replaceData);
            return replacedTemplate;
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u6253\u5370::\u6e32\u67d3\u6a21\u677f\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
            return "";
        }
    }
}

