/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.IQaRecordService;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartTemplateVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PhyRiskPreSmartDocHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhyRiskPreSmartDocHandle.class);
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;
    @DubboReference
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @DubboReference
    private IQaRecordService qaRecordService;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.PHYSICAL_EXCEPTION;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cids, LocalDate generateDate, PreSmartDocStaskEvent staskEvent, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        return null;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchRiskData(List<Long> cids, Map<Long, Set<String>> cidBusinessIdMap) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List existList = cidBusinessIdMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        ReformSearchVo reformSearchVo = new ReformSearchVo().setCidList(cids).setYear(Integer.valueOf(DateUtils.getYear((Date)new Date()))).setGenerationSources(List.of(Byte.valueOf((byte)4), Byte.valueOf((byte)5))).setIsCompleted(Boolean.valueOf(false)).setNotExistSourceIdList(existList);
        List<ReformItemBasic> basicList = this.itemBasicCommandService.getReformItemBasicList(reformSearchVo).stream().filter(item -> item != null && item.getReformItemSourceId() != null && StringUtils.isNotBlank((CharSequence)item.getTjBusinessId())).toList();
        ArrayList tjCidList = new ArrayList();
        ArrayList sourceIdList = new ArrayList();
        ArrayList tjBusinessIdList = new ArrayList();
        basicList.forEach(item -> {
            if (item == null) {
                return;
            }
            tjCidList.add(item.getCid());
            sourceIdList.add(item.getReformItemSourceId());
            tjBusinessIdList.add(item.getTjBusinessId());
        });
        Map<Long, List<PhcPhysicalStaffCheckInfo>> collect = this.phcPhysicalStaffCheckInfoService.getByCidAndSourceAndCardId(tjCidList, sourceIdList, tjBusinessIdList).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfo::getSourceId));
        ArrayList<MicrocomPreSmartContent> contentList = new ArrayList<MicrocomPreSmartContent>();
        int month = DateUtils.getMonth((Date)new Date());
        collect.forEach((sourceId, phyList) -> {
            String str2;
            if (CollectionUtils.isEmpty((Collection)phyList)) {
                return;
            }
            Long cid = ((PhcPhysicalStaffCheckInfo)phyList.get(0)).getCid();
            String dateStr = DateUtils.format((Date)((PhcPhysicalStaffCheckInfo)phyList.get(0)).getCheckTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5");
            StringBuilder dynamicData = new StringBuilder();
            dynamicData.append(dateStr).append("\u4f53\u68c0\u7ed3\u679c\u5b58\u5728\u5f02\u5e38");
            String str1 = phyList.stream().filter(phy -> phy != null && Objects.equals("4", phy.getConclusion())).map(PhcPhysicalStaffCheckInfo::getName).distinct().collect(Collectors.joining(","));
            if (StringUtils.isNotBlank((CharSequence)str1)) {
                dynamicData.append("\uff0c\u5b58\u5728\u804c\u4e1a\u7981\u5fcc\u8bc1\u4eba\u5458\uff1a").append(str1).append("\uff1b");
            }
            if (StringUtils.isNotBlank((CharSequence)(str2 = phyList.stream().filter(phy -> phy != null && Objects.equals("3", phy.getConclusion())).map(PhcPhysicalStaffCheckInfo::getName).distinct().collect(Collectors.joining(","))))) {
                dynamicData.append("\u5b58\u5728\u7591\u4f3c\u804c\u4e1a\u75c5\u4eba\u5458\uff1a").append(str2).append("\uff1b");
            }
            contentList.add(new MicrocomPreSmartContent(cid, RiskTypeEnum.PHYSICAL_EXCEPTION.getCode(), dynamicData.toString(), Integer.valueOf(month), sourceId.toString()));
        });
        return contentList;
    }

    @Override
    public String generateFrontData(List<MicrocomPreSmartContentVo> contentList, MicrocomPreSmartTemplateVo template) {
        if (CollectionUtils.isEmpty(contentList)) {
            return null;
        }
        StringBuilder frontData = new StringBuilder("\u4f53\u68c0\u5f02\u5e38\u7ed3\u679c\uff1a");
        for (MicrocomPreSmartContentVo contentVo : contentList) {
            if (contentVo == null) continue;
            String dynamicData = contentVo.getDynamicData();
            frontData.append(dynamicData).append("\n");
            frontData.append("\u4f53\u68c0\u5f02\u5e38\u5904\u7f6e\u5efa\u8bae\uff1a").append("\n");
            String templateStr = template.getTemplate();
            if (dynamicData.contains("\u804c\u4e1a\u7981\u5fcc\u8bc1")) {
                frontData.append(PhyRiskPreSmartDocHandle.getSection(templateStr, "\u804c\u4e1a\u7981\u5fcc\u8bc1")).append("\n");
            }
            if (!dynamicData.contains("\u7591\u4f3c\u804c\u4e1a\u75c5")) continue;
            frontData.append(PhyRiskPreSmartDocHandle.getSection(templateStr, "\u7591\u4f3c\u804c\u4e1a\u75c5")).append("\n");
        }
        return frontData.toString();
    }

    public static String getSection(String fullText, String sectionName) {
        String marker = "\u3010" + sectionName + "\u3011";
        int startIndex = fullText.indexOf(marker);
        if (startIndex == -1) {
            return null;
        }
        int nextIndex = -1;
        if ("\u804c\u4e1a\u7981\u5fcc\u8bc1".equals(sectionName)) {
            nextIndex = fullText.indexOf("\u3010\u7591\u4f3c\u804c\u4e1a\u75c5\u3011", startIndex + marker.length());
        } else if ("\u7591\u4f3c\u804c\u4e1a\u75c5".equals(sectionName) && (nextIndex = fullText.indexOf("\u3010\u804c\u4e1a\u7981\u5fcc\u8bc1\u3011", startIndex + marker.length())) == -1) {
            nextIndex = fullText.length();
        }
        if (nextIndex == -1) {
            return fullText.substring(startIndex);
        }
        return fullText.substring(startIndex, nextIndex);
    }
}

