/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PhcPhysicalPreSmartDocHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhcPhysicalPreSmartDocHandle.class);
    @DubboReference
    private IPhcPhysicalCheckV3221Service physicalCheckV3221Service;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.PHYSICALEXAMINATION;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent staskEvent, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        long startTime = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        int generateDateYear = generateDate.getYear();
        List<MicrocomPreSmartContent> list = null;
        if (staskEvent == PreSmartDocStaskEvent.YEAR_REMIND) {
            long stepStart = System.currentTimeMillis();
            List currentYearData = this.physicalCheckV3221Service.getLatestCheckData(cidList, generateDateYear);
            long dataQueryTime = System.currentTimeMillis() - stepStart;
            log.error("\u4f53\u68c0\u9884\u667a\u5355\u6570\u636e\u67e5\u8be2\u8017\u65f6\uff1a{}", (Object)dataQueryTime);
            stepStart = System.currentTimeMillis();
            list = this.buildMicrocomContentList(currentYearData, cidList);
            long dataBuildTime = System.currentTimeMillis() - stepStart;
            log.error("\u4f53\u68c0\u9884\u667a\u5355\u6570\u636e\u6784\u5efa\u8017\u65f6\uff1a{}", (Object)dataBuildTime);
        } else {
            list = this.handleMonthlyRemind(cidList, generateDate, generateDateYear);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        log.error("\u4f53\u68c0\u9884\u667a\u5355\u603b\u8017\u65f6\uff1a{}", (Object)totalTime);
        return this.postFilterOutFrequentReminders(list, cidRemindNumMap);
    }

    private List<MicrocomPreSmartContent> postFilterOutFrequentReminders(List<MicrocomPreSmartContent> contentList, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        if (CollUtil.isEmpty(contentList)) {
            return Collections.emptyList();
        }
        return contentList.stream().filter(content -> {
            PreSmartBussinessCommonParam remind = (PreSmartBussinessCommonParam)cidRemindNumMap.get(content.getCid());
            return remind == null || remind.getRemindNum() < 3;
        }).toList();
    }

    private List<MicrocomPreSmartContent> handleMonthlyRemind(List<Long> cidList, LocalDate generateDate, int generateDateYear) {
        int monthValue = generateDate.getMonthValue();
        boolean isDecember = monthValue == 12;
        int queryYear = isDecember ? generateDateYear : generateDateYear - 1;
        List lastYearData = this.physicalCheckV3221Service.getLatestCheckData(cidList, queryYear);
        if (!isDecember) {
            List currentYearData = this.physicalCheckV3221Service.getLatestCheckData(cidList, generateDateYear);
            Set<Long> currentYearCids = currentYearData.stream().map(PhcPhysicalStaffCheckInfo::getCid).collect(Collectors.toSet());
            return this.buildMicrocomContentListWithCondition(lastYearData, currentYearCids);
        }
        return this.buildMicrocomContentList(lastYearData, cidList);
    }

    private List<MicrocomPreSmartContent> buildMicrocomContentList(List<PhcPhysicalStaffCheckInfo> checkData, List<Long> cidList) {
        Map<Object, Object> checkMap = checkData != null && !checkData.isEmpty() ? checkData.stream().collect(Collectors.toMap(PhcPhysicalStaffCheckInfo::getCid, check -> check)) : new HashMap();
        return cidList.stream().map(cid -> {
            PhcPhysicalStaffCheckInfo check = (PhcPhysicalStaffCheckInfo)checkMap.get(cid);
            Integer month = check != null && check.getCheckTime() != null ? DateUtils.getMonth((Date)check.getCheckTime()) : 2;
            String cardId = check != null ? check.getCardId() : null;
            return new MicrocomPreSmartContent(cid, "02", null, month, cardId);
        }).toList();
    }

    private List<MicrocomPreSmartContent> buildMicrocomContentListWithCondition(List<PhcPhysicalStaffCheckInfo> checkData, Set<Long> excludeMonthCids) {
        return checkData.stream().map(check -> {
            Integer expireMonth = excludeMonthCids.contains(check.getCid()) ? null : Integer.valueOf(DateUtils.getMonth((Date)check.getCheckTime()));
            return new MicrocomPreSmartContent(check.getCid(), "02", null, expireMonth, check.getCardId());
        }).filter(content -> content.getExpireMonth() != null).toList();
    }
}

