/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartDocMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicroPersonProtectParam;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicroPersonProtectVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonProtectSmartDocHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonProtectSmartDocHandle.class);
    @Autowired
    protected MicrocomPreSmartDocMapper microcomPreSmartDocMapper;
    @Autowired
    protected MicrocomPreSmartContentMapper microcomPreSmartContentMapper;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.PROTECTEQUIPFIRST;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        MicroPersonProtectParam protectParam = this.preSetPersonProtectParam(cidList, generateDate, event);
        List<MicroPersonProtectVo> personProtectList = this.microcomPreSmartContentMapper.getMicroPersonProtectList(protectParam);
        List<MicrocomPreSmartContent> contentList = this.preSetContentList(cidList, protectParam, personProtectList, cidRemindNumMap);
        return contentList;
    }

    private List<MicrocomPreSmartContent> preSetContentList(List<Long> cidList, MicroPersonProtectParam protectParam, List<MicroPersonProtectVo> personProtectCollection, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        ArrayList<MicrocomPreSmartContent> contentList = new ArrayList<MicrocomPreSmartContent>();
        Map<Long, List<MicroPersonProtectVo>> personProtectMap = personProtectCollection.stream().collect(Collectors.groupingBy(MicroPersonProtectVo::getCid));
        Integer year = protectParam.getYear();
        for (Long cid : cidList) {
            boolean shouldGenerate;
            Boolean noPersonProtect = Optional.ofNullable(personProtectMap.get(cid)).map(list -> list.stream().noneMatch(d -> d.getIssuedTime().toInstant().atOffset(ZoneOffset.UTC).getYear() == year.intValue())).orElse(Boolean.TRUE);
            Boolean lessThree = true;
            if (!cidRemindNumMap.isEmpty()) {
                lessThree = Optional.ofNullable(cidRemindNumMap.get(cid)).map(remind -> remind.getRemindNum() < 3).orElse(Boolean.FALSE);
            }
            if (!(shouldGenerate = noPersonProtect != false && lessThree != false)) continue;
            contentList.add(new MicrocomPreSmartContent(cid, this.getRiskType().getCode(), "\u65e0" + year + "\u5e74\u4e2a\u4eba\u9632\u62a4", Integer.valueOf(11), null));
            System.out.println("\u751f\u6210");
        }
        return contentList;
    }

    public MicroPersonProtectParam preSetPersonProtectParam(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event) {
        MicroPersonProtectParam personProtectParam = new MicroPersonProtectParam();
        personProtectParam.setCids(cidList);
        personProtectParam.setGenerateDate(generateDate);
        personProtectParam.setEvent(event.getKey());
        int generateYear = generateDate.getYear();
        int personYear = switch (event) {
            case PreSmartDocStaskEvent.YEAR_REMIND -> generateYear + 1;
            case PreSmartDocStaskEvent.RISK_REMIND, PreSmartDocStaskEvent.WORK_REMIND -> generateYear;
            default -> LocalDate.now().getYear();
        };
        personProtectParam.setYear(Integer.valueOf(personYear));
        return personProtectParam;
    }
}

