/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.hutool.core.convert.Convert;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartDocMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicroCompanyDeclareParam;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicroCompanyDeclareVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeclarePreSmartDocRiskHandle
implements PreSmartDocBusinessDataService {
    @Autowired
    protected MicrocomPreSmartDocMapper microcomPreSmartDocMapper;
    @Autowired
    protected MicrocomPreSmartContentMapper microcomPreSmartContentMapper;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.DECLARE;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        MicroCompanyDeclareParam declareParam = this.preSetDeclareParam(cidList, generateDate, event);
        List<MicroCompanyDeclareVo> declareCollection = this.microcomPreSmartContentMapper.getMicroCompanyDeclareList(declareParam);
        List<MicrocomPreSmartContent> contentList = this.postSetDeclareContentList(cidList, declareParam, declareCollection, cidRemindNumMap);
        return contentList;
    }

    private List<MicrocomPreSmartContent> postSetDeclareContentList(List<Long> cidList, MicroCompanyDeclareParam declareParam, List<MicroCompanyDeclareVo> declareCollection, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        Map<Long, List<MicroCompanyDeclareVo>> declareMap = declareCollection.stream().collect(Collectors.groupingBy(MicroCompanyDeclareVo::getCid));
        String declareYear = declareParam.getDeclareYear();
        ArrayList<MicrocomPreSmartContent> contentList = new ArrayList<MicrocomPreSmartContent>();
        for (Long cid : cidList) {
            Boolean noDeclare = Optional.ofNullable(declareMap.get(cid)).map(list -> list.stream().noneMatch(d -> Objects.equals(d.getDeclareYear(), declareYear))).orElse(Boolean.TRUE);
            Boolean lessThree = Optional.ofNullable(cidRemindNumMap.get(cid)).map(remind -> remind.getRemindNum() < 3).orElse(Boolean.TRUE);
            boolean shouldGenerate = noDeclare != false && lessThree != false;
            if (!shouldGenerate) continue;
            contentList.add(new MicrocomPreSmartContent(cid, this.getRiskType().getCode(), "\u65e0" + declareYear + "\u5e74\u7533\u62a5\u6570\u636e", Integer.valueOf(11), null));
        }
        return contentList;
    }

    public MicroCompanyDeclareParam preSetDeclareParam(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event) {
        MicroCompanyDeclareParam declareParam = new MicroCompanyDeclareParam();
        declareParam.setCidList(cidList);
        declareParam.setGenerateDate(generateDate);
        declareParam.setEvent(event.getKey());
        int generateYear = generateDate.getYear();
        int declareYear = switch (event) {
            case PreSmartDocStaskEvent.YEAR_REMIND -> generateYear + 1;
            case PreSmartDocStaskEvent.RISK_REMIND, PreSmartDocStaskEvent.WORK_REMIND -> generateYear;
            default -> LocalDate.now().getYear();
        };
        declareParam.setDeclareYear(Convert.toStr((Object)declareYear));
        return declareParam;
    }
}

