/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartTemplateVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.EvQueryParam;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CheckPreSmartDocHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckPreSmartDocHandle.class);
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.CHECK;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cids, LocalDate generateDate, PreSmartDocStaskEvent staskEvent, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        int generateDateYear = generateDate.getYear();
        if (staskEvent == PreSmartDocStaskEvent.YEAR_REMIND) {
            return this.getPreSmartDocByYearRemind(cids, cidRemindNumMap, ++generateDateYear);
        }
        if (staskEvent == PreSmartDocStaskEvent.WORK_REMIND) {
            int monthValue = generateDate.getMonthValue();
            List<MicrocomPreSmartContent> contentList = this.getPreSmartDocByYearRemind(cids, cidRemindNumMap, generateDateYear);
            if (CollectionUtils.isEmpty(contentList)) {
                return contentList;
            }
            return contentList.stream().filter(content -> {
                if (content.getDynamicData().contains("\u73b0\u72b6")) {
                    return List.of(Integer.valueOf(content.getExpireMonth() - 2), Integer.valueOf(content.getExpireMonth() - 1), content.getExpireMonth()).contains(monthValue);
                }
                if (content.getDynamicData().contains("\u5b9a\u671f")) {
                    return List.of(Integer.valueOf(content.getExpireMonth() - 1), content.getExpireMonth()).contains(monthValue);
                }
                return false;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<MicrocomPreSmartContent> getPreSmartDocByYearRemind(List<Long> cidList, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap, int year) {
        ArrayList<MicrocomPreSmartContent> list = new ArrayList<MicrocomPreSmartContent>();
        List seriousCidList = this.itemBasicCommandService.getCompanyList(cidList, "\u4e25\u91cd\u4f01\u4e1a");
        EvQueryParam param = new EvQueryParam().setCidList(cidList).setCheckTypeList(Arrays.asList(2L, 3L, 4L)).setStartTime(LocalDateTime.of(year - 3, 1, 1, 0, 0, 0));
        Map<Long, List<RiskExposeEvaluate>> riskMap = this.riskExposeEvaluateService.getListByParam(param, null).stream().filter(item -> item != null && item.getCheckDate() != null && item.getCheckType() != null).sorted(Comparator.comparing(RiskExposeEvaluate::getCheckDate, Comparator.reverseOrder()).thenComparing(BaseEntity::getUpdateDate, Comparator.reverseOrder())).collect(Collectors.groupingBy(RiskExposeEvaluate::getCid));
        cidList.forEach(cid -> {
            List riskList = riskMap.get(cid) == null ? new ArrayList() : (List)riskMap.get(cid);
            PreSmartBussinessCommonParam generateNum = (PreSmartBussinessCommonParam)cidRemindNumMap.get(cid);
            if (generateNum != null && generateNum.getRemindNum() >= 4) {
                return;
            }
            if (seriousCidList.contains(cid)) {
                if (riskList.stream().noneMatch(risk -> risk != null && risk.getCheckDate().getYear() >= year - 2 && Objects.equals(3L, risk.getCheckType()))) {
                    Integer expireMonth = riskList.stream().filter(risk -> risk != null && risk.getCheckDate().getYear() == year - 3 && risk.getCheckType() == 3L).map(RiskExposeEvaluate::getCheckDate).map(LocalDateTime::getMonthValue).findFirst().orElse(2);
                    boolean flag = riskList.stream().anyMatch(risk -> risk != null && risk.getCheckDate().getYear() == year && risk.getCheckType() == 3L);
                    if (flag) {
                        return;
                    }
                    list.add(new MicrocomPreSmartContent(cid, RiskTypeEnum.CHECK.getCode(), "\u4e25\u91cd\u4f01\u4e1a\uff0c\u9700\u8981\u751f\u6210\u73b0\u72b6", expireMonth, null));
                } else {
                    if (generateNum != null && generateNum.getRemindNum() >= 3) {
                        return;
                    }
                    Integer expireMonth = riskList.stream().filter(risk -> risk != null && risk.getCheckDate().getYear() == year - 1).map(RiskExposeEvaluate::getCheckDate).map(LocalDateTime::getMonthValue).findFirst().orElse(2);
                    boolean flag = riskList.stream().anyMatch(risk -> risk != null && risk.getCheckDate().getYear() == year);
                    if (flag) {
                        return;
                    }
                    list.add(new MicrocomPreSmartContent(cid, RiskTypeEnum.CHECK.getCode(), "\u4e25\u91cd\u4f01\u4e1a\uff0c\u9700\u8981\u751f\u6210\u5b9a\u671f", expireMonth, null));
                }
            } else if (riskList.stream().noneMatch(risk -> risk != null && risk.getCheckDate().getYear() >= year - 2)) {
                if (generateNum != null && generateNum.getRemindNum() >= 3) {
                    return;
                }
                Integer expireMonth = riskList.stream().filter(risk -> risk != null && risk.getCheckDate().getYear() == year - 3).map(RiskExposeEvaluate::getCheckDate).map(LocalDateTime::getMonthValue).findFirst().orElse(2);
                boolean flag = riskList.stream().anyMatch(risk -> risk != null && risk.getCheckDate().getYear() == year);
                if (flag) {
                    return;
                }
                list.add(new MicrocomPreSmartContent(cid, RiskTypeEnum.CHECK.getCode(), "\u4e00\u822c\u4f01\u4e1a\uff0c\u9700\u8981\u751f\u6210\u5b9a\u671f", expireMonth, null));
            }
        });
        return list;
    }

    @Override
    public String generateFrontData(List<MicrocomPreSmartContentVo> contentList, MicrocomPreSmartTemplateVo template) {
        if (CollectionUtils.isEmpty(contentList)) {
            return null;
        }
        String frontData = null;
        for (MicrocomPreSmartContentVo contentVo : contentList) {
            if (contentVo == null || StringUtils.isBlank((CharSequence)contentVo.getDynamicData())) continue;
            String str = "";
            if (contentVo.getDynamicData().contains("\u5b9a\u671f")) {
                str = "\u5b9a\u671f\u68c0\u6d4b";
            } else if (contentVo.getDynamicData().contains("\u73b0\u72b6")) {
                str = "\u73b0\u72b6\u8bc4\u4ef7";
            }
            frontData = template.getTemplate().replace("${type}", str);
        }
        return frontData;
    }
}

