/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.common.IQaRecordService;
import cn.smarthse.modules.common.model.QaRecord;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartTemplateVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CheckOverPreSmartDocHandle
implements PreSmartDocBusinessDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckOverPreSmartDocHandle.class);
    @DubboReference
    private IQaRecordService qaRecordService;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.JJCB;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cids, LocalDate generateDate, PreSmartDocStaskEvent staskEvent, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        return null;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchRiskData(List<Long> cids, Map<Long, Set<String>> cidBusinessIdMap) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List existList = cidBusinessIdMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        List qaRecords = this.qaRecordService.listByType(cids, this.getRiskType().getCode(), existList);
        ArrayList<MicrocomPreSmartContent> contentList = new ArrayList<MicrocomPreSmartContent>();
        int month = DateUtils.getMonth((Date)new Date());
        qaRecords.stream().filter(Objects::nonNull).forEach(qaRecord -> contentList.add(new MicrocomPreSmartContent(qaRecord.getCid(), RiskTypeEnum.JJCB.getCode(), qaRecord.getAnswerContent(), Integer.valueOf(month), qaRecord.getBusinessId())));
        return contentList;
    }

    @Override
    public String generateFrontData(List<MicrocomPreSmartContentVo> contentList, MicrocomPreSmartTemplateVo template) {
        if (CollectionUtils.isEmpty(contentList)) {
            return null;
        }
        String bussinessId = contentList.get(0).getBussinessId();
        QaRecord qaRecord = this.qaRecordService.getByBusinessId(bussinessId, this.getRiskType().getCode());
        String frontData = null;
        for (MicrocomPreSmartContentVo contentVo : contentList) {
            if (contentVo == null) continue;
            frontData = template.getTemplate().replace("${reformStart}", qaRecord.getRemarks()).replace("${reformAdvise}", contentVo.getDynamicData());
        }
        return frontData;
    }
}

