/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service.handle;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartDocMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicroCompanyCertStaffDetailParam;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartTemplateVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertStaffDetailPreSmartDocRiskHandle
implements PreSmartDocBusinessDataService {
    @Autowired
    protected MicrocomPreSmartDocMapper microcomPreSmartDocMapper;
    @Autowired
    protected MicrocomPreSmartContentMapper microcomPreSmartContentMapper;

    @Override
    public RiskTypeEnum getRiskType() {
        return RiskTypeEnum.TRAINING;
    }

    @Override
    public Collection<MicrocomPreSmartContent> fetchBusinessData(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        MicroCompanyCertStaffDetailParam certParam = this.preSetCertParam(cidList, generateDate, event);
        List<MicrocomPreSmartContent> contentCollection = this.microcomPreSmartContentMapper.getMicroCompanyCertStaffDetailList(certParam);
        this.postProcessNoCertDataCompany(cidList, contentCollection);
        contentCollection = this.postFilterOutFrequentReminders(contentCollection, cidRemindNumMap);
        this.postSetCertContentList(contentCollection);
        return contentCollection;
    }

    private void postProcessNoCertDataCompany(List<Long> cidList, List<MicrocomPreSmartContent> contentCollection) {
        Map<Long, List<MicrocomPreSmartContent>> contentGroup = contentCollection.stream().collect(Collectors.groupingBy(MicrocomPreSmartContent::getCid));
        for (Long cid : cidList) {
            List<MicrocomPreSmartContent> contentList = contentGroup.get(cid);
            if (!CollUtil.isEmpty(contentList)) continue;
            MicrocomPreSmartContent content = new MicrocomPreSmartContent(cid, this.getRiskType().getCode(), null, Integer.valueOf(LocalDate.now().getMonthValue()), null);
            contentCollection.add(content);
        }
    }

    private MicroCompanyCertStaffDetailParam preSetCertParam(List<Long> cidList, LocalDate generateDate, PreSmartDocStaskEvent event) {
        MicroCompanyCertStaffDetailParam certParam = new MicroCompanyCertStaffDetailParam();
        certParam.setCidList(cidList);
        certParam.setGenerateDate(generateDate);
        certParam.setEvent(event.getKey());
        return certParam;
    }

    private List<MicrocomPreSmartContent> postFilterOutFrequentReminders(List<MicrocomPreSmartContent> contentList, Map<Long, PreSmartBussinessCommonParam> cidRemindNumMap) {
        if (CollUtil.isEmpty(contentList)) {
            return Collections.emptyList();
        }
        return contentList.stream().filter(content -> {
            PreSmartBussinessCommonParam remind = (PreSmartBussinessCommonParam)cidRemindNumMap.get(content.getCid());
            return remind == null || remind.getRemindNum() < 3;
        }).toList();
    }

    private void postSetCertContentList(List<MicrocomPreSmartContent> contentList) {
        for (MicrocomPreSmartContent content : contentList) {
            content.setCode(this.getRiskType().getCode());
            Long certId = content.getCertId();
            String staffName = content.getStaffName();
            JSONObject jsonObj = new JSONObject();
            jsonObj.set("certId", (Object)certId);
            jsonObj.set("staffName", (Object)staffName);
            String jsonData = JSONUtil.toJsonStr((JSON)jsonObj);
            content.setDynamicData(jsonData);
        }
    }

    @Override
    public String generateFrontData(List<MicrocomPreSmartContentVo> contentList, MicrocomPreSmartTemplateVo template) {
        String staffNameStr;
        List<Object> certIdList = new ArrayList();
        ArrayList<String> staffNameList = new ArrayList<String>();
        for (MicrocomPreSmartContentVo content : contentList) {
            String dynamicData = content.getDynamicData();
            if (StrUtil.isBlank((CharSequence)dynamicData)) continue;
            JSONObject jsonObject = JSONUtil.parseObj((String)dynamicData);
            Long certId = jsonObject.getLong((Object)"certId");
            String staffName = jsonObject.getStr((Object)"staffName");
            certIdList.add(certId);
            staffNameList.add(staffName);
        }
        certIdList = certIdList.stream().filter(Objects::nonNull).toList();
        Set certIdSet = Set.copyOf(certIdList);
        boolean empty = certIdList.isEmpty();
        boolean both = certIdSet.contains(12L) && certIdSet.contains(13L);
        boolean onlyOne = certIdSet.equals(Set.of(Long.valueOf(12L))) || certIdSet.equals(Set.of(Long.valueOf(13L)));
        List staffNameDistinctList = staffNameList.stream().distinct().toList();
        String string = staffNameStr = CollUtil.isNotEmpty(staffNameDistinctList) ? String.join((CharSequence)"\u3001", staffNameDistinctList) : null;
        if (empty) {
            return CertStaffDetailPreSmartDocRiskHandle.getReplacedData(template, "\u4e3b\u8981\u8d1f\u8d23\u4eba\u548c\u7ba1\u7406\u4eba\u5458\u5747\u65e0\u6570\u636e", null);
        }
        if (both) {
            return CertStaffDetailPreSmartDocRiskHandle.getReplacedData(template, "\u4eba\u5458\uff1a" + staffNameStr, null);
        }
        if (onlyOne) {
            return CertStaffDetailPreSmartDocRiskHandle.getReplacedData(template, "\u4eba\u5458\uff1a" + staffNameStr, "\uff0c\u4ee5\u53ca\u5176\u4ed6\u76f8\u5173\u4eba\u5458");
        }
        return template.getTemplate();
    }

    private static String getReplacedData(MicrocomPreSmartTemplateVo template, String replaceData, String suffix) {
        String frontData = template.getTemplate();
        if (StrUtil.isNotBlank((CharSequence)suffix)) {
            replaceData = (String)replaceData + suffix;
        }
        if (StrUtil.isNotBlank((CharSequence)replaceData)) {
            frontData = frontData.replace("{frontData}", (CharSequence)replaceData);
        }
        return frontData;
    }
}

