/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.service.PreSmartDocRiskDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartDocVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RiskDataGeneratorFactory {
    private final Map<RiskTypeEnum, PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo>> generatorMap;

    @Autowired
    public RiskDataGeneratorFactory(List<PreSmartDocRiskDataService> generators) {
        this.generatorMap = generators.stream().collect(Collectors.toMap(PreSmartDocRiskDataService::getRiskType, generator -> generator));
    }

    public <T extends MicrocomPreSmartDocVo> PreSmartDocRiskDataService<T> getGenerator(RiskTypeEnum type) {
        PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo> generator = this.generatorMap.get(type);
        if (generator == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u751f\u6210\u5668: " + String.valueOf(type));
        }
        return generator;
    }

    public List<PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo>> getAllGenerators() {
        return new ArrayList<PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo>>(this.generatorMap.values());
    }

    public Set<RiskTypeEnum> getRiskTypes() {
        return this.generatorMap.keySet();
    }
}

