/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.service.PreSmartDocRiskDataService;
import cn.smarthse.modules.health.micro.service.RiskDataGeneratorFactory;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartDocVo;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class RiskDataGenerateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskDataGenerateService.class);
    @Autowired
    private RiskDataGeneratorFactory generatorFactory;

    @Async
    public void generateAllRiskData(Long cid) {
        List<PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo>> generators = this.generatorFactory.getAllGenerators();
        generators.parallelStream().forEach(generator -> {
            try {
                this.generateWithGenerator(cid, (PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo>)generator);
            }
            catch (Exception e) {
                log.error("\u751f\u6210{}\u6570\u636e\u5931\u8d25", (Object)generator.getRiskType().getName(), (Object)e);
            }
        });
    }

    public void generateSpecificRiskData(Long cid, RiskTypeEnum type) {
        PreSmartDocRiskDataService generator = this.generatorFactory.getGenerator(type);
        this.generateWithGenerator(cid, generator);
    }

    public void generateMultipleRiskData(Long cid, Set<RiskTypeEnum> types) {
        types.parallelStream().forEach(type -> {
            try {
                PreSmartDocRiskDataService generator = this.generatorFactory.getGenerator((RiskTypeEnum)type);
                this.generateWithGenerator(cid, generator);
            }
            catch (Exception e) {
                log.error("\u751f\u6210{}\u6570\u636e\u5931\u8d25", (Object)type.getName(), (Object)e);
            }
        });
    }

    private void generateWithGenerator(Long cid, PreSmartDocRiskDataService<? extends MicrocomPreSmartDocVo> generator) {
        generator.generate(cid);
        log.info("\u751f\u6210{}\u6570\u636e\u6210\u529f\uff0c\u4f01\u4e1aID: {}", (Object)generator.getRiskType().getName(), (Object)cid);
    }
}

