/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreSmartDocBusinessGeneratorFactory {
    private final Map<RiskTypeEnum, PreSmartDocBusinessDataService> generatorMap;

    @Autowired
    public PreSmartDocBusinessGeneratorFactory(List<PreSmartDocBusinessDataService> generators) {
        this.generatorMap = generators.stream().collect(Collectors.toMap(PreSmartDocBusinessDataService::getRiskType, generator -> generator));
    }

    public PreSmartDocBusinessDataService getGenerator(RiskTypeEnum type) {
        PreSmartDocBusinessDataService generator = this.generatorMap.get(type);
        if (generator == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u751f\u6210\u5668: " + String.valueOf(type));
        }
        return generator;
    }

    public List<PreSmartDocBusinessDataService> getAllGenerators() {
        return new ArrayList<PreSmartDocBusinessDataService>(this.generatorMap.values());
    }

    public Set<RiskTypeEnum> getRiskTypes() {
        return this.generatorMap.keySet();
    }
}

