/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartPlan;
import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartPlanParam;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartPlanService;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessGeneratorFactory;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import cn.smarthse.snowflake.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreSmartDataGenerateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreSmartDataGenerateService.class);
    @Autowired
    private PreSmartDocBusinessGeneratorFactory generatorFactory;
    @Autowired
    private IMicrocomPreSmartPlanService planService;
    @Autowired
    private IdWorker idWorker;

    public void generateYearWorkRemindData(List<Long> cids, LocalDate generateDate, PreSmartDocStaskEvent staskEvent) {
        if (Objects.equals(staskEvent, PreSmartDocStaskEvent.RISK_REMIND)) {
            return;
        }
        Set<Object> businessDataServiceSet = new HashSet();
        if (Objects.equals(staskEvent, PreSmartDocStaskEvent.WORK_REMIND)) {
            businessDataServiceSet = this.generatorFactory.getAllGenerators().stream().filter(g -> g.workRemindDate().contains(MonthDay.from(generateDate))).collect(Collectors.toSet());
        } else if (Objects.equals(staskEvent, PreSmartDocStaskEvent.YEAR_REMIND)) {
            businessDataServiceSet = this.generatorFactory.getAllGenerators().stream().collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(businessDataServiceSet)) {
            return;
        }
        if (CollectionUtils.isEmpty(cids)) {
            List microcomPreSmartPlanVos = this.planService.listMicrocom();
            if (CollectionUtils.isEmpty((Collection)microcomPreSmartPlanVos)) {
                return;
            }
            cids = microcomPreSmartPlanVos.stream().map(item -> item.getCid()).collect(Collectors.toList());
        }
        for (List cidListPartition : ListUtil.partition(cids, (int)1000)) {
            ArrayList<MicrocomPreSmartContent> contents = new ArrayList<MicrocomPreSmartContent>();
            for (PreSmartDocBusinessDataService preSmartDocBusinessDataService : businessDataServiceSet) {
                XxlJobHelper.log((String)"\u6267\u884c\u4efb\u52a1\u5f00\u59cb\uff1a{}", (Object[])new Object[]{preSmartDocBusinessDataService.getRiskType().getName()});
                List<MicrocomPreSmartContent> microcomPreSmartContents = this.generateMicrocomPreSmartContent(preSmartDocBusinessDataService, cidListPartition, generateDate, staskEvent);
                XxlJobHelper.log((String)"\u6267\u884c\u4efb\u52a1\u7ed3\u675f\uff1a{}", (Object[])new Object[]{preSmartDocBusinessDataService.getRiskType().getName()});
                if (!CollectionUtils.isNotEmpty(microcomPreSmartContents)) continue;
                contents.addAll(microcomPreSmartContents);
            }
            if (!CollectionUtils.isNotEmpty(contents)) continue;
            Set hasContentCidSet = contents.stream().map(item -> item.getCid()).collect(Collectors.toSet());
            Map<Long, MicrocomPreSmartPlan> map = this.generatePlanMap(hasContentCidSet.stream().toList(), generateDate, staskEvent, null);
            for (MicrocomPreSmartContent content : contents) {
                content.setPlanId(map.get(content.getCid()).getId());
            }
            if (!MapUtil.isNotEmpty(map)) continue;
            this.planService.batchSave(map.values().stream().toList(), contents);
        }
    }

    private Map<Long, MicrocomPreSmartPlan> generatePlanMap(List<Long> cidListPartition, LocalDate generateDate, PreSmartDocStaskEvent staskEvent, String riskName) {
        HashMap<Long, MicrocomPreSmartPlan> cidPlanMap = new HashMap<Long, MicrocomPreSmartPlan>();
        for (Long cid : cidListPartition) {
            MicrocomPreSmartPlan plan = new MicrocomPreSmartPlan();
            plan.setCid(cid);
            plan.setEffectYear(Integer.valueOf(generateDate.getYear()));
            plan.setId(Long.valueOf(this.idWorker.nextId()));
            plan.setType(staskEvent.getKey());
            plan.setCreateDate(LocalDateTime.now());
            plan.setUpdateDate(LocalDateTime.now());
            plan.setGenerateTime(LocalDateTime.now());
            plan.setIsValid(Boolean.valueOf(true));
            Object title = "";
            if (staskEvent == PreSmartDocStaskEvent.YEAR_REMIND) {
                plan.setEffectYear(Integer.valueOf(generateDate.getYear() + 1));
                title = plan.getEffectYear() + "\u5e74\u804c\u4e1a\u75c5\u9632\u6cbb\u5de5\u4f5c\u5efa\u8bae";
            } else if (staskEvent == PreSmartDocStaskEvent.WORK_REMIND) {
                title = "\u5de5\u4f5c\u63d0\u9192";
            } else if (staskEvent == PreSmartDocStaskEvent.RISK_REMIND) {
                title = riskName + "\u98ce\u9669\u9488\u5bf9\u6027\u89e3\u51b3\u5efa\u8bae";
            }
            plan.setTitle((String)title);
            cidPlanMap.put(cid, plan);
        }
        return cidPlanMap;
    }

    private String generateBusinessKey(Long cid, Byte type) {
        String businessIdKey = DateUtil.format((Date)new Date(), (String)"yyyyMMdd");
        return cid + "_" + businessIdKey + "_" + type;
    }

    public List<MicrocomPreSmartContent> generateMicrocomPreSmartContent(PreSmartDocBusinessDataService businessGenerateService, List<Long> cids, LocalDate generateDate, PreSmartDocStaskEvent staskEvent) {
        MicrocomPreSmartPlanParam param = new MicrocomPreSmartPlanParam();
        if (generateDate == null) {
            generateDate = LocalDate.now();
        }
        if (Objects.equals(staskEvent, PreSmartDocStaskEvent.YEAR_REMIND)) {
            param.setEffectYear(Integer.valueOf(generateDate.getYear() + 1));
        }
        param.setCids(cids);
        param.setType(staskEvent.getKey());
        param.setCode(businessGenerateService.getRiskType().getCode());
        List collectRemindGt2List = this.planService.countRemindByCode(param);
        Map<Object, Object> cidRemindNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)collectRemindGt2List)) {
            cidRemindNumMap = collectRemindGt2List.stream().collect(Collectors.toMap(k -> k.getCid(), v -> v));
        }
        ArrayList<Long> removeList = new ArrayList<Long>();
        boolean cusControllRemindTimes = businessGenerateService.cusControllRemindTimes();
        for (Long cidTemp : cids) {
            String businessKey;
            PreSmartBussinessCommonParam remindNum;
            if (cusControllRemindTimes || (remindNum = (PreSmartBussinessCommonParam)cidRemindNumMap.get(cidTemp)) == null) continue;
            Set businessKeySet = CommonUtil.str2Set((String)remindNum.getBussinessId(), (String)",");
            if (businessKeySet.contains(businessKey = this.generateBusinessKey(cidTemp, staskEvent.getKey()))) {
                removeList.add(cidTemp);
                continue;
            }
            if (Objects.equals(staskEvent, PreSmartDocStaskEvent.YEAR_REMIND) && remindNum != null && remindNum.getRemindNum() > 0) {
                removeList.add(cidTemp);
            }
            if (remindNum == null || remindNum.getRemindNum() <= 2) continue;
            removeList.add(cidTemp);
        }
        List<Long> validCidList = cids.stream().filter(item -> !removeList.contains(item)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(validCidList)) {
            return Collections.emptyList();
        }
        Collection<MicrocomPreSmartContent> microcomPreSmartContents = businessGenerateService.fetchBusinessData(validCidList, generateDate, staskEvent, cidRemindNumMap);
        if (CollectionUtils.isEmpty(microcomPreSmartContents)) {
            return Collections.emptyList();
        }
        Map<Long, List<MicrocomPreSmartContent>> smartContentGroupByCid = microcomPreSmartContents.stream().collect(Collectors.groupingBy(item -> item.getCid()));
        ArrayList<MicrocomPreSmartContent> contents = new ArrayList<MicrocomPreSmartContent>();
        for (Long validCid : validCidList) {
            List<MicrocomPreSmartContent> microcomPreSmartContents1 = smartContentGroupByCid.get(validCid);
            if (!CollectionUtils.isNotEmpty(microcomPreSmartContents1)) continue;
            for (MicrocomPreSmartContent microcomPreSmartContent : microcomPreSmartContents1) {
                microcomPreSmartContent.setId(Long.valueOf(this.idWorker.nextId()));
                microcomPreSmartContent.setCreateDate(LocalDateTime.now());
                microcomPreSmartContent.setUpdateDate(LocalDateTime.now());
                microcomPreSmartContent.setIsValid(Boolean.valueOf(true));
                String businessKey = this.generateBusinessKey(validCid, staskEvent.getKey());
                microcomPreSmartContent.setBussinessId(businessKey);
            }
        }
        if (CollectionUtils.isNotEmpty(microcomPreSmartContents)) {
            contents.addAll(microcomPreSmartContents);
        }
        return contents;
    }

    public void generateRiskRemindPreSmart(PreSmartDocBusinessDataService businessGenerateService, List<Long> cids, LocalDate generateDate) {
        if (CollectionUtils.isEmpty(cids)) {
            List microcomPreSmartPlanVos = this.planService.listMicrocom();
            if (CollectionUtils.isEmpty((Collection)microcomPreSmartPlanVos)) {
                return;
            }
            cids = microcomPreSmartPlanVos.stream().map(item -> item.getCid()).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(cids)) {
            return;
        }
        for (List cidListPart : ListUtil.partition(cids, (int)1000)) {
            this.doGenerateRiskMicrocomPreSmartContent(businessGenerateService, cidListPart, generateDate);
        }
    }

    private void doGenerateRiskMicrocomPreSmartContent(PreSmartDocBusinessDataService businessGenerateService, List<Long> cids, LocalDate generateDate) {
        Collection<MicrocomPreSmartContent> microcomPreSmartContents;
        PreSmartDocStaskEvent event = businessGenerateService.getRiskType() == RiskTypeEnum.THREESIMULTANEOUS ? PreSmartDocStaskEvent.WORK_REMIND : PreSmartDocStaskEvent.RISK_REMIND;
        MicrocomPreSmartPlanParam param = new MicrocomPreSmartPlanParam();
        if (generateDate == null) {
            generateDate = LocalDate.now();
        }
        param.setEffectYear(Integer.valueOf(generateDate.getYear()));
        param.setCids(cids);
        param.setType(event.getKey());
        param.setCode(businessGenerateService.getRiskType().getCode());
        List collectRemindGt2List = this.planService.countRemindByCode(param);
        Map<Long, Set<String>> cid2BusinessIdMap = new HashMap<Long, Set<String>>();
        if (CollectionUtils.isNotEmpty((Collection)collectRemindGt2List)) {
            cid2BusinessIdMap = collectRemindGt2List.stream().collect(Collectors.groupingBy(k -> k.getCid(), Collectors.flatMapping(item -> CommonUtil.str2Set((String)item.getBussinessId(), (String)",").stream(), Collectors.toSet())));
        }
        if (CollectionUtils.isEmpty(microcomPreSmartContents = businessGenerateService.fetchRiskData(cids, cid2BusinessIdMap))) {
            return;
        }
        Map<Long, List<MicrocomPreSmartContent>> smartContentGroupByCid = microcomPreSmartContents.stream().collect(Collectors.groupingBy(item -> item.getCid()));
        ArrayList<MicrocomPreSmartContent> contents = new ArrayList<MicrocomPreSmartContent>();
        Map<Long, MicrocomPreSmartPlan> cidPlanMap = this.generatePlanMap(smartContentGroupByCid.keySet().stream().toList(), generateDate, event, businessGenerateService.getRiskType().getName());
        for (Long validCid : cids) {
            MicrocomPreSmartPlan plan = cidPlanMap.get(validCid);
            List<MicrocomPreSmartContent> microcomPreSmartContents1 = smartContentGroupByCid.get(validCid);
            if (!CollectionUtils.isNotEmpty(microcomPreSmartContents1)) continue;
            for (MicrocomPreSmartContent microcomPreSmartContent : microcomPreSmartContents1) {
                microcomPreSmartContent.setId(Long.valueOf(this.idWorker.nextId()));
                microcomPreSmartContent.setPlanId(plan.getId());
                microcomPreSmartContent.setCreateDate(LocalDateTime.now());
                microcomPreSmartContent.setUpdateDate(LocalDateTime.now());
                microcomPreSmartContent.setIsValid(Boolean.valueOf(true));
            }
            contents.addAll(microcomPreSmartContents1);
        }
        this.planService.batchSave(cidPlanMap.values().stream().toList(), contents);
    }
}

