/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartPlanMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartPlan;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartPlanParam;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartPlanService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartPlanVo;
import cn.smarthse.modules.health.micro.vo.PreSmartBussinessCommonParam;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class MicrocomPreSmartPlanServiceImpl
extends BaseServiceImpl<MicrocomPreSmartPlanMapper, MicrocomPreSmartPlan>
implements IMicrocomPreSmartPlanService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrocomPreSmartPlanServiceImpl.class);
    @Autowired
    MicrocomPreSmartContentMapper contentMapper;

    public List<MicrocomPreSmartPlanVo> listMicrocom() {
        return ((MicrocomPreSmartPlanMapper)this.dao).listMicrocom();
    }

    public List<PreSmartBussinessCommonParam> countRemindByCode(MicrocomPreSmartPlanParam param) {
        List<PreSmartBussinessCommonParam> preSmartBussinessCommonParams = ((MicrocomPreSmartPlanMapper)this.dao).listRemindByCode(param);
        if (CollectionUtils.isEmpty(preSmartBussinessCommonParams)) {
            return null;
        }
        Map<Long, List<PreSmartBussinessCommonParam>> cidSmartPlanMap = preSmartBussinessCommonParams.stream().collect(Collectors.groupingBy(PreSmartBussinessCommonParam::getCid));
        ArrayList<PreSmartBussinessCommonParam> rlist = new ArrayList<PreSmartBussinessCommonParam>();
        for (Long cid : cidSmartPlanMap.keySet()) {
            List<PreSmartBussinessCommonParam> cidReminds = cidSmartPlanMap.get(cid);
            PreSmartBussinessCommonParam result = new PreSmartBussinessCommonParam();
            result.setCid(cid);
            result.setType(cidReminds.get(0).getType());
            result.setEffectYear(cidReminds.get(0).getEffectYear());
            result.setRemindNum(cidReminds.size());
            Set businessIds = cidReminds.stream().map(PreSmartBussinessCommonParam::getBussinessId).collect(Collectors.toSet());
            result.setBussinessId(StringUtils.join(businessIds, (String)","));
            rlist.add(result);
        }
        return rlist;
    }

    public List<Long> listNoMicrocomPreSmartPlan(MicrocomPreSmartPlanParam param) {
        if (param.getType() == null || param.getEffectYear() == null) {
            return null;
        }
        return ((MicrocomPreSmartPlanMapper)this.dao).listNoMicrocomPreSmartPlan(param);
    }

    @Transactional(readOnly=false)
    public void batchSave(List<MicrocomPreSmartPlan> plans, List<MicrocomPreSmartContent> contents) {
        if (CollectionUtils.isNotEmpty(plans)) {
            for (List microcomPreSmartPlans : ListUtil.partition(plans, (int)1000)) {
                ((MicrocomPreSmartPlanMapper)this.dao).insertList2(microcomPreSmartPlans);
            }
        }
        if (CollectionUtils.isNotEmpty(contents)) {
            for (List microcomPreSmartContent : ListUtil.partition(contents, (int)1000)) {
                this.contentMapper.insertList2(microcomPreSmartContent);
            }
        }
    }

    public PageInfo<MicrocomPreSmartPlanVo> getMicrocomPreSmartPlanPage(JqGridParam pageParam, MicrocomPreSmartPlanParam planParam) {
        if (planParam == null || planParam.getCid() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Page planPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<MicrocomPreSmartPlanVo> planList = ((MicrocomPreSmartPlanMapper)this.dao).getMicrocomPreSmartPlanList(planParam);
        return new PageInfo((List)planPage);
    }

    public MicrocomPreSmartPlanVo preSmartPlanTip(MicrocomPreSmartPlanParam planParam) {
        MicrocomPreSmartPlanVo prePlanVo = new MicrocomPreSmartPlanVo();
        Example example = new Example(MicrocomPreSmartPlan.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Boolean.TRUE);
        criteria.andEqualTo("cid", (Object)planParam.getCid());
        example.setOrderByClause("create_date DESC");
        List prePlanList = ((MicrocomPreSmartPlanMapper)this.dao).selectByExample(example);
        if (CollUtil.isNotEmpty((Collection)prePlanList)) {
            MicrocomPreSmartPlan prePlan = (MicrocomPreSmartPlan)prePlanList.get(0);
            BeanUtil.copyProperties((Object)prePlan, (Object)prePlanVo, (String[])new String[0]);
        }
        return prePlanVo;
    }
}

