/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanyHsePreventionControlSelfJudge;
import cn.smarthse.modules.health.entity.base.selfjudge.MicroCompanySelfInspectionRiskAssessmentReportInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.vo.MicroCompanySelfInspectionRiskAssessmentReportV314Vo;
import cn.smarthse.modules.health.entity.base.wmbase.WarnSignManage;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemBasicView;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStatusEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartDocMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartDoc;
import cn.smarthse.modules.health.micro.param.MicroCompanyCertStaffDetailParam;
import cn.smarthse.modules.health.micro.param.MicroCompanyDeclareParam;
import cn.smarthse.modules.health.micro.param.MicroCompanyTsProjectSimpleParam;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartDocParam;
import cn.smarthse.modules.health.micro.param.MicrocomProcessGuideParam;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartDocService;
import cn.smarthse.modules.health.micro.service.RiskDataGenerateService;
import cn.smarthse.modules.health.micro.vo.MicroCompanyCertStaffDetailVo;
import cn.smarthse.modules.health.micro.vo.MicroCompanyDeclareVo;
import cn.smarthse.modules.health.micro.vo.MicroCompanyTsProjectSimpleVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartDocVo;
import cn.smarthse.modules.health.micro.vo.MicrocomProcessGuideVo;
import cn.smarthse.modules.health.service.base.selfjudge.IMicroCompanySelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.services.hfi.api.entity.riskev.MicroCompanyRiskExposeEvaluate;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
public class MicrocomPreSmartDocServiceImpl
extends BaseServiceImpl<MicrocomPreSmartDocMapper, MicrocomPreSmartDoc>
implements IMicrocomPreSmartDocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrocomPreSmartDocServiceImpl.class);
    @DubboReference
    private IMicroCompanySelfInspectionRiskAssessmentReportInfoService selfInspectionRiskAssessmentReportInfoService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @Autowired
    private RiskDataGenerateService riskDataGenerateService;
    @Autowired
    private ThreadPoolTaskExecutor poolTaskExecutor;

    public List<MicrocomPreSmartDocVo> getMicrocomPreSmartDocList(MicrocomPreSmartDocParam docParam) {
        MicrocomPreSmartDocServiceImpl.preParameterVerification(docParam);
        List<MicrocomPreSmartDocVo> docList = ((MicrocomPreSmartDocMapper)this.dao).getMicrocomPreSmartDocList(docParam);
        MicrocomPreSmartDocServiceImpl.postSetEnumName(docList);
        return docList;
    }

    public MicrocomProcessGuideVo getProcessGuideData(MicrocomProcessGuideParam guideParam) {
        if (guideParam == null || guideParam.getCid() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        MicrocomProcessGuideVo guideVo = new MicrocomProcessGuideVo();
        guideVo.setCid(guideParam.getCid());
        CountDownLatch latch = new CountDownLatch(2);
        this.poolTaskExecutor.execute(() -> {
            try {
                this.setClassSelfInspectionStatus(guideParam, guideVo);
            }
            finally {
                latch.countDown();
            }
        });
        this.poolTaskExecutor.execute(() -> {
            try {
                this.setCompanyRiskResolveStatus(guideParam, guideVo);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return guideVo;
    }

    private void setClassSelfInspectionStatus(MicrocomProcessGuideParam guideParam, MicrocomProcessGuideVo guideVo) {
        JqGridParam param = new JqGridParam();
        param.setCid(guideParam.getCid());
        param.setPage(1);
        param.setRows(10);
        PageInfo riskPage = this.selfInspectionRiskAssessmentReportInfoService.listPageDataV314(param);
        List riskList = riskPage.getList();
        if (CollUtil.isNotEmpty((Collection)riskList)) {
            Long id = ((MicroCompanySelfInspectionRiskAssessmentReportV314Vo)riskList.get(0)).getId();
            MicroCompanySelfInspectionRiskAssessmentReportV314Vo risk = this.selfInspectionRiskAssessmentReportInfoService.getV314VoById(id);
            MicroCompanyHsePreventionControlSelfJudge selfJudge = risk.getSelfJudge();
            MicroCompanyRiskExposeEvaluate exposeEvaluate = risk.getRiskExposeEvaluate();
            MicroCompanySelfInspectionRiskAssessmentReportInfo report = risk.getReportInfo();
            if (selfJudge != null) {
                guideVo.setSelfJudgeStatus(selfJudge.getStatus());
            }
            if (exposeEvaluate != null) {
                guideVo.setExposeEvaluateStatus(Convert.toByte((Object)exposeEvaluate.getReportStatus()));
            }
            if (report != null) {
                guideVo.setRiskAssessmentReportStatus(report.getStatus());
            }
        }
    }

    private void setCompanyRiskResolveStatus(MicrocomProcessGuideParam guideParam, MicrocomProcessGuideVo guideVo) {
        Boolean hasData;
        ReformSearchVo searchVo = new ReformSearchVo();
        searchVo.setCid(guideParam.getCid());
        searchVo.setRequireNoneRiskDifferentiation(Boolean.TRUE);
        List countViewList = this.reformItemBasicNewService.getReformItemBasicCountView(searchVo);
        Boolean hasRisks = CollUtil.isEmpty((Collection)countViewList) ? Boolean.FALSE : ((ReformItemBasicView)countViewList.get(0)).getHasRisks();
        Boolean bl = hasData = CollUtil.isEmpty((Collection)countViewList) ? Boolean.FALSE : ((ReformItemBasicView)countViewList.get(0)).getHasData();
        int companyRiskResolveStatus = Boolean.TRUE.equals(hasRisks) ? 2 : (Boolean.TRUE.equals(hasData) ? 3 : 1);
        guideVo.setCompanyRiskResolveStatus(Convert.toByte((Object)companyRiskResolveStatus));
    }

    public List<MicroCompanyDeclareVo> getMicroCompanyDeclareList(MicroCompanyDeclareParam dParam) {
        if (dParam.getCid() == null) {
            return Collections.emptyList();
        }
        return ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyDeclareList(dParam);
    }

    public List<MicroCompanyCertStaffDetailVo> getMicroCompanyCertStaffDetailList(MicroCompanyCertStaffDetailParam certParam) {
        if (certParam.getCid() == null) {
            return Collections.emptyList();
        }
        return ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyCertStaffDetailList(certParam);
    }

    public void generatePreSmartCertStaffDetailInfo(MicroCompanyCertStaffDetailParam certParam) {
        boolean isDecemberFirst;
        if (certParam == null) {
            certParam = new MicroCompanyCertStaffDetailParam();
        }
        Long cid = certParam.getCid();
        List cidList = certParam.getCidList();
        LocalDate currentDate = certParam.getCurrentDate();
        if (Objects.equals(certParam.getGenerateNumber(), 1) && !(isDecemberFirst = MicrocomPreSmartDocServiceImpl.isDecemberFirst(currentDate))) {
            return;
        }
        if (CollUtil.isEmpty((Collection)cidList) && cid != null) {
            cidList = ListUtil.toList((Object[])new Long[]{cid});
        }
        if (CollUtil.isEmpty((Collection)cidList)) {
            return;
        }
        int currentYear = currentDate == null ? LocalDate.now().getYear() : currentDate.getYear();
        int chooseYear = currentYear + 1;
        certParam.setChooseYear(Integer.valueOf(chooseYear));
        int batchSize = 1000;
        List batchPartition = Lists.partition((List)cidList, (int)batchSize);
        for (List batchCidList : batchPartition) {
            this.processPreSmartCertBatch(certParam, batchCidList);
        }
    }

    public List<MicroCompanyTsProjectSimpleVo> getMicroCompanyTsProjectSimpleList(MicroCompanyTsProjectSimpleParam tsParam) {
        if (tsParam.getCid() == null) {
            return Collections.emptyList();
        }
        if (MicrocomPreSmartDocServiceImpl.isDecemberFirst()) {
            // empty if block
        }
        return ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyTsProjectSimpleList(tsParam);
    }

    public void generatePreSmartTsProjectSimpleInfo(MicroCompanyTsProjectSimpleParam tsParam) {
        boolean isDecemberFirst;
        if (tsParam == null) {
            tsParam = new MicroCompanyTsProjectSimpleParam();
        }
        Long cid = tsParam.getCid();
        List cidList = tsParam.getCidList();
        LocalDate currentDate = tsParam.getCurrentDate();
        if (Objects.equals(tsParam.getGenerateNumber(), 1) && !(isDecemberFirst = MicrocomPreSmartDocServiceImpl.isDecemberFirst(currentDate))) {
            return;
        }
        if (Objects.equals(tsParam.getGenerateNumber(), 2)) {
            // empty if block
        }
        if (CollUtil.isEmpty((Collection)cidList) && cid != null) {
            cidList = ListUtil.toList((Object[])new Long[]{cid});
        }
        if (CollUtil.isEmpty((Collection)cidList)) {
            return;
        }
        int currentYear = currentDate == null ? LocalDate.now().getYear() : currentDate.getYear();
        int chooseYear = currentYear + 1;
        ArrayList statusList = ListUtil.toList((Object[])new Byte[]{TsProjectSimpleStatusEnum.DRAFT.getCode(), TsProjectSimpleStatusEnum.AUDIT.getCode(), TsProjectSimpleStatusEnum.BACK.getCode(), TsProjectSimpleStatusEnum.PROJECT_MANDATORY_ANNUAL_UPDATE.getCode()});
        tsParam.setChooseYear(Integer.valueOf(chooseYear));
        tsParam.setStatusList((List)statusList);
        int batchSize = 1000;
        List batchPartition = Lists.partition((List)cidList, (int)batchSize);
        for (List batchCidList : batchPartition) {
            this.processPreSmartTsBatch(tsParam, batchCidList);
        }
    }

    private void processPreSmartCertBatch(MicroCompanyCertStaffDetailParam certParam, List<Long> batchCidList) {
        LocalDateTime now = LocalDateTime.now();
        certParam.setCidList(batchCidList);
        List<MicroCompanyCertStaffDetailVo> certList = ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyCertStaffDetailList(certParam);
        if (CollUtil.isEmpty(certList)) {
            return;
        }
        MicrocomPreSmartDocParam docParam = new MicrocomPreSmartDocParam();
        docParam.setType(Byte.valueOf(RiskTypeEnum.TRAINING.getValue()));
        docParam.setCidList(batchCidList);
        List<MicrocomPreSmartDocVo> docList = ((MicrocomPreSmartDocMapper)this.dao).getMicrocomPreSmartDocSimpleList(docParam);
        List<MicroCompanyCertStaffDetailVo> filteredCertList = certList.stream().filter(t -> docList.stream().noneMatch(d -> Objects.equals(d.getBusinessId(), t.getId()))).toList();
        if (CollUtil.isEmpty(filteredCertList)) {
            return;
        }
        ArrayList<MicrocomPreSmartDoc> insertDocList = new ArrayList<MicrocomPreSmartDoc>();
        for (MicroCompanyCertStaffDetailVo cert : filteredCertList) {
            MicrocomPreSmartDoc doc = new MicrocomPreSmartDoc();
            doc.setId(Long.valueOf(IdWorker.getId()));
            doc.setCid(cert.getCid());
            doc.setBusinessId(cert.getId());
            if (cert.getValidityDate() != null) {
                int month = cert.getValidityDate().getMonthValue();
                doc.setMonth(Integer.valueOf(month));
            }
            doc.setType(Byte.valueOf(RiskTypeEnum.TRAINING.getValue()));
            doc.setValue(cert.getStaffName());
            doc.setIsValid(Boolean.TRUE);
            doc.setCreateBy(certParam.getCreateBy());
            doc.setCreateDate(now);
            doc.setUpdateBy(certParam.getUpdateBy());
            doc.setUpdateDate(now);
            insertDocList.add(doc);
        }
        if (CollUtil.isNotEmpty(insertDocList)) {
            ((MicrocomPreSmartDocMapper)this.dao).insertList2(insertDocList);
        }
    }

    private void generateBusinessData(MicrocomPreSmartDocParam docParam, List<MicrocomPreSmartDocVo> docList) {
        LocalDateTime now = LocalDateTime.now();
        MicroCompanyCertStaffDetailParam certParam = new MicroCompanyCertStaffDetailParam();
        BeanUtils.copyProperties((Object)docParam, (Object)certParam);
        List<MicroCompanyCertStaffDetailVo> certList = ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyCertStaffDetailList(certParam);
        if (CollUtil.isEmpty(certList)) {
            return;
        }
        List<MicroCompanyCertStaffDetailVo> filteredCertList = certList.stream().filter(t -> docList.stream().noneMatch(d -> Objects.equals(d.getBusinessId(), t.getId()))).toList();
        if (CollUtil.isEmpty(filteredCertList)) {
            return;
        }
        ArrayList<MicrocomPreSmartDoc> insertDocList = new ArrayList<MicrocomPreSmartDoc>();
        for (MicroCompanyCertStaffDetailVo cert : filteredCertList) {
            MicrocomPreSmartDoc doc = new MicrocomPreSmartDoc();
            doc.setId(Long.valueOf(IdWorker.getId()));
            doc.setCid(cert.getCid());
            doc.setBusinessId(cert.getId());
            if (cert.getValidityDate() != null) {
                int month = cert.getValidityDate().getMonthValue();
                doc.setMonth(Integer.valueOf(month));
            }
            doc.setType(Byte.valueOf(RiskTypeEnum.TRAINING.getValue()));
            doc.setValue(cert.getStaffName());
            doc.setIsValid(Boolean.TRUE);
            doc.setCreateBy(docParam.getCreateBy());
            doc.setCreateDate(now);
            doc.setUpdateBy(docParam.getUpdateBy());
            doc.setUpdateDate(now);
            insertDocList.add(doc);
        }
        if (CollUtil.isNotEmpty(insertDocList)) {
            ((MicrocomPreSmartDocMapper)this.dao).insertList2(insertDocList);
        }
    }

    private void processPreSmartTsBatch(MicroCompanyTsProjectSimpleParam tsParam, List<Long> batchCidList) {
        LocalDateTime now = LocalDateTime.now();
        tsParam.setCidList(batchCidList);
        List<MicroCompanyTsProjectSimpleVo> tsList = ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyTsProjectSimpleList(tsParam);
        if (CollUtil.isEmpty(tsList)) {
            return;
        }
        MicrocomPreSmartDocParam docParam = new MicrocomPreSmartDocParam();
        docParam.setType(Byte.valueOf(RiskTypeEnum.THREESIMULTANEOUS.getValue()));
        docParam.setCidList(batchCidList);
        List<MicrocomPreSmartDocVo> docList = ((MicrocomPreSmartDocMapper)this.dao).getMicrocomPreSmartDocSimpleList(docParam);
        List<MicroCompanyTsProjectSimpleVo> filteredTsList = tsList.stream().filter(t -> docList.stream().noneMatch(d -> Objects.equals(d.getBusinessId(), t.getId()))).toList();
        if (CollUtil.isEmpty(filteredTsList)) {
            return;
        }
        ArrayList<MicrocomPreSmartDoc> insertDocList = new ArrayList<MicrocomPreSmartDoc>();
        for (MicroCompanyTsProjectSimpleVo ts : filteredTsList) {
            MicrocomPreSmartDoc doc = new MicrocomPreSmartDoc();
            doc.setId(Long.valueOf(IdWorker.getId()));
            doc.setCid(ts.getCid());
            doc.setBusinessId(ts.getId());
            if (ts.getProjectTime() != null) {
                int month = ts.getProjectTime().getMonthValue();
                doc.setMonth(Integer.valueOf(month));
            }
            doc.setType(Byte.valueOf(RiskTypeEnum.THREESIMULTANEOUS.getValue()));
            String projectName = ts.getProjectName();
            String workName = this.getTsWorkName(ts);
            doc.setValue(projectName + "-" + workName + ",");
            doc.setIsValid(Boolean.TRUE);
            doc.setCreateBy(tsParam.getCreateBy());
            doc.setCreateDate(now);
            doc.setUpdateBy(tsParam.getUpdateBy());
            doc.setUpdateDate(now);
            insertDocList.add(doc);
        }
        if (CollUtil.isNotEmpty(insertDocList)) {
            ((MicrocomPreSmartDocMapper)this.dao).insertList2(insertDocList);
        }
    }

    public String getTsWorkName(MicroCompanyTsProjectSimpleVo ts) {
        String workName = Objects.equals(ts.getEvalState(), TsProjectSimpleStateEnum.ING.getCode()) ? "\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7" : (Objects.equals(ts.getDesignState(), TsProjectSimpleStateEnum.ING.getCode()) ? "\u804c\u4e1a\u75c5\u5371\u5bb3\u9632\u62a4\u8bbe\u65bd\u8bbe\u8ba1\u4e13\u7bc7" : (Objects.equals(ts.getControlState(), TsProjectSimpleStateEnum.ING.getCode()) ? "\u804c\u4e1a\u75c5\u5371\u5bb3\u63a7\u5236\u6548\u679c\u8bc4\u4ef7" : ""));
        return workName;
    }

    private List<Long> getMicroCompanyIdList() {
        return ((MicrocomPreSmartDocMapper)this.dao).getMicroCompanyIdList();
    }

    private static void preParameterVerification(MicrocomPreSmartDocParam docParam) {
        if (docParam == null || docParam.getCid() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (docParam.getMonth() == null) {
            int month = LocalDate.now().getMonthValue();
            docParam.setMonth(Integer.valueOf(month));
        }
    }

    private static void postSetEnumName(List<MicrocomPreSmartDocVo> docList) {
        docList.forEach(doc -> doc.setTypeName(RiskTypeEnum.getNameByValue((Byte)doc.getType())));
    }

    public static boolean isDecemberFirst() {
        return MicrocomPreSmartDocServiceImpl.isDecemberFirst(LocalDate.now());
    }

    public static boolean isDecemberFirst(String zoneId) {
        return MicrocomPreSmartDocServiceImpl.isDecemberFirst(LocalDate.now(ZoneId.of(zoneId)));
    }

    public static boolean isDecemberFirst(LocalDate date) {
        LocalDate targetDate = date != null ? date : LocalDate.now();
        return targetDate.getMonthValue() == 12 && targetDate.getDayOfMonth() == 1;
    }

    @Transactional
    public List<WarnSignManage> getWarnSignData(List<Long> cids, Integer year) {
        return ((MicrocomPreSmartDocMapper)this.dao).selectWarnSignData(cids, year);
    }

    public List<ProtectEquipIssueRecord> getProtectEquipData(List<Long> cids, Integer year) {
        return ((MicrocomPreSmartDocMapper)this.dao).selectProtectEquipData(cids, year);
    }

    public void generatePreSmartInfo(MicrocomPreSmartDocParam param) {
        if (param == null || param.getCid() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long cid = param.getCid();
        this.riskDataGenerateService.generateSpecificRiskData(cid, RiskTypeEnum.THREESIMULTANEOUS);
    }

    @Generated
    public MicrocomPreSmartDocServiceImpl() {
    }
}

