/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.enums.reform.RiskTypeEnum;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartContentMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartContent;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartContentParam;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartTemplateParam;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartContentService;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartTemplateService;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessDataService;
import cn.smarthse.modules.health.micro.service.PreSmartDocBusinessGeneratorFactory;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartContentVo;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartTemplateVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class MicrocomPreSmartContentServiceImpl
extends BaseServiceImpl<MicrocomPreSmartContentMapper, MicrocomPreSmartContent>
implements IMicrocomPreSmartContentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrocomPreSmartContentServiceImpl.class);
    @DubboReference
    private IMicrocomPreSmartTemplateService microcomPreSmartTemplateService;
    @Autowired
    private PreSmartDocBusinessGeneratorFactory generatorFactory;

    public List<MicrocomPreSmartContentVo> getMicrocomPreSmartContentList(MicrocomPreSmartContentParam contentParam) {
        MicrocomPreSmartContentServiceImpl.preParameterVerification(contentParam);
        List<MicrocomPreSmartContentVo> contentList = ((MicrocomPreSmartContentMapper)this.dao).getMicrocomPreSmartContentList(contentParam);
        contentList = this.postIntegrateSameTypeDataAndRenderTemplateByMonth(contentList);
        this.postSortContentList(contentList);
        return contentList;
    }

    private static void preParameterVerification(MicrocomPreSmartContentParam contentParam) {
        if (contentParam == null || contentParam.getCid() == null || contentParam.getPlanId() == null) {
            throw new RuntimeException("\u4f01\u4e1aid\u3001\u65b9\u6848id \u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
    }

    private List<MicrocomPreSmartContentVo> postIntegrateSameTypeDataAndRenderTemplate(List<MicrocomPreSmartContentVo> contentList) {
        ArrayList<MicrocomPreSmartContentVo> returnList = new ArrayList<MicrocomPreSmartContentVo>();
        MicrocomPreSmartTemplateParam tmpParam = new MicrocomPreSmartTemplateParam();
        List tmpList = this.microcomPreSmartTemplateService.getMicrocomPreSmartTemplateList(tmpParam);
        Map<String, MicrocomPreSmartTemplateVo> tmpMap = tmpList.stream().collect(Collectors.toMap(MicrocomPreSmartTemplateVo::getCode, t -> t, (v1, v2) -> v2));
        Map<String, List<MicrocomPreSmartContentVo>> contentMap = contentList.stream().collect(Collectors.groupingBy(MicrocomPreSmartContentVo::getCode));
        for (Map.Entry<String, List<MicrocomPreSmartContentVo>> contentEntry : contentMap.entrySet()) {
            String code = contentEntry.getKey();
            RiskTypeEnum type = RiskTypeEnum.getByCode((String)code);
            List<MicrocomPreSmartContentVo> typeContentList = contentEntry.getValue();
            MicrocomPreSmartTemplateVo tmp = tmpMap.get(code);
            if (type == null || CollUtil.isEmpty(typeContentList)) continue;
            MicrocomPreSmartContentVo frontContent = new MicrocomPreSmartContentVo();
            BeanUtils.copyProperties((Object)typeContentList.get(0), (Object)frontContent);
            Map<RiskTypeEnum, PreSmartDocBusinessDataService> generatorMap = this.generatorFactory.getAllGenerators().stream().collect(Collectors.toMap(PreSmartDocBusinessDataService::getRiskType, g -> g, (v1, v2) -> v2));
            PreSmartDocBusinessDataService generator = generatorMap.get(type);
            if (generator != null) {
                String frontData = generator.generateFrontData(typeContentList, tmp);
                frontContent.setFrontData(frontData);
            } else {
                frontContent.setFrontData("");
            }
            returnList.add(frontContent);
        }
        return returnList;
    }

    private List<MicrocomPreSmartContentVo> postIntegrateSameTypeDataAndRenderTemplateByMonth(List<MicrocomPreSmartContentVo> contentList) {
        ArrayList<MicrocomPreSmartContentVo> returnList = new ArrayList<MicrocomPreSmartContentVo>();
        MicrocomPreSmartTemplateParam tmpParam = new MicrocomPreSmartTemplateParam();
        List tmpList = this.microcomPreSmartTemplateService.getMicrocomPreSmartTemplateList(tmpParam);
        Map<String, MicrocomPreSmartTemplateVo> tmpMap = tmpList.stream().collect(Collectors.toMap(MicrocomPreSmartTemplateVo::getCode, t -> t, (v1, v2) -> v2));
        Map<RiskTypeEnum, PreSmartDocBusinessDataService> generatorMap = this.generatorFactory.getAllGenerators().stream().collect(Collectors.toMap(PreSmartDocBusinessDataService::getRiskType, g -> g, (v1, v2) -> v2));
        Map<String, List<MicrocomPreSmartContentVo>> contentMap = contentList.stream().collect(Collectors.groupingBy(MicrocomPreSmartContentVo::getCode));
        for (Map.Entry<String, List<MicrocomPreSmartContentVo>> contentEntry : contentMap.entrySet()) {
            String code = contentEntry.getKey();
            RiskTypeEnum type = RiskTypeEnum.getByCode((String)code);
            List<MicrocomPreSmartContentVo> typeContentCollection = contentEntry.getValue();
            MicrocomPreSmartTemplateVo tmp = tmpMap.get(code);
            PreSmartDocBusinessDataService generator = generatorMap.get(type);
            if (type == null || CollUtil.isEmpty(typeContentCollection) || generator == null) continue;
            if (type == RiskTypeEnum.TRAINING) {
                Map<Integer, List<MicrocomPreSmartContentVo>> typeContentGroup = typeContentCollection.stream().collect(Collectors.groupingBy(MicrocomPreSmartContentVo::getExpireMonth));
                for (Map.Entry<Integer, List<MicrocomPreSmartContentVo>> typeContentEntry : typeContentGroup.entrySet()) {
                    MicrocomPreSmartContentVo frontContent = new MicrocomPreSmartContentVo();
                    List<MicrocomPreSmartContentVo> typeContentList = typeContentEntry.getValue();
                    BeanUtils.copyProperties((Object)typeContentList.get(0), (Object)frontContent);
                    String frontData = generator.generateFrontData(typeContentList, tmp);
                    frontContent.setFrontData(frontData);
                    returnList.add(frontContent);
                }
                continue;
            }
            MicrocomPreSmartContentVo frontContent = new MicrocomPreSmartContentVo();
            BeanUtils.copyProperties((Object)typeContentCollection.get(0), (Object)frontContent);
            String frontData = generator.generateFrontData(typeContentCollection, tmp);
            frontContent.setFrontData(frontData);
            returnList.add(frontContent);
        }
        return returnList;
    }

    private void postSortContentList(List<MicrocomPreSmartContentVo> contentList) {
        contentList.sort(Comparator.comparing(MicrocomPreSmartContentVo::getExpireMonth, Comparator.nullsLast(Integer::compareTo)));
    }
}

