/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.micro.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.health.micro.dao.MicrocomPreSmartDocMapper;
import cn.smarthse.modules.health.micro.entity.MicrocomPreSmartDoc;
import cn.smarthse.modules.health.micro.service.PreSmartDocRiskDataService;
import cn.smarthse.modules.health.micro.vo.MicrocomPreSmartDocVo;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractPreSmartDocRiskDataService<T extends MicrocomPreSmartDocVo>
implements PreSmartDocRiskDataService<T> {
    @Autowired
    protected MicrocomPreSmartDocMapper preSmartDocMapper;

    @Override
    public List<MicrocomPreSmartDoc> convertToDoc(List<T> businessData) {
        return businessData.stream().map(this::convertSingle).collect(Collectors.toList());
    }

    protected abstract MicrocomPreSmartDoc convertSingle(T var1);

    protected String buildValue(T data, Boolean json) {
        if (Boolean.TRUE.equals(json)) {
            JSONObject valueJson = new JSONObject();
            this.populateValueJson(data, valueJson);
            return valueJson.toJSONString(new JSONWriter.Feature[0]);
        }
        return data.getValue();
    }

    protected void populateValueJson(T data, JSONObject json) {
    }

    @Override
    public void saveData(List<MicrocomPreSmartDoc> docs) {
        if (CollUtil.isNotEmpty(docs)) {
            this.preSmartDocMapper.insertList2(docs);
        }
    }

    protected void setBaseFields(T source, MicrocomPreSmartDoc target, Boolean json) {
        LocalDateTime now = LocalDateTime.now();
        target.setId(Long.valueOf(IdWorker.getId()));
        target.setCid(source.getCid());
        target.setBusinessId(source.getBusinessId());
        target.setType(Byte.valueOf(this.getRiskType().getValue()));
        target.setValue(this.buildValue(source, json));
        target.setIsValid(Boolean.TRUE);
        target.setCreateBy(Long.valueOf(1L));
        target.setCreateDate(now);
        target.setUpdateBy(Long.valueOf(1L));
        target.setUpdateDate(now);
    }
}

