/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.fcyth.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.fcyth.dao.FcythPatientSuspectedApplyMapper;
import cn.smarthse.modules.health.fcyth.dao.FcythTbcCompanyClueMapper;
import cn.smarthse.modules.health.fcyth.dao.FcythTbcCompanyMapper;
import cn.smarthse.modules.health.fcyth.entity.FcythCompanyChangeRecord;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientBasicInfo;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientSuspectedApply;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientSuspectedApplyHistory;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompany;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompanyClue;
import cn.smarthse.modules.health.fcyth.enums.FcythChangeTypeEnum;
import cn.smarthse.modules.health.fcyth.enums.FcythSuspectedApplyStatusEnum;
import cn.smarthse.modules.health.fcyth.enums.FcythSuspectedApplyTypeEnum;
import cn.smarthse.modules.health.fcyth.model.FcythSuspectedApplyModel;
import cn.smarthse.modules.health.fcyth.service.IFcythCompanyChangeRecordService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientBasicInfoService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientSuspectedApplyHistoryService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientSuspectedApplyService;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyClueService;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyService;
import cn.smarthse.modules.health.fcyth.vo.FcythSuspectedApplyVo;
import cn.smarthse.modules.health.fcyth.vo.PneumoconiosisPatientVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class FcythPatientSuspectedApplyServiceImpl
extends BaseServiceImpl<FcythPatientSuspectedApplyMapper, FcythPatientSuspectedApply>
implements IFcythPatientSuspectedApplyService {
    private final IFcythPatientBasicInfoService fcythPatientBasicInfoService;
    private final IFcythPatientSuspectedApplyHistoryService historyService;
    private final IFcythTbcCompanyService fcythTbcCompanyService;
    private final IFcythTbcCompanyClueService fcythTbcCompanyClueService;
    private final IFcythCompanyChangeRecordService fcythCompanyChangeRecordService;
    @DubboReference
    private ISysFileProvideService sysFileService;

    public PageInfo<FcythSuspectedApplyVo> getSuspectedApplyList(JqGridParam pageParam, FcythSuspectedApplyModel model) {
        PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<FcythSuspectedApplyVo> fcythSuspectedApplyVoList = ((FcythPatientSuspectedApplyMapper)this.dao).selectSuspectedApplyList(model);
        for (FcythSuspectedApplyVo fcythSuspectedApplyVo : fcythSuspectedApplyVoList) {
            fcythSuspectedApplyVo.setStatusName(FcythSuspectedApplyStatusEnum.getValue((Integer)fcythSuspectedApplyVo.getStatus()));
            fcythSuspectedApplyVo.setTypeName(FcythSuspectedApplyTypeEnum.getValue((Integer)fcythSuspectedApplyVo.getType()));
        }
        PageInfo pageInfo = new PageInfo(fcythSuspectedApplyVoList);
        return pageInfo;
    }

    @Transactional
    public void appeal(FcythPatientSuspectedApply apply, StaffInfo operator) {
        List<Integer> statusList = Arrays.asList(FcythSuspectedApplyStatusEnum.PENDING_REVIEW.getKey());
        PneumoconiosisPatientVo vo = this.fcythPatientBasicInfoService.archiveHeadData(apply.getPatientId());
        if (vo == null) {
            throw new RuntimeException("\u60a3\u8005\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        if (vo.getConfirmType() != 2) {
            throw new RuntimeException("\u53ea\u6709\u5c18\u80ba\u75c5\u60a3\u8005\u624d\u80fd\u7533\u8bc9");
        }
        Example example = new Example(FcythPatientSuspectedApply.class);
        example.createCriteria().andEqualTo("cid", (Object)apply.getCid()).andEqualTo("patientId", (Object)apply.getPatientId());
        FcythPatientSuspectedApply dbData = (FcythPatientSuspectedApply)this.getOneByExample(example);
        if (dbData != null) {
            if (dbData.getIsValid().booleanValue()) {
                if (statusList.contains(dbData.getStatus())) {
                    throw new RuntimeException("\u5f53\u524d\u60a3\u8005\u7533\u8bc9\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4");
                }
                dbData.setStatus(FcythSuspectedApplyStatusEnum.PENDING_REVIEW.getKey());
                dbData.setProveFile(StringUtils.join((Iterable)apply.getFileIds(), (String)","));
                dbData.setUpdateDate(new Date());
                dbData.setUpdatedBy(operator.getId());
                dbData.setAppealContent(apply.getAppealContent());
                this.historyService.addLog(dbData, operator, apply.getAppealContent());
                apply.setAppealTime(new Date());
                this.update(dbData);
            } else {
                dbData.setStatus(FcythSuspectedApplyStatusEnum.PENDING_REVIEW.getKey());
                dbData.setProveFile(StringUtils.join((Iterable)apply.getFileIds(), (String)","));
                dbData.setUpdateDate(new Date());
                dbData.setUpdatedBy(operator.getId());
                dbData.setIsValid(Boolean.valueOf(true));
                dbData.setAppealContent(apply.getAppealContent());
                this.historyService.addLog(dbData, operator, apply.getAppealContent());
                dbData.setAppealTime(new Date());
                this.update(dbData);
            }
        } else {
            apply.setPatientName(vo.getName());
            apply.setPatientGender(Byte.valueOf(StaffGenderEnum.getValue((String)vo.getGender()).byteValue()));
            apply.setIdCard(vo.getIdCard());
            apply.setStatus(FcythSuspectedApplyStatusEnum.PENDING_REVIEW.getKey());
            apply.setProveFile(StringUtils.join((Iterable)apply.getFileIds(), (String)","));
            apply.setUpdateDate(new Date());
            apply.setUpdatedBy(operator.getId());
            apply.setCreateBy(operator.getId());
            apply.setCreateDate(new Date());
            apply.setIsValid(Boolean.valueOf(true));
            this.historyService.addLog(apply, operator, apply.getAppealContent());
            apply.setAppealTime(new Date());
            this.add(apply);
        }
    }

    @Transactional
    public void revoke(FcythPatientSuspectedApply applyParameter, StaffInfo operator) {
        Example example = new Example(FcythPatientSuspectedApply.class);
        example.createCriteria().andEqualTo("cid", (Object)applyParameter.getCid()).andEqualTo("patientId", (Object)applyParameter.getPatientId()).andEqualTo("isValid", (Object)true);
        FcythPatientSuspectedApply apply = (FcythPatientSuspectedApply)this.getOneByExample(example);
        if (apply == null) {
            throw new RuntimeException("\u7533\u8bc9\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        if (!FcythSuspectedApplyStatusEnum.PENDING_REVIEW.getKey().equals(apply.getStatus())) {
            throw new RuntimeException("\u53ea\u6709\u5f85\u5ba1\u6838\u7684\u7533\u8bc9\u624d\u80fd\u64a4\u9500,\u8bf7\u68c0\u67e5");
        }
        apply.setStatus(FcythSuspectedApplyStatusEnum.WITHDRAW_APPEAL.getKey());
        apply.setUpdateDate(new Date());
        apply.setUpdatedBy(operator.getId());
        this.update(apply);
        apply.setProveFile(StringUtils.join((Iterable)applyParameter.getFileIds(), (String)","));
        this.historyService.addLog(apply, operator, applyParameter.getAppealContent());
    }

    @Transactional
    public void examineSuspectedApply(FcythSuspectedApplyModel model, StaffInfo operator) {
        FcythPatientSuspectedApply apply = (FcythPatientSuspectedApply)this.getById(model.getApplyId());
        if (ObjectUtil.isNull((Object)apply)) {
            throw new HealthException("\u7533\u8bc9\u4fe1\u606f\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
        }
        if (ObjectUtil.isNull((Object)model.getStatus())) {
            throw new HealthException("\u8bf7\u9009\u62e9\u662f\u5426\u901a\u8fc7\u7533\u8ff0");
        }
        if (ObjectUtil.isNull((Object)apply.getStatus()) || apply.getStatus() != 1) {
            throw new HealthException("\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838");
        }
        PneumoconiosisPatientVo pneumoconiosisPatientVo = this.fcythPatientBasicInfoService.archiveHeadData(apply.getPatientId());
        if (ObjectUtil.isNull((Object)pneumoconiosisPatientVo)) {
            throw new HealthException("\u60a3\u8005\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Long cid = apply.getCid();
        if (ObjectUtil.isNull((Object)cid)) {
            throw new HealthException("\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        if (ObjectUtil.isNull((Object)apply.getStatus()) || !apply.getStatus().equals(FcythSuspectedApplyStatusEnum.PENDING_REVIEW.getKey())) {
            throw new HealthException("\u8be5\u7533\u8ff0\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4");
        }
        if (model.getStatus() == 2) {
            apply.setStatus(FcythSuspectedApplyStatusEnum.ALREADY_PASSED.getKey());
            Integer type = apply.getType();
            if (ObjectUtil.isNotNull((Object)type) && type == FcythSuspectedApplyTypeEnum.NOT_DISEASED_UNIT.getKey()) {
                this.fcythPatientBasicInfoService.updateApplyState(apply.getPatientId(), 1, operator.getId());
                this.againJudgeFCCompany(Arrays.asList(cid), operator.getId(), FcythChangeTypeEnum.APPEAL_BACK.getKey());
            }
        } else if (model.getStatus() == 3) {
            if (StringUtils.isEmpty((CharSequence)model.getAppealContent())) {
                throw new HealthException("\u9a73\u56de\u9700\u8981\u786e\u5b9a\u9a73\u56de\u7406\u7531");
            }
            apply.setStatus(FcythSuspectedApplyStatusEnum.REJECTED.getKey());
        }
        apply.setUpdateDate(new Date());
        apply.setUpdatedBy(operator.getId());
        this.update(apply);
        this.historyService.addLog(apply, operator, model.getAppealContent());
    }

    @Transactional(readOnly=false)
    public void againJudgeFCCompany(List<Long> cids, Long operatorId, Byte changeType) {
        if (CollectionUtils.isEmpty(cids)) {
            return;
        }
        if (ObjectUtil.isNull((Object)changeType)) {
            throw new ServiceException("\u672a\u660e\u786e\u53d8\u66f4\u65b9\u5f0f");
        }
        for (Long cid : cids) {
            List longs;
            if (!ObjectUtil.isNotNull((Object)cid) || !this.fcythTbcCompanyService.isTYPE3FcCompany(cid) || (longs = this.fcythTbcCompanyService.selectTYPE3Company(cid)).size() != 0) continue;
            Example e = new Example(FcythTbcCompany.class);
            e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("state", (Object)1).andEqualTo("isValid", (Object)1);
            List tbcCompanyList = this.fcythTbcCompanyService.getListByExample(e);
            if (!CollectionUtils.isNotEmpty((Collection)tbcCompanyList)) continue;
            Date date = new Date();
            List tbcCompanyIdList = tbcCompanyList.stream().map(FcythTbcCompany::getId).distinct().collect(Collectors.toList());
            List<Long> cidList = tbcCompanyList.stream().map(FcythTbcCompany::getCid).distinct().collect(Collectors.toList());
            ArrayList<FcythCompanyChangeRecord> recordList = new ArrayList<FcythCompanyChangeRecord>();
            Example example = new Example(FcythTbcCompanyClue.class);
            example.createCriteria().andIn("tbcCompanyId", tbcCompanyIdList).andEqualTo("state", (Object)1).andEqualTo("isValid", (Object)1);
            List clueList = this.fcythTbcCompanyClueService.getListByExample(example);
            for (FcythTbcCompanyClue clue : clueList) {
                clue.setState(Integer.valueOf(2));
                clue.setUpdateDate(date);
                clue.setUpdateBy(operatorId);
            }
            this.batchUpdateOrInsert(clueList, FcythTbcCompanyClueMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            for (FcythTbcCompany tbcCompany : tbcCompanyList) {
                tbcCompany.setState(Integer.valueOf(2));
                tbcCompany.setJudgeType(changeType);
                tbcCompany.setUpdateDate(date);
                tbcCompany.setUpdateBy(operatorId);
                FcythCompanyChangeRecord record = new FcythCompanyChangeRecord();
                record.setCid(tbcCompany.getCid());
                record.setIsChange(Boolean.valueOf(true));
                record.setChangeType(changeType);
                record.setSourceClueId(tbcCompany.getId());
                record.setOperateName("\u7cfb\u7edf");
                record.setUpdatedBy(Long.valueOf(1L));
                recordList.add(record);
            }
            this.fcythTbcCompanyService.batchUpdateOrInsert(tbcCompanyList, FcythTbcCompanyMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            this.fcythCompanyChangeRecordService.addTbcCompanyRecord(recordList);
            ((FcythPatientSuspectedApplyMapper)this.dao).updateCompanyToFcyth(cidList, 0, operatorId);
        }
    }

    public FcythSuspectedApplyVo currentAppealInformation(FcythPatientSuspectedApply model) {
        if (ObjectUtil.isNull((Object)model.getPatientId()) || ObjectUtil.isNull((Object)model.getCid())) {
            return new FcythSuspectedApplyVo();
        }
        List<FcythSuspectedApplyVo> applyList = ((FcythPatientSuspectedApplyMapper)this.dao).selectCurrentAppealInformation(model.getPatientId(), model.getCid());
        if (CollectionUtils.isEmpty(applyList)) {
            return new FcythSuspectedApplyVo();
        }
        FcythSuspectedApplyVo apply = applyList.get(0);
        apply.setStatusName(FcythSuspectedApplyStatusEnum.getValue((Integer)apply.getStatus()));
        apply.setTypeName(FcythSuspectedApplyTypeEnum.getValue((Integer)apply.getType()));
        apply.setPatientGender(StaffGenderEnum.getName((Integer)((Object)apply.getGender())));
        Object cardId = apply.getIdCard();
        if (StringUtils.isNotBlank((CharSequence)cardId)) {
            cardId = ((String)cardId).length() == 18 ? ((String)cardId).substring(0, 3) + "****" + ((String)cardId).substring(((String)cardId).length() - 3) : (((String)cardId).length() >= 3 ? ((String)cardId).charAt(0) + "****" + ((String)cardId).substring(((String)cardId).length() - 1) : ((String)cardId).charAt(0) + "****");
        }
        apply.setIdCard((String)cardId);
        String proveFile = apply.getProveFile();
        ArrayList<SysFileModel> sysFileModels = new ArrayList<SysFileModel>();
        if (StringUtils.isNotEmpty((String)proveFile)) {
            String[] fileIds;
            for (String fileId : fileIds = proveFile.split(",")) {
                SysFileModel file;
                if (!StringUtils.isNumber((String)fileId) || !ObjectUtil.isNotNull((Object)(file = this.sysFileService.getFileById(Long.valueOf(fileId))))) continue;
                sysFileModels.add(file);
            }
        }
        apply.setProveFileModel(sysFileModels);
        return apply;
    }

    public void addLog(FcythPatientSuspectedApply apply, StaffInfo operator, String appealReason) {
        FcythPatientSuspectedApplyHistory history = new FcythPatientSuspectedApplyHistory();
        history.setId(Long.valueOf(this.idworker.nextId()));
        history.setAppealId(apply.getId());
        history.setAppealTime(new Date());
        history.setOperatorId(operator.getId());
        history.setOperatorName(operator.getStaffBasicInfo().getRealName());
        history.setPatientId(apply.getPatientId());
        if (ObjectUtil.isNotNull((Object)history.getPatientId())) {
            FcythPatientBasicInfo basicInfo = (FcythPatientBasicInfo)this.fcythPatientBasicInfoService.getById(history.getPatientId());
            history.setPatientName(basicInfo.getName());
            history.setPatientGender(basicInfo.getGender());
            history.setIdCard(basicInfo.getIdCard());
        }
        history.setType(apply.getType());
        history.setAppealContent(appealReason);
        history.setProveFile(apply.getProveFile());
        history.setStatus(apply.getStatus());
        history.setCreateBy(operator.getId());
        history.setUpdatedBy(operator.getId());
        history.setIsValid(Boolean.valueOf(true));
        this.historyService.add((Object)history);
    }

    @Generated
    public FcythPatientSuspectedApplyServiceImpl(IFcythPatientBasicInfoService fcythPatientBasicInfoService, IFcythPatientSuspectedApplyHistoryService historyService, IFcythTbcCompanyService fcythTbcCompanyService, IFcythTbcCompanyClueService fcythTbcCompanyClueService, IFcythCompanyChangeRecordService fcythCompanyChangeRecordService) {
        this.fcythPatientBasicInfoService = fcythPatientBasicInfoService;
        this.historyService = historyService;
        this.fcythTbcCompanyService = fcythTbcCompanyService;
        this.fcythTbcCompanyClueService = fcythTbcCompanyClueService;
        this.fcythCompanyChangeRecordService = fcythCompanyChangeRecordService;
    }
}

