/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.fcyth.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.BeanUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.fcyth.dao.FcythPatientSuspectedApplyHistoryMapper;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientBasicInfo;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientSuspectedApply;
import cn.smarthse.modules.health.fcyth.entity.FcythPatientSuspectedApplyHistory;
import cn.smarthse.modules.health.fcyth.enums.FcythSuspectedApplyStatusEnum;
import cn.smarthse.modules.health.fcyth.enums.FcythSuspectedApplyTypeEnum;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientBasicInfoService;
import cn.smarthse.modules.health.fcyth.service.IFcythPatientSuspectedApplyHistoryService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class FcythPatientSuspectedApplyHistoryServiceImpl
extends BaseServiceImpl<FcythPatientSuspectedApplyHistoryMapper, FcythPatientSuspectedApplyHistory>
implements IFcythPatientSuspectedApplyHistoryService {
    @Autowired
    private IFcythPatientBasicInfoService fcythPatientBasicInfoService;
    @DubboReference
    private ISysFileProvideService sysFileService;

    @Transactional
    public void addLog(FcythPatientSuspectedApply apply, StaffInfo operator, String auditRemarks) {
        FcythPatientSuspectedApplyHistory history = new FcythPatientSuspectedApplyHistory();
        BeanUtils.copyProperties((Object)apply, (Object)history);
        history.setId(Long.valueOf(this.idworker.nextId()));
        history.setAppealId(apply.getId());
        history.setOperatorName(operator.getStaffBasicInfo().getRealName());
        history.setOperatorId(operator.getId());
        history.setAppealTime(new Date());
        history.setAuditRemarks(auditRemarks);
        if (StringUtils.isEmpty((CharSequence)apply.getPatientName())) {
            FcythPatientBasicInfo basicInfo = (FcythPatientBasicInfo)this.fcythPatientBasicInfoService.getById(apply.getPatientId());
            history.setPatientName(basicInfo.getName());
            history.setPatientGender(basicInfo.getGender());
            history.setIdCard(basicInfo.getIdCard());
        }
        this.add(history);
    }

    public PageInfo<FcythPatientSuspectedApplyHistory> historyList(Long patientId, JqGridParam jqGridParam) {
        Example example = new Example(FcythPatientSuspectedApplyHistory.class);
        example.setOrderByClause("update_date desc");
        example.createCriteria().andEqualTo("patientId", (Object)patientId).andEqualTo("isValid", (Object)true);
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List list = this.getListByExample(example);
        for (FcythPatientSuspectedApplyHistory his : list) {
            his.setStatusName(FcythSuspectedApplyStatusEnum.getValue((Integer)his.getStatus()));
            his.setTypeName(FcythSuspectedApplyTypeEnum.getValue((Integer)his.getType()));
            Object cardId = his.getIdCard();
            if (StringUtils.isNotBlank((CharSequence)cardId)) {
                cardId = ((String)cardId).length() == 18 ? ((String)cardId).substring(0, 3) + "****" + ((String)cardId).substring(((String)cardId).length() - 3) : (((String)cardId).length() >= 3 ? ((String)cardId).charAt(0) + "****" + ((String)cardId).substring(((String)cardId).length() - 1) : ((String)cardId).charAt(0) + "****");
            }
            his.setIdCard((String)cardId);
            String proveFile = his.getProveFile();
            ArrayList<SysFileModel> sysFileModels = new ArrayList<SysFileModel>();
            if (StringUtils.isNotEmpty((String)proveFile)) {
                String[] fileIds;
                for (String fileId : fileIds = proveFile.split(",")) {
                    SysFileModel file;
                    if (!StringUtils.isNumber((String)fileId) || !ObjectUtil.isNotNull((Object)(file = this.sysFileService.getFileById(Long.valueOf(fileId))))) continue;
                    sysFileModels.add(file);
                }
            }
            his.setProveFileModel(sysFileModels);
        }
        return new PageInfo(list);
    }

    @Generated
    public FcythPatientSuspectedApplyHistoryServiceImpl() {
    }
}

