/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.fcyth.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.fcyth.dao.FcythTbcCompanyClueMapper;
import cn.smarthse.modules.health.fcyth.dao.FcythTbcCompanyMapper;
import cn.smarthse.modules.health.fcyth.entity.FcythCompanyChangeRecord;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompany;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompanyClue;
import cn.smarthse.modules.health.fcyth.enums.FcythChangeTypeEnum;
import cn.smarthse.modules.health.fcyth.enums.FcythClueTypeEnum;
import cn.smarthse.modules.health.fcyth.model.FcythCompanyChangeRecordModel;
import cn.smarthse.modules.health.fcyth.model.FcythTbcCompanyModel;
import cn.smarthse.modules.health.fcyth.service.IFcythCompanyChangeRecordService;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyClueService;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.utils.HolidayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class FcythTbcCompanyClueServiceImpl
extends BaseServiceImpl<FcythTbcCompanyClueMapper, FcythTbcCompanyClue>
implements IFcythTbcCompanyClueService {
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    private final IFcythTbcCompanyService tbcCompanyService;
    private final IFcythCompanyChangeRecordService companyChangeRecordService;
    private final RedisClient redisClient;
    private final ThreadPoolExecutor threadPoolExecutor;

    public PageInfo<FcythTbcCompanyModel> getTbcCompanyPage(JqGridParam jqGridParam, FcythTbcCompanyModel param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        List<FcythTbcCompanyModel> list = this.getTbcCompanyList(param);
        return new PageInfo(list);
    }

    public List<FcythTbcCompanyModel> getTbcCompanyList(FcythTbcCompanyModel param) {
        return ((FcythTbcCompanyClueMapper)this.dao).getTbcCompanyList(param);
    }

    public Map<String, String> getTbcCompanyHead(FcythTbcCompanyModel param) {
        Map<String, String> head = ((FcythTbcCompanyClueMapper)this.dao).getTbcCompanyHead(param);
        AreaModel areaModel = this.sysAreaProvideService.getAreaById(param.getAreaId());
        if (areaModel != null) {
            head.put("areaName", areaModel.getName());
        }
        return head;
    }

    public PageInfo<FcythTbcCompanyClue> getTbcCluePage(JqGridParam jqGridParam, FcythTbcCompanyClue param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        List<FcythTbcCompanyClue> list = this.getTbcClueList(param);
        return new PageInfo(list);
    }

    public List<FcythTbcCompanyClue> getTbcClueList(FcythTbcCompanyClue param) {
        List<FcythTbcCompanyClue> list = ((FcythTbcCompanyClueMapper)this.dao).getTbcCompanyClueList(param);
        String fileIds = list.stream().filter(Objects::nonNull).map(FcythTbcCompanyClue::getCommitFile).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        Map<Long, SysFileModel> fileModelMap = this.getFileMap(fileIds);
        for (FcythTbcCompanyClue companyClue : list) {
            if (companyClue == null) continue;
            companyClue.setCommitFileList(this.getFileList(companyClue.getCommitFile(), fileModelMap));
        }
        return list;
    }

    public FcythTbcCompanyModel getTbcCompanyDetail(FcythTbcCompanyModel param) {
        if (param.getId() == null) {
            return null;
        }
        List<FcythTbcCompanyModel> list = this.getTbcCompanyList(param);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        FcythTbcCompanyModel model = list.get(0);
        model.setBackFileList(this.getFileList(model.getBackFile(), this.getFileMap(model.getBackFile())));
        return model;
    }

    @Transactional
    public void identify(FcythTbcCompanyModel param) {
        if (param.getId() == null) {
            throw new ServiceException("\u7ebf\u7d22\u4f01\u4e1a\u7684\u5361\u7247id");
        }
        if (param.getState() == null) {
            throw new ServiceException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getClueType() == null) {
            throw new ServiceException("\u7ebf\u7d22\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FcythTbcCompany tbcCompany = (FcythTbcCompany)this.tbcCompanyService.getById(param.getId());
        if (tbcCompany == null) {
            throw new ServiceException("\u8be5\u6279\u6b21\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if (tbcCompany.getState() != null && tbcCompany.getState() != 0) {
            throw new ServiceException("\u8be5\u6279\u6b21\u7ebf\u7d22\u5df2\u8ba4\u5b9a\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (tbcCompany.getIsValid() != null && !tbcCompany.getIsValid().booleanValue()) {
            throw new ServiceException("\u8be5\u6279\u6b21\u7ebf\u7d22\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(tbcCompany.getCid());
        if (company == null) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        if (company.getIsFcyth() != null && company.getIsFcyth().booleanValue()) {
            throw new ServiceException("\u4f01\u4e1a\u5df2\u7ecf\u662f\u7c89\u5c18\u4f01\u4e1a\uff0c\u65e0\u6cd5\u8ba4\u5b9a\uff0c\u6570\u636e\u5f02\u5e38");
        }
        if (param.getState() == 1) {
            this.changeClueState(Collections.singletonList(tbcCompany), 1, FcythChangeTypeEnum.CLUE_INTO.getKey(), param.getUpdateBy(), param.getOperateName(), true);
        }
        if (param.getState() == 2) {
            tbcCompany.setBackReason(param.getBackReason());
            tbcCompany.setBackFile(param.getBackFile());
            this.changeClueState(Collections.singletonList(tbcCompany), 2, FcythChangeTypeEnum.CLUE_BACK.getKey(), param.getUpdateBy(), param.getOperateName(), true);
        }
    }

    @Transactional
    public void addTbcCompanyClueByXzxg(Long cid, String commitName, String commitReason, String commitFile, Long operateId) {
        FcythTbcCompany entity;
        if (cid == null) {
            throw new ServiceException("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)commitName)) {
            throw new ServiceException("\u63d0\u4ea4\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)commitReason)) {
            throw new ServiceException("\u63d0\u4ea4\u7406\u7531\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)commitFile)) {
            throw new ServiceException("\u63d0\u4ea4\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanySuperviseModel company = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (company == null) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u5b58\u5728");
        }
        if (company.getIsFcyth() != null && company.getIsFcyth().booleanValue()) {
            throw new ServiceException("\u4f01\u4e1a\u5df2\u7ecf\u662f\u7c89\u5c18\u4f01\u4e1a\uff0c\u65e0\u6cd5\u8ba4\u5b9a\uff0c\u6570\u636e\u5f02\u5e38");
        }
        Date date = new Date();
        Example example = new Example(FcythTbcCompany.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("state", (Object)0).andEqualTo("isValid", (Object)true);
        List tbcCompanyList = this.tbcCompanyService.getListByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)tbcCompanyList) && tbcCompanyList.size() > 1) {
            throw new ServiceException("\u4f01\u4e1a\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long tbcCompanyId = this.idworker.nextId();
        if (CollectionUtils.isEmpty((Collection)tbcCompanyList)) {
            entity = new FcythTbcCompany().setId(tbcCompanyId).setCid(cid).setState(Integer.valueOf(0)).setClueTypeStr(FcythClueTypeEnum.TYPE_2.getKey().toString()).setPushTime(date).setType2Reason(commitReason).setEndTime(HolidayUtils.addWorkDay((Date)date, (int)15));
            this.tbcCompanyService.add((Object)entity, operateId, cid);
        } else {
            FcythTbcCompany tbcCompany = (FcythTbcCompany)tbcCompanyList.get(0);
            if (!tbcCompany.getClueTypeStr().contains(FcythClueTypeEnum.TYPE_2.getKey().toString())) {
                tbcCompany.setClueTypeStr(tbcCompany.getClueTypeStr() + "," + FcythClueTypeEnum.TYPE_2.getKey());
            }
            this.tbcCompanyService.updateByPrimaryKey((Object)tbcCompany, operateId);
            tbcCompanyId = tbcCompany.getId();
        }
        entity = new FcythTbcCompanyClue().setId(Long.valueOf(this.idworker.nextId())).setTbcCompanyId(tbcCompanyId).setClueType(Integer.valueOf(FcythClueTypeEnum.TYPE_2.getKey().intValue())).setPushTime(date).setCommitName(commitName).setCommitReason(commitReason).setCommitFile(commitFile).setState(Integer.valueOf(0));
        this.add(entity, operateId, cid);
    }

    private Map<Long, SysFileModel> getFileMap(String ids) {
        List fileModels = this.sysFileProvideService.getListByIds(ids);
        if (CollectionUtils.isEmpty((Collection)fileModels)) {
            return new HashMap<Long, SysFileModel>();
        }
        return fileModels.stream().collect(Collectors.toMap(SysFileModel::getId, Function.identity(), (k1, k2) -> k1));
    }

    private List<SysFileModel> getFileList(String fileIds, Map<Long, SysFileModel> fileModelMap) {
        String[] split;
        if (StringUtils.isBlank((CharSequence)fileIds)) {
            return null;
        }
        ArrayList<SysFileModel> commitFileModels = new ArrayList<SysFileModel>();
        for (String s : split = fileIds.split(",")) {
            Long fileId = Long.valueOf(s);
            if (!StringUtils.isNotBlank((CharSequence)s) || !fileModelMap.containsKey(fileId)) continue;
            commitFileModels.add(fileModelMap.get(fileId));
        }
        return commitFileModels;
    }

    public List<FcythCompanyChangeRecordModel> getTbcCompanyRecord(Long cid) {
        if (cid == null) {
            return Collections.emptyList();
        }
        FcythCompanyChangeRecordModel param = new FcythCompanyChangeRecordModel();
        param.setCid(cid);
        List recordList = this.companyChangeRecordService.getCompanyRecordList(param);
        for (FcythCompanyChangeRecordModel recordModel : recordList) {
            Long tbcCompanyId;
            if (recordModel == null || (tbcCompanyId = recordModel.getSourceClueId()) == null) continue;
            List<FcythTbcCompanyClue> tbcClueList = this.getTbcClueList(new FcythTbcCompanyClue().setTbcCompanyId(tbcCompanyId));
            FcythTbcCompanyModel model = new FcythTbcCompanyModel();
            model.setId(tbcCompanyId);
            FcythTbcCompanyModel tbcCompanyDetail = this.getTbcCompanyDetail(model);
            recordModel.setTbcClueList(tbcClueList);
            recordModel.setTbcCompanyDetail(tbcCompanyDetail);
        }
        return recordList;
    }

    @Transactional
    public void updateCountdown() {
        Date date = new Date();
        ArrayList<FcythTbcCompany> errList = new ArrayList<FcythTbcCompany>();
        List<FcythTbcCompany> list = ((FcythTbcCompanyClueMapper)this.dao).getOverTimeTbcCompany(DateUtils.formatDate((Date)date));
        for (FcythTbcCompany tbcCompany : list) {
            boolean b;
            if (tbcCompany == null || (b = this.redisClient.addDelayQueue((Object)tbcCompany.getId(), date, tbcCompany.getEndTime(), "countdownUpdateTbc"))) continue;
            errList.add(tbcCompany);
        }
        this.changeClueState(errList, 1, FcythChangeTypeEnum.CLUE_AUTO.getKey(), 1L, "\u7cfb\u7edf", true);
        if (CollectionUtils.isNotEmpty(errList)) {
            this.logger.error("\u5b58\u5728\u5012\u8ba1\u65f6\u5b9a\u65f6\u4efb\u52a1\u6f0f\u6389\u6216\u8005\u6267\u884c\u672a\u6210\u529f\uff0c\u6570\u636e\u4e3a\uff1a{}", errList);
        }
    }

    @PostConstruct
    public void countdownUpdateTbc() {
        new Thread(() -> {
            this.updateCountdown();
            while (true) {
                try {
                    while (true) {
                        Long tbcCompanyId;
                        FcythTbcCompany tbcCompany;
                        if ((tbcCompany = (FcythTbcCompany)this.tbcCompanyService.getById(tbcCompanyId = (Long)this.redisClient.getDelayQueueTake("countdownUpdateTbc"))) == null) {
                            return;
                        }
                        this.threadPoolExecutor.execute(() -> this.changeClueState(Collections.singletonList(tbcCompany), 1, FcythChangeTypeEnum.CLUE_AUTO.getKey(), 1L, "\u7cfb\u7edf", true));
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u5012\u8ba1\u65f6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }

    @Transactional
    public void autoIntoFcyth(List<Long> cidList) {
        ArrayList<FcythCompanyChangeRecord> recordAddList = new ArrayList<FcythCompanyChangeRecord>();
        ArrayList<FcythTbcCompany> tbcCompanyUpdateList = new ArrayList<FcythTbcCompany>();
        ArrayList<FcythTbcCompany> tbcCompanyAddList = new ArrayList<FcythTbcCompany>();
        ArrayList<FcythTbcCompanyClue> tbcCompanyClueAddList = new ArrayList<FcythTbcCompanyClue>();
        Date date = new Date();
        List<Long> reason1CidList = ((FcythTbcCompanyClueMapper)this.dao).getCompanyCuleReason1(cidList, 0);
        List<Long> reason2CidList = ((FcythTbcCompanyClueMapper)this.dao).getCompanyCuleReason2(cidList, 0);
        List<Object> cidAllList = new ArrayList<Long>();
        cidAllList.addAll(reason1CidList);
        cidAllList.addAll(reason2CidList);
        cidAllList = cidAllList.stream().distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cidAllList)) {
            return;
        }
        Example example = new Example(FcythTbcCompany.class);
        example.createCriteria().andIn("cid", cidAllList).andEqualTo("state", (Object)0).andEqualTo("isValid", (Object)1);
        Map tbcCompanyMap = this.tbcCompanyService.getListByExample(example).stream().filter(Objects::nonNull).collect(Collectors.toMap(FcythTbcCompany::getCid, Function.identity(), (v1, v2) -> v1));
        for (Long l : cidAllList) {
            if (CollectionUtils.isNotEmpty(tbcCompanyMap) && tbcCompanyMap.get(l) != null) {
                FcythTbcCompany fcythTbcCompany = (FcythTbcCompany)tbcCompanyMap.get(l);
                if (reason1CidList.contains(l)) {
                    this.getMakeFcythTbcCompanyClue(tbcCompanyClueAddList, fcythTbcCompany, FcythClueTypeEnum.TYPE_3.getKey(), date);
                }
                if (reason2CidList.contains(l)) {
                    this.getMakeFcythTbcCompanyClue(tbcCompanyClueAddList, fcythTbcCompany, FcythClueTypeEnum.TYPE_4.getKey(), date);
                }
                tbcCompanyUpdateList.add(fcythTbcCompany);
                continue;
            }
            FcythTbcCompany tbcCompany = new FcythTbcCompany().setId(Long.valueOf(this.idworker.nextId())).setCid(l).setState(Integer.valueOf(1)).setPushTime(date).setEndTime(date).setCreateBy(Long.valueOf(1L)).setUpdateBy(Long.valueOf(1L)).setCreateDate(date).setUpdateDate(date).setIsValid(Boolean.valueOf(true));
            if (reason1CidList.contains(l)) {
                this.getMakeFcythTbcCompanyClue(tbcCompanyClueAddList, tbcCompany, FcythClueTypeEnum.TYPE_3.getKey(), date);
            }
            if (reason2CidList.contains(l)) {
                this.getMakeFcythTbcCompanyClue(tbcCompanyClueAddList, tbcCompany, FcythClueTypeEnum.TYPE_4.getKey(), date);
            }
            tbcCompanyAddList.add(tbcCompany);
            FcythCompanyChangeRecord record = new FcythCompanyChangeRecord();
            record.setCid(l);
            record.setIsChange(Boolean.valueOf(true));
            record.setChangeType(FcythChangeTypeEnum.CLUE_AUTO.getKey());
            record.setOperateName("\u7cfb\u7edf");
            record.setSourceClueId(tbcCompany.getId());
            record.setUpdatedBy(Long.valueOf(1L));
            recordAddList.add(record);
        }
        this.changeClueState(tbcCompanyUpdateList, 1, FcythChangeTypeEnum.CLUE_AUTO.getKey(), 1L, "\u7cfb\u7edf", true);
        if (CollectionUtils.isNotEmpty(tbcCompanyAddList)) {
            this.tbcCompanyService.batchUpdateOrInsert(tbcCompanyAddList, FcythTbcCompanyMapper.class, (item, mapper) -> mapper.insert(item));
            ((FcythTbcCompanyClueMapper)this.dao).insertList2(tbcCompanyClueAddList);
            ((FcythTbcCompanyClueMapper)this.dao).updateCompanyToFcyth(recordAddList.stream().map(FcythCompanyChangeRecord::getCid).collect(Collectors.toList()));
            this.companyChangeRecordService.addTbcCompanyRecord(recordAddList);
        }
    }

    public void getMakeFcythTbcCompanyClue(List<FcythTbcCompanyClue> tbcCompanyClueAddList, FcythTbcCompany tbcCompany, Byte clueType, Date date) {
        FcythTbcCompanyClue companyClue = new FcythTbcCompanyClue().setId(Long.valueOf(this.idworker.nextId())).setTbcCompanyId(tbcCompany.getId()).setCid(tbcCompany.getCid()).setClueType(Integer.valueOf(clueType.intValue())).setPushTime(date).setState(Integer.valueOf(1)).setCreateBy(Long.valueOf(1L)).setUpdateBy(Long.valueOf(1L)).setCreateDate(date).setUpdateDate(date).setIsValid(Boolean.valueOf(true));
        tbcCompanyClueAddList.add(companyClue);
        if (StringUtils.isBlank((CharSequence)tbcCompany.getClueTypeStr())) {
            tbcCompany.setClueTypeStr(clueType.toString());
            return;
        }
        if (FcythClueTypeEnum.TYPE_3.getKey().equals(clueType) && !tbcCompany.getClueTypeStr().contains(FcythClueTypeEnum.TYPE_3.getKey().toString())) {
            tbcCompany.setClueTypeStr(tbcCompany.getClueTypeStr() + "," + FcythClueTypeEnum.TYPE_3.getKey());
        }
        if (FcythClueTypeEnum.TYPE_4.getKey().equals(clueType) && !tbcCompany.getClueTypeStr().contains(FcythClueTypeEnum.TYPE_4.getKey().toString())) {
            tbcCompany.setClueTypeStr(tbcCompany.getClueTypeStr() + "," + FcythClueTypeEnum.TYPE_4.getKey());
        }
    }

    @Transactional
    public List<FcythTbcCompany> changeClueInByCid(List<Long> cidList, Byte judgeType, Long operateId) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<FcythTbcCompany>();
        }
        Example example = new Example(FcythTbcCompany.class);
        example.createCriteria().andIn("cid", cidList).andEqualTo("state", (Object)0).andEqualTo("isValid", (Object)1);
        List tbcCompanyList = this.tbcCompanyService.getListByExample(example);
        this.changeClueState(tbcCompanyList, 1, judgeType, operateId, null, false);
        return tbcCompanyList;
    }

    @Transactional
    public void changeClueState(List<FcythTbcCompany> tbcCompanyList, Integer state, Byte judgeType, Long operateId, String operateName, Boolean isUpdateCompanyAndRecord) {
        if (CollectionUtils.isEmpty(tbcCompanyList)) {
            return;
        }
        Date date = new Date();
        List tbcCompanyIdList = tbcCompanyList.stream().map(FcythTbcCompany::getId).distinct().collect(Collectors.toList());
        List<Long> cidList = tbcCompanyList.stream().map(FcythTbcCompany::getCid).distinct().collect(Collectors.toList());
        ArrayList<FcythCompanyChangeRecord> recordList = new ArrayList<FcythCompanyChangeRecord>();
        Example example = new Example(FcythTbcCompanyClue.class);
        example.createCriteria().andIn("tbcCompanyId", tbcCompanyIdList).andEqualTo("state", (Object)0).andEqualTo("isValid", (Object)1);
        List clueList = ((FcythTbcCompanyClueMapper)this.dao).selectByExample(example);
        for (FcythTbcCompanyClue clue : clueList) {
            clue.setState(state);
            clue.setUpdateDate(date);
            clue.setUpdateBy(operateId);
        }
        this.batchUpdateOrInsert(clueList, FcythTbcCompanyClueMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        for (FcythTbcCompany tbcCompany : tbcCompanyList) {
            tbcCompany.setState(state);
            tbcCompany.setJudgeType(judgeType);
            tbcCompany.setUpdateDate(date);
            tbcCompany.setUpdateBy(operateId);
            FcythCompanyChangeRecord record = new FcythCompanyChangeRecord();
            record.setCid(tbcCompany.getCid());
            record.setIsChange(Boolean.valueOf(true));
            record.setChangeType(judgeType);
            record.setSourceClueId(tbcCompany.getId());
            record.setOperateName(operateName);
            record.setUpdatedBy(operateId);
            recordList.add(record);
        }
        this.tbcCompanyService.batchUpdateOrInsert(tbcCompanyList, FcythTbcCompanyMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        if (isUpdateCompanyAndRecord.booleanValue()) {
            if (state == 1) {
                ((FcythTbcCompanyClueMapper)this.dao).updateCompanyToFcyth(cidList);
            }
            this.companyChangeRecordService.addTbcCompanyRecord(recordList);
        }
    }

    public List<Long> getCanNotExitCid(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        List<Long> companyCuleReason1 = ((FcythTbcCompanyClueMapper)this.dao).getCompanyCuleReason1(cidList, 1);
        List<Long> companyCuleReason2 = ((FcythTbcCompanyClueMapper)this.dao).getCompanyCuleReason2(cidList, 1);
        companyCuleReason2.addAll(companyCuleReason1);
        return companyCuleReason2;
    }

    @Generated
    public FcythTbcCompanyClueServiceImpl(IFcythTbcCompanyService tbcCompanyService, IFcythCompanyChangeRecordService companyChangeRecordService, RedisClient redisClient, ThreadPoolExecutor threadPoolExecutor) {
        this.tbcCompanyService = tbcCompanyService;
        this.companyChangeRecordService = companyChangeRecordService;
        this.redisClient = redisClient;
        this.threadPoolExecutor = threadPoolExecutor;
    }
}

