/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.fcyth.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.fcyth.dao.FcythCompanyChangeRecordMapper;
import cn.smarthse.modules.health.fcyth.entity.FcythCompanyChangeRecord;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompany;
import cn.smarthse.modules.health.fcyth.enums.FcythChangeTypeEnum;
import cn.smarthse.modules.health.fcyth.model.FcythCompanyChangeRecordModel;
import cn.smarthse.modules.health.fcyth.service.IFcythCompanyChangeRecordService;
import cn.smarthse.modules.health.fcyth.vo.FcythCompanyChangePrevCurrVo;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfo;
import cn.smarthse.modules.health.supervise.entity.companyChange.CompanyChangeInfoDetail;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class FcythCompanyChangeRecordServiceImpl
extends BaseServiceImpl<FcythCompanyChangeRecordMapper, FcythCompanyChangeRecord>
implements IFcythCompanyChangeRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FcythCompanyChangeRecordServiceImpl.class);
    @DubboReference(version="1.0.0")
    private final ISysAreaProvideService regionService;

    public PageInfo<FcythCompanyChangePrevCurrVo> getChangeRecordPage(JqGridParam pageParam, FcythCompanyChangeRecordModel changeParam) {
        this.preSetRegionInfo(changeParam);
        Page changeRecordPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<FcythCompanyChangePrevCurrVo> changeRecordList = ((FcythCompanyChangeRecordMapper)this.dao).getChangeRecordList(changeParam);
        this.postSetRegionFullName(changeRecordList);
        FcythCompanyChangeRecordServiceImpl.postSetEnumFieldValue(changeRecordList);
        return new PageInfo((List)changeRecordPage);
    }

    @Transactional
    public void preDustChangeRecordLog(CompanyChangeInfo changeInfo, List<CompanyChangeInfoDetail> changeDetailList, List<FcythTbcCompany> tbcCompanyList) {
        if (changeInfo == null || CollUtil.isEmpty(changeDetailList)) {
            return;
        }
        Long changeId = changeInfo.getId();
        Long createBy = changeInfo.getCreateBy();
        String createByName = changeInfo.getCreateByName();
        Date currDate = new Date();
        List<FcythCompanyChangeRecord> changeRecordList = this.getByChangeTypeAndSourceId(changeInfo.getChangeType(), changeId);
        if (CollUtil.isNotEmpty(changeRecordList)) {
            return;
        }
        ArrayList<FcythCompanyChangeRecord> dustChangeRecordList = new ArrayList<FcythCompanyChangeRecord>();
        for (CompanyChangeInfoDetail detail : changeDetailList) {
            Byte fcythChangeType;
            Byte type;
            FcythCompanyChangeRecord dustChangeRecord = new FcythCompanyChangeRecord();
            dustChangeRecord.setId(Long.valueOf(IdWorker.getId()));
            dustChangeRecord.setCid(detail.getCid());
            CompanyChangeTypeEnum changeTypeEnum = CompanyChangeTypeEnum.getEnum((Integer)changeInfo.getChangeType());
            Boolean isValid = switch (changeTypeEnum) {
                case CompanyChangeTypeEnum.addDustImportantCompany -> {
                    type = (byte)1;
                    fcythChangeType = FcythChangeTypeEnum.CHANGE_INTO_DUST.getKey();
                    yield Boolean.TRUE;
                }
                case CompanyChangeTypeEnum.removeDustImportantCompany -> {
                    type = (byte)2;
                    fcythChangeType = FcythChangeTypeEnum.CHANGE_OUT_DUST.getKey();
                    yield Boolean.FALSE;
                }
                default -> {
                    type = null;
                    fcythChangeType = null;
                    yield Boolean.FALSE;
                }
            };
            dustChangeRecord.setIsChange(Boolean.TRUE);
            dustChangeRecord.setType(type);
            dustChangeRecord.setChangeType(fcythChangeType);
            dustChangeRecord.setSourceId(changeId);
            dustChangeRecord.setOperateName(createByName);
            dustChangeRecord.setCreateBy(createBy);
            dustChangeRecord.setCreateDate(currDate);
            dustChangeRecord.setUpdatedBy(createBy);
            dustChangeRecord.setUpdateDate(currDate);
            dustChangeRecord.setReason(changeInfo.getReason());
            dustChangeRecord.setIsValid(isValid);
            dustChangeRecordList.add(dustChangeRecord);
        }
        if (CollUtil.isNotEmpty(tbcCompanyList)) {
            Map<Long, Long> tbcMap = tbcCompanyList.stream().filter(Objects::nonNull).collect(Collectors.toMap(FcythTbcCompany::getCid, FcythTbcCompany::getId, (v1, v2) -> v2));
            dustChangeRecordList.forEach(dust -> dust.setSourceClueId((Long)tbcMap.get(dust.getCid())));
        }
        ((FcythCompanyChangeRecordMapper)this.dao).insertList2(dustChangeRecordList);
    }

    public void preSetRegionInfo(FcythCompanyChangeRecordModel changeParam) {
        if (changeParam == null || changeParam.getRegionId() == null) {
            throw new ServiceException("\u884c\u653f\u533a\u5212id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Long regionId = changeParam.getRegionId();
        AreaModel region = this.regionService.getAreaById(regionId);
        if (region == null) {
            throw new ServiceException("\u5f53\u524d\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728\uff1a" + regionId);
        }
        changeParam.setRegionLevel(region.getLevel());
    }

    public void postSetRegionFullName(List<FcythCompanyChangePrevCurrVo> changeRecordList) {
        if (CollUtil.isNotEmpty(changeRecordList)) {
            Map<Long, String> regionMap = this.regionService.getAreaListByIds(changeRecordList.stream().map(FcythCompanyChangePrevCurrVo::getRegionId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","))).stream().collect(Collectors.toMap(AreaModel::getId, region -> {
                switch (region.getLevel()) {
                    case 0: {
                        return "\u56fd\u5bb6";
                    }
                    case 1: {
                        return region.getProvinceName();
                    }
                    case 2: {
                        return region.getProvinceName() + "/" + region.getCityName();
                    }
                    case 3: {
                        return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName();
                    }
                    case 4: {
                        return region.getProvinceName() + "/" + region.getCityName() + "/" + region.getAreaName() + "/" + region.getStreetName();
                    }
                }
                return "";
            }));
            changeRecordList.forEach(n -> n.setRegionFullName((String)regionMap.get(n.getRegionId())));
        }
    }

    private static void postSetEnumFieldValue(List<FcythCompanyChangePrevCurrVo> changeRecordList) {
        if (CollUtil.isNotEmpty(changeRecordList)) {
            changeRecordList.forEach(rec -> rec.setChangeTypeName(FcythChangeTypeEnum.getValue((Byte)rec.getChangeType())));
            block7: for (FcythCompanyChangePrevCurrVo r : changeRecordList) {
                Byte changeType = r.getChangeType();
                if (changeType == null) continue;
                switch (changeType) {
                    case 1: {
                        r.setChangeTypeName("\u53d8\u66f4\u7eb3\u5165");
                        continue block7;
                    }
                    case 2: {
                        r.setChangeTypeName("\u53d8\u66f4\u9000\u51fa");
                        continue block7;
                    }
                    case 3: {
                        r.setChangeTypeName("\u7ebf\u7d22\u7eb3\u5165");
                        continue block7;
                    }
                    case 6: {
                        r.setChangeTypeName("\u7ecf\u7533\u8bc9\u9000\u51fa");
                        continue block7;
                    }
                    case 7: {
                        r.setChangeTypeName("\u66f4\u65b0\u540e\u9000\u51fa");
                        continue block7;
                    }
                }
                r.setChangeTypeName("-");
            }
        }
    }

    @Transactional
    public void addTbcCompanyRecord(List<FcythCompanyChangeRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (FcythCompanyChangeRecord record : list) {
            record.setId(Long.valueOf(this.idworker.nextId()));
            record.setCreateDate(new Date());
            record.setCreateBy(record.getUpdatedBy());
            record.setUpdateDate(new Date());
            record.setIsValid(Boolean.valueOf(true));
        }
        ((FcythCompanyChangeRecordMapper)this.dao).insertList2(list);
    }

    public PageInfo<FcythCompanyChangeRecordModel> getCompanyRecordPage(JqGridParam jqGridParam, FcythCompanyChangeRecordModel param) {
        if (jqGridParam.getTotal() == -1L) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows(), (boolean)false);
        } else {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        }
        return new PageInfo(this.getCompanyRecordList(param));
    }

    public List<FcythCompanyChangeRecordModel> getCompanyRecordList(FcythCompanyChangeRecordModel param) {
        return ((FcythCompanyChangeRecordMapper)this.dao).getCompanyRecordList(param);
    }

    public List<FcythCompanyChangeRecord> getByChangeTypeAndSourceId(Integer changeType, Long changeId) {
        CompanyChangeTypeEnum changeTypeEnum = CompanyChangeTypeEnum.getEnum((Integer)changeType);
        Byte fcythChangeType = switch (changeTypeEnum) {
            case CompanyChangeTypeEnum.addDustImportantCompany -> FcythChangeTypeEnum.CHANGE_INTO_DUST.getKey();
            case CompanyChangeTypeEnum.removeDustImportantCompany -> FcythChangeTypeEnum.CHANGE_OUT_DUST.getKey();
            default -> null;
        };
        Example example = new Example(FcythCompanyChangeRecord.class);
        example.createCriteria().andEqualTo("changeType", (Object)fcythChangeType).andEqualTo("sourceId", (Object)changeId);
        return ((FcythCompanyChangeRecordMapper)this.dao).selectByExample(example);
    }

    @Generated
    public FcythCompanyChangeRecordServiceImpl(ISysAreaProvideService regionService) {
        this.regionService = regionService;
    }
}

