/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.dosemonitor.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dosemonitor.dao.DoseMonitorDataMapper;
import cn.smarthse.modules.health.dosemonitor.dao.DoseMonitorMapper;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitor;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitorData;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorStatusEnum;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorConvertModel;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorDataConvertModel;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorDataModel;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorModel;
import cn.smarthse.modules.health.dosemonitor.model.params.DoseMonitorDataParam;
import cn.smarthse.modules.health.dosemonitor.model.params.DoseMonitorParam;
import cn.smarthse.modules.health.dosemonitor.service.IDoseMonitorService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class DoseMonitorServiceImpl
extends BaseServiceImpl<DoseMonitorMapper, DoseMonitor>
implements IDoseMonitorService {
    @Autowired
    DoseMonitorDataMapper doseMonitorDataMapper;
    @Autowired
    IWorkOperateLogService workOperateLogService;
    @DubboReference
    private IReformItemBasicCommandService itemBasicCommandService;

    public List<DoseMonitorModel> listDoseMonitorByCid(DoseMonitorParam param) {
        if (param.getCid() == null) {
            return null;
        }
        return ((DoseMonitorMapper)this.dao).listDoseMonitorByCid(param);
    }

    public PageInfo<DoseMonitorModel> pageDoseMonitorByCid(JqGridParam jqGridParam, DoseMonitorParam param) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<DoseMonitorModel> doseMonitorModels = this.listDoseMonitorByCid(param);
        return new PageInfo(doseMonitorModels);
    }

    public PageInfo<DoseMonitorDataModel> pageDoseMonitorDataDetail(JqGridParam jqGridParam, DoseMonitorDataParam param) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<DoseMonitorDataModel> doseMonitorModels = this.doseMonitorDataMapper.listDoseMonitorDataDetail(param);
        return new PageInfo(doseMonitorModels);
    }

    public Long countDoseMonitorPersons(DoseMonitorParam param) {
        if (param.getCid() == null) {
            return 0L;
        }
        return this.doseMonitorDataMapper.countDoseMonitorPersons(param);
    }

    public List<DoseMonitorConvertModel> listNeedSyncDoseMonitor(DoseMonitorParam param) {
        return ((DoseMonitorMapper)this.dao).listNeedSyncDoseMonitor(param);
    }

    public List<DoseMonitorDataConvertModel> listNeedSyncDoseMonitorData(DoseMonitorParam param) {
        return ((DoseMonitorMapper)this.dao).listNeedSyncDoseMonitorData(param);
    }

    public List<Long> listNeedSyncDoseMonitorStaffDataCid() {
        return ((DoseMonitorMapper)this.dao).listNeedSyncDoseMonitorStaffDataCid();
    }

    public List<DoseMonitorDataConvertModel> listNeedSyncDoseMonitorStaffData(DoseMonitorParam param) {
        return ((DoseMonitorMapper)this.dao).listNeedSyncDoseMonitorStaffData(param);
    }

    @Transactional(readOnly=false)
    public void updateDoseMonitors(List<DoseMonitor> doseMonitors, List<DoseMonitorConvertModel> doseMonitorConvertModels) {
        List<DoseMonitorConvertModel> collect;
        if (CollectionUtils.isNotEmpty(doseMonitors)) {
            doseMonitors.forEach(doseMonitor -> {
                if (doseMonitor.getIsValid() == null) {
                    doseMonitor.setIsValid(Boolean.valueOf(true));
                }
            });
            ((DoseMonitorMapper)this.dao).updateDoseMonitors(doseMonitors);
        }
        if (CollectionUtils.isNotEmpty(doseMonitorConvertModels) && CollectionUtils.isNotEmpty(collect = doseMonitorConvertModels.stream().filter(f -> !Objects.equals(f.getIsConvertedTozlwq(), 0)).collect(Collectors.toList()))) {
            ((DoseMonitorMapper)this.dao).updateDoseMonitorConvertFlat(collect);
        }
    }

    @Transactional(readOnly=false)
    public void updateDoseMonitorDatas(List<DoseMonitorData> doseMonitorData, List<DoseMonitorDataConvertModel> doseMonitorConvertModels) {
        List<DoseMonitorDataConvertModel> collect;
        if (CollectionUtils.isNotEmpty(doseMonitorData)) {
            ((DoseMonitorMapper)this.dao).updateDoseMonitorDatas(doseMonitorData);
        }
        if (CollectionUtils.isNotEmpty(doseMonitorConvertModels) && CollectionUtils.isNotEmpty(collect = doseMonitorConvertModels.stream().filter(f -> !Objects.equals(f.getIsConvertedTozlwq(), 0)).collect(Collectors.toList()))) {
            ((DoseMonitorMapper)this.dao).updateDoseMonitorDataConvertFlat(collect);
        }
    }

    @Transactional(readOnly=false)
    public void updateDoseMonitorDatasStaffFlag(List<DoseMonitorDataConvertModel> doseMonitorConvertModels) {
        List<DoseMonitorDataConvertModel> collect;
        if (CollectionUtils.isNotEmpty(doseMonitorConvertModels) && CollectionUtils.isNotEmpty(collect = doseMonitorConvertModels.stream().filter(f -> !Objects.equals(f.getIsConvertedTozlwq(), 0)).collect(Collectors.toList()))) {
            ((DoseMonitorMapper)this.dao).updateStaffConvertFlat(collect);
        }
    }

    @Transactional(readOnly=false)
    public void systemBack(Set<Long> doseMonitorIdSet, String reason, String operater) {
        if (CollectionUtils.isEmpty(doseMonitorIdSet)) {
            return;
        }
        Example e = new Example(DoseMonitor.class);
        e.createCriteria().andIn("id", doseMonitorIdSet);
        DoseMonitor r = new DoseMonitor();
        r.setStatus(DoseMonitorStatusEnum.BREAKED.getKey());
        r.setUpdateDate(new Date());
        ((DoseMonitorMapper)this.dao).updateByExampleSelective(r, e);
        for (Long doseMonitorId : doseMonitorIdSet) {
            this.workOperateLogService.back(doseMonitorId, null, reason, null, operater, null);
        }
        this.itemBasicCommandService.backDoseMonitorAndDeleteReform(new ArrayList<Long>(doseMonitorIdSet));
    }

    @Generated
    public DoseMonitorServiceImpl() {
    }
}

