/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.dosemonitor.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.modules.health.dosemonitor.dao.DoseMonitorMapper;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitor;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitorData;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorSourcesEnum;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorStatusEnum;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorDataOrgModel;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorOrgModel;
import cn.smarthse.modules.health.dosemonitor.model.org.DoseMonitorOrgParam;
import cn.smarthse.modules.health.dosemonitor.service.IDoseMonitorDataService;
import cn.smarthse.modules.health.dosemonitor.service.IDoseMonitorOrgService;
import cn.smarthse.modules.health.dosemonitor.service.IDoseMonitorService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicCommandService;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class DoseMonitorOrgServiceImpl
extends BaseServiceImpl<DoseMonitorMapper, DoseMonitor>
implements IDoseMonitorOrgService {
    @Autowired
    IDoseMonitorService doseMonitorService;
    @Autowired
    IDoseMonitorDataService doseMonitorDataService;
    @Autowired
    IWorkOperateLogService workOperateLogService;
    @DubboReference
    private IReformItemBasicCommandService commandService;

    @Transactional(readOnly=false)
    public DoseMonitorOrgModel saveDoseMonitorOrgModel(DoseMonitorOrgModel model) {
        if (model != null) {
            if (model.getId() == null) {
                model.setId(Long.valueOf(this.idworker.nextId()));
            }
            if (model.getStatus() == null) {
                model.setStatus(DoseMonitorStatusEnum.DRAF.getKey());
            }
            model.setSourceId(String.valueOf(model.getId()));
            model.setDataSource(DoseMonitorSourcesEnum.FROM_ORG.getKey());
            if (StringUtils.isBlank((String)model.getUniqueid())) {
                model.setUniqueid(String.valueOf(model.getId()));
            }
            DoseMonitor doseMonitor = new DoseMonitor();
            BeanUtils.copyProperties((Object)model, (Object)doseMonitor);
            this.doseMonitorService.updateDoseMonitors(List.of(doseMonitor), null);
            if (Objects.equals(model.getStatus(), DoseMonitorStatusEnum.CHECKING.getKey()) || Objects.equals(model.getStatus(), DoseMonitorStatusEnum.CHECKED.getKey())) {
                this.doseMonitorDataService.resetStaffConvertFalg(model.getId(), Integer.valueOf(0));
                this.workOperateLogService.report(doseMonitor.getId(), WorkOperateLogEnum.dosemonitor.getTypeVal(), model.getUserId(), model.getUserName(), model.getUserCompanyName());
            }
        }
        return model;
    }

    @Transactional(readOnly=false)
    public List<DoseMonitorDataOrgModel> importDoseMonitorDataSave(Long doseMonitorId, List<DoseMonitorDataOrgModel> models, Integer source) {
        if (doseMonitorId == null) {
            throw new ServiceException("\u7f3a\u5931\u5173\u952e\u53c2\u6570\uff01");
        }
        if (CollectionUtils.isEmpty(models)) {
            return null;
        }
        List doseMonitorData = models.stream().map(model -> {
            boolean idCard = IDCardUtil.isIDCard((String)model.getIdCard());
            if (!idCard) {
                throw new ServiceException("\u3010" + model.getIdCard() + "\u3011\u8eab\u4efd\u8bc1\u683c\u5f0f\u9519\u8bef\uff01");
            }
            model.setDoseMonitorId(doseMonitorId);
            if (model.getId() == null) {
                model.setId(Long.valueOf(this.idworker.nextId()));
            }
            if (StringUtils.isBlank((String)model.getSourceId())) {
                model.setSourceId(String.valueOf(model.getId()));
                model.setUniqueid(String.valueOf(model.getId()));
            }
            model.setIsConvertStaff(Integer.valueOf(0));
            if (model.getIsValid() == null) {
                model.setIsValid(Boolean.valueOf(true));
            }
            DoseMonitorData data = new DoseMonitorData();
            BeanUtils.copyProperties((Object)model, (Object)data);
            return data;
        }).collect(Collectors.toList());
        HashSet<String> repeatIDcardSet = new HashSet<String>();
        Map dbMonitorDatasMap = this.doseMonitorDataService.listDataByMonitorId(List.of(doseMonitorId));
        if (MapUtils.isNotEmpty((Map)dbMonitorDatasMap)) {
            List dbMonitorDatasList = (List)dbMonitorDatasMap.get(doseMonitorId);
            Map<String, List<DoseMonitorData>> dbIdcardGroupMap = dbMonitorDatasList.stream().collect(Collectors.groupingBy(data -> data.getIdCard()));
            for (DoseMonitorData doseMonitorDatum : doseMonitorData) {
                List<DoseMonitorData> dbIdcardGroupList = dbIdcardGroupMap.get(doseMonitorDatum.getIdCard());
                if (!CollectionUtils.isNotEmpty(dbIdcardGroupList)) continue;
                for (DoseMonitorData dbgroupMapData : dbIdcardGroupList) {
                    String uniqueid = dbgroupMapData.getUniqueid();
                    if (Objects.equals(uniqueid, doseMonitorDatum.getUniqueid())) continue;
                    repeatIDcardSet.add(doseMonitorDatum.getIdCard());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(repeatIDcardSet)) {
            if (Objects.equals(source, 1)) {
                throw new ServiceException("\u8be5\u8eab\u4efd\u8bc1\u53f7\u5bf9\u5e94\u7684\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u7ed3\u679c\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            throw new ServiceException("\u3010" + StringUtils.join(repeatIDcardSet, (String)",") + "\u3011\u8eab\u4efd\u8bc1\u53f7\u5bf9\u5e94\u7684\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u7ed3\u679c\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        this.doseMonitorService.updateDoseMonitorDatas(doseMonitorData, null);
        return models;
    }

    public PageInfo<DoseMonitorOrgModel> pageDoseMonitorOrg(JqGridParam jparam, DoseMonitorOrgParam param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<DoseMonitorOrgModel> list = ((DoseMonitorMapper)this.dao).listDoseMonitorOrg(param);
        return new PageInfo(list);
    }

    public List<DoseMonitorOrgModel> listDoseMonitorOrg(DoseMonitorOrgParam param) {
        List<DoseMonitorOrgModel> list = ((DoseMonitorMapper)this.dao).listDoseMonitorOrg(param);
        return list;
    }

    @Transactional(readOnly=false)
    public void delDoseMonitorIds(String ids, Long updateBy) {
        List idsList = CommonUtil.str2LongList((String)ids);
        Example e = new Example(DoseMonitor.class);
        e.createCriteria().andIn("id", (Iterable)idsList);
        DoseMonitor result = new DoseMonitor();
        result.setIsValid(Boolean.valueOf(false));
        result.setUpdateDate(new Date());
        result.setUpdateBy(updateBy);
        ((DoseMonitorMapper)this.dao).updateByExampleSelective(result, e);
    }

    public DoseMonitorOrgModel getOrgModelById(Long doseMonitorId) {
        DoseMonitor byId = (DoseMonitor)this.getById(doseMonitorId);
        if (byId != null) {
            DoseMonitorOrgModel model = new DoseMonitorOrgModel();
            BeanUtils.copyProperties((Object)byId, (Object)model);
            return model;
        }
        return null;
    }

    @Transactional
    public void updateStatus(DoseMonitor doseMonitor, WorkOperateLog log, Long loginId) {
        this.update(doseMonitor, loginId);
        if (Objects.equals(doseMonitor.getStatus(), DoseMonitorStatusEnum.BREAKED.getKey())) {
            this.workOperateLogService.back(log.getWorkId(), log.getWorkModule(), log.getReason(), log.getCreateBy(), log.getOperater(), log.getCompanyName());
            this.doseMonitorDataService.resetStaffConvertFalg(doseMonitor.getId(), Integer.valueOf(0));
            this.commandService.backDoseMonitorAndDeleteReform(List.of(doseMonitor.getId()));
        } else if (Objects.equals(doseMonitor.getStatus(), DoseMonitorStatusEnum.CHECKED.getKey())) {
            this.workOperateLogService.pass(log.getWorkId(), log.getWorkModule(), log.getCreateBy(), log.getOperater(), log.getCompanyName());
        }
    }

    @Generated
    public DoseMonitorOrgServiceImpl() {
    }
}

