/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.component;

import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.digest.MD5;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.file.FileUploadSimple;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.PageReadListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.ocr.v1.OcrClient;
import com.huaweicloud.sdk.ocr.v1.model.GeneralTableRequestBody;
import com.huaweicloud.sdk.ocr.v1.model.GeneralTableWordsBlockList;
import com.huaweicloud.sdk.ocr.v1.model.RecognizeGeneralTableRequest;
import com.huaweicloud.sdk.ocr.v1.model.RecognizeGeneralTableResponse;
import com.huaweicloud.sdk.ocr.v1.model.RecognizeSealRequest;
import com.huaweicloud.sdk.ocr.v1.model.RecognizeSealResponse;
import com.huaweicloud.sdk.ocr.v1.model.RecognizeSmartDocumentRecognizerRequest;
import com.huaweicloud.sdk.ocr.v1.model.RecognizeSmartDocumentRecognizerResponse;
import com.huaweicloud.sdk.ocr.v1.model.SealList;
import com.huaweicloud.sdk.ocr.v1.model.SealRequestBody;
import com.huaweicloud.sdk.ocr.v1.model.SmartDocumentRecognizerRequestBody;
import com.huaweicloud.sdk.ocr.v1.model.SmartDocumentRecognizerResult;
import com.huaweicloud.sdk.ocr.v1.model.SmartDocumentRecognizerTableBlock;
import com.huaweicloud.sdk.ocr.v1.model.WordsRegionList;
import com.huaweicloud.sdk.ocr.v1.region.OcrRegion;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OcrClientBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OcrClientBean.class);
    @Value(value="${ocr.ak}")
    private String ak;
    @Value(value="${ocr.sk}")
    private String sk;
    @Autowired
    private ISysFileProvideService fileService;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    protected IdWorker idworker;

    public String getStrPath() {
        Object strPath = System.getProperty("java.io.tmpdir");
        if (!((String)strPath).endsWith(File.separator)) {
            strPath = (String)strPath + File.separator;
        }
        return strPath;
    }

    public OcrClient getClient() {
        HttpConfig config = HttpConfig.getDefaultHttpConfig();
        AbstractCredentials auth = ((BasicCredentials)new BasicCredentials().withAk(this.ak)).withSk(this.sk);
        return (OcrClient)OcrClient.newBuilder().withHttpConfig(config).withCredential((ICredential)auth).withRegion(OcrRegion.valueOf((String)"cn-north-4")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getGeneralTable(Long fileId, String headKeywords, T model) {
        List<Object> list;
        block18: {
            list = new ArrayList();
            if (fileId == null || model == null) {
                return list;
            }
            SysFileModel fileModel = this.fileService.getFileById(fileId);
            if (fileModel == null) {
                return list;
            }
            ArrayList<File> files = new ArrayList<File>();
            PDDocument document = null;
            try {
                String fileExt = FileUtil.getSuffix((String)fileModel.getFileName());
                if (Objects.equals(fileExt, "pdf")) {
                    String fileName = FileUtil.getPrefix((String)fileModel.getFileName()) + this.idworker.nextId() + "." + fileExt;
                    this.ossClientBean.downloadFile(fileModel.getDestPath(), this.getStrPath(), fileName);
                    String fullPath = this.getStrPath() + fileName;
                    File file = new File(fullPath);
                    files.add(file);
                    document = PDDocument.load((File)file);
                    PDFRenderer renderer = new PDFRenderer(document);
                    for (int i = 0; i < document.getNumberOfPages(); ++i) {
                        BufferedImage image = renderer.renderImageWithDPI(i, 300.0f);
                        String ocrImageFullPath = this.getStrPath() + "ocr_general_image_" + this.idworker.nextId() + ".jpg";
                        File imageFile = new File(ocrImageFullPath);
                        files.add(imageFile);
                        ImageIO.write((RenderedImage)image, "jpg", imageFile);
                        byte[] bytes = Files.readAllBytes(Paths.get(ocrImageFullPath, new String[0]));
                        String imageBase64 = Base64.getEncoder().encodeToString(bytes);
                        List<T> generalTable = this.getGeneralTable(null, imageBase64, headKeywords, model);
                        if (!CollectionUtils.isNotEmpty(generalTable)) continue;
                        list.addAll(generalTable);
                    }
                } else {
                    list = this.getGeneralTable(fileModel.getFullOssurl(), null, headKeywords, model);
                }
            }
            catch (Exception e) {
                log.error("ocr\u626b\u63cf\u8868\u683c(\u901a\u7528\u8868\u683c\u8bc6\u522b)\u5185\u5bb9\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u6587\u6863\u5931\u8d25", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (!CollectionUtils.isNotEmpty(files)) break block18;
                for (File file : files) {
                    FileUtil.del((File)file);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getSmartDocument(Long fileId, T excelModel) {
        List<Object> list = new ArrayList();
        if (fileId == null || excelModel == null) {
            return list;
        }
        SysFileModel fileModel = this.fileService.getFileById(fileId);
        if (fileModel == null) {
            return list;
        }
        File file = null;
        PDDocument document = null;
        try {
            String fileExt = FileUtil.getSuffix((String)fileModel.getFileName());
            if (Objects.equals(fileExt, "pdf")) {
                String fileName = FileUtil.getPrefix((String)fileModel.getFileName()) + this.idworker.nextId() + "." + fileExt;
                this.ossClientBean.downloadFile(fileModel.getDestPath(), this.getStrPath(), fileName);
                String fullPath = this.getStrPath() + fileName;
                file = new File(fullPath);
                document = PDDocument.load((File)file);
                int pageCount = document.getNumberOfPages();
                for (int i = 1; i <= pageCount; ++i) {
                    List<T> smartDocument = this.getSmartDocument(fileModel.getFullOssurl(), null, i, excelModel);
                    if (!CollectionUtils.isNotEmpty(smartDocument)) continue;
                    list.addAll(smartDocument);
                }
            } else {
                list = this.getSmartDocument(fileModel.getFullOssurl(), null, null, excelModel);
            }
        }
        catch (Exception e) {
            log.error("ocr\u626b\u63cf\u8868\u683c(\u667a\u6167\u6587\u6863\u8bc6\u522b)\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6587\u6863\u5931\u8d25", (Throwable)e);
                    e.printStackTrace();
                }
            }
            if (file != null) {
                FileUtil.del(file);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SysFileModel> getSealImage(Long fileId, Long operateId) {
        List<SysFileModel> list = new ArrayList<SysFileModel>();
        if (fileId == null) {
            return list;
        }
        SysFileModel fileModel = this.fileService.getFileById(fileId);
        if (fileModel == null) {
            return list;
        }
        File file = null;
        try {
            String fileExt = FileUtil.getSuffix((String)fileModel.getFileName());
            if (Objects.equals(fileExt, "pdf")) {
                String fileName = FileUtil.getPrefix((String)fileModel.getFileName()) + this.idworker.nextId() + "." + fileExt;
                this.ossClientBean.downloadFile(fileModel.getDestPath(), this.getStrPath(), fileName);
                String fullPath = this.getStrPath() + fileName;
                file = new File(fullPath);
                PDDocument document = PDDocument.load((File)file);
                int pageCount = document.getNumberOfPages();
                document.close();
                for (int i = 1; i <= pageCount; ++i) {
                    List<SysFileModel> sysFileModels = this.getSealImage(fileModel.getFullOssurl(), null, i, operateId);
                    if (!CollectionUtils.isNotEmpty(sysFileModels)) continue;
                    list.addAll(sysFileModels);
                }
            } else {
                list = this.getSealImage(fileModel.getFullOssurl(), null, null, operateId);
            }
        }
        catch (Exception e) {
            log.error("ocr\u626b\u63cf\u5370\u7ae0\u622a\u56fe\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (file != null) {
                FileUtil.del(file);
            }
        }
        return list;
    }

    public <T> List<T> getGeneralTable(String url, String imageBase64, String headKeywords, T model) {
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)imageBase64)) {
            throw new RuntimeException("url\u548cimageBase64 \u4e8c\u9009\u4e00");
        }
        if (StringUtils.isBlank((CharSequence)url) && StringUtils.isBlank((CharSequence)imageBase64)) {
            throw new RuntimeException("url\u548cimageBase64 \u5747\u4e3a\u7a7a");
        }
        RecognizeGeneralTableRequest request = new RecognizeGeneralTableRequest();
        GeneralTableRequestBody body = new GeneralTableRequestBody();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            body.withUrl(url);
        } else if (StringUtils.isNotBlank((CharSequence)imageBase64)) {
            body.withImage(imageBase64);
        }
        body.setReturnTextLocation(Boolean.valueOf(true));
        body.setReturnRectificationMatrix(Boolean.valueOf(true));
        request.withBody(body);
        ArrayList list = new ArrayList();
        try {
            RecognizeGeneralTableResponse response = this.getClient().recognizeGeneralTable(request);
            if (response == null || response.getResult() == null) {
                return list;
            }
            List tableList = response.getResult().getWordsRegionList().stream().filter(item -> item != null && item.getType().equals("table")).collect(Collectors.toList());
            Field[] declaredFields = model.getClass().getDeclaredFields();
            for (WordsRegionList wordsRegionList : tableList) {
                List wordsBlockList;
                if (wordsRegionList == null || CollectionUtils.isEmpty((Collection)(wordsBlockList = wordsRegionList.getWordsBlockList()))) continue;
                int rowMaxNum = wordsBlockList.stream().mapToInt(c -> (Integer)c.getRows().get(0)).max().orElse(-1);
                for (int i = 0; i <= rowMaxNum; ++i) {
                    long count;
                    int finalI = i;
                    List oneRow = wordsBlockList.stream().filter(c -> (Integer)c.getRows().get(0) == finalI).map(GeneralTableWordsBlockList::getWords).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(oneRow) || oneRow.stream().noneMatch(org.apache.commons.lang3.StringUtils::isNotBlank) || (count = oneRow.stream().filter(o -> StringUtils.isNotBlank((CharSequence)headKeywords) && headKeywords.contains((CharSequence)o)).distinct().count()) >= 2L) continue;
                    if (oneRow.size() < declaredFields.length) {
                        for (int k = oneRow.size() - 1; k >= 0; --k) {
                            if (StringUtils.isNotBlank((CharSequence)((CharSequence)oneRow.get(k)))) {
                                String[] parts = ((String)oneRow.get(k)).split("\\s+");
                                oneRow.remove(k);
                                oneRow.addAll(Arrays.asList(parts));
                                break;
                            }
                            oneRow.remove(k);
                        }
                    }
                    Object instance = model.getClass().newInstance();
                    for (int j = 0; j < declaredFields.length; ++j) {
                        Field field = declaredFields[j];
                        field.setAccessible(true);
                        if (j >= oneRow.size()) continue;
                        field.set(instance, oneRow.get(j));
                    }
                    list.add(instance);
                }
            }
        }
        catch (Exception e) {
            log.error("ocr\u8868\u683c\u8bc6\u522b\u9519\u8bef\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getSmartDocument(String url, String imageBase64, Integer pdfPageNumber, T excelModel) {
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)imageBase64)) {
            throw new RuntimeException("url\u548cimageBase64 \u4e8c\u9009\u4e00");
        }
        if (StringUtils.isBlank((CharSequence)url) && StringUtils.isBlank((CharSequence)imageBase64)) {
            throw new RuntimeException("url\u548cimageBase64 \u5747\u4e3a\u7a7a");
        }
        RecognizeSmartDocumentRecognizerRequest request = new RecognizeSmartDocumentRecognizerRequest();
        SmartDocumentRecognizerRequestBody body = new SmartDocumentRecognizerRequestBody();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            body.withUrl(url);
        } else if (StringUtils.isNotBlank((CharSequence)imageBase64)) {
            body.withData(imageBase64);
        }
        body.withTable(Boolean.valueOf(true));
        body.withReturnExcel(Boolean.valueOf(true));
        body.withEraseSeal(Boolean.valueOf(true));
        if (pdfPageNumber != null) {
            body.withPdfPageNumber(pdfPageNumber);
        }
        request.withBody(body);
        List list = new ArrayList();
        Path tempFilePath = null;
        try {
            RecognizeSmartDocumentRecognizerResponse response = this.getClient().recognizeSmartDocumentRecognizer(request);
            if (response == null || CollectionUtils.isEmpty((Collection)response.getResult())) {
                ArrayList arrayList = list;
                return arrayList;
            }
            for (SmartDocumentRecognizerResult recognizerResult : response.getResult()) {
                if (recognizerResult == null || recognizerResult.getTableResult() == null || CollectionUtils.isEmpty((Collection)recognizerResult.getTableResult().getTableList())) continue;
                for (SmartDocumentRecognizerTableBlock table : recognizerResult.getTableResult().getTableList()) {
                    if (table == null || StringUtils.isBlank((CharSequence)table.getExcel())) continue;
                    tempFilePath = Files.createTempFile("ocr_smart_document_" + this.idworker.nextId(), ".xlsx", new FileAttribute[0]);
                    byte[] decode = Base64.getDecoder().decode(table.getExcel());
                    Files.write(tempFilePath, decode, new OpenOption[0]);
                    if (pdfPageNumber != null && pdfPageNumber > 1) {
                        list = ((ExcelReaderBuilder)EasyExcel.read((String)tempFilePath.toString(), excelModel.getClass(), (ReadListener)new PageReadListener(a -> log.debug("\u6ca1\u6709\u8868\u5934\u7684Excel\u6587\u4ef6\u8bfb\u53d6\u5b8c\u6210"))).headRowNumber(Integer.valueOf(0))).sheet().doReadSync();
                        continue;
                    }
                    list = ((ExcelReaderBuilder)EasyExcel.read((String)tempFilePath.toString()).head(excelModel.getClass())).sheet().doReadSync();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (tempFilePath != null) {
                FileUtil.del(tempFilePath);
            }
        }
        return list;
    }

    public List<SysFileModel> getSealImage(String url, String imageBase64, Integer pdfPageNumber, Long operateId) {
        if (StringUtils.isNotBlank((CharSequence)url) && StringUtils.isNotBlank((CharSequence)imageBase64)) {
            throw new RuntimeException("url\u548cimageBase64 \u4e8c\u9009\u4e00");
        }
        if (StringUtils.isBlank((CharSequence)url) && StringUtils.isBlank((CharSequence)imageBase64)) {
            throw new RuntimeException("url\u548cimageBase64 \u5747\u4e3a\u7a7a");
        }
        RecognizeSealRequest request = new RecognizeSealRequest();
        SealRequestBody body = new SealRequestBody();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            body.withUrl(url);
        } else if (StringUtils.isNotBlank((CharSequence)imageBase64)) {
            body.withData(imageBase64);
        }
        body.withReturnSealImage(Boolean.valueOf(true));
        if (pdfPageNumber != null) {
            body.withPdfPageNumber(pdfPageNumber);
        }
        request.withBody(body);
        ArrayList<SysFileModel> list = new ArrayList<SysFileModel>();
        try {
            RecognizeSealResponse response = this.getClient().recognizeSeal(request);
            if (response != null && response.getResult() != null && CollectionUtils.isNotEmpty((Collection)response.getResult().getSealList())) {
                for (SealList sealList : response.getResult().getSealList()) {
                    String suffix;
                    String fileName;
                    String sealImage;
                    SysFileModel sysFileModel;
                    if (sealList == null || !StringUtils.isNotBlank((CharSequence)sealList.getSealImage()) || (sysFileModel = this.sealImageUpload(sealImage = sealList.getSealImage(), fileName = "ocr_seal_image_" + this.idworker.nextId(), suffix = ".jpg", operateId)) == null) continue;
                    list.add(sysFileModel);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return list;
    }

    private SysFileModel sealImageUpload(String sealImage, String fileName, String suffix, Long operateId) throws IOException {
        byte[] fileBytes = Base64.getDecoder().decode(sealImage);
        String filehash = String.valueOf(MD5.create().digestHex(fileBytes));
        SysFileModel existSysFile = this.fileService.getFileByHash(filehash);
        if (existSysFile != null) {
            log.info("\u4e0a\u4f20\u6587\u4ef6 \u6210\u529f(hash\u503c\u5b58\u5728)\uff01");
            return existSysFile;
        }
        Path tempFilePath = Files.createTempFile(fileName, suffix, new FileAttribute[0]);
        Files.write(tempFilePath, fileBytes, new OpenOption[0]);
        File file = tempFilePath.toFile();
        String ossFileName = FileUploadSimple.getNumberName((String)(fileName + suffix));
        String uploadDir = "ocr/ocr_seal_image/";
        String ossUrl = (uploadDir + ossFileName).replace("\\", "/");
        SysFileModel sysFileModel = new SysFileModel();
        sysFileModel.setResource(Integer.valueOf(FileResourceEnum.supervise_05.getValue()));
        sysFileModel.setFileName(fileName + suffix);
        sysFileModel.setFileSize(String.valueOf(file.length()));
        sysFileModel.setFileExt(suffix);
        sysFileModel.setFileHash(filehash);
        sysFileModel.setOssUrl(ossUrl);
        log.debug("\u4e0a\u4f20\u6587\u4ef6\uff1a{}", (Object)sysFileModel.getFileName());
        this.ossClientBean.OSSPutObject(ossFileName, file, uploadDir, ossFileName);
        sysFileModel = this.fileService.addSysFile(sysFileModel, operateId);
        Files.deleteIfExists(tempFilePath);
        return sysFileModel;
    }
}

